/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.security.KerberosConfigurationProvider;
import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.common.util.KerberosUtil;
import com.pingidentity.common.util.KerberosUtilFactory;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.x2012.x01.kerberosRealms.KerberosKeySetType;
import com.pingidentity.x2012.x01.kerberosRealms.KerberosKeySetsType;
import com.pingidentity.x2012.x01.kerberosRealms.KerberosRealmType;
import com.pingidentity.x2012.x01.kerberosRealms.KerberosRealmsSettingsDocument;
import com.pingidentity.x2012.x01.kerberosRealms.KerberosRealmsSettingsType;
import com.pingidentity.x2012.x01.kerberosRealms.KerberosRealmsType;
import com.pingidentity.x2012.x01.kerberosRealms.KeyDistributionCentersType;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.KerberosConnectionType;
import org.sourceid.saml20.domain.KerberosKeySet;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.KerberosRealmsSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.JaasLoginConfigurationManager;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;
import org.sourceid.saml20.domain.mgmt.impl.KerberosContextManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.util.KerberosKeySetUtil;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class KerberosRealmManagerImpl
extends ConfigManagerBase
implements KerberosRealmManager {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String KERBEROS_REALMS_XML_FILE_NAME = "pingfederate-kerberos-realms.xml";
    private static final String ID_BASE_KERBEROS = "KERB";
    private String directory;
    private Map<String, KerberosRealm> kerberosRealms = new HashMap<String, KerberosRealm>();
    private String debugLogOutput;
    private String forceTcp;
    private String kdcTimeout;
    private String kdcRetries;
    private int keySetRetentionPeriodMins = 610;
    private Clock clock = Clock.systemDefaultZone();

    public KerberosRealmManagerImpl() {
    }

    public KerberosRealmManagerImpl(SysDirInfo sysDirInfo, XmlLoader xmlLoader, Mediator mediator) {
        this(xmlLoader, sysDirInfo.getDataDirectory());
    }

    public KerberosRealmManagerImpl(XmlLoader xmlLoader, String directory) {
        this.xmlLoader = xmlLoader;
        this.directory = directory;
        this.reload();
    }

    @Override
    public void init() {
    }

    @Override
    public synchronized void reload() {
        KerberosRealmsSettingsDocument doc;
        this.kerberosRealms.clear();
        KerberosRealmsSettingsType kerberosRealmsSettingsType = null;
        if (this.xmlLoader.xmlExists(this.directory, KERBEROS_REALMS_XML_FILE_NAME)) {
            doc = (KerberosRealmsSettingsDocument)this.xmlLoader.load(this.directory, KERBEROS_REALMS_XML_FILE_NAME);
            kerberosRealmsSettingsType = doc.getKerberosRealmsSettings();
        } else {
            doc = KerberosRealmsSettingsDocument.Factory.newInstance();
            kerberosRealmsSettingsType = doc.addNewKerberosRealmsSettings();
            kerberosRealmsSettingsType.addNewKerberosRealms();
        }
        if (kerberosRealmsSettingsType != null) {
            KerberosRealmsType kerberosRealmsType = kerberosRealmsSettingsType.getKerberosRealms();
            KerberosRealmType[] kerberosRealmArray = kerberosRealmsType.getKerberosRealmArray();
            for (KerberosRealmType kerberosRealmType : kerberosRealmArray) {
                KerberosRealm kr = new KerberosRealm();
                kr.setConnectType(kerberosRealmType.getKerberosConnectionType() == null ? KerberosConnectionType.DIRECT : KerberosConnectionType.valueOf((String)kerberosRealmType.getKerberosConnectionType()));
                kr.setLdapGatewayDatastoreId(kerberosRealmType.getPingOneGatewayDataStore());
                kr.setKerberosRealmName(kerberosRealmType.getKerberosRealmName());
                kr.setId(kerberosRealmType.getId());
                kr.setKerberosUsername(kerberosRealmType.getKerberosUsername());
                if (kerberosRealmType.getKerberosPassword() != null) {
                    kr.setKerberosPassword(Obfuscator.deobfuscate(kerberosRealmType.getKerberosPassword()));
                }
                kr.setSuppressDomainNameConcatenation(kerberosRealmType.getSuppressDomainNameConcatenation());
                if (kerberosRealmType.isSetRetainPreviousKeysOnPasswordChange()) {
                    kr.setRetainPreviousKeysOnPasswordChange(kerberosRealmType.getRetainPreviousKeysOnPasswordChange());
                } else {
                    kr.setRetainPreviousKeysOnPasswordChange(true);
                }
                for (String keyDistributionCenter : kerberosRealmType.getKeyDistributionCenters().getKeyDistributionCenterArray()) {
                    kr.getKeyDistributionCenters().add(keyDistributionCenter);
                }
                if (kerberosRealmType.getKeySets() != null) {
                    ArrayList<KerberosKeySet> keySets = new ArrayList<KerberosKeySet>();
                    for (KerberosKeySetType keySetType : kerberosRealmType.getKeySets().getKeySetArray()) {
                        Instant deactivatedAt = null;
                        if (keySetType.isSetDeactivatedAt()) {
                            deactivatedAt = keySetType.getDeactivatedAt().toInstant();
                        }
                        keySets.add(KerberosKeySetUtil.fromEncryptedKeySet(deactivatedAt, keySetType.getEncryptedKeySet()));
                    }
                    kr.setKeySets(keySets);
                }
                this.kerberosRealms.put(kr.getId(), kr);
            }
            this.debugLogOutput = kerberosRealmsSettingsType.getDebug();
            this.forceTcp = kerberosRealmsSettingsType.getForceTcp();
            this.kdcTimeout = kerberosRealmsSettingsType.getKdcTimeout();
            this.kdcRetries = kerberosRealmsSettingsType.getKdcRetries();
            if (kerberosRealmsSettingsType.isSetKeySetRetentionPeriodMins()) {
                this.keySetRetentionPeriodMins = kerberosRealmsSettingsType.getKeySetRetentionPeriodMins();
            }
        }
        if (!KerberosConfigUtil.getKrb5ConfFile().exists()) {
            try {
                KerberosConfigUtil.createKrb5Conf();
            }
            catch (IOException e) {
                this.log.debug((Object)e);
            }
        }
        if (KerberosConfigUtil.isAutoGenerateKrb5ConfFile()) {
            KerberosConfigUtil.updateKrb5Conf(this.getKerberosRealms(), this.getKerberosRealmsSettings());
        }
        if (!this.getKerberosRealms().isEmpty()) {
            KerberosConfigUtil.setKrb5ConfSystemProperty();
        }
        JaasLoginConfigurationManager jaasLoginConfigurationManager = MgmtFactory.getJaasLoginConfigurationManager();
        for (KerberosRealm kerberosRealm : this.getKerberosRealms()) {
            KerberosConfigurationProvider kerberosConfigurationProvider = new KerberosConfigurationProvider(kerberosRealm.getKerberosRealmName(), this.debugLogOutput);
            jaasLoginConfigurationManager.addAppConfigurationEntry(kerberosRealm.getKerberosRealmName(), kerberosConfigurationProvider.getAppConfigurationEntry(kerberosRealm.getKerberosRealmName()));
        }
        for (String entryName : jaasLoginConfigurationManager.getEntryNames()) {
            if (this.kerberosRealms.values().stream().anyMatch(realm -> realm.getKerberosRealmName().equals(entryName))) continue;
            jaasLoginConfigurationManager.removeAppConfigurationEntry(entryName);
        }
        KerberosContextManager kerberosContextManager = KerberosContextManager.getManager();
        kerberosContextManager.clearAllContexts();
    }

    @Override
    public synchronized Collection<KerberosRealm> getKerberosRealms() {
        return Collections.unmodifiableCollection(new ArrayList<KerberosRealm>(this.kerberosRealms.values()));
    }

    @Override
    public synchronized KerberosRealm getKerberosRealmById(String id) {
        return this.kerberosRealms.get(id);
    }

    @Override
    public synchronized KerberosRealm getKerberosRealmByName(String name) {
        for (KerberosRealm kerberosRealm : this.kerberosRealms.values()) {
            if (!kerberosRealm.getKerberosRealmName().equalsIgnoreCase(name)) continue;
            return kerberosRealm;
        }
        return null;
    }

    @Override
    public synchronized boolean isInUse(KerberosRealm kerberosRealm) {
        AdapterManager adapterManager = MgmtFactory.getAdapterManager();
        TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
        if (kerberosRealm != null) {
            return adapterManager.isKerberosRealmInUse(kerberosRealm.getId()) || tokenProcessorManager.isKerberosRealmInUse(kerberosRealm.getId());
        }
        return false;
    }

    @Override
    public synchronized void saveKerberosRealm(KerberosRealm kerberosRealm) {
        this.log.debug((Object)("Saving Kerberos Realm " + kerberosRealm.getId() + "..."));
        String id = kerberosRealm.getId();
        if (StringUtils.isBlank((String)id)) {
            id = this.generateId(ID_BASE_KERBEROS);
            kerberosRealm.setId(id);
        }
        KerberosRealm existing = this.kerberosRealms.put(id, kerberosRealm);
        this.log.debug((Object)("Kerberos realm '" + kerberosRealm.getKerberosRealmName() + "' now has " + kerberosRealm.getKeySets().size() + " saved key sets"));
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.save();
            auditLoggerScope.log(AdminAuditLogger.Component.KERBEROS_REALM, existing == null ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY, kerberosRealm.getKerberosRealmName());
        }
    }

    @Override
    public synchronized void updateKeySets(KerberosRealm realm) throws KerberosException {
        ArrayList<KerberosKeySet> keySets = new ArrayList<KerberosKeySet>();
        if (realm.isLdapGatewayConnection()) {
            realm.setKeySets(keySets);
            return;
        }
        boolean saveCurrentKeys = true;
        for (KerberosKeySet existingKeySet : realm.getValidKeySets(this.clock.instant())) {
            if (!existingKeySet.getRealmName().equals(realm.getKerberosRealmName()) || !existingKeySet.getUsername().equals(realm.getKerberosUsername())) continue;
            boolean passwordMatches = HashedPassword.fromEncodedText(existingKeySet.getHashedPassword()).checkSecret(realm.getKerberosPassword());
            if (existingKeySet.getDeactivatedAt() == null && passwordMatches) {
                saveCurrentKeys = false;
                keySets.add(existingKeySet);
                continue;
            }
            if (passwordMatches) continue;
            if (existingKeySet.getDeactivatedAt() == null) {
                keySets.add(new KerberosKeySet(existingKeySet, this.clock.instant()));
                continue;
            }
            keySets.add(existingKeySet);
        }
        if (saveCurrentKeys) {
            KerberosUtil kerberosUtil = this.makeKerberosUtil(realm, false);
            kerberosUtil.testKerberosRealm(this.getKerberosRealmsSettings(), KerberosConfigUtil.isAutoGenerateKrb5ConfFile());
            Set<KerberosKey> currentKeys = kerberosUtil.getCurrentKeys();
            if (currentKeys != null && !currentKeys.isEmpty()) {
                KerberosKeySet currentKeySet = new KerberosKeySet(realm, currentKeys);
                keySets.add(0, currentKeySet);
            }
        }
        realm.setKeySets(keySets);
    }

    protected synchronized void setClock(Clock clock) {
        this.clock = clock;
    }

    private synchronized void save() {
        this.log.debug((Object)"Saving Kerberos Realms...");
        KerberosRealmsSettingsDocument doc = KerberosRealmsSettingsDocument.Factory.newInstance();
        KerberosRealmsSettingsType kerberosRealmsSettingsType = doc.addNewKerberosRealmsSettings();
        KerberosRealmsType kerberosRealmsType = kerberosRealmsSettingsType.addNewKerberosRealms();
        for (KerberosRealm kerberosRealm : this.kerberosRealms.values()) {
            this.addKerberosRealmType(kerberosRealmsType, kerberosRealm);
        }
        kerberosRealmsSettingsType.setDebug(this.debugLogOutput != null ? this.debugLogOutput : "false");
        kerberosRealmsSettingsType.setForceTcp(this.forceTcp != null ? this.forceTcp : "false");
        kerberosRealmsSettingsType.setKdcTimeout(this.kdcTimeout != null ? this.kdcTimeout : "3000");
        kerberosRealmsSettingsType.setKdcRetries(this.kdcRetries != null ? this.kdcRetries : "3");
        kerberosRealmsSettingsType.setKeySetRetentionPeriodMins(this.keySetRetentionPeriodMins);
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), KERBEROS_REALMS_XML_FILE_NAME, (XmlObject)doc);
        this.reload();
    }

    @Override
    public synchronized void deleteKerberosRealmAndSave(String kerberosRealmId) {
        KerberosRealm realm = this.kerberosRealms.remove(kerberosRealmId);
        if (realm != null) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                this.save();
                auditLoggerScope.log(AdminAuditLogger.Component.KERBEROS_REALM, AdminAuditLogger.Event.DELETE, realm.getKerberosRealmName());
            }
        }
    }

    private void addKerberosRealmType(KerberosRealmsType kerberosRealmsType, KerberosRealm kerberosRealm) {
        KerberosRealmType kerberosRealmType = kerberosRealmsType.addNewKerberosRealm();
        kerberosRealmType.setId(kerberosRealm.getId());
        String kerberosConnectionType = KerberosConnectionType.DIRECT.toString();
        if (kerberosRealm.getConnectionType() != null) {
            kerberosConnectionType = kerberosRealm.getConnectionType().toString();
        }
        kerberosRealmType.setKerberosConnectionType(kerberosConnectionType);
        kerberosRealmType.setPingOneGatewayDataStore(kerberosRealm.getLdapGatewayDatastoreId());
        kerberosRealmType.setKerberosRealmName(kerberosRealm.getKerberosRealmName());
        KeyDistributionCentersType keyDistributionCenters = kerberosRealmType.addNewKeyDistributionCenters();
        for (String keyDistributionCenter : kerberosRealm.getKeyDistributionCenters()) {
            keyDistributionCenters.addKeyDistributionCenter(keyDistributionCenter);
        }
        kerberosRealmType.setKeyDistributionCenters(keyDistributionCenters);
        kerberosRealmType.setKerberosUsername(kerberosRealm.getKerberosUsername());
        kerberosRealmType.setKerberosPassword(StringUtils.isEmpty((String)kerberosRealm.getKerberosPassword()) ? null : Obfuscator.obfuscate(kerberosRealm.getKerberosPassword()));
        kerberosRealmType.setSuppressDomainNameConcatenation(kerberosRealm.isSuppressDomainNameConcatenation());
        kerberosRealmType.setRetainPreviousKeysOnPasswordChange(kerberosRealm.isRetainPreviousKeysOnPasswordChange());
        if (!kerberosRealm.getKeySets().isEmpty()) {
            KerberosKeySetsType keySetsType = kerberosRealmType.addNewKeySets();
            for (KerberosKeySet keySet : kerberosRealm.getKeySets()) {
                KerberosKeySetType keySetType = keySetsType.addNewKeySet();
                if (keySet.getDeactivatedAt() != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(keySet.getDeactivatedAt().toEpochMilli());
                    keySetType.setDeactivatedAt(calendar);
                }
                keySetType.setEncryptedKeySet(KerberosKeySetUtil.toEncryptedKeySet(keySet));
            }
        }
    }

    @Override
    public synchronized void setKerberosRealms(Collection<KerberosRealm> kerberosRealms) {
        this.kerberosRealms.clear();
        for (KerberosRealm kerberosRealm : kerberosRealms) {
            if (StringUtils.isEmpty((String)kerberosRealm.getId())) {
                kerberosRealm.setId(this.generateId(ID_BASE_KERBEROS));
            }
            this.kerberosRealms.put(kerberosRealm.getId(), kerberosRealm);
        }
        this.save();
    }

    @Override
    public synchronized String getDebugLogOutput() {
        return this.debugLogOutput;
    }

    @Override
    public synchronized String getKdcTimout() {
        return this.kdcTimeout;
    }

    @Override
    public synchronized String getKdcRetries() {
        return this.kdcRetries;
    }

    @Override
    public synchronized String getforceTcp() {
        return this.forceTcp;
    }

    @Override
    public synchronized int getKeySetRetentionPeriodMins() {
        return this.keySetRetentionPeriodMins;
    }

    @Override
    public synchronized void setDebugLogOutput(String debugLogOutput) {
        this.debugLogOutput = debugLogOutput;
        this.save();
    }

    @Override
    public synchronized void setforceTcp(String forceTcp) {
        this.forceTcp = forceTcp;
        this.save();
    }

    @Override
    public synchronized void setKdcTimout(String kdcTimeout) {
        this.kdcTimeout = kdcTimeout;
        this.save();
    }

    @Override
    public synchronized void setKdcRetries(String kdcRetries) {
        this.kdcRetries = kdcRetries;
        this.save();
    }

    @Override
    public synchronized void setKeySetRetentionPeriodMins(int keySetRetentionPeriodMins) {
        this.keySetRetentionPeriodMins = keySetRetentionPeriodMins;
        this.save();
    }

    @Override
    public synchronized KerberosRealmsSettings getKerberosRealmsSettings() {
        KerberosRealmsSettings kerberosRealmsSettings = new KerberosRealmsSettings();
        kerberosRealmsSettings.setDebugLogOutput(this.debugLogOutput);
        kerberosRealmsSettings.setForceTcp(this.forceTcp);
        kerberosRealmsSettings.setKdcTimeout(this.kdcTimeout);
        kerberosRealmsSettings.setKdcRetries(this.kdcRetries);
        kerberosRealmsSettings.setKeySetRetentionPeriodMins(this.keySetRetentionPeriodMins);
        return kerberosRealmsSettings;
    }

    @Override
    public synchronized void setKerberosRealmsSettingsAndSave(KerberosRealmsSettings settings) {
        this.debugLogOutput = settings.getDebugLogOutput();
        this.forceTcp = settings.getForceTcp();
        this.kdcTimeout = settings.getKdcTimeout();
        this.kdcRetries = settings.getKdcRetries();
        this.keySetRetentionPeriodMins = settings.getKeySetRetentionPeriodMins();
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.save();
            auditLoggerScope.log(AdminAuditLogger.Component.KERBEROS_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }

    protected KerberosUtil makeKerberosUtil(KerberosRealm realm, boolean useCache) {
        return KerberosUtilFactory.getKerberosUtil(realm, useCache);
    }
}

