/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.ConfigurationArchiveUtil;
import com.pingidentity.common.util.LockScope;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.common.util.WriteLockScope;
import com.pingidentity.common.util.zip.FileEntry;
import com.pingidentity.common.util.zip.ZipUtil;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.configservice.ConfigUpdateCoordinator;
import com.pingidentity.configservice.ConfigUpdateType;
import com.pingidentity.configservice.ListenerRegistry;
import com.pingidentity.configservice.ReloadRegistry;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.JCEManager;
import com.pingidentity.crypto.LunaUtil;
import com.pingidentity.hivemind.ServiceSetManager;
import com.pingidentity.jdbc.WarningsForHsqlDb;
import com.pingidentity.jgroups.DistributedMap;
import com.pingidentity.jgroups.MembershipListenerStub;
import com.pingidentity.jgroups.MuxRpcDispatcherMgr;
import com.pingidentity.jgroups.NodeAddress;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.monitoring.ThreadPoolExhaustionService;
import com.pingidentity.util.InitialSetupConfigStore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jose4j.jwk.JsonWebKeySet;
import org.sourceid.common.VersionUtil;
import org.sourceid.common.soap.soap11.SoapHttpConnectionPoolingManager;
import org.sourceid.config.ConfigFilePaths;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.mgmt.DataDirectoryManager;
import org.sourceid.mgmt.InstanceMetadataManager;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.domain.ReplicationArchive;
import org.sourceid.saml20.domain.ReplicationData;
import org.sourceid.saml20.domain.ReplicationRecord;
import org.sourceid.saml20.domain.SynchronizationData;
import org.sourceid.saml20.domain.SynchronizationRequest;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProvider;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProviderManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.ReplicationStateManager;
import org.sourceid.saml20.domain.mgmt.impl.DataArchiveBackup;
import org.sourceid.saml20.domain.mgmt.impl.DataDeployer;
import org.sourceid.saml20.domain.mgmt.impl.DataDirWatcher;
import org.sourceid.saml20.domain.mgmt.impl.DeploymentOption;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.MediatorListener;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.domain.mgmt.impl.ServerX509TrustManager;
import org.sourceid.saml20.domain.util.InitMigrationUtil;
import org.sourceid.saml20.service.PseudonymService;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.SystemUtil;
import org.sourceid.util.UpgradeInfo;
import org.sourceid.util.license.DisplayableLicense;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.PingLicense;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.DeferredInitServlet;

public class MediatorImpl
implements Mediator {
    private static final String FIPS_KEY = "pf.hsm.mode";
    private static final String LUNA_MODE = "luna";
    private static final String INITIAL_SETUP_CONFIG_STORE_FILE = "config-store" + File.separator + "com.pingidentity.page.Login.xml";
    private final Log log = LogFactory.getLog(this.getClass());
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.mgmt.impl.MediatorImpl");
    private DistributedMap distributedMap;
    private final SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
    private final ReplicationStateManager replStateManager = MgmtFactory.getReplicationStateManager();
    private final DeltaReplicationProviderManager replProviderManager = MgmtFactory.getDeltaReplicationProviderManager();
    private final InstanceMetadataManager instanceMetadataManager = MgmtFactory.getInstanceMetadataManager();
    private final DataDirectoryManager dataDirectoryManager = MgmtFactory.getDataDirectoryManager();
    private DataDirWatcher dataDirWatcher;
    private final DataArchiveBackup dataArchiveBackup = new DataArchiveBackup();
    private boolean isConsole;
    private boolean isEngine;
    private static boolean shutdownInProgress = false;
    private final ReloadRegistry reloadRegistry = new ReloadRegistry(true);
    private final Object reloadLock = new Object();
    private final File dataDirFile = new File(this.sysDirInfo.getDataDirectory());
    private final Path dataDirPath = new File(this.sysDirInfo.getDataDirectory()).toPath();
    private final ReadWriteLock configIntegrityLock = new ReentrantReadWriteLock();
    private MembershipListener mbrListen = new MembershipListenerStub(){

        @Override
        public void viewAccepted(View newView) {
            ArrayList<NodeAddress> deadNodes = new ArrayList<NodeAddress>();
            for (Object obj : MediatorImpl.this.distributedMap.keySet()) {
                NodeAddress nodeAddr;
                Address address;
                if (!(obj instanceof NodeAddress) || newView.containsMember(address = (nodeAddr = (NodeAddress)obj).getAddress())) continue;
                deadNodes.add(nodeAddr);
            }
            for (NodeAddress deadNode : deadNodes) {
                MediatorImpl.this.distributedMap.remove(deadNode);
            }
        }
    };

    public MediatorImpl() {
        try {
            this.init();
        }
        catch (Exception e) {
            SystemUtil.hardShutdown("Unexpected Exception thrown from Mediator.  This server cannot function properly.", e);
        }
    }

    private void init() {
        this.ensureDirsExist();
        JCEManager jceManager = GlobalRegistry.getService(JCEManager.class);
        jceManager.initialize();
        ShutdownHook hook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(hook);
        this.log.debug((Object)("Server operational mode: " + ModeSupport.getMode()));
        this.isConsole = ModeSupport.isConsole();
        this.isEngine = ModeSupport.isEngine();
        if (ModeSupport.isStandalone()) {
            this.log.info((Object)"Server is standalone.");
        } else {
            this.log.info((Object)"Server is not standalone so it must be part of a cluster.");
            if (this.hasConsoleRole(ModeSupport.getMode())) {
                this.log.info((Object)"Server is console.");
                if (ModeSupport.getMode() == Mode.CLUSTERED_DUAL) {
                    this.log.info((Object)"Server is engine as well as console so will use local configuration.");
                }
            }
        }
        if (this.isConsole()) {
            this.dataArchiveBackup.scheduleBackup();
        }
        boolean isDistributable = this.isDistributable();
        System.setProperty("pf.saml2.engine.web.app.distributable", String.valueOf(isDistributable));
        this.log.debug((Object)("isDistributable=" + isDistributable));
        if (this.isConsole() && !this.isStandalone()) {
            try {
                GlobalRegistry.getService(PseudonymService.class);
            }
            catch (Exception e) {
                this.log.error((Object)"Problem trying to early load the PseudonymService", (Throwable)e);
            }
        }
    }

    @Override
    public void retrieveClusterState() {
        if (ModeSupport.getMode() != Mode.STANDALONE) {
            MuxRpcDispatcherMgr muxRpcDispatcherMgr = MuxRpcDispatcherMgr.getMgr();
            muxRpcDispatcherMgr.retrieveState();
            this.distributedMap = muxRpcDispatcherMgr.getDistributedMap();
            muxRpcDispatcherMgr.addMembershipListener(this.mbrListen);
            int numberEngineNodes = ModeSupport.isEngine() ? 1 : 0;
            View view = this.distributedMap.getChannel().getView();
            if (view != null) {
                for (Object obj : this.distributedMap.keySet()) {
                    NodeAddress nodeAddr;
                    Address address;
                    if (!(obj instanceof NodeAddress) || !view.containsMember(address = (nodeAddr = (NodeAddress)obj).getAddress())) continue;
                    Mode mode = (Mode)((Object)this.distributedMap.get(nodeAddr));
                    if (this.hasConsoleRole(ModeSupport.getMode()) && this.hasConsoleRole(mode) && !MgmtFactory.getAdminNodeConfigManager().isEnabled()) {
                        this.kill("Only one server in a cluster can act as the console.  Currently that server is " + address + ". This server will not run as the console.");
                    }
                    if (!this.hasEngineRole(mode)) continue;
                    ++numberEngineNodes;
                }
            }
            this.log.debug((Object)(numberEngineNodes + " engine node(s)."));
            PingLicense license = LicenseManager.getLicense();
            if (license.exceedsNodeLimit(numberEngineNodes)) {
                DisplayableLicense displayableLicense = LicenseManager.getDisplayableLicense();
                this.kill("Adding this server would make " + numberEngineNodes + " nodes in the cluster but this system is only licensed for " + displayableLicense.getNodeLimit() + " node(s).No transactions will be processed.");
            }
            Address localAddress = this.distributedMap.getLocalAddress();
            this.log.info((Object)("local address: " + localAddress));
            Object nodeAddress = localAddress == null ? "not connected" : new NodeAddress(localAddress);
            this.distributedMap.put(nodeAddress, ModeSupport.getMode());
        }
    }

    @Override
    public void initEngineNode() {
        this.log.info((Object)"Server is engine only - looking for configuration from cluster.");
        boolean configDownloaded = MgmtFactory.getConfigReplicationService().updateConfigFromCluster();
        if (!configDownloaded && MgmtFactory.getConfigReplicationService().isRequireReplicationDataOnStartup() && !this.replStateManager.hasValidReplicationData()) {
            this.kill("Exiting as engine is configured to require replication data on startup, none was previously downloaded, and none could be retrieved from the cluster.");
        }
    }

    private void ensureDirsExist() {
        for (String path : Arrays.asList(this.sysDirInfo.getLocalDataDirectory(), this.sysDirInfo.getInstanceDataDirectory())) {
            File dir = new File(path);
            if (dir.exists()) continue;
            dir.mkdirs();
        }
    }

    private void kill(String msg) {
        SystemUtil.hardShutdown(msg, null);
    }

    private boolean hasEngineRole(Mode m) {
        return m == Mode.CLUSTERED_ENGINE || m == Mode.CLUSTERED_DUAL || m == Mode.STANDALONE;
    }

    private boolean hasConsoleRole(Mode m) {
        return m == Mode.CLUSTERED_CONSOLE || m == Mode.CLUSTERED_DUAL;
    }

    @Override
    public Mode getMode() {
        return ModeSupport.getMode();
    }

    @Override
    public boolean isDistributable() {
        return !this.isStandalone();
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        this.reloadRegistry.registerForReloadEvents(reloadable);
    }

    @Override
    public void unregisterForReloadEvents(Reloadable reloadable) {
        this.reloadRegistry.unregisterForReloadEvents(reloadable);
    }

    @Override
    public void configurePlugins() {
        if (configStore.getBooleanValue("ConfigurePluginsOnStartup", true)) {
            MgmtFactory.getSpAdapterManager().loadConfigurations();
            MgmtFactory.getIdpAdapterManager().loadConfigurations();
            MgmtFactory.getTokenGeneratorManager().loadConfigurations();
            MgmtFactory.getTokenProcessorManager().loadConfigurations();
            MgmtFactory.getBearerAccessTokenMgmtPluginMgr().loadConfigurations();
            MgmtFactory.getCredentialValidatorManager().loadConfigurations();
            MgmtFactory.getOOBAuthPluginManager().loadConfigurations();
        }
    }

    @Override
    public void reloadConfiguration() {
        this.reloadConfiguration(true);
    }

    @Override
    public void reloadConfiguration(boolean performFullReload) {
        this.reloadConfiguration(performFullReload, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfiguration(boolean performFullReload, byte[] licenseData) {
        Object object = this.reloadLock;
        synchronized (object) {
            try {
                ServiceSetManager.getDefault().createPendingServiceSet();
                this.doConfigReload(performFullReload, licenseData);
                ServiceSetManager.getDefault().activatePendingServiceSet();
            }
            finally {
                ServiceSetManager.getDefault().clearPendingServiceSet();
            }
            SoapHttpConnectionPoolingManager.getInstance().delayedClear();
            HttpConnectionPoolingManager.getInstance().delayedClear();
            ConfigStoreFarm.reloadAll();
            this.reloadRegistry.reload();
            if (this.isEngine()) {
                MgmtFactory.getBearerAccessTokenMgmtPluginMgr().loadConfigurations();
            }
            MgmtFactory.getSingleThreadedExecutor().execute(() -> {
                WarningsForHsqlDb.getInstance().reloadConnectionUsageInfo();
                WarningsForHsqlDb.getInstance().logWarningsForHsqlDbUse();
            });
        }
    }

    private void doConfigReload(boolean performFullReload, byte[] licenseData) {
        this.ensureDirsExist();
        if (licenseData != null) {
            this.deployLicense(licenseData);
        }
        ServiceSetManager.getDefault().reload();
        ConnectionModuleSupport.getInstance().reloadConfigurations();
        if (performFullReload && this.isConsole()) {
            MgmtFactory.getAdminUserManager().updateConfiguration();
            MgmtFactory.getAdminApiUserManager().updateConfiguration();
        }
        if (this.isConsole()) {
            MgmtFactory.getAdminUserManager().reload();
            MgmtFactory.getAdminApiUserManager().reload();
        }
        MgmtFactory.getUserPreferencesManager().reload();
        MgmtFactory.getPingOneAdminService().reload();
        MgmtFactory.getDSignRotationSettingsManager().reload();
        if (this.isConsole()) {
            MgmtFactory.getDSignRotationSettingsManager().startDigitalCertRotationTask();
        }
        MgmtFactory.getMetadataUpdateScheduleManager().reload();
        MgmtFactory.getPingOneAdminService().upgradeConfiguration();
        MgmtFactory.getAuthzServerManager().upgradeLegacyUserKeyToAccessTokenMappingIds();
        MgmtFactory.getAuthzServerManager().upgradeLegacyConfigStoreSettings();
        MgmtFactory.getAuthzServerManager().handleLegacyClientCredentialToAccessTokenMappingIds();
        InitMigrationUtil.addPolicyIdToAuthnPolicies();
        InitMigrationUtil.createDefaultNotificationPublisher();
        InitMigrationUtil.createDefaultCaptchaProvider();
        this.scheduleDataArchiveBackup();
        if (this.isConsole()) {
            MgmtFactory.getMetadataDirectory().getIdpConnections();
            MgmtFactory.getMetadataDirectory().getSpConnections();
        }
        MgmtFactory.getKerberosRealmManager().reload();
        MgmtFactory.getJwkFacilitator().reload();
        ServerX509TrustManager.getX509TrustManager().reload();
        MgmtFactory.getLogSettingsManager().reload();
        if (performFullReload) {
            if (this.isConsole()) {
                MgmtFactory.getAdminSslServerPkCertManager().reloadSslProviders();
            }
            if (this.isEngine()) {
                MgmtFactory.getSslServerPkCertManager().reloadSslProviders();
            }
        }
    }

    private void scheduleDataArchiveBackup() {
        if (this.isConsole()) {
            this.dataArchiveBackup.cancelBackup();
            this.dataArchiveBackup.scheduleBackup();
        }
    }

    @Override
    public byte[] getZippedConfigFromFileSystem() throws IOException {
        try (WriteLockScope lockScope = this.newExclusiveConfigIntegrityLockScope();){
            byte[] byArray = this.getZippedConfigFromFileSystem(false, PropertyInfo.getPingFederateVersion());
            return byArray;
        }
    }

    @Override
    public byte[] getZippedConfigFromFileSystem(String version) throws IOException {
        try (WriteLockScope lockScope = this.newExclusiveConfigIntegrityLockScope();){
            byte[] byArray = this.getZippedConfigFromFileSystem(false, version);
            return byArray;
        }
    }

    @Override
    public void saveToDropInDeployer(byte[] zippedConfigData) throws IOException {
        File dir = new File(this.sysDirInfo.getDropInDeployerDir());
        File archive = new File(dir, "data.zip");
        SimpleFileUtil.writeFile(archive, zippedConfigData);
    }

    @Override
    public SynchronizationRequest makeSynchronizationRequest() {
        IOFileFilter filter = this.getFileFilterForSynchronization();
        Collection files = FileUtils.listFiles((File)this.getDataDirFile(), (IOFileFilter)filter, (IOFileFilter)filter);
        HashMap<String, Long> fileTimestamps = new HashMap<String, Long>();
        files.forEach(file -> {
            String relativePath = this.makeRelativeSystemIndependentPath(this.dataDirPath, (File)file);
            fileTimestamps.put(relativePath, file.lastModified());
        });
        SynchronizationRequest result = new SynchronizationRequest();
        NodeIndexRegistry nodeIndexRegistry = MgmtFactory.getNodeIndexRegistry();
        Address localNodeAddress = nodeIndexRegistry.getLocalNodeAddress();
        if (localNodeAddress != null) {
            result.setSourceNodeAddress(localNodeAddress.toString());
        }
        result.setSourceNodeIndex(nodeIndexRegistry.getLocalNodeIndex());
        result.setConfigSyncProfileId(this.getConfigSyncProfileId());
        result.setConfigSyncTimestamp(this.getConfigSyncDate());
        result.setFileTimestamps(fileTimestamps);
        return result;
    }

    private String makeRelativeSystemIndependentPath(Path basePath, File file) {
        return basePath.relativize(file.toPath()).toString().replace("\\", "/");
    }

    private byte[] getZippedConfigFromFileSystemCoreOnly() throws IOException {
        return this.getZippedConfigFromFileSystem(true, PropertyInfo.getPingFederateVersion());
    }

    private byte[] getZippedConfigFromFileSystem(boolean coreOnly, String version) throws IOException {
        Set<File> ex = this.getExcludedDataFiles();
        if (coreOnly) {
            for (DeltaReplicationProvider provider : this.replProviderManager.getReplicationProviders()) {
                ex.add(new File(this.sysDirInfo.getDataDirectory(), provider.getManagedDirectoryName()));
            }
            ex.add(new File(this.sysDirInfo.getDataDirectory(), "pingfederate-dependency-errors.xml"));
            ex.add(new File(this.sysDirInfo.getConfigStoreDir(), "org.sourceid.util.license.Synchronizer.xml"));
            ex.add(new File(this.getDataDirFile(), "admin-api-config.xml"));
        }
        HashSet<File> inc = new HashSet<File>();
        inc.add(new File(this.sysDirInfo.getInstanceDataDirectory(), "metadata.xml"));
        HashMap<String, byte[]> additionalData = new HashMap<String, byte[]>();
        additionalData.put("archive-metadata", ConfigurationArchiveUtil.createArchiveMetadata(version));
        return ZipUtil.zip(this.getDataDirFile(), ex, inc, additionalData);
    }

    private byte[] getZippedConfigForSynchronization(Date configSyncTime, boolean fullSynchronization, Map<String, Long> targetFileTimestamps, Map<String, Long> sourceFileTimestamps) throws IOException {
        IOFileFilter filter = this.getFileFilterForSynchronization();
        Collection sourceFiles = FileUtils.listFiles((File)this.getDataDirFile(), (IOFileFilter)filter, (IOFileFilter)filter);
        ArrayList<FileEntry> zipFileEntries = new ArrayList<FileEntry>();
        HashSet<String> sourceRelativePaths = new HashSet<String>();
        for (File sourceFile : sourceFiles) {
            long lastModified = sourceFile.lastModified();
            if (lastModified >= configSyncTime.getTime()) {
                lastModified -= 100L;
            }
            String sourceRelativePath = this.makeRelativeSystemIndependentPath(this.dataDirPath, sourceFile);
            sourceRelativePaths.add(sourceRelativePath);
            Long timestamp = targetFileTimestamps.get(sourceRelativePath);
            if (timestamp != null && timestamp.equals(lastModified) && !fullSynchronization) continue;
            zipFileEntries.add(new FileEntry(sourceRelativePath, FileUtils.readFileToByteArray((File)sourceFile)));
            sourceFileTimestamps.put(sourceRelativePath, lastModified);
        }
        for (String targetFilePath : targetFileTimestamps.keySet()) {
            if (sourceRelativePaths.contains(targetFilePath)) continue;
            zipFileEntries.add(new FileEntry(targetFilePath, ReplicationRecord.TOMBSTONE_MAGIC_DATA));
        }
        if (zipFileEntries.isEmpty()) {
            return null;
        }
        this.log.debug((Object)("Creating core synchronization archive with " + zipFileEntries.size() + " files"));
        return ZipUtil.zip(zipFileEntries);
    }

    private IOFileFilter getFileFilterForSynchronization() {
        final Set<File> excluded = this.getExcludedDataFiles();
        for (DeltaReplicationProvider provider : this.replProviderManager.getReplicationProviders()) {
            excluded.add(new File(this.sysDirInfo.getDataDirectory(), provider.getManagedDirectoryName()));
        }
        IOFileFilter filter = new IOFileFilter(){

            public boolean accept(File file) {
                return !excluded.contains(file);
            }

            public boolean accept(File dir, String name) {
                return this.accept(new File(dir, name));
            }
        };
        return filter;
    }

    @Override
    public byte[] getLicenseFile() {
        byte[] license = null;
        PingLicense pingLicense = LicenseManager.getLicense();
        if (pingLicense != null) {
            String licenseFile = pingLicense.getFileData();
            license = licenseFile.getBytes(StandardCharsets.UTF_8);
        }
        return license;
    }

    @Override
    public Set<File> getExcludedDataFiles() {
        File dataDir = this.getDataDirFile();
        HashSet<File> ex = new HashSet<File>();
        ex.add(new File(dataDir, "hypersonic"));
        ex.add(new File(dataDir, "index"));
        ex.add(new File(dataDir, ".placeholder"));
        ex.add(new File(dataDir, LicenseManager.FALLBACK_KEY_FILE_NAME));
        ex.add(new File(dataDir, "drop-in-deployer"));
        ex.add(new File(dataDir, "archive"));
        ex.add(new File(this.sysDirInfo.getReplicationDirectory()));
        ex.add(new File(dataDir, "connection-deployer"));
        ex.add(new File(this.sysDirInfo.getModuleDir(), "provisioner-notify.txt"));
        ex.add(new File(this.sysDirInfo.getInstanceDataDirectory()));
        ex.add(new File(ConfigFilePaths.getPingOneIdpMetadataPath()));
        ex.add(new File(dataDir, "archive-metadata"));
        ex.add(new File(dataDir, "ping-ssl-client-trust-cas.jks"));
        return ex;
    }

    @Override
    public File getDataDirFile() {
        return this.dataDirFile;
    }

    @Override
    public File backup() throws IOException {
        byte[] zippedConfigFromFileSystem = this.getZippedConfigFromFileSystem();
        return this.dataArchiveBackup.backupConfig(zippedConfigFromFileSystem);
    }

    @Override
    public void reloadConfigChangeDate() {
        this.lazyLoadDataDirWatcher();
        if (this.dataDirWatcher != null) {
            this.dataDirWatcher.scanForLastModified();
        }
    }

    @Override
    public Date getConfigChangeDate(boolean skipSelectiveProviders) {
        this.lazyLoadDataDirWatcher();
        Date modifiedDate = null;
        if (this.dataDirWatcher != null) {
            modifiedDate = new Date(this.dataDirWatcher.getLastModified());
        }
        PingLicense license = LicenseManager.getLicense();
        Date licenseModifiedDate = license.getModifiedTime();
        if (modifiedDate == null || licenseModifiedDate.after(modifiedDate)) {
            modifiedDate = licenseModifiedDate;
        }
        for (DeltaReplicationProvider provider : this.replProviderManager.getReplicationProviders()) {
            Date latestUpdate;
            if (skipSelectiveProviders && provider.selectiveReplicationEnabled() || !(latestUpdate = provider.getLatestUpdateTimestamp()).after(modifiedDate)) continue;
            modifiedDate = latestUpdate;
        }
        return modifiedDate;
    }

    @Override
    public boolean getClusterReplicationRequiredStatus() {
        if (!this.isReplicationSource()) {
            return true;
        }
        if (!this.replStateManager.getUnreplicatedData().isEmpty()) {
            return true;
        }
        Date configChangeDate = this.getConfigChangeDate(true);
        Date configPublishDate = this.getConfigPublishDate();
        if (configChangeDate == null || configPublishDate == null) {
            return true;
        }
        return configChangeDate.after(configPublishDate);
    }

    @Override
    public Date getConfigSyncDate() {
        return this.replStateManager.getConfigSyncTimestamp();
    }

    private void lazyLoadDataDirWatcher() {
        if (this.dataDirWatcher == null && this.isConsole()) {
            this.log.debug((Object)("Server is " + (this.isStandalone() ? "standalone" : "the admin console for a cluster") + ", starting background thread to monitor configuration file changes."));
            this.dataDirWatcher = new DataDirWatcher(this.getDataDirFile());
        }
    }

    @Override
    public Date getConfigPublishDate() {
        return this.replStateManager.getConfigTimestamp();
    }

    @Override
    public Date getAutomaticConfigPublishDate() {
        return this.replStateManager.getAutomaticConfigTimeStamp();
    }

    @Override
    public void publishConfig() throws IOException {
        try (WriteLockScope scope = this.newExclusiveConfigIntegrityLockScope();){
            this.log.info((Object)"Publishing config to the cluster");
            this.replStateManager.clearUnreplicatedData();
            this.applyPublishWait();
            Date replTimestamp = new Date();
            ReplicationData replData = new ReplicationData(this.replStateManager.getConfigProfileId(), replTimestamp);
            byte[] license = this.getLicenseFile();
            replData.setLicense(license);
            this.log.debug((Object)"Generating core archive");
            ReplicationArchive coreArchive = new ReplicationArchive(this.getZippedConfigFromFileSystemCoreOnly(), replTimestamp);
            replData.setCoreArchive(coreArchive);
            if (this.replStateManager.getReplicationData().getBaseDeltaArchive() == null) {
                replData.setBaseDeltaArchive(this.makeDeltaArchive(null, replTimestamp, true));
            } else {
                Date startTime = this.replStateManager.getReplicationData().getLatestArchiveTimestamp(true);
                ReplicationArchive deltaArchive = this.makeDeltaArchive(startTime, replTimestamp, false);
                if (deltaArchive != null) {
                    replData.setDeltaArchives(Arrays.asList(deltaArchive));
                }
            }
            this.replStateManager.mergeReplicationData(replData);
            int tombstoneRetentionPeriodSecs = configStore.getIntValue("TombstoneRetentionPeriodSecs", 3600);
            Instant tombstoneThreshold = Instant.now().minus(Duration.ofSeconds(tombstoneRetentionPeriodSecs));
            for (DeltaReplicationProvider provider : this.replProviderManager.getReplicationProviders()) {
                provider.deleteTombstones(Date.from(tombstoneThreshold));
            }
        }
        this.notifyConfigPublished();
    }

    @Override
    public void checkPublishConfig() {
        if (this.isDistributable() && MgmtFactory.getConfigReplicationService().isPublishReplicationDataOnStartup()) {
            if (this.isConsole() && UpgradeInfo.isPostUpgradeProcessingRequired() && !MgmtFactory.getAdminNodeConfigManager().isEnabledAndPassiveNode()) {
                try {
                    this.publishConfig();
                }
                catch (IOException e) {
                    throw new ProcessRuntimeException("Error occurred while replicating configuration", e);
                }
            } else if (this.replStateManager.hasValidReplicationData()) {
                this.replStateManager.setConfigProfileValidForReplication(true);
                if (this.isConsole()) {
                    this.notifyConfigPublished();
                }
            }
        }
    }

    @Override
    public LockScope newSharedConfigIntegrityLockScope() {
        return new LockScope(this.configIntegrityLock.readLock());
    }

    @Override
    public WriteLockScope newExclusiveConfigIntegrityLockScope() {
        return new WriteLockScope(this.configIntegrityLock);
    }

    private ReplicationArchive makeDeltaArchive(Date startTime, Date endTime, boolean createIfEmpty) {
        this.log.trace((Object)("Creating delta archive, startTime=" + startTime + ", endTime=" + endTime));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int recordCount = 0;
        try (ZipOutputStream zipOut = new ZipOutputStream(byteArrayOutputStream);){
            for (DeltaReplicationProvider provider : this.replProviderManager.getReplicationProviders()) {
                Iterator<ReplicationRecord> records = provider.getReplicationRecords(startTime);
                while (records.hasNext()) {
                    ReplicationRecord record = records.next();
                    ZipEntry zipEntry = new ZipEntry(provider.getManagedDirectoryName() + "/" + record.getId());
                    zipOut.putNextEntry(zipEntry);
                    zipOut.write(record.getData());
                    ++recordCount;
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unexpected error creating delta archive", e);
        }
        if (recordCount == 0 && !createIfEmpty) {
            return null;
        }
        if (recordCount > 0) {
            this.log.debug((Object)("Creating delta archive with " + recordCount + " records"));
        }
        return new ReplicationArchive(byteArrayOutputStream.toByteArray(), endTime);
    }

    @Override
    public String getConfigProfileId() {
        return this.replStateManager.getConfigProfileId();
    }

    @Override
    public String getConfigSyncProfileId() {
        return this.replStateManager.getConfigSyncProfileId();
    }

    @Override
    public boolean isReplicationSource() {
        return this.replStateManager.isConfigProfileValidForReplication() && this.replStateManager.hasValidReplicationData();
    }

    @Override
    public void setConfigProfileValidForReplication(boolean valid) {
        this.replStateManager.setConfigProfileValidForReplication(valid);
    }

    @Override
    public ReplicationData getReplicationData(String configProfileId, Date startTime) {
        ReplicationData replicationData = this.replStateManager.getReplicationData(configProfileId, startTime);
        replicationData.setDataVersion(this.instanceMetadataManager.getDataVersion());
        return replicationData;
    }

    @Override
    public DataArchiveBackup getDataArchiveBackup() {
        return this.dataArchiveBackup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deployReplicationData(ReplicationData replData) {
        if (this.isCurrentConfigMoreRecent(replData)) {
            this.log.debug((Object)"Local config timestamp is greater than or equal to incoming config timestamp, nothing updated");
            return;
        }
        if (this.isEngine()) {
            ConfigUpdateType updateType = this.getConfigUpdateType(replData);
            try {
                this.log.info((Object)"Deploying configuration from cluster.");
                ConfigUpdateCoordinator.getInstance().setUpdateInProgress(updateType);
                JsonWebKeySet oldKeySet = MgmtFactory.getMasterKeySet().getJsonWebKeySet();
                boolean fullReloadNeeded = false;
                if (replData.getCoreArchive() != null && this.isCoreConfigOutOfDate(replData)) {
                    this.dataDirectoryManager.deployCoreArchive(replData.getCoreArchive().getData(), EnumSet.of(DeploymentOption.REPLICATION));
                    fullReloadNeeded = true;
                }
                if (replData.getBaseDeltaArchive() != null) {
                    this.dataDirectoryManager.deployDeltaArchive(replData.getBaseDeltaArchive().getData(), true, false, false);
                    fullReloadNeeded = true;
                }
                for (ReplicationArchive archive : replData.getDeltaArchives()) {
                    this.dataDirectoryManager.deployDeltaArchive(archive.getData(), false, false, false);
                    fullReloadNeeded = true;
                }
                for (ReplicationArchive archive : replData.getSelectiveArchives()) {
                    this.dataDirectoryManager.deployDeltaArchive(archive.getData(), false, true, false);
                }
                this.replStateManager.mergeReplicationData(replData);
                this.instanceMetadataManager.setDataVersion(replData.getDataVersion());
                if (!fullReloadNeeded) return;
                this.log.debug((Object)"Reloading configuration...");
                this.reloadConfiguration(true, replData.getLicense());
                DataDeployer dataDeployer = new DataDeployer();
                try {
                    dataDeployer.reencryptInstanceFiles(oldKeySet);
                }
                catch (IOException e) {
                    throw new ConfigurationException("Error reencrypting instance files", e);
                }
                MgmtFactory.getTimerTaskManager().scheduleTasks();
                ThreadPoolExhaustionService.getInstance().start();
                dataDeployer.mergeMasterKeySets(oldKeySet);
                return;
            }
            finally {
                ConfigUpdateCoordinator.getInstance().clearUpdateInProgress();
            }
        }
        this.replStateManager.mergeReplicationData(replData);
    }

    @Override
    public SynchronizationData getSynchronizationData(SynchronizationRequest request) throws IOException {
        try (WriteLockScope ignored = this.newExclusiveConfigIntegrityLockScope();){
            this.log.trace((Object)"Gathering synchronization data for passive admin node from file system");
            Date startTime = request.getConfigSyncTimestamp();
            if (!StringUtils.equals((CharSequence)request.getConfigSyncProfileId(), (CharSequence)this.getConfigSyncProfileId())) {
                startTime = null;
            }
            if (startTime != null) {
                for (DeltaReplicationProvider provider : this.replProviderManager.getReplicationProviders()) {
                    if (!startTime.before(provider.getTombstoneTrackingStartTime())) continue;
                    startTime = null;
                    break;
                }
            }
            SynchronizationData synchronizationData = new SynchronizationData();
            synchronizationData.setDataVersion(this.instanceMetadataManager.getDataVersion());
            synchronizationData.setFullSynchronization(startTime == null);
            synchronizationData.setConfigSyncProfileId(this.getConfigSyncProfileId());
            Date configSyncTime = new Date();
            synchronizationData.setConfigSyncTimestamp(configSyncTime);
            byte[] license = this.getLicenseFile();
            synchronizationData.setLicense(license);
            HashMap<String, Long> sourceFileTimestamps = new HashMap<String, Long>();
            byte[] coreArchive = this.getZippedConfigForSynchronization(configSyncTime, startTime == null, request.getFileTimestamps(), sourceFileTimestamps);
            if (coreArchive != null) {
                synchronizationData.setCoreArchive(new ReplicationArchive(coreArchive, configSyncTime));
                synchronizationData.setCoreArchiveTimestamps(sourceFileTimestamps);
            }
            synchronizationData.setDeltaArchive(this.makeDeltaArchive(startTime, configSyncTime, false));
            this.replStateManager.saveConfigSyncProfileInfo(this.getConfigSyncProfileId(), configSyncTime);
            SynchronizationData synchronizationData2 = synchronizationData;
            return synchronizationData2;
        }
    }

    @Override
    public void deploySynchronizationData(SynchronizationData syncData) {
        JsonWebKeySet oldKeySet = MgmtFactory.getMasterKeySet().getJsonWebKeySet();
        if (syncData.getLicense() != null) {
            this.deployLicense(syncData.getLicense());
        }
        if (syncData.getCoreArchive() != null) {
            Set<String> changedFiles = this.dataDirectoryManager.deploySynchronizationArchive(syncData.getCoreArchive().getData(), syncData.getCoreArchiveTimestamps());
            if (changedFiles.contains("pingfederate-admin-user.xml")) {
                MgmtFactory.getAdminUserManager().reload();
                MgmtFactory.getAdminApiUserManager().reload();
            }
            if (changedFiles.contains(INITIAL_SETUP_CONFIG_STORE_FILE)) {
                InitialSetupConfigStore.reload();
            }
        }
        if (syncData.getDeltaArchive() != null) {
            this.dataDirectoryManager.deployDeltaArchive(syncData.getDeltaArchive().getData(), syncData.isFullSynchronization(), false, true);
        }
        MgmtFactory.getMasterKeySet().reload();
        DataDeployer dataDeployer = new DataDeployer();
        try {
            dataDeployer.reencryptInstanceFiles(oldKeySet);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reencrypting instance files", e);
        }
        if (syncData.getDataVersion() == null) {
            this.log.debug((Object)"syncData.getVersion() is null");
        } else if (!VersionUtil.isValidVersion((String)syncData.getDataVersion())) {
            this.log.warn((Object)("Invalid version number in synchronization data: " + syncData.getDataVersion()));
        } else {
            this.instanceMetadataManager.setDataVersion(syncData.getDataVersion());
        }
        dataDeployer.mergeMasterKeySets(oldKeySet);
        this.replStateManager.saveConfigSyncProfileInfo(syncData.getConfigSyncProfileId(), syncData.getConfigSyncTimestamp());
    }

    private ConfigUpdateType getConfigUpdateType(ReplicationData replData) {
        if (replData.getCoreArchive() == null) {
            return ConfigUpdateType.SELECTIVE_RELOAD;
        }
        return replData.getBaseDeltaArchive() != null ? ConfigUpdateType.FULL_CONFIG_RELOAD : ConfigUpdateType.CONFIG_RELOAD;
    }

    private boolean isCurrentConfigMoreRecent(ReplicationData replData) {
        if (this.replStateManager.getConfigTimestamp() == null) {
            return false;
        }
        boolean appliedDataIsMoreRecent = !this.replStateManager.getConfigTimestamp().before(replData.getConfigTimestamp()) && (replData.getAutomaticConfigTimeStamp() == null || !this.replStateManager.getConfigTimestamp().before(replData.getAutomaticConfigTimeStamp()));
        return this.replStateManager.getConfigProfileId().equals(replData.getConfigProfileId()) && appliedDataIsMoreRecent && !Node.ReplicationStatus.FAILED.equals((Object)MgmtFactory.getNodeIndexRegistry().getLocalNodeReplicationStatus());
    }

    private boolean isCoreConfigOutOfDate(ReplicationData replicationData) {
        if (this.replStateManager.getConfigTimestamp() == null) {
            return true;
        }
        return this.replStateManager.getConfigTimestamp().before(replicationData.getCoreArchive().getTimestamp());
    }

    private void deployLicense(byte[] licenseData) {
        String licenseFilePath = LicenseManager.getLicenseKeyFile();
        PingLicense license = new PingLicense(licenseFilePath);
        boolean importClusterLicense = true;
        String rawLicense = new String(licenseData, StandardCharsets.UTF_8);
        if (license.licenseFileExists()) {
            Date issueDate = license.getIssueDate();
            try {
                PingLicense clusterLicense = new PingLicense(rawLicense, true);
                if (clusterLicense.licenseFileExists()) {
                    Date clusterLicenseIssue = clusterLicense.getIssueDate();
                    if (issueDate.after(clusterLicenseIssue)) {
                        this.log.warn((Object)("The License date (" + clusterLicenseIssue.toInstant() + ") from the cluster is older than the engine's License (" + issueDate.toInstant() + "). The older license (cluster) will be applied."));
                    }
                    if (license.getFingerPrint().equals(clusterLicense.getFingerPrint())) {
                        if (!this.isConsole) {
                            this.log.debug((Object)"License from cluster ignored as this node's license has the same fingerprint.");
                        }
                        importClusterLicense = false;
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to read license and import license from cluster " + e.getMessage()));
            }
        }
        if (importClusterLicense) {
            this.log.debug((Object)"Deploying license file from cluster.");
            ArrayList<String> errors = new ArrayList<String>();
            LicenseManager.importLicense(rawLicense, errors);
            for (String error : errors) {
                this.log.error((Object)error);
            }
        }
    }

    protected void notifyConfigPublished() {
        MgmtFactory.getConfigReplicationService().notifyConfigPublished();
        MgmtFactory.getNodeIndexRegistry().setLocalNodeReplicationStatus(Node.ReplicationStatus.IDLE);
        MgmtFactory.getSingleThreadedExecutor().execute(() -> ListenerRegistry.getInstance().notifyListeners(ConfigEventType.CONFIG_PUBLISHED));
    }

    @Override
    public boolean isConsole() {
        return this.isConsole;
    }

    @Override
    public boolean isEngine() {
        return this.isEngine;
    }

    @Override
    public boolean isStandalone() {
        return ModeSupport.isStandalone();
    }

    @Override
    public int getNumOfActiveNodes() {
        int nodeCount = 1;
        if (this.distributedMap != null) {
            JChannel channel = this.distributedMap.getChannel();
            nodeCount = channel.getView().getMembers().size();
        }
        return nodeCount;
    }

    @Override
    public Collection<Address> getClusterMembers() {
        if (this.distributedMap == null) {
            return Collections.emptyList();
        }
        View view = this.distributedMap.getChannel().getView();
        if (view == null) {
            return Collections.emptyList();
        }
        return view.getMembers();
    }

    @Override
    public String getClusterIpAddress() {
        if (this.distributedMap == null) {
            return null;
        }
        Address address = this.distributedMap.getLocalAddress();
        if (address == null) {
            return null;
        }
        String addressString = address.toString();
        int colonIndex = addressString.lastIndexOf(58);
        if (colonIndex < 0) {
            return addressString;
        }
        return addressString.substring(0, colonIndex);
    }

    @Override
    public void addListener(MediatorListener listener) {
        ListenerRegistry.getInstance().addListener(ConfigEventType.CONFIG_PUBLISHED, listener, MediatorListener::onConfigPublished);
    }

    @Override
    public void removeListener(MediatorListener listener) {
        ListenerRegistry.getInstance().removeListener(ConfigEventType.CONFIG_PUBLISHED, listener);
    }

    @Override
    public TimerTaskBase getDataZipTimerTask() {
        return new TimerTaskBase(){

            @Override
            public void doTask() {
                if (Boolean.TRUE.toString().equals(System.getProperty("pf.jetty.started"))) {
                    if (!shutdownInProgress && MediatorImpl.LUNA_MODE.equalsIgnoreCase(System.getProperty(MediatorImpl.FIPS_KEY))) {
                        try {
                            LunaUtil.ping();
                        }
                        catch (Exception ex) {
                            try {
                                ConfigUpdateCoordinator.getInstance().setUpdateInProgress(ConfigUpdateType.HSM_RECONNECT);
                                this.log.warn((Object)"Connection to Luna HSM is lost.  Attempting to reinitialize the connection and reload the configuration.");
                                if (LunaUtil.handleException(ex)) {
                                    MediatorImpl.this.reloadConfiguration();
                                }
                            }
                            finally {
                                ConfigUpdateCoordinator.getInstance().clearUpdateInProgress();
                            }
                        }
                    }
                    new DataDeployer().attemptDeployData();
                }
            }
        };
    }

    @Override
    public void applyPartialReplicationRecords(Collection<ReplicationRecord> replicationRecords, DeltaReplicationProvider provider) {
        this.log.debug((Object)"Creating delta archive");
        if (replicationRecords == null || replicationRecords.isEmpty()) {
            return;
        }
        this.applyPublishWait();
        ByteArrayOutputStream outputStream = this.createReplicationOutputStream(replicationRecords, provider);
        Date archiveTimestamp = new Date();
        String currentConfigProfileId = this.replStateManager.getConfigProfileId();
        Date configTimestamp = this.replStateManager.getConfigTimestamp();
        ReplicationData replicationData = new ReplicationData(currentConfigProfileId, configTimestamp);
        replicationData.setAutomaticConfigTimeStamp(archiveTimestamp);
        ReplicationArchive replicationArchive = new ReplicationArchive(outputStream.toByteArray(), archiveTimestamp, true);
        replicationData.getDeltaArchives().add(replicationArchive);
        this.replStateManager.mergeReplicationData(replicationData);
        this.notifyConfigPublished();
    }

    @Override
    public void applySelectiveReplicationRecords(Collection<ReplicationRecord> replicationRecords, DeltaReplicationProvider provider) {
        this.log.debug((Object)"Creating selective replication archive");
        if (replicationRecords == null || replicationRecords.isEmpty()) {
            return;
        }
        this.applyPublishWait();
        ByteArrayOutputStream outputStream = this.createReplicationOutputStream(replicationRecords, provider);
        Date archiveTimestamp = new Date();
        String currentConfigProfileId = this.replStateManager.getConfigProfileId();
        Date configTimestamp = this.replStateManager.getConfigTimestamp();
        ReplicationData replicationData = new ReplicationData(currentConfigProfileId, configTimestamp);
        replicationData.setAutomaticConfigTimeStamp(archiveTimestamp);
        ReplicationArchive replicationArchive = new ReplicationArchive(outputStream.toByteArray(), archiveTimestamp, false, true);
        replicationData.getSelectiveArchives().add(replicationArchive);
        this.replStateManager.mergeReplicationData(replicationData);
        this.notifyConfigPublished();
    }

    private ByteArrayOutputStream createReplicationOutputStream(Collection<ReplicationRecord> replicationRecords, DeltaReplicationProvider provider) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOut = new ZipOutputStream(outputStream);){
            for (ReplicationRecord record : replicationRecords) {
                ZipEntry zipEntry = new ZipEntry(provider.getManagedDirectoryName() + "/" + record.getId());
                zipOut.putNextEntry(zipEntry);
                zipOut.write(record.getData());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unexpected error creating delta archive", e);
        }
        return outputStream;
    }

    private void applyPublishWait() {
        try {
            Thread.sleep(configStore.getLongValue("ConfigPublishDelayMillis", 1000L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class ShutdownHook
    extends Thread {
        private final Log log = LogFactory.getLog(ShutdownHook.class);

        private ShutdownHook() {
        }

        @Override
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="introduced by java 11 language level change")
        public void run() {
            shutdownInProgress = true;
            DeferredInitServlet.shutdown();
            if (MgmtFactory.getMediator().isDistributable()) {
                try {
                    StateMgmtFactory.getDistributedStateCoordinator().prepareForShutdown();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error preparing distributed state coordinator for shutdown", (Throwable)e);
                }
                try {
                    this.log.info((Object)"Closing cluster channel");
                    MuxRpcDispatcherMgr.getMgr().getRpcDispatcher().getChannel().close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Problem closing cluster channel", (Throwable)e);
                }
            }
            if (PropertyInfo.getRuntimeHttpsPort() != null || PropertyInfo.getRuntimeHttpPort() != null) {
                PrintWriter printWriter = SystemUtil.getPrintWriterInstance();
                printWriter.println();
                printWriter.println("PingFederate shutdown...");
                printWriter.flush();
                this.log.info((Object)"PingFederate shutdown...");
            }
            LogManager.shutdown();
        }
    }
}

