/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.Cert;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTask;
import org.sourceid.saml20.domain.util.DsigUtil;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.w3c.dom.Node;

public class MetadataUpdateTaskHelper {
    private static final Log log = LogFactory.getLog(MetadataUpdateTaskHelper.class);

    private MetadataUpdateTaskHelper() {
    }

    public static Collection<String> mergeConnection(ConnectionBase connectionBase, ConnectionBase metadataConnection) {
        ArrayList<String> updatedComponents = new ArrayList<String>(3);
        if (metadataConnection != null) {
            boolean contactInfoUpdated = MetadataImportExportUtil.mergeContactInfo(connectionBase, metadataConnection);
            boolean verificationCertUpdated = MetadataImportExportUtil.mergeVerificationCert(connectionBase, metadataConnection);
            boolean encryptCertUpdated = MetadataImportExportUtil.mergeEncryptionCert(connectionBase, metadataConnection);
            updatedComponents.addAll(MetadataUpdateTaskHelper.getUpdatedComponents(contactInfoUpdated, verificationCertUpdated, encryptCertUpdated));
        }
        return updatedComponents;
    }

    private static Collection<String> getUpdatedComponents(boolean contactInfoUpdated, boolean verificationCertUpdated, boolean encryptCertUpdated) {
        ArrayList<String> updatedComponents = new ArrayList<String>(3);
        String contactInfo = MetadataUpdateTaskHelper.appendComponentName(contactInfoUpdated, MetadataUpdateTask.Component.CONTACT_INFO);
        String verfCert = MetadataUpdateTaskHelper.appendComponentName(verificationCertUpdated, MetadataUpdateTask.Component.VERIFICATION_CERT);
        String encryPtCert = MetadataUpdateTaskHelper.appendComponentName(encryptCertUpdated, MetadataUpdateTask.Component.ENCRYPTION_CERTIFICATE);
        if (StringUtils.isNotBlank((String)contactInfo)) {
            updatedComponents.add(contactInfo);
        }
        if (StringUtils.isNotBlank((String)verfCert)) {
            updatedComponents.add(verfCert);
        }
        if (StringUtils.isNotBlank((String)encryPtCert)) {
            updatedComponents.add(encryPtCert);
        }
        return updatedComponents;
    }

    private static String appendComponentName(boolean isComponentUpdate, MetadataUpdateTask.Component component) {
        if (isComponentUpdate) {
            return component.toString();
        }
        return null;
    }

    public static XmlObject getMetadataXml(MetadataUrlCertPair metadataUrlCert) throws MetadataImportException {
        if (metadataUrlCert == null) {
            return null;
        }
        XmlObject metadataXml = null;
        try {
            boolean validSignature = false;
            InputStream samlMetadataStream = null;
            XmlObject downloadedXml = null;
            samlMetadataStream = MetadataUpdateTaskHelper.downloadMetadataFromUrl(metadataUrlCert.getUrl());
            downloadedXml = MetadataUpdateTaskHelper.initXmlAndVerifier(samlMetadataStream);
            samlMetadataStream.close();
            if (metadataUrlCert.isValidateSignature()) {
                XmlSignatureVerifier signatureVerifier = MetadataUpdateTaskHelper.createSignatureVerifier(metadataUrlCert, downloadedXml);
                validSignature = MetadataUpdateTaskHelper.validateSignature(signatureVerifier);
                if (validSignature) {
                    metadataXml = downloadedXml;
                }
            } else {
                metadataXml = downloadedXml;
            }
        }
        catch (Exception e) {
            throw new MetadataImportException(e.getMessage());
        }
        return metadataXml;
    }

    private static XmlSignatureVerifier createSignatureVerifier(MetadataUrlCertPair metadataUrlCert, XmlObject metadataXml) {
        XmlSignatureVerifier signatureVerifier = DsigUtil.createVerifier(metadataXml);
        Cert verificationCert = metadataUrlCert.getVerificationCert();
        if (verificationCert == null) {
            signatureVerifier.setProvidedX509Cert(null);
        } else {
            signatureVerifier.setProvidedX509Cert(verificationCert.getX509Certificate());
        }
        return signatureVerifier;
    }

    public static ConnectionBase getConnectionWithEntityId(String entityId, Collection<ConnectionBase> connections) throws MetadataImportException {
        ConnectionBase validConnection = null;
        if (connections != null) {
            for (ConnectionBase connectionBase : connections) {
                if (!connectionBase.getEntityId().equals(entityId)) continue;
                validConnection = connectionBase;
                break;
            }
            if (connections.size() > 0 && validConnection == null) {
                String errorMessage = "Metadata for the entity id '" + entityId + "' not found in the input metadata URL.";
                throw new MetadataImportException(errorMessage);
            }
        }
        return validConnection;
    }

    public static InputStream downloadMetadataFromUrl(String metadataUrl) throws ValidationException {
        log.debug((Object)("Downloading metadata from URL " + metadataUrl));
        String errorMessage = null;
        InputStream stream = null;
        try {
            URL url = new URL(metadataUrl);
            String host = url.getHost();
            if (StringUtils.isBlank((String)host)) {
                errorMessage = "'" + metadataUrl + "' is not a valid URL. Please include a host name or IP address.";
                throw new ValidationException(errorMessage);
            }
            stream = url.openStream();
        }
        catch (Exception e) {
            errorMessage = "Unable to communicate with Metadata URL '" + metadataUrl + "'.";
            if (e.getCause() != null && StringUtils.isNotBlank((String)e.getCause().getMessage())) {
                errorMessage = errorMessage + e.getCause().getMessage() + ".";
            }
            log.debug((Object)errorMessage, (Throwable)e);
            throw new ValidationException("Unable to communicate with metadata URL. Confirm the URL is correct and reachable. Check logs for more details.");
        }
        return stream;
    }

    private static XmlObject initXmlAndVerifier(InputStream samlMetadataStream) throws ValidationException {
        try {
            Node node = XmlBeansUtil.parseToNode(samlMetadataStream);
            return XmlObject.Factory.parse((Node)node);
        }
        catch (Exception e) {
            log.debug((Object)"Importing metadata file caused a exception.", (Throwable)e);
            throw new ValidationException("The SAML XML metadata file or URL you provided is invalid.");
        }
    }

    private static boolean validateSignature(XmlSignatureVerifier verifier) throws ValidationException {
        if (verifier != null) {
            if (verifier.hasCert()) {
                if (verifier.isCertKnownToBeRevoked()) {
                    throw new ValidationException("Certificate used to sign XML file is revoked.");
                }
                if (verifier.getSignatureStatus() != SignatureStatus.VALID) {
                    String errorMessage = "Invalid signature on metadata file.";
                    if (verifier.getSignatureStatus() == SignatureStatus.NOT_PRESENT) {
                        errorMessage = "A certificate is configured for the metadata URL, but the metadata is unsigned";
                    }
                    throw new ValidationException(errorMessage);
                }
                X509Certificate cert = verifier.getEffectiveCert();
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    throw new ValidationException("An error occurred while importing the metadata file. The certificate used to sign the file has expired.");
                }
                catch (CertificateNotYetValidException e) {
                    throw new ValidationException("An error occurred while importing the metadata file. The certificate used to sign the file is not yet valid.");
                }
                return true;
            }
            if (verifier.hasSignature()) {
                throw new ValidationException("The metadata is signed, but no verification certificate is associated with the URL");
            }
        }
        return true;
    }
}

