/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import com.pingidentity.x2015.x01.metadataUrl.MetadataUrlCertType;
import com.pingidentity.x2015.x01.metadataUrl.MetadataUrlsDocument;
import com.pingidentity.x2015.x01.metadataUrl.MetadataUrlsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MetadataUrlManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;

public class MetadataUrlManagerImpl
extends ConfigManagerBase
implements MetadataUrlManager,
AutoReloadable {
    private static Log log = LogFactory.getLog(MetadataUrlManagerImpl.class);
    private static final String PF_METADATE_URL_XML_FILE_NAME = "pingfederate-metadata-url.xml";
    private Map<String, MetadataUrlCertPair> metadataUrlCertPairs = new HashMap<String, MetadataUrlCertPair>();
    private Set<String> metadataUrls = new HashSet<String>();

    public MetadataUrlManagerImpl() {
        this.loadConfig();
    }

    private synchronized void loadConfig() {
        this.reloadFromXml();
    }

    private synchronized void reloadFromXml() {
        MetadataUrlCertType[] urlCertTypes;
        this.metadataUrlCertPairs.clear();
        this.metadataUrls.clear();
        MetadataUrlsDocument metadataUrlDoc = this.getDoc();
        MetadataUrlsType urlsType = metadataUrlDoc.getMetadataUrls();
        for (MetadataUrlCertType urlCertType : urlCertTypes = urlsType.getMetadataUrlCertTypeArray()) {
            MetadataUrlCertPair urlCert = new MetadataUrlCertPair(urlCertType.getId(), urlCertType.getMetadataUrl(), urlCertType.getCertAlias(), urlCertType.getName(), urlCertType.isSetValidateSignature() ? urlCertType.getValidateSignature() : true);
            this.metadataUrlCertPairs.put(urlCertType.getId(), urlCert);
            this.metadataUrls.add(urlCert.getUrl());
        }
    }

    private MetadataUrlsDocument getDoc() {
        String dataDir = this.sysDirInfo.getDataDirectory();
        return (MetadataUrlsDocument)this.xmlLoader.load(dataDir, PF_METADATE_URL_XML_FILE_NAME);
    }

    @Override
    public synchronized MetadataUrlCertPair saveMetadataUrl(MetadataUrlCertPair metadataUrlPair) {
        if (metadataUrlPair == null || StringUtils.isBlank((String)metadataUrlPair.getUrl())) {
            return null;
        }
        String id = metadataUrlPair.getId();
        if (StringUtils.isBlank((String)id)) {
            id = IDGenerator.rndAlphaNumeric((int)25);
        }
        log.debug((Object)("Saving Metadata URL: " + metadataUrlPair.getUrl()));
        MetadataUrlsDocument metadataUrlDoc = this.getDoc();
        MetadataUrlsType urlsType = metadataUrlDoc.getMetadataUrls();
        MetadataUrlCertType[] urlCertTypes = urlsType.getMetadataUrlCertTypeArray();
        ArrayList<MetadataUrlCertType> metadataUrls = new ArrayList<MetadataUrlCertType>(Arrays.asList(urlCertTypes));
        if (this.metadataUrlCertPairs.containsKey(id)) {
            for (MetadataUrlCertType urlCertType : metadataUrls) {
                if (!id.equals(urlCertType.getId())) continue;
                urlCertType.setMetadataUrl(metadataUrlPair.getUrl());
                urlCertType.setName(metadataUrlPair.getName());
                urlCertType.setValidateSignature(metadataUrlPair.isValidateSignature());
                if (metadataUrlPair.isValidateSignature()) {
                    urlCertType.setCertAlias(metadataUrlPair.getCertAlias());
                    continue;
                }
                urlCertType.setCertAlias(null);
            }
        } else {
            MetadataUrlCertType newMetadataUrl = MetadataUrlCertType.Factory.newInstance();
            newMetadataUrl.setId(id);
            metadataUrlPair.setId(id);
            newMetadataUrl.setMetadataUrl(metadataUrlPair.getUrl());
            newMetadataUrl.setName(metadataUrlPair.getName());
            newMetadataUrl.setValidateSignature(metadataUrlPair.isValidateSignature());
            if (metadataUrlPair.isValidateSignature()) {
                newMetadataUrl.setCertAlias(metadataUrlPair.getCertAlias());
            }
            metadataUrls.add(newMetadataUrl);
        }
        MetadataUrlCertType[] updatedUrlCertTypes = new MetadataUrlCertType[metadataUrls.size()];
        metadataUrls.toArray(updatedUrlCertTypes);
        urlsType.setMetadataUrlCertTypeArray(updatedUrlCertTypes);
        MetadataUrlCertPair existingMetadata = this.getMetadataUrlPair(metadataUrlPair.getId());
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.saveMetadataUrls(metadataUrlDoc);
            auditLoggerScope.log(AdminAuditLogger.Component.METADATA_URL, existingMetadata == null ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY, metadataUrlPair.getUrl());
        }
        return metadataUrlPair;
    }

    @Override
    public synchronized boolean deleteMetadataUrl(String metadataUrlId) {
        boolean deleted = false;
        if (StringUtils.isBlank((String)metadataUrlId)) {
            return deleted;
        }
        MetadataUrlsDocument metadataUrlDoc = this.getDoc();
        MetadataUrlsType urlsType = metadataUrlDoc.getMetadataUrls();
        MetadataUrlCertType[] urlCertTypes = urlsType.getMetadataUrlCertTypeArray();
        ArrayList<MetadataUrlCertType> metadataUrls = new ArrayList<MetadataUrlCertType>(urlCertTypes.length);
        for (MetadataUrlCertType urlCertType : urlCertTypes) {
            if (!metadataUrlId.equals(urlCertType.getId())) {
                metadataUrls.add(urlCertType);
                continue;
            }
            log.debug((Object)("Deleting metadata URL and certificate pair with id " + metadataUrlId));
            deleted = true;
        }
        MetadataUrlCertType[] updatedUrlCertTypes = new MetadataUrlCertType[metadataUrls.size()];
        metadataUrls.toArray(updatedUrlCertTypes);
        urlsType.setMetadataUrlCertTypeArray(updatedUrlCertTypes);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            MetadataUrlCertPair metadataUrlCertPairToDelete = this.getMetadataUrlPair(metadataUrlId);
            this.saveMetadataUrls(metadataUrlDoc);
            auditLoggerScope.log(AdminAuditLogger.Component.METADATA_URL, AdminAuditLogger.Event.DELETE, metadataUrlCertPairToDelete.getUrl());
        }
        return deleted;
    }

    @Override
    public synchronized MetadataUrlCertPair getMetadataUrlPair(String metadataId) {
        log.debug((Object)("Getting Metadata URL for Id: " + metadataId));
        MetadataUrlCertPair existingPair = this.metadataUrlCertPairs.get(metadataId);
        MetadataUrlCertPair metadataCertPair = null;
        if (existingPair != null) {
            metadataCertPair = new MetadataUrlCertPair(existingPair.getId(), existingPair.getUrl(), existingPair.getCertAlias(), existingPair.getName(), existingPair.isValidateSignature());
        }
        return metadataCertPair;
    }

    @Override
    public synchronized Collection<MetadataUrlCertPair> getMetadataUrlPairs() {
        ArrayList<MetadataUrlCertPair> metadataUrls = new ArrayList<MetadataUrlCertPair>(this.metadataUrlCertPairs.values());
        return metadataUrls;
    }

    private synchronized void saveMetadataUrls(MetadataUrlsDocument metadataUrlDoc) {
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), PF_METADATE_URL_XML_FILE_NAME, (XmlObject)metadataUrlDoc);
        this.reloadFromXml();
    }

    @Override
    public synchronized boolean urlExists(String id, String url) {
        MetadataUrlCertPair urlCertPair;
        if (id != null && (urlCertPair = this.metadataUrlCertPairs.get(id)) != null && urlCertPair.getUrl().equals(url)) {
            return false;
        }
        return this.metadataUrls.contains(url);
    }

    @Override
    public synchronized boolean isMetadataUrlInUse(String id) {
        boolean isIdUsedInConn;
        if (StringUtils.isBlank((String)id)) {
            return false;
        }
        ConnectionManager connMgr = MgmtFactory.getConnectionManager();
        for (IdpConnection idpConn : connMgr.getAllIdpConnections()) {
            isIdUsedInConn = this.isSameId(id, idpConn);
            if (!isIdUsedInConn) continue;
            return true;
        }
        for (SpConnection spConn : connMgr.getAllSpConnections()) {
            isIdUsedInConn = this.isSameId(id, spConn);
            if (!isIdUsedInConn) continue;
            return true;
        }
        return false;
    }

    private boolean isSameId(String id, ConnectionBase conn) {
        String connMetadataId = conn.getMetadataUrlId();
        return StringUtils.isNotBlank((String)connMetadataId) && id.equals(connMetadataId);
    }

    @Override
    public synchronized boolean isMetadataUrlNameInUse(String id, String name) {
        String existingName;
        MetadataUrlCertPair existingUrl;
        if (name == null) {
            return false;
        }
        if (id != null && (existingUrl = this.metadataUrlCertPairs.get(id)) != null && (existingName = existingUrl.getName()) != null && existingName.equalsIgnoreCase(name)) {
            return false;
        }
        for (Map.Entry<String, MetadataUrlCertPair> urlCertPairEntry : this.metadataUrlCertPairs.entrySet()) {
            MetadataUrlCertPair urlCertPair = urlCertPairEntry.getValue();
            if (urlCertPair == null || !name.equals(urlCertPair.getName())) continue;
            return true;
        }
        return false;
    }
}

