/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.x2015.x01.metadataNotification.MetadataNotificationSettingsDocument;
import com.pingidentity.x2015.x01.metadataNotification.MetadataNotificationSettingsType;
import com.pingidentity.x2015.x01.metadataNotification.MetadataNotificationType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.mgmt.MetadataUrlNotificationManager;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;

public class MetadataUrlNotificationManagerImpl
extends ConfigManagerBase
implements MetadataUrlNotificationManager,
AutoReloadable {
    private static Log log = LogFactory.getLog(MetadataUrlNotificationManagerImpl.class);
    private static final String PF_NOTIFICATION_METADATA_SETTING_XML_FILE_NAME = "pingfederate-metadata-notification.xml";
    private Map<String, Boolean> metadataNotificationMap = new HashMap<String, Boolean>();

    public MetadataUrlNotificationManagerImpl() {
        this.loadConfig();
    }

    public synchronized void loadConfig() {
        this.fillMetadataMap();
    }

    private synchronized MetadataNotificationSettingsDocument getDoc() {
        String dataDir = this.sysDirInfo.getLocalDataDirectory();
        return (MetadataNotificationSettingsDocument)this.xmlLoader.load(dataDir, PF_NOTIFICATION_METADATA_SETTING_XML_FILE_NAME);
    }

    private void generateMetadataNotificationTypeValues(String urlId, Boolean notified, MetadataNotificationType metadataSettingType) {
        if (StringUtils.isNotBlank((String)urlId)) {
            metadataSettingType.setUrlId(urlId);
            metadataSettingType.setNotificationSent(notified.booleanValue());
        }
    }

    private void saveMetadataSettings(Map<String, Boolean> metadataSettings) {
        if (metadataSettings == null) {
            return;
        }
        MetadataNotificationSettingsDocument metadataNotificationDoc = MetadataNotificationSettingsDocument.Factory.newInstance();
        MetadataNotificationSettingsType medataSettingType = metadataNotificationDoc.addNewMetadataNotificationSettings();
        for (String metadata : metadataSettings.keySet()) {
            Boolean isNotified = metadataSettings.get(metadata);
            MetadataNotificationType metadataType = medataSettingType.addNewMetadataNotificationType();
            this.generateMetadataNotificationTypeValues(metadata, isNotified, metadataType);
        }
        this.xmlLoader.save(this.sysDirInfo.getLocalDataDirectory(), PF_NOTIFICATION_METADATA_SETTING_XML_FILE_NAME, (XmlObject)metadataNotificationDoc);
        this.fillMetadataMap();
    }

    private synchronized void fillMetadataMap() {
        MetadataNotificationType[] metadataUpdataSettings;
        this.metadataNotificationMap.clear();
        MetadataNotificationSettingsDocument metadataNotificationDoc = this.getDoc();
        MetadataNotificationSettingsType metadataSettingType = metadataNotificationDoc.getMetadataNotificationSettings();
        for (MetadataNotificationType metadataUpdataSetting : metadataUpdataSettings = metadataSettingType.getMetadataNotificationTypeArray()) {
            String key = metadataUpdataSetting.getUrlId();
            Boolean notified = metadataUpdataSetting.getNotificationSent();
            this.metadataNotificationMap.put(key, notified);
        }
    }

    @Override
    public synchronized void saveNotificationStatus(String urlId, boolean notifed) {
        if (StringUtils.isBlank((String)urlId)) {
            return;
        }
        MetadataNotificationSettingsDocument metadataNotificationDoc = this.getDoc();
        MetadataNotificationSettingsType metadataSettingType = metadataNotificationDoc.getMetadataNotificationSettings();
        MetadataNotificationType[] metadataNotificationSettings = metadataSettingType.getMetadataNotificationTypeArray();
        HashMap<String, Boolean> metadataNotifications = new HashMap<String, Boolean>();
        log.debug((Object)("Getting metadata notification settings for metadata url id " + urlId));
        for (MetadataNotificationType metadataNotificationType : metadataNotificationSettings) {
            String id = metadataNotificationType.getUrlId();
            if (urlId.equals(id)) continue;
            Boolean notificationSent = metadataNotificationType.getNotificationSent();
            metadataNotifications.put(id, notificationSent);
        }
        metadataNotifications.put(urlId, notifed);
        this.saveMetadataSettings(metadataNotifications);
    }

    @Override
    public synchronized boolean getMetadataNotificationStatus(String urlId) {
        Boolean notifed = this.metadataNotificationMap.get(urlId);
        if (notifed != null) {
            return notifed;
        }
        return false;
    }

    @Override
    public synchronized boolean deleteMetadataNotificationStatus(String urlId) {
        boolean deleted = false;
        if (StringUtils.isBlank((String)urlId)) {
            return deleted;
        }
        MetadataNotificationSettingsDocument metadataNotificationDoc = this.getDoc();
        MetadataNotificationSettingsType metadataSettingType = metadataNotificationDoc.getMetadataNotificationSettings();
        MetadataNotificationType[] metadataNotificationSettings = metadataSettingType.getMetadataNotificationTypeArray();
        HashMap<String, Boolean> metadataNotifications = new HashMap<String, Boolean>();
        log.debug((Object)("Getting metadata notification settings for metadata url id " + urlId));
        for (MetadataNotificationType metadataNotificationType : metadataNotificationSettings) {
            String id = metadataNotificationType.getUrlId();
            if (!urlId.equals(id)) {
                Boolean notificationSent = metadataNotificationType.getNotificationSent();
                metadataNotifications.put(id, notificationSent);
                continue;
            }
            deleted = true;
        }
        this.saveMetadataSettings(metadataNotifications);
        return deleted;
    }
}

