/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ItemReplicationStatus;
import org.sourceid.saml20.domain.mgmt.ClusterSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class NotificationBanner {
    private final String message;
    private final NotificationBannerType type;
    private static final ClusterSettingsManager clusterSettingsManager = MgmtFactory.getClusterSettingsManager();

    public NotificationBanner(String message, NotificationBannerType type) {
        this.message = message;
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public NotificationBannerType getType() {
        return this.type;
    }

    public static NotificationBanner getBannerContentForReplicationSuccess() {
        NotificationBannerType type = NotificationBannerType.SUCCESS;
        String message = "Settings saved. Changes were automatically replicated to the cluster.";
        return new NotificationBanner(message, type);
    }

    public static NotificationBanner getBannerContentForReplicationFailure() {
        NotificationBannerType type = NotificationBannerType.INFO;
        String message = "Settings saved. Changes were not replicated to the cluster as there are un-replicated dependencies.";
        return new NotificationBanner(message, type);
    }

    public static NotificationBanner getBannerContentForSettingsSaved() {
        NotificationBannerType type = NotificationBannerType.SUCCESS;
        String message = "Settings saved.";
        return new NotificationBanner(message, type);
    }

    public static NotificationBanner getBannerForConnectionDeleted() {
        NotificationBannerType type = NotificationBannerType.SUCCESS;
        String message = "Connection deleted.";
        return new NotificationBanner(message, type);
    }

    public static NotificationBanner getBannerForClientDeleted() {
        NotificationBannerType type = NotificationBannerType.SUCCESS;
        String message = "Client deleted.";
        return new NotificationBanner(message, type);
    }

    public static NotificationBanner getNotificationBannerForConnection(ConnectionBase connection) {
        NotificationBanner banner = clusterSettingsManager.isEnableSelectiveReplicationForConnections() ? (ItemReplicationStatus.REPLICATED.equals((Object)connection.getReplicationStatus()) ? NotificationBanner.getBannerContentForReplicationSuccess() : NotificationBanner.getBannerContentForReplicationFailure()) : NotificationBanner.getBannerContentForSettingsSaved();
        return banner;
    }

    public static NotificationBanner getNotificationBannerForClient(Client client) {
        NotificationBanner banner = clusterSettingsManager.isEnableSelectiveReplicationForClients() ? (ItemReplicationStatus.REPLICATED.equals((Object)client.getReplicationStatus()) ? NotificationBanner.getBannerContentForReplicationSuccess() : NotificationBanner.getBannerContentForReplicationFailure()) : NotificationBanner.getBannerContentForSettingsSaved();
        return banner;
    }

    public static enum NotificationBannerType {
        SUCCESS("Success"),
        INFO("Info"),
        ERROR("Error");

        private final String id;
        private static final Map<String, NotificationBannerType> ID_TO_TYPE_MAP;

        private NotificationBannerType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static NotificationBannerType getType(String id) {
            return ID_TO_TYPE_MAP.get(id);
        }

        static {
            ID_TO_TYPE_MAP = Arrays.stream(NotificationBannerType.values()).collect(Collectors.toMap(NotificationBannerType::getId, Function.identity()));
        }
    }
}

