/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.notification.NotificationPublisherPlugin;
import java.util.Collection;
import org.sourceid.mgmt.AuditLoggingManager;
import org.sourceid.saml20.domain.AuditLoggingSettings;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginMgmtConfigSupport;

public class NotificationPublisherPluginManagerImpl
implements NotificationPublisherPluginManager,
AutoReloadable {
    public static final String BASE_NAME = "notification-sender";
    private final IdpAdapterManager idpAdapterManager;
    private final LocalIdentityManager localIdentityProfileManager;
    private final NotificationMgr notificationMgr;
    private final PluginManagementSupport pluginMgmtSupport;
    private final AuditLoggingManager auditLoggingManager;

    public NotificationPublisherPluginManagerImpl(IdpAdapterManager idpAdapterManager, LocalIdentityManager localIdentityProfileManager, NotificationMgr notificationMgr, AuditLoggingManager auditLoggingManager) {
        this.idpAdapterManager = idpAdapterManager;
        this.localIdentityProfileManager = localIdentityProfileManager;
        this.notificationMgr = notificationMgr;
        this.auditLoggingManager = auditLoggingManager;
        this.pluginMgmtSupport = new PluginManagementSupport(BASE_NAME, new PluginMgmtConfigSupport(BASE_NAME), true, AdminAuditLogger.Component.NOTIFICATION_PUBLISHERS);
        this.pluginMgmtSupport.setPluginInstanceFactory(this::newInstance);
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        return this.pluginMgmtSupport.getInstalledPluginDescriptors();
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<NotificationSenderPluginInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public NotificationSenderPluginInstance getInstance(String instanceId) {
        return (NotificationSenderPluginInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        if (instance == null) {
            return;
        }
        boolean origNotifyAccountChanges = this.notificationMgr.getNotificationSettings().isEnableAccountChangesNotification();
        NotificationSenderPluginInstance origAdminAccChgNotificationPublisher = this.getAdminAccChgNotificationPublisher();
        NotificationSenderPluginInstance savingInstance = (NotificationSenderPluginInstance)instance;
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.pluginMgmtSupport.savePluginInstance(savingInstance, savingInstance.getName(), auditLoggerScope);
            NotificationSupportHelper.auditLogAdminAccountsNotificationPublisher(origNotifyAccountChanges, origAdminAccChgNotificationPublisher, auditLoggerScope);
        }
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return false;
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        Object settings;
        if (pluginId == null) {
            return false;
        }
        boolean isInUse = this.idpAdapterManager.getInstances().stream().anyMatch(adapter -> NotificationSupportHelper.isAdapterUsingPublisher(adapter, pluginId));
        if (!isInUse) {
            isInUse = this.localIdentityProfileManager.getProfiles().stream().anyMatch(lip -> NotificationSupportHelper.isLipUsingPublisher(lip, pluginId));
        }
        if (!isInUse) {
            settings = this.notificationMgr.getNotificationSettings();
            boolean bl = isInUse = ((NotificationSettings)settings).isEnableAccountChangesNotification() && this.isPluginUsingNotificationPublisher(((NotificationSettings)settings).getNotificationPublisherAccountChanges(), pluginId) || ((NotificationSettings)settings).isEnableCertificateExpirationNotification() && ((NotificationSettings)settings).getCertExpirationNotificationMode().equals((Object)NotificationMode.NOTIFICATION_PUBLISHER) && this.isPluginUsingNotificationPublisher(((NotificationSettings)settings).getNotificationPublisherCertificates(), pluginId) || ((NotificationSettings)settings).isEnableEmailNotification() && this.isPluginUsingNotificationPublisher(((NotificationSettings)settings).getNotificationPublisherLicensing(), pluginId) || ((NotificationSettings)settings).isEnableMetadataEventNotification() && this.isPluginUsingNotificationPublisher(((NotificationSettings)settings).getNotificationPublisherMetadata(), pluginId) || ((NotificationSettings)settings).isEnableThreadPoolExhaustionNotification() && ((NotificationSettings)settings).getThreadPoolExhaustionNotificationMode().equals((Object)NotificationMode.NOTIFICATION_PUBLISHER) && this.isPluginUsingNotificationPublisher(((NotificationSettings)settings).getNotificationPublisherThreadPoolExhaustion(), pluginId) || ((NotificationSettings)settings).isEnableBulkheadAlertNotification() && ((NotificationSettings)settings).getBulkheadAlertsNotificationMode().equals((Object)NotificationMode.NOTIFICATION_PUBLISHER) && this.isPluginUsingNotificationPublisher(((NotificationSettings)settings).getNotificationPublisherBulkheadAlerts(), pluginId);
        }
        if (!isInUse) {
            settings = this.auditLoggingManager.getAuditLoggingSettings();
            isInUse = ((AuditLoggingSettings)settings).isTrackAuditLogFailures() && this.isPluginUsingNotificationPublisher(((AuditLoggingSettings)settings).getNotificationPublisherId(), pluginId);
        }
        return isInUse;
    }

    @Override
    public NotificationSenderPluginInstance newInstance() {
        return new NotificationSenderPluginInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return false;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return true;
    }

    @Override
    public NotificationSenderPluginInstance getDefaultInstance() {
        return (NotificationSenderPluginInstance)this.pluginMgmtSupport.getDefaultInstance();
    }

    @Override
    public void setDefaultInstance(String pluginId) {
        boolean origNotifyAccountChanges = this.notificationMgr.getNotificationSettings().isEnableAccountChangesNotification();
        NotificationSenderPluginInstance origAdminAccChgNotificationPublisher = this.getAdminAccChgNotificationPublisher();
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.pluginMgmtSupport.setDefaultInstance(pluginId, auditLoggerScope);
            NotificationSupportHelper.auditLogAdminAccountsNotificationPublisher(origNotifyAccountChanges, origAdminAccChgNotificationPublisher, auditLoggerScope);
        }
    }

    @Override
    public NotificationPublisherPlugin getNotificationSenderPlugin(String instanceId) {
        return (NotificationPublisherPlugin)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    @Override
    public Collection<NotificationSenderPluginInstance> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }

    private NotificationSenderPluginInstance getAdminAccChgNotificationPublisher() {
        String origAdminAccChgNotificationPublisherId = this.notificationMgr.getNotificationSettings().getNotificationPublisherAccountChanges();
        NotificationSenderPluginInstance tempOrigAdminAccChgNotificationPublisher = NotificationSupportHelper.getNotificationPublisherForAuditLogDiff(origAdminAccChgNotificationPublisherId);
        return NotificationSenderPluginInstance.createCopyForAuditLogging(tempOrigAdminAccChgNotificationPublisher);
    }
}

