/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.oobauth.OOBAuthPlugin;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.OOBAuthPluginInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.OOBAuthPluginManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;

public class OOBAuthPluginManagerImpl
implements OOBAuthPluginManager,
AutoReloadable {
    private final PluginManagementSupport pluginMgmtSupport = new PluginManagementSupport("oob-auth-plugins", AdminAuditLogger.Component.OOB_AUTH_PLUGIN);
    public static final String BASE_NAME = "oob-auth-plugins";

    public OOBAuthPluginManagerImpl(Mediator mediator) {
        this.pluginMgmtSupport.setPluginInstanceFactory(new PluginManagementSupport.PluginInstanceFactory(){

            @Override
            public ConfigurablePluginInstance constructPluginInstance() {
                return OOBAuthPluginManagerImpl.this.newInstance();
            }
        });
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public OOBAuthPlugin getOOBAuthPlugin(String instanceId) {
        return (OOBAuthPlugin)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        Collection<PluginDescriptor> descriptors = this.pluginMgmtSupport.getInstalledPluginDescriptors();
        return descriptors;
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<OOBAuthPluginInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public OOBAuthPluginInstance getInstance(String instanceId) {
        return (OOBAuthPluginInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.savePluginInstance(instance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        for (OOBAuthPluginInstance instance : this.getInstances()) {
            String parentId = instance.getParentId();
            if (parentId == null || !parentId.equals(pluginId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        Map<String, CibaServerPolicy.RequestHandlingPolicy> policies = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy().getRequestHandlingPolicies();
        for (CibaServerPolicy.RequestHandlingPolicy policy : policies.values()) {
            if (!pluginId.equals(policy.getPluginId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public OOBAuthPluginInstance newInstance() {
        return new OOBAuthPluginInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return false;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }

    @Override
    public OOBAuthPluginInstance getDefaultInstance() {
        return (OOBAuthPluginInstance)this.pluginMgmtSupport.getDefaultInstance();
    }

    @Override
    public Collection<OOBAuthPluginInstance> getVirtualInstances() {
        return Collections.emptyList();
    }
}

