/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.Cert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.impl.CertNotFoundException;
import org.sourceid.saml20.domain.mgmt.impl.DsigPkCertManager;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;

public class PartnerCertMigrator {
    static final String PARTNER_CERT_MIGRATION_COMPLETE = "partner.cert.migration.complete";
    private static final Log log = LogFactory.getLog(PartnerCertMigrator.class);
    private ConfigStore configStore = ConfigStoreFarm.getConfig(PartnerCertMigrator.class);
    private ConfigStore certMappingConfigStore;
    private MetadataDirectory metadataDirectory;

    public PartnerCertMigrator(MetadataDirectory metadataDirectory) {
        this.metadataDirectory = metadataDirectory;
    }

    PartnerCertMigrator(ConfigStore testConfigStore, MetadataDirectory metadataDirectory) {
        this.certMappingConfigStore = testConfigStore;
        this.metadataDirectory = metadataDirectory;
    }

    public void initialize(MetadataDirectory metadataDirectory) {
        this.metadataDirectory = metadataDirectory;
    }

    public void migrateCertsIfNeeded() {
        if (!this.hasMigrationCompleted().booleanValue()) {
            log.info((Object)"Migrating partner certificates.");
            List<ConnInfo> connectionsToCleanup = this.migrateCerts();
            log.info((Object)"Finished migrating partner certificates.");
            log.info((Object)("Cleaning up partner certificates for " + connectionsToCleanup.size() + " connections."));
            this.cleanupCertsForEntityIds(connectionsToCleanup);
            log.info((Object)"Finished cleaning up partner certificates.");
            this.setMigrationComplete();
        }
    }

    private void cleanupCertsForEntityIds(List<ConnInfo> conns) {
        this.getLegacyCertManager().startBatchUpdate();
        this.getCertMappingConfigStore().startBatchUpdate();
        int totalEntityIdsCleaned = 0;
        for (ConnInfo connInfo : conns) {
            this.cleanupCertsForConn(connInfo);
            if (++totalEntityIdsCleaned % 500 != 0) continue;
            log.info((Object)("Cleaned up certificates for " + totalEntityIdsCleaned + " connections."));
        }
        for (ConnInfo connInfo : conns) {
            this.getCertMappingConfigStore().clearValue(connInfo.entityId);
        }
        this.getLegacyCertManager().commitBatchUpdate();
        log.info((Object)"Persisting cleanup to disk. This may take a while.");
        this.getCertMappingConfigStore().commitBatchUpdate();
    }

    private List<ConnInfo> migrateCerts() {
        ArrayList<ConnInfo> successfullyMigratedConns = new ArrayList<ConnInfo>();
        for (ConnInfo connInfo : this.getConnsToMigrate()) {
            boolean successfullyMigrated;
            ConnectionBase conn = connInfo.role.equals((Object)Role.IDP) ? this.metadataDirectory.getIdpConnection(connInfo.entityId, false) : this.metadataDirectory.getSpConnection(connInfo.entityId, false);
            if (conn != null && !conn.partnerCertsMigrated() && (successfullyMigrated = this.migrateCertsToConnection(conn))) {
                successfullyMigratedConns.add(connInfo);
            }
            if (successfullyMigratedConns.size() % 500 != 0) continue;
            log.info((Object)("Migrated certificates for " + successfullyMigratedConns.size() + " connections."));
        }
        return successfullyMigratedConns;
    }

    private boolean migrateCertsToConnection(ConnectionBase conn) {
        boolean connectionMigrated = false;
        String entityId = conn.getEntityId();
        Role role = conn.getRoleType();
        try {
            Set<Cert> certs = this.getCertsFromLegacyFormat(entityId, role);
            certs = this.mergeInConnectionCerts(certs, conn);
            log.debug((Object)("Migrating " + certs.size() + " cert(s) for the " + role.name() + " connection with entityId '" + entityId + "'"));
            conn.getDsigVerificationCerts().setOtherVerificationCerts(certs);
            if (role.equals((Object)Role.IDP)) {
                this.metadataDirectory.saveIdpConnection((IdpConnection)conn);
            } else {
                this.metadataDirectory.saveSpConnection((SpConnection)conn);
            }
            connectionMigrated = true;
        }
        catch (CertNotFoundException e) {
            log.error((Object)("Unable to migrate " + role.name() + " connection with entityID " + entityId + " due to " + e.getMessage()));
        }
        return connectionMigrated;
    }

    private Set<Cert> mergeInConnectionCerts(Set<Cert> certs, ConnectionBase conn) {
        HashSet<Cert> mergedCerts = new HashSet<Cert>(certs);
        mergedCerts.addAll(conn.getDsigVerificationCerts().getActiveVerificationCerts());
        EncryptionSettings encryptionSettings = conn.getEncryptionSettings();
        if (encryptionSettings.getEncryptionCert() != null) {
            mergedCerts.add(encryptionSettings.getEncryptionCert());
        }
        return mergedCerts;
    }

    private void cleanupCertsForConn(ConnInfo connInfo) {
        log.debug((Object)("Cleaning up certs for " + connInfo.role.name() + " connection with entityId: " + connInfo.entityId));
        this.cleanupCertsForConnection(connInfo.entityId, connInfo.role);
    }

    private void cleanupCertsForConnection(String entityId, Role role) {
        if (PropertyInfo.getHSMMode().equals((Object)PropertyInfo.HSM_MODE.NCIPHER)) {
            log.warn((Object)("Skipping removal of the certificates for entityID " + entityId + " since the certs are stored on an HSM."));
        } else {
            this.getLegacyCertManager().deleteCertsForConnection(entityId, role);
        }
    }

    private Set<Cert> getCertsFromLegacyFormat(String entityId, Role role) throws CertNotFoundException {
        HashSet<Cert> availableCerts = new HashSet<Cert>();
        for (String alias : this.getCertAliasesForConnection(entityId, role)) {
            Cert cert = this.getLegacyCertManager().getCert(alias);
            if (cert != null) {
                availableCerts.add(cert);
                continue;
            }
            log.error((Object)("Could not find cert with alias " + alias + " in the legacy location."));
            throw new CertNotFoundException("Could not find cert " + alias);
        }
        return availableCerts;
    }

    synchronized Set<String> getCertAliasesForConnection(String entityId, Role role) {
        HashSet<String> certAliases = new HashSet<String>();
        Map connectionAliasesMap = this.getCertMappingConfigStore().getMapValue(entityId, Collections.EMPTY_MAP);
        for (Map.Entry entry : connectionAliasesMap.entrySet()) {
            Role connRole = Role.valueOf((String)entry.getValue());
            if (!connRole.equals((Object)role)) continue;
            certAliases.add((String)entry.getKey());
        }
        return certAliases;
    }

    private Collection<ConnInfo> getConnsToMigrate() {
        LinkedList<ConnInfo> conns = new LinkedList<ConnInfo>();
        this.metadataDirectory.getIdpEntityIds().forEach(entityId -> conns.add(new ConnInfo((String)entityId, Role.IDP)));
        this.metadataDirectory.getSpEntityIds().forEach(entityId -> conns.add(new ConnInfo((String)entityId, Role.SP)));
        return conns;
    }

    private PkCertAndConnectionCertManager getLegacyCertManager() {
        return (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
    }

    private ConfigStore getCertMappingConfigStore() {
        if (this.certMappingConfigStore == null) {
            return ConfigStoreFarm.getConfig(DsigPkCertManager.class);
        }
        return this.certMappingConfigStore;
    }

    private Boolean hasMigrationCompleted() {
        return this.configStore.getBooleanValue(PARTNER_CERT_MIGRATION_COMPLETE, false);
    }

    private void setMigrationComplete() {
        this.configStore.setBooleanValue(PARTNER_CERT_MIGRATION_COMPLETE, Boolean.TRUE);
    }

    static class ConnInfo {
        private final String entityId;
        private final Role role;

        ConnInfo(String entityId, Role role) {
            this.entityId = entityId;
            this.role = role;
        }
    }
}

