/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.Cert;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.impl.PkCertManagerBase;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.Defense;

public abstract class PkCertAndConnectionCertManagerBase
extends PkCertManagerBase
implements PkCertAndConnectionCertManager {
    private boolean batchUpdateInProgress = false;
    private boolean localKeystoreChanges = false;
    private boolean hsmKeystoreChanges = false;
    private Map<String, Cert> x509CertCache;

    protected Map<String, Cert> getX509CertCache() {
        return this.x509CertCache;
    }

    protected void setX509CertCache(Map<String, Cert> x509Certs) {
        this.x509CertCache = x509Certs;
    }

    @Override
    public synchronized Cert getCert(String alias) {
        Cert certificate = this.getX509Certificates().get(alias);
        Defense.notNull(certificate, "No cert found for alias " + alias);
        return certificate;
    }

    private Map<String, Cert> getX509Certificates() {
        Map<String, Cert> x509Certs = this.getX509CertCache();
        if (x509Certs == null) {
            x509Certs = new HashMap<String, Cert>();
            if (this.isConnectionCertsStoredLocally()) {
                x509Certs.putAll(this.buildX509CertCache(true));
            }
            if (this.isConnectionCertsStoredOnHSM()) {
                x509Certs.putAll(this.buildX509CertCache(false));
            }
            this.setX509CertCache(x509Certs);
        }
        return x509Certs;
    }

    private boolean isConnectionCertsStoredLocally() {
        return !PropertyInfo.isHSM() || PropertyInfo.isHSMHybrid() || PropertyInfo.HSM_MODE.LUNA == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.AWSCLOUDHSM == PropertyInfo.getHSMMode();
    }

    private boolean isConnectionCertsStoredOnHSM() {
        return PropertyInfo.isHSM() && PropertyInfo.HSM_MODE.LUNA != PropertyInfo.getHSMMode() && PropertyInfo.HSM_MODE.AWSCLOUDHSM != PropertyInfo.getHSMMode();
    }

    private Map<String, Cert> buildX509CertCache(boolean localKeystore) {
        boolean retry = false;
        KeyStore keystore = null;
        HashMap<String, Cert> x509Certs = new HashMap<String, Cert>();
        do {
            if (keystore == null) {
                keystore = localKeystore ? this.getKeystore() : this.getHSMKeystore();
            }
            try {
                String keystoreName = localKeystore ? null : this.getHSMKeystoreName();
                ArrayList<String> aliases = Collections.list(this.certService.getAliases(keystoreName, keystore));
                for (String alias : aliases) {
                    X509Certificate x509 = (X509Certificate)keystore.getCertificate(alias);
                    if (x509 == null) continue;
                    Cert cert = new Cert(alias, x509);
                    if (PropertyInfo.isHSMHybrid()) {
                        cert.setStoredOnHSM(!this.isLocalKeystore(keystore));
                    }
                    x509Certs.put(alias, cert);
                }
                retry = false;
            }
            catch (KeyStoreException e) {
                throw new ConfigurationException(e);
            }
            catch (Exception e) {
                if ("ncipher".equalsIgnoreCase(System.getProperty("pf.hsm.mode")) && !retry) {
                    this.log.warn((Object)("Error occured while getting x509 certs.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                    this.certService.reload();
                    this.clearAllCaches();
                    retry = true;
                    continue;
                }
                throw new RuntimeException(e);
            }
        } while (retry);
        this.setX509CertCache(x509Certs);
        return x509Certs;
    }

    @Override
    public synchronized Set<Cert> getCertsForConnection(String entityId, Role role) {
        HashSet<Cert> certs = new HashSet<Cert>();
        Map connectionAliasesMap = this.configStore.getMapValue(entityId, Collections.EMPTY_MAP);
        Iterator iterator = connectionAliasesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry mapEntry = o = iterator.next();
            String alias = (String)mapEntry.getKey();
            String roleString = mapEntry.getValue().toString();
            Role tempRole = Role.valueOf(roleString);
            if (tempRole != role) continue;
            Cert cert = this.getX509Certificates().get(alias);
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public synchronized void saveCertsForConnection(Set<Cert> certs, String entityId, Role role) {
        Map connectionAliasesMap = this.configStore.getMapValue(entityId, new HashMap());
        this.deleteCertsNotInConnection(certs, entityId, role, connectionAliasesMap);
        if (!this.isConnectionCertsStoredOnHSM()) {
            this.saveLocalCertsForConnection(certs, entityId, role, connectionAliasesMap);
        } else if (PropertyInfo.isHSMHybrid()) {
            HashSet<Cert> localCerts = new HashSet<Cert>();
            HashSet<Cert> hsmCerts = new HashSet<Cert>();
            for (Cert cert : certs) {
                if (cert.isStoredOnHSM() == null || cert.isStoredOnHSM().booleanValue()) {
                    hsmCerts.add(cert);
                    continue;
                }
                localCerts.add(cert);
            }
            this.saveLocalCertsForConnection(localCerts, entityId, role, connectionAliasesMap);
            this.saveHSMCertsForConnection(hsmCerts, entityId, role, connectionAliasesMap);
        } else {
            this.saveHSMCertsForConnection(certs, entityId, role, connectionAliasesMap);
        }
        this.configStore.setMapValue(entityId, connectionAliasesMap);
    }

    private synchronized void saveLocalCertsForConnection(Set<Cert> certs, String entityId, Role role, Map connectionAliasesMap) {
        this.saveCertsForConnection(certs, entityId, role, true, connectionAliasesMap);
    }

    private synchronized void saveHSMCertsForConnection(Set<Cert> certs, String entityId, Role role, Map connectionAliasesMap) {
        this.saveCertsForConnection(certs, entityId, role, false, connectionAliasesMap);
    }

    private synchronized void saveCertsForConnection(Set<Cert> certs, String entityId, Role role, boolean localKeystore, Map connectionAliasesMap) {
        boolean retry = false;
        KeyStore keystore = null;
        do {
            boolean saveRequired = false;
            if (keystore == null) {
                keystore = localKeystore ? this.getKeystore() : this.getHSMKeystore();
            }
            try {
                for (Cert cert : certs) {
                    if (StringUtils.isBlank((String)cert.getAlias())) {
                        String alias = PkCertAndConnectionCertManagerBase.generateNewAlias();
                        cert.setAlias(alias);
                    }
                    if (connectionAliasesMap.get(cert.getAlias()) != null) continue;
                    connectionAliasesMap.put(cert.getAlias(), role);
                    X509Certificate certInKeyStore = (X509Certificate)keystore.getCertificate(cert.getAlias());
                    if (certInKeyStore == null || !cert.getX509Certificate().equals(certInKeyStore)) {
                        this.log.debug((Object)("saving cert " + cert.getAlias()));
                        keystore.setCertificateEntry(cert.getAlias(), cert.getX509Certificate());
                        saveRequired = true;
                        continue;
                    }
                    this.log.debug((Object)("cert " + cert.getAlias() + " is already in keystore"));
                }
                if (saveRequired) {
                    this.persistKeystore(keystore);
                }
                retry = false;
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                throw new ConfigurationException("Unexpected Problem saving certs." + role + " | " + entityId + " | " + certs, e);
            }
            catch (Exception e) {
                if ("ncipher".equalsIgnoreCase(System.getProperty("pf.hsm.mode")) && !retry) {
                    this.log.warn((Object)("Error occured while saving certs for connection.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                    this.certService.reload();
                    this.clearAllCaches();
                    retry = true;
                    continue;
                }
                throw new RuntimeException(e);
            }
        } while (retry);
    }

    @Override
    public synchronized void startBatchUpdate() {
        this.batchUpdateInProgress = true;
    }

    private synchronized void persistKeystore(KeyStore keystore) {
        if (this.isLocalKeystore(keystore)) {
            if (this.batchUpdateInProgress) {
                this.localKeystoreChanges = true;
            } else {
                this.writeKeyStore(keystore);
                this.setX509CertCache(null);
                this.localKeystoreChanges = false;
            }
        } else if (this.batchUpdateInProgress) {
            this.hsmKeystoreChanges = true;
        } else {
            this.writeHSMKeyStore(keystore);
            this.setX509CertCache(null);
            this.hsmKeystoreChanges = false;
        }
    }

    @Override
    public synchronized void commitBatchUpdate() {
        this.batchUpdateInProgress = false;
        if (this.localKeystoreChanges) {
            this.persistKeystore(this.getKeystore());
        }
        if (this.hsmKeystoreChanges) {
            this.persistKeystore(this.getHSMKeystore());
        }
    }

    private synchronized void deleteCertsNotInConnection(Set<Cert> certs, String entityId, Role role, Map connectionAliasesMap) {
        boolean retry = false;
        do {
            boolean saveLocalRequired = false;
            boolean saveHSMRequired = false;
            KeyStore localKeystore = null;
            KeyStore hsmKeystore = null;
            boolean processLocalKeystore = this.isConnectionCertsStoredLocally();
            boolean processHsmKeystore = this.isConnectionCertsStoredOnHSM();
            if (processLocalKeystore) {
                localKeystore = this.getKeystore();
            }
            if (processHsmKeystore) {
                hsmKeystore = this.getHSMKeystore();
            }
            try {
                Iterator i = connectionAliasesMap.entrySet().iterator();
                while (i.hasNext()) {
                    String roleString;
                    Role tempRole;
                    Map.Entry mapEntry = i.next();
                    String alias = (String)mapEntry.getKey();
                    if (this.setContainsAlias(alias, certs) || (tempRole = Role.valueOf(roleString = mapEntry.getValue().toString())) != role) continue;
                    this.log.debug((Object)("deleting cert " + alias));
                    if (processLocalKeystore && this.deleteKey(localKeystore, alias)) {
                        saveLocalRequired = true;
                    }
                    if (processHsmKeystore && this.deleteKey(hsmKeystore, alias)) {
                        saveHSMRequired = true;
                    }
                    i.remove();
                }
                if (saveLocalRequired || saveHSMRequired) {
                    if (saveLocalRequired) {
                        this.persistKeystore(localKeystore);
                    }
                    if (saveHSMRequired) {
                        this.persistKeystore(hsmKeystore);
                    }
                    this.setX509CertCache(null);
                }
                retry = false;
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                throw new ConfigurationException("Unexpected Problem saving certs." + role + " | " + entityId + " | " + certs, e);
            }
            catch (Exception e) {
                if ("ncipher".equalsIgnoreCase(System.getProperty("pf.hsm.mode")) && !retry) {
                    this.log.warn((Object)("Error occured while saving certs for connection.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                    this.certService.reload();
                    this.clearAllCaches();
                    retry = true;
                    continue;
                }
                throw new RuntimeException(e);
            }
        } while (retry);
    }

    private boolean deleteKey(KeyStore keystore, String alias) throws KeyStoreException {
        if (keystore.containsAlias(alias)) {
            keystore.deleteEntry(alias);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void deleteCertsForConnection(String entityId, Role role) {
        Map connectionAliasesMap = this.configStore.getMapValue(entityId, new HashMap());
        if (!this.isConnectionCertsStoredOnHSM()) {
            this.deleteLocalCertsForConnection(entityId, role, connectionAliasesMap);
        } else if (PropertyInfo.isHSMHybrid()) {
            this.deleteLocalCertsForConnection(entityId, role, connectionAliasesMap);
            this.deleteHSMCertsForConnection(entityId, role, connectionAliasesMap);
        } else {
            this.deleteHSMCertsForConnection(entityId, role, connectionAliasesMap);
        }
        this.removeConnectionFromMap(entityId, role);
    }

    private synchronized void deleteLocalCertsForConnection(String entityId, Role role, Map connectionAliasesMap) {
        this.deleteCertsForConnection(entityId, role, true, connectionAliasesMap);
    }

    private synchronized void deleteHSMCertsForConnection(String entityId, Role role, Map connectionAliasesMap) {
        this.deleteCertsForConnection(entityId, role, false, connectionAliasesMap);
    }

    private synchronized void deleteCertsForConnection(String entityId, Role role, boolean localKeystore, Map connectionAliasesMap) {
        boolean retry = false;
        KeyStore keystore = null;
        do {
            try {
                keystore = localKeystore ? this.getKeystore() : this.getHSMKeystore();
                for (Map.Entry mapEntry : connectionAliasesMap.entrySet()) {
                    String alias = (String)mapEntry.getKey();
                    String roleString = mapEntry.getValue().toString();
                    Role tempRole = Role.valueOf(roleString);
                    if (tempRole != role || !keystore.containsAlias(alias)) continue;
                    keystore.deleteEntry(alias);
                    if (this.getX509CertCache() == null) continue;
                    this.getX509CertCache().remove(alias);
                }
                this.persistKeystore(keystore);
                retry = false;
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                throw new ConfigurationException("Unexpected Problem deleting certs." + role + " | " + entityId, e);
            }
            catch (Exception e) {
                if ("ncipher".equalsIgnoreCase(System.getProperty("pf.hsm.mode")) && !retry) {
                    this.log.warn((Object)("Error occured while deleting certs for connection.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                    this.certService.reload();
                    this.clearAllCaches();
                    retry = true;
                    continue;
                }
                throw new RuntimeException(e);
            }
        } while (retry);
    }

    @Override
    public synchronized void cleanupCertsForConnection(String entityId, Role role) {
        this.removeConnectionFromMap(entityId, role);
    }

    private void removeConnectionFromMap(String entityId, Role role) {
        try {
            Map aliases = this.configStore.getMapValue(entityId);
            aliases.entrySet().removeIf(entry -> entry.getValue() != null && role.equals((Object)this.getRole(entry.getValue())));
            this.configStore.setMapValue(entityId, aliases);
        }
        catch (NoSuchValueException e) {
            this.log.debug((Object)("No certs were found to delete for entityId " + entityId));
        }
    }

    private Role getRole(Object role) {
        if (role instanceof Role) {
            return (Role)((Object)role);
        }
        return Role.valueOf((String)role);
    }

    @Override
    public synchronized Set<Cert> getCertsForFeature(String featureId) {
        return this.getCertsForConnection(featureId, Role.IDP);
    }

    @Override
    public synchronized Set<String> getAllFeatureIds() {
        return this.configStore.getKeys();
    }

    @Override
    public synchronized void saveCertsForFeature(Set<Cert> certs, String featureId) {
        this.saveCertsForConnection(certs, featureId, Role.IDP);
    }

    @Override
    public synchronized void deleteCertsForFeature(String featureId) {
        this.deleteCertsForConnection(featureId, Role.IDP);
    }

    @Override
    public synchronized void clearCaches() {
        this.setX509CertCache(null);
        super.clearCaches();
    }
}

