/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.pingcommons.util.Closer;
import com.pingidentity.sdk.DescribablePlugin;
import com.pingidentity.sdk.provision.IdentityStoreUserProvisioner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.domain.mgmt.impl.IdentityStoreProvisionerWrapper;

public class PluginSupport {
    private Log log = LogFactory.getLog(this.getClass());
    private Map<String, URL> classNameToUrlMap = new HashMap<String, URL>();
    private Map<String, Class<?>> classNameToClassMap = new HashMap();

    synchronized URL parseItUp(String resourceName, URL url, String className) {
        URL classLoaderUrl = null;
        String fileString = url.getPath();
        try {
            if ("jar".equals(url.getProtocol())) {
                fileString = fileString.substring(0, fileString.indexOf(resourceName) - 2);
                classLoaderUrl = new URL(fileString);
            } else {
                fileString = fileString.substring(0, fileString.indexOf(resourceName));
                classLoaderUrl = new URL("file", null, fileString);
            }
        }
        catch (MalformedURLException e) {
            this.log.error((Object)("Problem deriving URL for classpath of adapter " + className + " / " + url + " / " + resourceName), (Throwable)e);
        }
        return classLoaderUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Set<String> getInstalledClassNames(String resourceName) {
        HashSet<String> classNames = new HashSet<String>();
        Enumeration<URL> resources = null;
        try {
            Enumeration<URL> en = resources = this.getClassLoader().getResources(resourceName);
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                this.log.debug((Object)("Loading adapter descriptor: " + url));
                BufferedReader bf = null;
                try {
                    Object content = url.getContent();
                    if (content instanceof InputStream) {
                        String line;
                        InputStream is = (InputStream)content;
                        bf = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8.name()));
                        while ((line = bf.readLine()) != null) {
                            boolean isNewEntry;
                            String className = line.trim();
                            URL classLoaderUrl = this.parseItUp(resourceName, url, className);
                            if (classLoaderUrl != null) {
                                this.classNameToUrlMap.put(className, classLoaderUrl);
                            }
                            if (isNewEntry = classNames.add(className)) continue;
                            this.log.info((Object)("Adapter " + line + " is defined more than once."));
                        }
                        continue;
                    }
                    this.log.warn((Object)(url + " get content did not return an InputStream. " + content));
                }
                catch (IOException e) {
                    this.log.error((Object)("Unable to load url:" + url), (Throwable)e);
                }
                finally {
                    Closer.close(bf);
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Exception looking for resources " + resources + " / " + resourceName), (Throwable)e);
        }
        return classNames;
    }

    public synchronized <T> T createInstance(String className, Class<T> type) {
        return this.createInstance(className, type, true);
    }

    public synchronized <T> T createInstance(String className, Class<T> type, boolean logWarnings) {
        try {
            Object objInstance = this.getInstance(className);
            if (type.equals(DescribablePlugin.class)) {
                if (ConfigurableAuthnAdapter.class.isInstance(objInstance)) {
                    ConfigurableAuthnAdapter configurableAdapter = (ConfigurableAuthnAdapter)objInstance;
                    objInstance = () -> ((ConfigurableAuthnAdapter)configurableAdapter).getAdapterDescriptor();
                } else if (IdentityStoreUserProvisioner.class.isInstance(objInstance)) {
                    IdentityStoreProvisionerWrapper.IdentityStoreProvDescriptorWrapper provDesc = new IdentityStoreProvisionerWrapper.IdentityStoreProvDescriptorWrapper(((IdentityStoreUserProvisioner)objInstance).getPluginDescriptor());
                    objInstance = () -> provDesc;
                }
            }
            return type.cast(objInstance);
        }
        catch (ClassCastException cce) {
            if (logWarnings) {
                this.log.warn((Object)("Unable to cast instance of " + className + " to " + type + ". " + cce));
            }
            return null;
        }
    }

    protected synchronized Object getInstance(String className) {
        Class<?> pluginClass = this.loadPluginClass(className);
        if (pluginClass == null) {
            return null;
        }
        try {
            return pluginClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.error((Object)("Error creating instance of class " + className), (Throwable)e);
            return null;
        }
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="PF does not currently use Java security managers")
    protected synchronized Class<?> loadPluginClass(String className) {
        Class<?> adapterClass = this.classNameToClassMap.get(className);
        if (adapterClass != null) {
            return adapterClass;
        }
        URL url = this.classNameToUrlMap.get(className);
        try {
            ClassLoader classLoader;
            if (url != null) {
                this.log.debug((Object)("Creating class loader for url " + url));
                URL[] urls = new URL[]{url};
                classLoader = new URLClassLoader(urls, this.getClassLoader());
            } else {
                classLoader = this.getClassLoader();
            }
            try {
                adapterClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException urls) {
                // empty catch block
            }
            if (adapterClass == null) {
                classLoader = PluginSupport.class.getClassLoader();
                adapterClass = classLoader.loadClass(className);
            }
            if (adapterClass != null) {
                this.classNameToClassMap.put(className, adapterClass);
            }
            return adapterClass;
        }
        catch (Exception e) {
            String message = "Unable to load plugin class " + className;
            if (url != null) {
                message = message + " from url " + url;
            }
            this.log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    synchronized ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

