/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.sdk.secretmanager.SecretManagerException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.impl.SecretReferenceHelper;

public class SecretManagerConnectionFactory
implements ConnectionFactory {
    private final Driver driver;
    private final String connectionUri;
    private final Properties properties;

    public SecretManagerConnectionFactory(Driver driver, String connectionUri, Properties properties) {
        this.driver = driver;
        this.connectionUri = connectionUri;
        this.properties = properties;
    }

    public Connection createConnection() throws SQLException {
        SecretReferenceHelper.Credentials credentials;
        try {
            String username = this.properties.getProperty("user");
            String password = this.properties.getProperty("password");
            if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
                throw new SQLException("Unable to obtain credentials.");
            }
            SecretReferenceHelper secretReferenceHelper = new SecretReferenceHelper(password);
            credentials = secretReferenceHelper.getSecretInfo(username);
        }
        catch (SecretManagerException e) {
            throw new SQLException("Unable to obtain credentials.", e);
        }
        Properties properties = new Properties();
        properties.put("user", credentials.getUsername());
        properties.put("password", credentials.getSecret());
        return this.driver.connect(this.connectionUri, properties);
    }
}

