/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;

public class ServerX509TrustManager
implements X509TrustManager {
    private static final ServerX509TrustManager instance = new ServerX509TrustManager();
    private volatile X509TrustManager x509TrustManager;
    private volatile Set<X509Certificate> unanchoredCerts = Collections.emptySet();
    private RevocationChecker revocationChecker = GlobalRegistry.getService(RevocationChecker.class);

    public static ServerX509TrustManager getX509TrustManager() {
        return instance;
    }

    protected ServerX509TrustManager() {
        this.reload();
    }

    public void reload() {
        TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
        Set<X509Certificate> customTrustedCAs = trustedCAsManager.getTrustedCaX509s();
        WsTrustClientCertAuthManager wsTrustClientCertAuthManager = GlobalRegistry.getService(WsTrustClientCertAuthManager.class);
        if (wsTrustClientCertAuthManager.isAuthenticationEnabled()) {
            customTrustedCAs.addAll(wsTrustClientCertAuthManager.getSslAuthCerts());
        }
        this.setCustomTrustedCAs(customTrustedCAs);
        this.setUnanchoredCerts(MgmtFactory.getConnectionManager().getActiveUnanchoredIncomingSslAuthCerts());
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] acceptedIssuers;
        X509Certificate[] acceptedCAs = this.x509TrustManager.getAcceptedIssuers();
        if (this.unanchoredCerts != null && !this.unanchoredCerts.isEmpty()) {
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            list.addAll(Arrays.asList(acceptedCAs));
            for (X509Certificate cert : this.unanchoredCerts) {
                if (!cert.getIssuerDN().equals(cert.getSubjectDN())) continue;
                list.add(cert);
            }
            acceptedIssuers = new X509Certificate[list.size()];
            int i = 0;
            for (X509Certificate cert : list) {
                acceptedIssuers[i++] = cert;
            }
        } else {
            acceptedIssuers = acceptedCAs;
        }
        return acceptedIssuers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        block5: {
            try {
                this.x509TrustManager.checkClientTrusted(chain, authType);
            }
            catch (CertificateException certificateException) {
                if (this.unanchoredCerts.contains(chain[0])) break block5;
                throw new CertificateException("Client certificate not trusted: " + chain[0].getSubjectDN().toString() + "; " + certificateException.getMessage(), certificateException);
            }
        }
        if (SecurityProviderUtil.doLegacyRevocationCheck()) {
            try {
                this.revocationChecker.check(chain);
            }
            catch (RevokedCertException e) {
                throw new CertificateException("Client certificate chain contains a revoked certificate", e);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.x509TrustManager.checkServerTrusted(chain, authType);
        if (SecurityProviderUtil.doLegacyRevocationCheck()) {
            try {
                this.revocationChecker.check(chain);
            }
            catch (RevokedCertException e) {
                throw new CertificateException("Client certificate chain contains a revoked certificate", e);
            }
        }
    }

    private void setUnanchoredCerts(Set<X509Certificate> certs) {
        this.unanchoredCerts = new HashSet<X509Certificate>(certs);
    }

    private void setCustomTrustedCAs(Set<X509Certificate> trustedCerts) {
        try {
            TrustManagerFactory tm = TrustManagerFactory.getInstance(SecurityProviderUtil.getTrustManagerFactoryAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType(), "SUN");
            keyStore.load(null, new char[]{'x', 'a', '0'});
            int aliasIdx = 0;
            for (X509Certificate x509Certificate : trustedCerts) {
                keyStore.setCertificateEntry(String.valueOf(aliasIdx++), x509Certificate);
            }
            CertificateService certificateSvc = GlobalRegistry.getService(CertificateService.class);
            for (X509Certificate x509Certificate : certificateSvc.getJavaTrustedCaCerts()) {
                keyStore.setCertificateEntry(String.valueOf(aliasIdx++), x509Certificate);
            }
            tm.init(keyStore);
            TrustManager[] trustManagerArray = tm.getTrustManagers();
            this.x509TrustManager = (X509TrustManager)trustManagerArray[0];
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

