/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.PkCert;
import java.security.KeyStore;
import java.util.Set;
import org.sourceid.common.soap.soap11.SoapClient;
import org.sourceid.saml20.domain.mgmt.impl.PkCertAndConnectionCertManagerBase;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class SslAuthPkCertManager
extends PkCertAndConnectionCertManagerBase {
    @Override
    public void savePkCerts(Set<PkCert> pkCerts) {
        super.savePkCerts(pkCerts);
        SoapClient.flushClientsCache();
    }

    @Override
    protected KeyStore getKeystore() {
        return this.certService.getSslKeystore();
    }

    @Override
    protected String getPrivateKeyPassword(String alias) {
        return this.coreConfig.getSslPrivateKeyPassword(alias);
    }

    @Override
    protected void setPrivateKeyPassword(String alias, String password) {
        this.coreConfig.setSslPrivateKeyPassword(alias, password);
    }

    @Override
    protected void writeKeyStore(KeyStore keystore) {
        this.certService.writeSslKeystore(keystore);
    }

    @Override
    public boolean isInUseById(String id) {
        return InUseDetectionUtil.getInstance().isSslAuthCertInUse(id);
    }

    @Override
    protected KeyStore getHSMKeystore() {
        return this.certService.getSslHSMKeystore();
    }

    @Override
    protected String getHSMKeystoreName() {
        return PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode() ? this.coreConfig.getSslHSMKeystoreName() : null;
    }

    @Override
    protected String getHSMPrivateKeyPassword(String alias) {
        return this.coreConfig.getSslHSMPrivateKeyPassword(alias);
    }

    @Override
    protected void setHSMPrivateKeyPassword(String alias, String password) {
        this.coreConfig.setSslHSMPrivateKeyPassword(alias, password);
    }

    @Override
    protected void writeHSMKeyStore(KeyStore keystore) {
        this.certService.writeSslHSMKeystore(keystore);
    }
}

