/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.sdk.DescribablePlugin;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;
import org.sourceid.saml20.domain.mgmt.impl.TokenGeneratorMgmtConfigSupport;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;
import org.sourceid.saml20.xmlbinding.adapterconf.TokenProcessorConfigurationDocument;
import org.sourceid.saml20.xmlbinding.adapterconf.TokenProcessorConfigurationType;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;

public class TokenProcessorMgmtConfigSupport
extends TokenGeneratorMgmtConfigSupport {
    private Log log = LogFactory.getLog(this.getClass());

    public TokenProcessorMgmtConfigSupport() {
        super("token-processors");
    }

    @Override
    ConfigType constructConfigType(XmlObject document, ConfigurablePluginInstance pluginInstance) {
        TokenProcessorConfigurationDocument tokenProcessorConfigDoc = (TokenProcessorConfigurationDocument)document;
        TokenProcessorConfigurationType pluginConfig = tokenProcessorConfigDoc.getTokenProcessorConfiguration();
        if (document instanceof TokenProcessorConfigurationDocument) {
            return this.constructConfigType((ConfigType)pluginConfig, pluginInstance);
        }
        this.log.error((Object)"The xml document was not of type TokenProcessorConfigurationDocument.");
        return pluginConfig;
    }

    @Override
    public ConfigType constructConfigType(ConfigType tokenPluginConfig, ConfigurablePluginInstance pluginInstance) {
        if (pluginInstance instanceof TokenProcessorInstance) {
            TokenProcessorConfigurationType pluginConfig = (TokenProcessorConfigurationType)tokenPluginConfig;
            TokenProcessorInstance tokenProcessorInstance = (TokenProcessorInstance)pluginInstance;
            tokenProcessorInstance.setOwnMaskOgnlValues(pluginConfig.getMaskOgnlValues());
            String[] maskedFieldArray = pluginConfig.getMaskedFieldArray();
            HashSet<String> maskedFieldSet = new HashSet<String>(Arrays.asList(maskedFieldArray));
            tokenProcessorInstance.setOwnMaskedFields(maskedFieldSet);
            tokenProcessorInstance.setInheritingAttributeSettings(pluginConfig.getIsInheritAttributeSettings());
        }
        return tokenPluginConfig;
    }

    @Override
    public void saveConf(ConfigurablePluginInstance pluginInstance) {
        this.saveConf((TokenProcessorInstance)pluginInstance);
    }

    public void saveConf(TokenProcessorInstance pluginInstance) {
        TokenProcessorConfigurationDocument tokenProcessorConfigDoc = TokenProcessorConfigurationDocument.Factory.newInstance();
        TokenProcessorConfigurationType tokenProcessorConfigType = this.addTokenProcessorConfigType(tokenProcessorConfigDoc, pluginInstance);
        super.saveConf(pluginInstance, (ConfigType)tokenProcessorConfigType, (XmlObject)tokenProcessorConfigDoc);
    }

    private TokenProcessorConfigurationType addTokenProcessorConfigType(TokenProcessorConfigurationDocument tokenProcessorConfigDoc, TokenProcessorInstance pluginInstance) {
        TokenProcessorConfigurationType tokenProcessorConfigType = tokenProcessorConfigDoc.addNewTokenProcessorConfiguration();
        return this.fillInTokenProcessorConfigType(pluginInstance, tokenProcessorConfigType);
    }

    public TokenProcessorConfigurationType fillInTokenProcessorConfigType(TokenProcessorInstance pluginInstance, TokenProcessorConfigurationType tokenProcessorConfigType) {
        boolean inheritAttributeSettings = pluginInstance.isInheritingAttributeSettings();
        tokenProcessorConfigType.setIsInheritAttributeSettings(inheritAttributeSettings);
        if (!inheritAttributeSettings) {
            tokenProcessorConfigType.setMaskOgnlValues(pluginInstance.getMaskOgnlValues());
            Set<String> maskedFields = pluginInstance.getMaskedFields();
            String[] masked = maskedFields.toArray(new String[maskedFields.size()]);
            tokenProcessorConfigType.setMaskedFieldArray(masked);
        }
        return tokenProcessorConfigType;
    }

    @Override
    public TokenPluginInstance parseXml(String xml, String className) throws XmlException {
        TokenProcessorInstance instance = null;
        if (xml != null) {
            ByteArrayInputStream inStream;
            instance = new TokenProcessorInstance();
            PluginSupport pluginSupport = new PluginSupport();
            DescribablePlugin pluginImpl = pluginSupport.createInstance(className, DescribablePlugin.class);
            instance.setDescriptor(pluginImpl.getPluginDescriptor());
            try {
                inStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new XmlException((Throwable)e);
            }
            XmlObject document = this.xmlLoader.load(inStream);
            ConfigType configType = this.constructConfigType(document, (ConfigurablePluginInstance)instance);
            this.loadConf(instance, configType);
        }
        return instance;
    }

    @Override
    public String toXml(TokenPluginInstance instance) {
        String xml = "";
        if (instance != null) {
            TokenProcessorInstance tokenProcessorInstance = (TokenProcessorInstance)instance;
            TokenProcessorConfigurationDocument processorConfigDoc = TokenProcessorConfigurationDocument.Factory.newInstance();
            TokenProcessorConfigurationType processorConfigType = this.addTokenProcessorConfigType(processorConfigDoc, tokenProcessorInstance);
            super.fillInDoc(tokenProcessorInstance, (ConfigType)processorConfigType);
            XmlOptions opts = XmlBeansUtil.getXmlOptions();
            opts.setSavePrettyPrint();
            xml = processorConfigDoc.xmlText(opts);
        }
        return xml;
    }
}

