/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.Collections;
import java.util.List;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.TrackedHttpParamsSettings;
import org.sourceid.saml20.domain.mgmt.TrackedHttpParamManager;

public class TrackedHttpParamManagerImpl
implements TrackedHttpParamManager {
    private ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final String ALLOWED_TRACKED_PARAMS = "AllowedTrackedParams";
    private static final String MASK_TRACKED_PARAMS = "MaskTrackedParams";

    @Override
    public synchronized void saveTrackedParamSettings(TrackedHttpParamsSettings settings) {
        if (settings != null) {
            this.configStore.setListValue(ALLOWED_TRACKED_PARAMS, settings.getTrackedParamNames());
        }
    }

    @Override
    public synchronized TrackedHttpParamsSettings getTrackedParamSettings() {
        List<String> params = this.configStore.getListValue(ALLOWED_TRACKED_PARAMS, Collections.emptyList());
        return new TrackedHttpParamsSettings(params);
    }

    @Override
    public synchronized boolean isMaskTrackedParams() {
        return this.configStore.getBooleanValue(MASK_TRACKED_PARAMS, false);
    }
}

