/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventListener;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.configservice.ListenerRegistry;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.pingcommons.crypto.X500PrincipalWrapper;
import com.pingidentity.pingcommons.util.NumberUtils;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.soap.soap11.SoapClient;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.domain.mgmt.impl.CertModifiedTimeTracker;
import org.sourceid.saml20.domain.mgmt.impl.ServerX509TrustManager;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class TrustedCAsManagerImpl
implements TrustedCAsManager,
AutoReloadable {
    protected Log log = LogFactory.getLog(this.getClass());
    protected CertificateService certService = GlobalRegistry.getService(CertificateService.class);
    Set<TrustAnchor> allTrustAnchors;
    private Map<String, X509Certificate> allTrustCAMap = new HashMap<String, X509Certificate>();
    private Map<X500PrincipalWrapper, Collection<X509Certificate>> allTrustCAsByDN = new HashMap<X500PrincipalWrapper, Collection<X509Certificate>>();
    private Set<Cert> cachedCerts = null;

    public TrustedCAsManagerImpl() {
        this.loadConfig();
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        MgmtFactory.getMediator().registerForReloadEvents(reloadable);
        ListenerRegistry.getInstance().addListener(ConfigEventType.TRUSTED_CAS_RELOADED, reloadable, r -> r.reload());
    }

    @Override
    public void registerForConfigEvents(ConfigEventListener listener) {
        ListenerRegistry.getInstance().addListener(ConfigEventType.TRUSTED_CAS_UPDATED, listener, l -> l.onConfigUpdated());
    }

    @Override
    public synchronized Set<Cert> getTrustedCAs() {
        if (this.cachedCerts == null) {
            this.cachedCerts = new HashSet<Cert>();
            if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
                this.cachedCerts.addAll(this.getTrustedCAs(true));
            }
            if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
                this.cachedCerts.addAll(this.getTrustedCAs(false));
            }
        }
        return new HashSet<Cert>(this.cachedCerts);
    }

    private synchronized Set<Cert> getTrustedCAs(boolean localKeystore) {
        try {
            HashSet<Cert> trustedCAs = new HashSet<Cert>();
            KeyStore trustKeystore = localKeystore ? this.certService.getTrustKeystore() : this.certService.getTrustHSMKeystore();
            Enumeration<String> e = trustKeystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate certificate = trustKeystore.getCertificate(alias);
                X509Certificate x509Certificate = (X509Certificate)certificate;
                Cert cert = new Cert(alias, x509Certificate);
                if (PropertyInfo.isHSMHybrid()) {
                    cert.setStoredOnHSM(!localKeystore);
                }
                trustedCAs.add(cert);
            }
            return trustedCAs;
        }
        catch (KeyStoreException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public Cert getCert(String alias) {
        for (Cert cert : this.getTrustedCAs()) {
            if (!alias.equals(cert.getAlias())) continue;
            return cert;
        }
        return null;
    }

    @Override
    public synchronized Set<X509Certificate> getTrustedCaX509s() {
        return this.unwrapAll(this.getTrustedCAs());
    }

    @Override
    public X509Certificate getTrustedCaX509(String alias) {
        Set<Cert> certs = this.getTrustedCAs();
        for (Cert cert : certs) {
            if (!cert.getAlias().equals(alias)) continue;
            return cert.getX509Certificate();
        }
        return null;
    }

    Set<X509Certificate> unwrapAll(Set<Cert> certs) {
        HashSet<X509Certificate> x509s = new HashSet<X509Certificate>();
        for (Cert cert : certs) {
            x509s.add(cert.getX509Certificate());
        }
        return x509s;
    }

    @Override
    public synchronized void saveTrustedCAs(Set<Cert> certs) {
        if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.LUNA == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.AWSCLOUDHSM == PropertyInfo.getHSMMode()) {
            this.saveLocalCerts(certs);
        } else if (PropertyInfo.isHSMHybrid()) {
            HashSet<Cert> localCerts = new HashSet<Cert>();
            HashSet<Cert> hsmCerts = new HashSet<Cert>();
            for (Cert cert : certs) {
                if (cert.isStoredOnHSM() == null || cert.isStoredOnHSM().booleanValue()) {
                    hsmCerts.add(cert);
                    continue;
                }
                localCerts.add(cert);
            }
            this.saveLocalCerts(localCerts);
            this.saveHSMCerts(hsmCerts);
        } else {
            this.saveHSMCerts(certs);
        }
    }

    private void saveLocalCerts(Set<Cert> certs) {
        this.saveTrustedCAs(true, certs);
    }

    private void saveHSMCerts(Set<Cert> certs) {
        this.saveTrustedCAs(false, certs);
    }

    private synchronized void saveTrustedCAs(boolean localKeystore, Set<Cert> certs) {
        try {
            boolean saveKeystore = false;
            KeyStore trustKeystore = localKeystore ? this.certService.getTrustKeystore() : this.certService.getTrustHSMKeystore();
            ArrayList<String> aliases = Collections.list(trustKeystore.aliases());
            HashSet<String> keyStoreAliases = new HashSet<String>(aliases);
            HashSet<String> certAliases = new HashSet<String>();
            for (Cert cert : certs) {
                if (cert.getAlias() == null) {
                    cert.setAlias(this.generateNewAlias());
                }
                certAliases.add(cert.getAlias());
            }
            for (String keyStoreAlias : keyStoreAliases) {
                if (certAliases.contains(keyStoreAlias)) continue;
                trustKeystore.deleteEntry(keyStoreAlias);
                saveKeystore = true;
                CertModifiedTimeTracker.deleteCertModifiedTime(keyStoreAlias);
            }
            for (Cert cert : certs) {
                if (!keyStoreAliases.contains(cert.getAlias())) {
                    trustKeystore.setCertificateEntry(cert.getAlias(), cert.getX509Certificate());
                    saveKeystore = true;
                }
                CertModifiedTimeTracker.trackCertModifiedTime(cert.getAlias());
            }
            if (saveKeystore) {
                if (localKeystore) {
                    this.certService.writeTrustKeystore(trustKeystore);
                } else {
                    this.certService.writeTrustHSMKeystore(trustKeystore);
                }
                this.certService.setupSslClientTrustStore();
                this.reload();
                ListenerRegistry.getInstance().notifyListeners(ConfigEventType.TRUSTED_CAS_UPDATED);
            }
        }
        catch (KeyStoreException e) {
            throw new ConfigurationException(e);
        }
        SoapClient.flushClientsCache();
    }

    @Override
    public synchronized Set<TrustAnchor> getAllTrustAnchors() {
        return this.allTrustAnchors;
    }

    @Override
    public synchronized Set<TrustAnchor> getTrustedCaTrustAnchors() {
        HashSet<TrustAnchor> result = new HashSet<TrustAnchor>();
        TrustedCAsManagerImpl.addEm(this.getTrustedCaX509s(), result);
        return result;
    }

    @Override
    public synchronized Set<TrustAnchor> getTrustAnchorsByDN(X500Principal dn) {
        HashSet<TrustAnchor> result = new HashSet<TrustAnchor>();
        Collection<X509Certificate> certs = this.allTrustCAsByDN.get(new X500PrincipalWrapper(dn));
        if (certs != null) {
            for (X509Certificate cert : certs) {
                result.add(new TrustAnchor(cert, null));
            }
        }
        return result;
    }

    @Override
    public Set<X509Certificate> getJmvTrustedCAs() {
        try {
            return this.certService.getJavaTrustedCaCerts();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load ca certs from the JVM", e);
        }
    }

    @Override
    public synchronized void reload() {
        this.loadConfig();
        ServerX509TrustManager.getX509TrustManager().reload();
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.TRUSTED_CAS_RELOADED);
    }

    private synchronized void loadConfig() {
        this.cachedCerts = null;
        Set<X509Certificate> trustedCaX509s = this.getTrustedCaX509s();
        this.allTrustAnchors = new HashSet<TrustAnchor>();
        TrustedCAsManagerImpl.addEm(trustedCaX509s, this.allTrustAnchors);
        try {
            Set<X509Certificate> javaTrustedCaCerts = this.getJmvTrustedCAs();
            TrustedCAsManagerImpl.addEm(javaTrustedCaCerts, this.allTrustAnchors);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to load default java trusted CAs", (Throwable)e);
        }
        this.allTrustAnchors = Collections.unmodifiableSet(this.allTrustAnchors);
        this.allTrustCAMap = new HashMap<String, X509Certificate>();
        this.allTrustCAsByDN = new HashMap<X500PrincipalWrapper, Collection<X509Certificate>>();
        for (TrustAnchor anchor : this.allTrustAnchors) {
            X509Certificate cert = anchor.getTrustedCert();
            try {
                String sha256Key = HashUtil.hashToHexString((byte[])cert.getEncoded(), (HashAlgorithm)HashAlgorithm.SHA256);
                this.allTrustCAMap.put(sha256Key, cert);
                X500PrincipalWrapper key = new X500PrincipalWrapper(cert.getSubjectX500Principal());
                Collection<X509Certificate> certs = this.allTrustCAsByDN.get(key);
                if (certs == null) {
                    certs = new ArrayList<X509Certificate>();
                    this.allTrustCAsByDN.put(key, certs);
                }
                certs.add(cert);
            }
            catch (CertificateEncodingException e) {
                this.log.error((Object)e.getMessage());
            }
        }
        this.logAllTrustedCAs();
    }

    protected String generateNewAlias() {
        return IDGenerator.rndStr(25, IDGenerator.LOWER_ALPHA_NUMERICS);
    }

    private static void addEm(Collection<X509Certificate> certs, Set<TrustAnchor> anchors) {
        for (X509Certificate cert : certs) {
            anchors.add(new TrustAnchor(cert, null));
        }
    }

    @Override
    public boolean isInAllTrustAnchors(X509Certificate cert) {
        boolean retV = false;
        if (cert != null) {
            try {
                String sha256key = HashUtil.hashToHexString((byte[])cert.getEncoded(), (HashAlgorithm)HashAlgorithm.SHA256);
                retV = this.allTrustCAMap.get(sha256key) != null;
            }
            catch (CertificateEncodingException e) {
                this.log.error((Object)e.getMessage());
            }
        }
        return retV;
    }

    @Override
    public boolean isInUse(X509Certificate cert) {
        InUseDetectionUtil inuseUtil = InUseDetectionUtil.getInstance();
        return inuseUtil.isTrustedCAUsedByOAuthClient(cert) || inuseUtil.isCertInUseClientRegIssuerDefault(cert);
    }

    @Override
    public synchronized void saveTrustedCA(Cert newCert) {
        HashSet<Cert> certs = new HashSet<Cert>(this.getTrustedCAs());
        certs.add(newCert);
        this.saveTrustedCAs(certs);
    }

    @Override
    public synchronized boolean deleteTrustedCA(Cert certToDelete) {
        Set<Cert> oldCerts = this.getTrustedCAs();
        HashSet<Cert> newCerts = new HashSet<Cert>();
        boolean found = false;
        for (Cert cert : oldCerts) {
            if (cert.equals(certToDelete)) {
                found = true;
                continue;
            }
            newCerts.add(cert);
        }
        if (found) {
            this.saveTrustedCAs(newCerts);
        }
        return found;
    }

    private void logAllTrustedCAs() {
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Trusted certificate authorities loaded:");
            for (X509Certificate certificate : this.allTrustCAMap.values()) {
                sb.append(System.lineSeparator());
                sb.append("Serial number: ");
                sb.append(NumberUtils.createHexStringForDisplay((BigInteger)certificate.getSerialNumber()));
                sb.append(System.lineSeparator());
                if (certificate.getIssuerDN() != null) {
                    sb.append("Issuer DN: ");
                    sb.append(certificate.getIssuerDN().getName());
                    sb.append(System.lineSeparator());
                }
                if (certificate.getSubjectDN() != null) {
                    sb.append("Subject DN: ");
                    sb.append(certificate.getSubjectDN().getName());
                    sb.append(System.lineSeparator());
                }
                if (certificate.getPublicKey() != null) {
                    sb.append("Public key algorithm: ");
                    sb.append(certificate.getPublicKey().getAlgorithm());
                    sb.append(System.lineSeparator());
                }
                try {
                    sb.append("Certificate is valid: ");
                    certificate.checkValidity();
                    sb.append("true");
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    sb.append("false");
                }
                sb.append(System.lineSeparator());
            }
            this.log.debug((Object)sb.toString());
        }
    }
}

