/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.x2020.x07.userPreferences.User;
import com.pingidentity.x2020.x07.userPreferences.UserPreferences;
import com.pingidentity.x2020.x07.userPreferences.UserPreferencesDocument;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.mgmt.UserPreferencesManager;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;
import org.sourceid.saml20.domain.mgmt.impl.UserKey;
import org.sourceid.saml20.domain.mgmt.impl.UserPreference;

public class UserPreferencesManagerImpl
extends ConfigManagerBase
implements UserPreferencesManager {
    private static final Log log = LogFactory.getLog(UserPreferencesManagerImpl.class);
    private static final String USER_PREFERENCES_XML_FILE_NAME = "pingfederate-user-preferences.xml";
    private Map<String, UserPreference> userPrefs = new CaseInsensitiveMap(new HashMap());

    public UserPreferencesManagerImpl() {
        this.reload();
    }

    @Override
    public synchronized void reload() {
        this.loadUserPreferences();
    }

    @Override
    public synchronized UserPreference getPreferenceForUser(UserKey userKey) {
        String key = userKey.getKey();
        return this.userPrefs.containsKey(key) ? this.userPrefs.get(key) : new UserPreference(userKey);
    }

    @Override
    public synchronized void removeUserPreference(UserKey userKey) {
        if (userKey != null && this.userPrefs.containsKey(userKey.getKey())) {
            this.userPrefs.remove(userKey.getKey());
            Collection<UserPreference> updatedUserPrefs = this.getUserPreferences();
            this.savePreferences(updatedUserPrefs);
        }
    }

    @Override
    public synchronized void savePreferences(Collection<UserPreference> prefsToSave) {
        log.debug((Object)"Saving user preferences...");
        UserPreferencesDocument doc = UserPreferencesDocument.Factory.newInstance();
        UserPreferences userPreferences = doc.addNewUserPreferences();
        for (UserPreference userPreference : prefsToSave) {
            User user = userPreferences.addNewUser();
            user.setUserKey(userPreference.getUserKey().getKey());
            user.setShortcutsArray(userPreference.getShortcuts().toArray(new String[0]));
        }
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), USER_PREFERENCES_XML_FILE_NAME, (XmlObject)doc);
        this.reload();
    }

    private UserPreferencesDocument getDoc() {
        String dataDir = this.sysDirInfo.getDataDirectory();
        return (UserPreferencesDocument)this.xmlLoader.load(dataDir, USER_PREFERENCES_XML_FILE_NAME);
    }

    public Collection<UserPreference> getUserPreferences() {
        return this.userPrefs.values().stream().map(UserPreference::getClone).collect(Collectors.toList());
    }

    @Override
    public synchronized void addUserPreference(UserPreference userPreference) {
        this.userPrefs.remove(userPreference.getUserKey().getKey());
        Collection<UserPreference> existingUserPrefs = this.getUserPreferences();
        existingUserPrefs.add(userPreference);
        this.savePreferences(existingUserPrefs);
    }

    private synchronized void loadUserPreferences() {
        this.userPrefs.clear();
        try {
            User[] users;
            UserPreferencesDocument doc = this.getDoc();
            for (User user : users = doc.getUserPreferences().getUserArray()) {
                UserKey userKey = new UserKey(user.getUserKey());
                UserPreference userPreference = new UserPreference(userKey, Arrays.asList(user.getShortcutsArray()));
                this.userPrefs.put(user.getUserKey(), userPreference);
            }
        }
        catch (ConfigurationException ex) {
            log.debug((Object)"No user preference configuration file found. Default configurations will be returned.");
            log.trace((Object)ex);
        }
    }
}

