/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.scim.util;

import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.scim.model.Schema;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;
import org.sourceid.saml20.domain.scim.model.SchemaSubAttribute;

public class CustomAttributesUtil {
    public static List<String> getCustomAttributeIdsWithDotNotation(Schema schema) {
        ArrayList<String> canonicalValues = new ArrayList<String>();
        ArrayList<String> subAttributes = new ArrayList<String>();
        ArrayList<String> sortedAttributeIds = new ArrayList<String>();
        for (SchemaAttribute attr : schema.getAttributes()) {
            for (SchemaSubAttribute subAttr : attr.getSubAttributes()) {
                if (subAttr.getName().equalsIgnoreCase("type")) {
                    canonicalValues.addAll(subAttr.getCanonicalValues());
                    continue;
                }
                subAttributes.add(subAttr.getName());
            }
            sortedAttributeIds.addAll(CustomAttributesUtil.getCustomAttributeIdsWithDotNotation(attr.getName(), canonicalValues, subAttributes, attr.isMultiValued()));
            canonicalValues.clear();
            subAttributes.clear();
        }
        return sortedAttributeIds;
    }

    public static List<String> getCustomAttributeIdsWithDotNotation(String attributeName, List<String> canonicalValues, List<String> subAttrNames, boolean isMultivalued) {
        String dot = ".";
        ArrayList<String> ids = new ArrayList<String>();
        if (canonicalValues == null || canonicalValues.size() < 1) {
            if (isMultivalued) {
                ids.add(attributeName);
            } else if (subAttrNames == null || subAttrNames.size() == 0) {
                ids.add(attributeName);
            } else {
                for (String subAttrName : subAttrNames) {
                    ids.add(attributeName + dot + subAttrName);
                }
            }
        } else {
            for (String canonicalValue : canonicalValues) {
                for (String subAttrName : subAttrNames) {
                    ids.add(attributeName + dot + canonicalValue + dot + subAttrName);
                }
            }
        }
        return ids;
    }
}

