/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.websso.Protocol;

public class BrowserSsoCompareUtil {
    public static Collection<String> compareBrowserSSOInfo(ConnectionBase sourceConn, ConnectionBase mergedConn) {
        Collection<String> attrContractChanges;
        Collection<String> arsChanges;
        Collection<String> sloChanges;
        boolean isSaml1x;
        ArrayList<String> changes = new ArrayList<String>();
        boolean bl = isSaml1x = sourceConn.getProtocol().name().equals(Protocol.SAML10.name()) || sourceConn.getProtocol().name().equals(Protocol.SAML11.name());
        if (sourceConn instanceof IdpConnection) {
            IdpConnection srcIdpConnection = (IdpConnection)sourceConn;
            IdpConnection mergedIdpConnection = (IdpConnection)mergedConn;
            Collection<String> ssoChanges = null;
            if (isSaml1x) {
                ssoChanges = BrowserSsoCompareUtil.compareSaml1xSSOEndpoints(srcIdpConnection.getSingleSignOnServices(), mergedIdpConnection.getSingleSignOnServices());
            } else if (sourceConn.getEnabledProfiles().isSpInitiatedSSOEnabled()) {
                ssoChanges = BrowserSsoCompareUtil.compareEndpoints(srcIdpConnection.getSingleSignOnServices(), mergedIdpConnection.getSingleSignOnServices(), EndpointType.SSO);
            }
            if (ssoChanges != null && ssoChanges.size() > 0) {
                changes.addAll(ssoChanges);
            }
        } else if (sourceConn instanceof SpConnection) {
            Collection<String> acsChanges;
            SpConnection srcSpConnection = (SpConnection)sourceConn;
            SpConnection mergedSpConnection = (SpConnection)mergedConn;
            if (isSaml1x) {
                ArrayList<Endpoint> srcACS = srcSpConnection.getAssertionConsumerServiceEndpoints() == null ? new ArrayList() : srcSpConnection.getAssertionConsumerServiceEndpoints().getEndpoints();
                ArrayList<Endpoint> mergedACS = mergedSpConnection.getAssertionConsumerServiceEndpoints() == null ? new ArrayList() : mergedSpConnection.getAssertionConsumerServiceEndpoints().getEndpoints();
                acsChanges = BrowserSsoCompareUtil.compareEndpoints(srcACS, mergedACS, EndpointType.ACS);
            } else {
                acsChanges = BrowserSsoCompareUtil.compareIndexedEndPoints(srcSpConnection.getAssertionConsumerServiceEndpoints(), mergedSpConnection.getAssertionConsumerServiceEndpoints(), EndpointType.ACS);
            }
            if (acsChanges.size() > 0) {
                changes.addAll(acsChanges);
            }
        }
        if ((sourceConn.getEnabledProfiles().isIdpInitiatedSLOEnabled() || sourceConn.getEnabledProfiles().isSpInitiatedSLOEnabled()) && (sloChanges = BrowserSsoCompareUtil.compareEndpoints(sourceConn.getSingleLogoutServices(), mergedConn.getSingleLogoutServices(), EndpointType.SLO)).size() > 0) {
            changes.addAll(sloChanges);
        }
        if (isSaml1x) {
            ArrayList<Endpoint> srcARS = sourceConn.getArtifactResolutionServices() == null ? new ArrayList() : sourceConn.getArtifactResolutionServices().getEndpoints();
            ArrayList<Endpoint> mergedARS = mergedConn.getArtifactResolutionServices() == null ? new ArrayList() : mergedConn.getArtifactResolutionServices().getEndpoints();
            arsChanges = BrowserSsoCompareUtil.compareEndpoints(srcARS, mergedARS, EndpointType.ARS);
        } else {
            arsChanges = BrowserSsoCompareUtil.compareIndexedEndPoints(sourceConn.getArtifactResolutionServices(), mergedConn.getArtifactResolutionServices(), EndpointType.ARS);
        }
        if (arsChanges.size() > 0) {
            changes.addAll(arsChanges);
        }
        if ((attrContractChanges = BrowserSsoCompareUtil.compareAttributeContract(sourceConn.getAttributeContract(), mergedConn.getAttributeContract())).size() > 0) {
            changes.addAll(attrContractChanges);
        }
        return changes;
    }

    private static Collection<String> compareSaml1xSSOEndpoints(EndpointGroup srcIdpGroup, EndpointGroup mergedIdpGroup) {
        Collection mergedEndpoints;
        ArrayList<String> changes = new ArrayList<String>(1);
        Collection sourceEndpoints = srcIdpGroup == null ? null : srcIdpGroup.getEndpoints();
        Collection collection = mergedEndpoints = mergedIdpGroup == null ? null : mergedIdpGroup.getEndpoints();
        if (sourceEndpoints == null || sourceEndpoints.isEmpty()) {
            if (mergedEndpoints != null && !mergedEndpoints.isEmpty()) {
                Endpoint mergedEndpoint = (Endpoint)mergedEndpoints.iterator().next();
                changes.add(BrowserSsoCompareUtil.getChangedEndpointEntry(Change.ADDED, mergedEndpoint, EndpointType.SSO));
            }
        } else {
            Endpoint sourceEndpoint = (Endpoint)sourceEndpoints.iterator().next();
            if (mergedEndpoints == null || mergedEndpoints.isEmpty()) {
                changes.add(BrowserSsoCompareUtil.getChangedEndpointEntry(Change.REMOVED, sourceEndpoint, EndpointType.SSO));
            } else {
                Endpoint mergedEndpoint = (Endpoint)mergedEndpoints.iterator().next();
                if (!sourceEndpoint.getFullLocation().equals(mergedEndpoint.getFullLocation())) {
                    changes.add(BrowserSsoCompareUtil.getChangedEndpointEntry(Change.MODIFIED, sourceEndpoint, EndpointType.SSO));
                }
            }
        }
        return changes;
    }

    public static Collection<String> compareAttributeContract(AttributeContract sourceAttributeContract, AttributeContract mergedAttributeContract) {
        Map<String, Change> addedChanges;
        Collection<String> addedChangesString;
        ArrayList<String> changes = new ArrayList<String>();
        Map<String, Change> removedChanges = BrowserSsoCompareUtil.compareAttribute(sourceAttributeContract, mergedAttributeContract, Change.REMOVED);
        Collection<String> removedChangesString = BrowserSsoCompareUtil.attributeContractChanges(removedChanges);
        if (removedChangesString.size() > 0) {
            changes.addAll(removedChangesString);
        }
        if ((addedChangesString = BrowserSsoCompareUtil.attributeContractChanges(addedChanges = BrowserSsoCompareUtil.compareAttribute(mergedAttributeContract, sourceAttributeContract, Change.ADDED))).size() > 0) {
            changes.addAll(addedChangesString);
        }
        return changes;
    }

    public static Collection<String> attributeContractChanges(Map<String, Change> changes) {
        ArrayList<String> changeStrings = new ArrayList<String>();
        if (changes != null) {
            for (String change : changes.keySet()) {
                Change changeType = changes.get(change);
                changeStrings.add(BrowserSsoCompareUtil.getChangedAttrContractEntry(changeType, change));
            }
        }
        return changeStrings;
    }

    public static Map<String, Change> compareAttribute(AttributeContract sourceAttributeContract, AttributeContract mergedAttributeContract, Change change) {
        Set<String> mergedMutableAttributeNames;
        HashMap<String, Change> changes = new HashMap<String, Change>();
        Set<String> srcMutableAttributeNames = sourceAttributeContract == null ? null : sourceAttributeContract.getMutableAttributeNames();
        Set<String> set = mergedMutableAttributeNames = mergedAttributeContract == null ? null : mergedAttributeContract.getMutableAttributeNames();
        if (srcMutableAttributeNames != null) {
            for (String srcAttributeName : srcMutableAttributeNames) {
                boolean found = false;
                if (mergedMutableAttributeNames != null) {
                    for (String mergedAttributeName : mergedMutableAttributeNames) {
                        if (!mergedAttributeName.equals(srcAttributeName)) continue;
                        found = true;
                        if (!change.equals((Object)Change.REMOVED)) break;
                        String sourceAttValue = sourceAttributeContract.getMutableAttributeNameFormat(srcAttributeName);
                        String mergedAttValue = mergedAttributeContract.getMutableAttributeNameFormat(mergedAttributeName);
                        if (sourceAttValue != null) {
                            if (mergedAttValue != null) {
                                if (sourceAttValue.equals(mergedAttValue)) break;
                                changes.put(srcAttributeName, Change.MODIFIED);
                                break;
                            }
                            changes.put(srcAttributeName, Change.MODIFIED);
                            break;
                        }
                        if (mergedAttValue == null) break;
                        changes.put(srcAttributeName, Change.MODIFIED);
                        break;
                    }
                }
                if (found) continue;
                changes.put(srcAttributeName, change);
            }
        }
        return changes;
    }

    public static Collection<String> compareIndexedEndPoints(IndexedEndpoints sourceIndexedEndpoints, IndexedEndpoints mergedIndexedEndpoints, EndpointType endpointType) {
        Collection<String> addedEndpoints;
        ArrayList<String> changes = new ArrayList<String>();
        HashMap<Integer, Endpoint> mergedEndpoints = mergedIndexedEndpoints != null ? mergedIndexedEndpoints.getEndpointsMap() : new HashMap<Integer, Endpoint>();
        Collection<String> removedEndpoints = BrowserSsoCompareUtil.compareIndexedEndpoints(sourceIndexedEndpoints.getEndpointsMap(), mergedEndpoints, Change.REMOVED, endpointType);
        if (removedEndpoints.size() > 0) {
            changes.addAll(removedEndpoints);
        }
        if ((addedEndpoints = BrowserSsoCompareUtil.compareIndexedEndpoints(mergedEndpoints, sourceIndexedEndpoints.getEndpointsMap(), Change.ADDED, endpointType)).size() > 0) {
            changes.addAll(addedEndpoints);
        }
        return changes;
    }

    private static Collection<String> compareIndexedEndpoints(Map<Integer, Endpoint> sourceIndexedEndpoints, Map<Integer, Endpoint> mergedIndexedEndpoints, Change change, EndpointType endpointType) {
        ArrayList<String> changes = new ArrayList<String>();
        if (sourceIndexedEndpoints != null) {
            for (Map.Entry<Integer, Endpoint> srcIndexedEndpoint : sourceIndexedEndpoints.entrySet()) {
                boolean found = false;
                Integer sourceIndex = srcIndexedEndpoint.getKey();
                Endpoint sourceEndpoint = srcIndexedEndpoint.getValue();
                if (mergedIndexedEndpoints != null) {
                    for (Map.Entry<Integer, Endpoint> mergedIndexedEndpoint : mergedIndexedEndpoints.entrySet()) {
                        String mergedBinding;
                        Integer mergedIndex = mergedIndexedEndpoint.getKey();
                        Endpoint mergedEndpoint = mergedIndexedEndpoint.getValue();
                        if (!mergedIndex.equals(sourceIndex)) continue;
                        found = true;
                        if (!change.equals((Object)Change.REMOVED)) break;
                        String sourceBinding = sourceEndpoint.getBinding();
                        boolean isBindingModified = BrowserSsoCompareUtil.hasChanged(sourceBinding, mergedBinding = mergedEndpoint.getBinding());
                        if (isBindingModified) {
                            changes.add(BrowserSsoCompareUtil.getChangedIndexedEndpointEntry(Change.MODIFIED, sourceEndpoint, sourceIndex, endpointType));
                            break;
                        }
                        boolean isLocationModified = BrowserSsoCompareUtil.hasChanged(sourceEndpoint.getFullLocation(), mergedEndpoint.getFullLocation());
                        if (!isLocationModified) break;
                        changes.add(BrowserSsoCompareUtil.getChangedIndexedEndpointEntry(Change.MODIFIED, sourceEndpoint, sourceIndex, endpointType));
                        break;
                    }
                }
                if (found) continue;
                changes.add(BrowserSsoCompareUtil.getChangedIndexedEndpointEntry(change, sourceEndpoint, sourceIndex, endpointType));
            }
        }
        return changes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasChanged(String sourceValue, String mergedValue) {
        if (sourceValue != null) {
            if (mergedValue == null) return true;
            if (sourceValue.equals(mergedValue)) return false;
            return true;
        }
        if (mergedValue == null) return false;
        return true;
    }

    public static Collection<String> compareEndpoints(EndpointGroup sourceEndGroup, EndpointGroup mergedEndGroup, EndpointType endpointType) {
        ArrayList<Endpoint> srcEndPoints = sourceEndGroup == null ? new ArrayList() : sourceEndGroup.getEndpoints();
        ArrayList<Endpoint> mergedEndPoints = mergedEndGroup == null ? new ArrayList() : mergedEndGroup.getEndpoints();
        Collection<String> changes = BrowserSsoCompareUtil.compareEndpoints(srcEndPoints, mergedEndPoints, endpointType);
        return changes;
    }

    private static Collection<String> compareEndpoints(Collection<Endpoint> srcEndPoints, Collection<Endpoint> mergedEndPoints, EndpointType endpointType) {
        ArrayList<String> changes = new ArrayList<String>();
        Collection<String> removedChanges = BrowserSsoCompareUtil.compareEndpoints(srcEndPoints, mergedEndPoints, Change.REMOVED, endpointType);
        Collection<String> addedChanges = BrowserSsoCompareUtil.compareEndpoints(mergedEndPoints, srcEndPoints, Change.ADDED, endpointType);
        if (removedChanges.size() > 0) {
            changes.addAll(removedChanges);
        }
        if (addedChanges.size() > 0) {
            changes.addAll(addedChanges);
        }
        return changes;
    }

    private static Collection<String> compareEndpoints(Collection<Endpoint> srcEndPoints, Collection<Endpoint> mergedEndpoints, Change change, EndpointType endpointType) {
        ArrayList<String> changes = new ArrayList<String>();
        if (srcEndPoints != null) {
            for (Endpoint srcEndpoint : srcEndPoints) {
                boolean found = false;
                if (mergedEndpoints != null) {
                    for (Endpoint mergedEndpoint : mergedEndpoints) {
                        if (!mergedEndpoint.getBinding().equals(srcEndpoint.getBinding()) || !mergedEndpoint.getFullLocation().equals(srcEndpoint.getFullLocation())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                changes.add(BrowserSsoCompareUtil.getChangedEndpointEntry(change, srcEndpoint, endpointType));
            }
        }
        return changes;
    }

    private static String getChangedEndpointEntry(Change change, Endpoint endpoint, EndpointType endpointType) {
        return "Endpoint type: " + endpointType.name() + " Binding: " + endpoint.getBinding() + " Location: " + endpoint.getFullLocation() + " - " + change.name();
    }

    private static String getChangedIndexedEndpointEntry(Change change, Endpoint endpoint, int index, EndpointType endpointType) {
        return "Endpoint type: " + endpointType.name() + " Index: " + index + " Binding: " + endpoint.getBinding() + " Location: " + endpoint.getFullLocation() + " - " + change.name();
    }

    private static String getChangedAttrContractEntry(Change change, String attrContractName) {
        return "Attribute Contract: " + attrContractName + " - " + change.name();
    }

    public static enum EndpointType {
        SSO,
        SLO,
        ACS,
        ARS;

    }

    public static enum Change {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

