/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.common.util.HierarchicalUriComparison;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class HierarchicalResourceMatchingUtil {
    private HierarchicalResourceMatchingUtil() {
    }

    public static boolean match(String requestedResource, List<String> resourceUris) {
        if (StringUtils.isBlank((String)requestedResource)) {
            return false;
        }
        try {
            URI requestedResourceUri = new URI(requestedResource);
            if (resourceUris.contains(requestedResource)) {
                return true;
            }
            boolean matched = false;
            for (String uriStr : resourceUris) {
                try {
                    URI resourceUri = new URI(uriStr);
                    int compare = HierarchicalUriComparison.compare(requestedResourceUri, resourceUri, true);
                    if (compare < 0) continue;
                    matched = true;
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return matched;
        }
        catch (URISyntaxException ignored) {
            return false;
        }
    }
}

