/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.GDurationSpecification;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.impl.MetadataDirectoryBase;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.w3c.dom.Node;

public class ImportingMetadataDir
extends MetadataDirectoryBase {
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private long cacheUntil = 0L;
    private EntitiesDescriptorDocument partnerMetadata;

    public ImportingMetadataDir(InputStream inStream) throws MetadataImportException {
        InvalidXmlException invalidXmlException = null;
        try {
            this.partnerMetadata = this.loadFromStream(inStream);
            try {
                XmlBeansUtil.validate((XmlObject)this.partnerMetadata);
            }
            catch (InvalidXmlException e) {
                invalidXmlException = e;
                if (this.config.getBooleanValue("LaxOnInvalidXml", true)) {
                    this.log.warn((Object)("Metadata XML file is invalid. " + e));
                }
                throw new MetadataImportException("Problem parsing metadata.", e);
            }
            this.loadAllConnections();
            this.processConnections();
            this.loadAffiliationMap(this.partnerMetadata);
        }
        catch (MetadataImportException e) {
            this.log.error((Object)"Exception in import", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Object message = "Unexpected error during metadata import";
            if (invalidXmlException != null) {
                message = (String)message + ", likely caused by invalid XML: " + invalidXmlException.getMessage();
            }
            MetadataImportException metadataImportEx = new MetadataImportException((String)message, e);
            this.log.error((Object)"Exception in import", (Throwable)metadataImportEx);
            throw metadataImportEx;
        }
    }

    public synchronized long getCacheUntil() {
        return this.cacheUntil;
    }

    @Override
    protected synchronized boolean loadConnectionFromStore(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected synchronized boolean loadConnectionFromStoreByEntityId(Role role, String entityId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected synchronized void loadAllConnectionsFromStore() {
        EntitiesDescriptorType edt = this.partnerMetadata.getEntitiesDescriptor();
        this.updateCacheUntil(edt.getValidUntil(), edt.getCacheDuration());
        if (edt.isSetValidUntil()) {
            this.validateValidUntil(edt.getValidUntil());
        }
        for (EntityDescriptorType entityDescriptorType : edt.getEntityDescriptorArray()) {
            this.addConnectionFromMetadata(entityDescriptorType);
            this.updateCacheUntil(entityDescriptorType.getValidUntil(), entityDescriptorType.getCacheDuration());
        }
    }

    private synchronized void processConnections() {
        Collection<IdpConnection> idpConnections = this.getIdpConnections();
        for (IdpConnection connection : idpConnections) {
            if (connection.getBaseUrl() != null) continue;
            LinkedList<Endpoint> endpoints = new LinkedList<Endpoint>();
            endpoints.addAll(connection.getSingleSignOnServices().getEndpoints());
            endpoints.addAll(connection.getSingleLogoutServices().getEndpoints());
            endpoints.addAll(connection.getArtifactResolutionServices().getEndpoints());
            LinkedList<Endpoint> attributeService = new LinkedList<Endpoint>();
            AttributeAuthority attrAuthority = connection.getAttributeAuthority();
            if (attrAuthority != null) {
                Endpoint endpoint = attrAuthority.getAttributeService();
                attributeService.add(endpoint);
            }
            endpoints.addAll(attributeService);
            HashSet theSet = new HashSet();
            for (Endpoint endpoint : endpoints) {
                theSet.add(this.trimBaseUrlString(endpoint.getLocation()));
            }
            if (theSet.size() != 1 || theSet.contains(null) || connection.getSingleSignOnServices() == null || connection.getSingleSignOnServices().getPrimaryEndpoint() == null) continue;
            try {
                String baseUrlStr = connection.getSingleSignOnServices().getPrimaryEndpoint().getLocation();
                baseUrlStr = this.trimBaseUrlString(baseUrlStr);
                URL baseUrl = new URL(baseUrlStr);
                connection.setBaseUrl(baseUrl);
                int baseUrlLen = baseUrlStr.length();
                for (Endpoint endpoint : endpoints) {
                    String newLocation = endpoint.getLocation();
                    newLocation = newLocation.substring(baseUrlLen);
                    endpoint.setLocation(newLocation);
                }
            }
            catch (MalformedURLException baseUrlStr) {
            }
        }
        Collection<SpConnection> spConnections = this.getSpConnections();
        for (SpConnection connection : spConnections) {
            if (connection.getBaseUrl() != null) continue;
            HashSet<Endpoint> endpoints = new HashSet<Endpoint>();
            endpoints.addAll(connection.getAssertionConsumerServiceEndpoints().getEndpoints());
            endpoints.addAll(connection.getSingleLogoutServices().getEndpoints());
            endpoints.addAll(connection.getArtifactResolutionServices().getEndpoints());
            HashSet<String> theSet = new HashSet<String>();
            for (Endpoint endpoint : endpoints) {
                theSet.add(this.trimBaseUrlString(endpoint.getLocation()));
            }
            if (theSet.size() != 1 || theSet.contains(null)) continue;
            try {
                String baseUrlStr = connection.getAssertionConsumerServiceEndpoints().getDefault().getLocation();
                baseUrlStr = this.trimBaseUrlString(baseUrlStr);
                URL baseUrl = new URL(baseUrlStr);
                connection.setBaseUrl(baseUrl);
                int baseUrlLen = baseUrlStr.length();
                for (Endpoint endpoint : endpoints) {
                    String newLocation = endpoint.getLocation();
                    newLocation = newLocation.substring(baseUrlLen);
                    endpoint.setLocation(newLocation);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
    }

    private String trimBaseUrlString(String baseUrlString) {
        try {
            Object returnString = null;
            URL theUrl = new URL(baseUrlString);
            String path = theUrl.getPath();
            if (path != null && !path.equals("") && !path.equals("/")) {
                returnString = theUrl.getProtocol();
                returnString = (String)returnString + "://";
                returnString = (String)returnString + theUrl.getHost();
                if (-1 != theUrl.getPort()) {
                    returnString = (String)returnString + ":" + Integer.toString(theUrl.getPort());
                }
            }
            return returnString;
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private EntitiesDescriptorDocument loadFromStream(InputStream inStream) throws MetadataImportException {
        EntitiesDescriptorDocument entitiesDescriptorDoc;
        XmlObject xmlObj;
        try {
            Node node = XmlBeansUtil.parseToNode(inStream);
            xmlObj = XmlObject.Factory.parse((Node)node);
        }
        catch (Exception e) {
            throw new MetadataImportException("Problem parsing metadata.", e);
        }
        if (xmlObj instanceof EntitiesDescriptorDocument) {
            entitiesDescriptorDoc = (EntitiesDescriptorDocument)xmlObj;
        } else if (xmlObj instanceof EntityDescriptorDocument) {
            EntitiesDescriptorDocument entities = EntitiesDescriptorDocument.Factory.newInstance();
            EntitiesDescriptorType entitiesDescriptor = entities.addNewEntitiesDescriptor();
            entitiesDescriptor.addNewEntityDescriptor().set((XmlObject)((EntityDescriptorDocument)xmlObj).getEntityDescriptor());
            entitiesDescriptorDoc = entities;
        } else {
            throw new MetadataImportException(xmlObj.schemaType().getName() + " is not a supported metadata format");
        }
        return entitiesDescriptorDoc;
    }

    private void updateCacheUntil(Calendar curValidUntil, GDuration curCacheUntil) {
        if (curValidUntil != null) {
            long validityTime = curValidUntil.getTimeInMillis();
            if (curCacheUntil != null) {
                long cacheTime = this.getTimeFromGduration(curCacheUntil);
                long minValue = validityTime < cacheTime ? validityTime : cacheTime;
                this.setMinToCachedUntil(minValue);
            } else {
                this.setMinToCachedUntil(validityTime);
            }
        } else if (curCacheUntil != null) {
            long cacheTime = this.getTimeFromGduration(curCacheUntil);
            this.setMinToCachedUntil(cacheTime);
        }
    }

    private long getTimeFromGduration(GDuration curCacheUntil) {
        long time = 0L;
        if (curCacheUntil != null) {
            GDate curCalender = new GDate(Calendar.getInstance());
            GDate cacheUntilCalender = curCalender.add((GDurationSpecification)curCacheUntil);
            time = cacheUntilCalender.getDate().getTime();
        }
        return time;
    }

    private void setMinToCachedUntil(long value) {
        if (this.cacheUntil == 0L || this.cacheUntil > value) {
            this.cacheUntil = value;
        }
    }
}

