/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.crypto.Cert;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.sourceid.oauth20.authorizationdetails.AuthorizationDetailTypesManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.ciba.domain.CibaServerPolicyManager;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.AuthorizationDetailProcessorInstance;
import org.sourceid.saml20.domain.mgmt.AuthorizationDetailProcessorsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.domain.mgmt.impl.CertModifiedTimeTracker;
import org.sourceid.saml20.domain.util.SelectiveReplicationValidator;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SelectiveReplicationClientValidator
extends SelectiveReplicationValidator {
    private final OpenIdConnectProviderPolicyManager oidcPolicyManager = MgmtFactory.getOIDCProviderPolicyManager();
    private final CibaServerPolicyManager cibaPolicyManager = MgmtFactory.getCibaServerPolicyManager();
    private final AuthorizationDetailTypesManager authorizationDetailTypesManager = MgmtFactory.getAuthorizationDetailTypesManager();
    private final AuthorizationDetailProcessorsManager authorizationDetailProcessorsManager = MgmtFactory.getAuthorizationDetailProcessorsPluginManager();
    private final TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
    private final Client client;

    public SelectiveReplicationClientValidator(Client client) {
        this.client = client;
    }

    public boolean checkSelectiveReplicationClient() {
        if (this.lastFullConfigReplication == null) {
            return false;
        }
        ArrayList<BooleanSupplier> validators = new ArrayList<BooleanSupplier>();
        validators.add(this::validateAccessTokenManager);
        validators.add(this::validateAccessTokenManager);
        validators.add(this::validateOidcPolicy);
        validators.add(this::validateCibaPolicy);
        validators.add(this::validateAuthorizationDetailTypes);
        validators.add(this::validateClientSecret);
        validators.add(this::validateScopes);
        validators.add(this::validateTrustedCAs);
        for (BooleanSupplier validator : validators) {
            if (validator.getAsBoolean()) continue;
            log.debug((Object)"Not automatically replicating client changes as there are un-replicated dependencies.");
            return false;
        }
        return true;
    }

    private boolean validateAccessTokenManager() {
        String atmId = this.client.getDefaultAccessTokenManagerId();
        return this.validateAtm(atmId);
    }

    private boolean validateOidcPolicy() {
        String oidcPolicyId = this.client.getPolicyGroupId();
        if (oidcPolicyId != null && this.oidcPolicyManager.getPolicy() != null) {
            OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.oidcPolicyManager.getPolicy().getPolicyGroup(oidcPolicyId);
            Calendar policyLastModified = policyGroup.getLastModified();
            return !this.afterTime(policyLastModified, this.lastFullConfigReplication);
        }
        return true;
    }

    private boolean validateCibaPolicy() {
        String cibaPolicyId = this.client.getCibaPolicyId();
        if (cibaPolicyId != null && this.cibaPolicyManager.getCibaServerPolicy() != null) {
            CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy = this.cibaPolicyManager.getCibaServerPolicy().getRequestHandlingPolicy(cibaPolicyId);
            Calendar policyLastModified = requestHandlingPolicy.getLastModified();
            return !this.afterTime(policyLastModified, this.lastFullConfigReplication);
        }
        return true;
    }

    private boolean validateAuthorizationDetailTypes() {
        List<String> authorizationDetailTypes = this.client.getAuthorizationDetailTypes();
        if (!authorizationDetailTypes.isEmpty()) {
            for (String type : authorizationDetailTypes) {
                String processorId = this.authorizationDetailTypesManager.getAuthorizationDetailTypeByType(type).getAuthorizationDetailProcessorId();
                Calendar lastModified = ((AuthorizationDetailProcessorInstance)this.authorizationDetailProcessorsManager.getInstance(processorId)).getLastModified();
                if (!this.afterTime(lastModified, this.lastFullConfigReplication)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateClientSecret() {
        if (this.client.getObfuscatedReversableSecret() != null) {
            return this.validateConfigurationEncryptionKey();
        }
        return true;
    }

    private boolean validateScopes() {
        Date scopeLastModified;
        return (this.client.getRestrictedScopes() == null || this.client.getRestrictedScopes().isEmpty()) && (this.client.getExclusiveScopes() == null || this.client.getExclusiveScopes().isEmpty()) || !this.afterTime(scopeLastModified = MgmtFactory.getScopeManager().getLastModified(), this.lastFullConfigReplication);
    }

    private boolean validateTrustedCAs() {
        String issuerDn = this.client.getClientCertIssuerDn();
        if (issuerDn != null && !"Trust Any".equals(issuerDn)) {
            for (Cert cert : this.trustedCAsManager.getTrustedCAs()) {
                Calendar lastModified;
                String certIssuerDn = cert.getX509Certificate().getIssuerDN().getName();
                if (!issuerDn.equals(certIssuerDn) || !this.afterTime(lastModified = CertModifiedTimeTracker.getCertModifiedTime(cert.getAlias()), this.lastFullConfigReplication)) continue;
                return false;
            }
        }
        return true;
    }
}

