/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.saml20.domain.mgmt.impl.CertModifiedTimeTracker;
import org.sourceid.saml20.domain.mgmt.impl.ReplicationStateManagerImpl;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.domain.util.SelectiveReplicationValidator;
import org.sourceid.saml20.metadata.Role;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SelectiveReplicationConnectionValidator
extends SelectiveReplicationValidator {
    private final ConnectionBase connection;

    public SelectiveReplicationConnectionValidator(ConnectionBase connection) {
        this.connection = connection;
    }

    public boolean checkSelectiveReplicationIdpConnection() {
        log.debug((Object)("Checking selective replication for " + this.connection.getEntityId()));
        if (this.lastFullConfigReplication == null) {
            return false;
        }
        ArrayList<BooleanSupplier> validators = new ArrayList<BooleanSupplier>();
        validators.add(this::validateConnectionExtendedProperties);
        validators.add(this::validateIdpConnectionOAuthAttributeMapping);
        validators.add(this::validateIdpConnectionSpAdapterMappings);
        validators.add(this::validateIdpConnectionApcMappings);
        validators.add(this::validateIdpConnectionOAuthAssertionGrantMapping);
        validators.add(this::validateConnectionDigitalSignatureSettings);
        validators.add(this::validateConnectionWsTrustTokenGenerator);
        validators.add(this::validateIdpConnectionInboundProvisioning);
        validators.add(this::validateIdpConnectionOidcSettings);
        validators.add(this::validateIdpConnectionJITProvisioning);
        validators.add(this::validateConnectionEncryptionSettings);
        validators.add(() -> this.validateUnreplicatedChanges(Role.IDP));
        validators.add(this::validateConnectionModuleConfigurations);
        for (BooleanSupplier validator : validators) {
            if (validator.getAsBoolean()) continue;
            log.debug((Object)"Not automatically replicating connection changes as there are un-replicated dependencies.");
            return false;
        }
        return true;
    }

    public boolean checkSelectiveReplicationSpConnection() {
        log.debug((Object)("Checking selective replication for " + this.connection.getEntityId()));
        if (this.lastFullConfigReplication == null) {
            return false;
        }
        ArrayList<BooleanSupplier> validators = new ArrayList<BooleanSupplier>();
        validators.add(this::validateConnectionExtendedProperties);
        validators.add(this::validateSpConnectionAdapterMappings);
        validators.add(this::validateSpConnectionApcMappings);
        validators.add(this::validateSpConnectionWsTrustSettings);
        validators.add(this::validateConnectionDigitalSignatureSettings);
        validators.add(this::validateConnectionEncryptionSettings);
        validators.add(() -> this.validateUnreplicatedChanges(Role.SP));
        validators.add(this::validateConnectionModuleConfigurations);
        for (BooleanSupplier validator : validators) {
            if (validator.getAsBoolean()) continue;
            log.debug((Object)"Not automatically replicating connection changes as there are un-replicated dependencies.");
            return false;
        }
        return true;
    }

    private boolean validateSpConnectionAdapterMappings() {
        Collection<AdapterToAssertionMapping> adapterMappings = ((SpConnection)this.connection).getAdapterMappings();
        for (AdapterToAssertionMapping adapterMapping : adapterMappings) {
            String adapterId = adapterMapping.getAdapterInstanceId();
            if (this.validatePluginInstance((ConfigurablePluginInstance)this.idpAdapterManager.getInstance(adapterId))) continue;
            return false;
        }
        return true;
    }

    private boolean validateSpConnectionApcMappings() {
        Collection<C2cContractToAssertionMapping> apcMappings = ((SpConnection)this.connection).getC2cMappings();
        for (C2cContractToAssertionMapping apcMapping : apcMappings) {
            String contractId = apcMapping.getContractId();
            if (!this.validateApc(contractId)) {
                return false;
            }
            for (AttributeMapping attributeMapping : apcMapping.getAttributeMappingList()) {
                List<AttributeSource> attributeSources = attributeMapping.getAttributeSources();
                if (this.validateAttributeDataSources(attributeSources)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateConnectionExtendedProperties() {
        if (!this.connection.getExtendedProperties().isEmpty()) {
            Calendar extendedPropertiesLastModified = this.clientSettingManager.getClientSetting().getExtendedMetadataParamsLastModified();
            return !this.afterTime(extendedPropertiesLastModified, this.lastFullConfigReplication);
        }
        return true;
    }

    private boolean validateConnectionEncryptionSettings() {
        EncryptionSettings encryptionSettings = this.connection.getEncryptionSettings();
        if (encryptionSettings != null) {
            Calendar decryptionKeyModifiedTime = CertModifiedTimeTracker.getCertModifiedTime(encryptionSettings.getDecryptionKeyAlias());
            Calendar secondaryDecryptionModifiedTime = CertModifiedTimeTracker.getCertModifiedTime(encryptionSettings.getSecondaryDecryptionKeyAlias());
            if (this.afterTime(decryptionKeyModifiedTime, this.lastFullConfigReplication) || this.afterTime(secondaryDecryptionModifiedTime, this.lastFullConfigReplication)) {
                return false;
            }
            if (encryptionSettings.getEncryptionCert() != null) {
                Calendar encryptionKeyModifiedTime = CertModifiedTimeTracker.getCertModifiedTime(encryptionSettings.getEncryptionCert().getAlias());
                return !this.afterTime(encryptionKeyModifiedTime, this.lastFullConfigReplication);
            }
        }
        return true;
    }

    private boolean validateSpConnectionWsTrustSettings() {
        if (((SpConnection)this.connection).getWsTrustSettings() != null) {
            WsTrustRequestContract requestContract;
            Collection<TokenPluginAttributeMapping> tokenMappings = ((SpConnection)this.connection).getWsTrustSettings().getTokenToAssertionMappings();
            for (TokenPluginAttributeMapping tokenMapping : tokenMappings) {
                Object tokenProcessor = this.tokenProcessorManager.getInstance(tokenMapping.getPluginId());
                if (this.validatePluginInstance((ConfigurablePluginInstance)tokenProcessor)) continue;
                return false;
            }
            String requestContractId = ((SpConnection)this.connection).getWsTrustSettings().getRequestContractId();
            if (requestContractId != null && (requestContract = this.wsTrustRequestContractManager.findById(requestContractId)) != null) {
                return !this.afterTime(requestContract.getLastModified(), this.lastFullConfigReplication);
            }
        }
        return true;
    }

    private boolean validateIdpConnectionOAuthAttributeMapping() {
        List<AttributeSource> attributeSources;
        if (((IdpConnection)this.connection).getSsoToOAuthAttrMapping() != null && (attributeSources = ((IdpConnection)this.connection).getSsoToOAuthAttrMapping().getAttributeSources()) != null && !this.validateAttributeDataSources(attributeSources)) {
            return false;
        }
        return ((IdpConnection)this.connection).getOAuthApcId() == null || this.validateApc(((IdpConnection)this.connection).getOAuthApcId());
    }

    private boolean validateIdpConnectionSpAdapterMappings() {
        Collection<TargetAttributeMapping> targetAttributeMappings = ((IdpConnection)this.connection).getTargetAttributeMappings();
        if (targetAttributeMappings != null) {
            for (TargetAttributeMapping mapping : targetAttributeMappings) {
                Object spAdapter = this.spAdapterManager.getInstance(mapping.getAdapterInstanceId());
                if (spAdapter != null && this.afterTime(spAdapter.getLastModified(), this.lastFullConfigReplication)) {
                    return false;
                }
                List<AttributeSource> attributeSources = mapping.getAttributeSources();
                if (this.validateAttributeDataSources(attributeSources)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateIdpConnectionApcMappings() {
        Collection<C2cContractAttributeMapping> apcMappings = ((IdpConnection)this.connection).getC2cContractMappings();
        if (apcMappings != null) {
            for (C2cContractAttributeMapping apcMapping : apcMappings) {
                this.validateApc(apcMapping.getContractId());
                List<AttributeSource> attributeSources = apcMapping.getAttributeSources();
                if (this.validateAttributeDataSources(attributeSources)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateIdpConnectionOAuthAssertionGrantMapping() {
        List<OAuthAssertionGrantMapping> grantMappings;
        if (((IdpConnection)this.connection).getOAuthSettings() != null && (grantMappings = ((IdpConnection)this.connection).getOAuthSettings().getOAuthAssertionGrantMappingList()) != null) {
            for (OAuthAssertionGrantMapping mapping : grantMappings) {
                List<AttributeSource> attributeSources = mapping.getAttributeSources();
                if (this.validateAtm(mapping.getTokenManagerId()) && this.validateAttributeDataSources(attributeSources)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateConnectionDigitalSignatureSettings() {
        Calendar secondarySigningKeyModifiedTime;
        Calendar primarySigningKeyModifiedTime;
        if (this.connection.getSigningKeyAlias() != null && this.afterTime(primarySigningKeyModifiedTime = CertModifiedTimeTracker.getCertModifiedTime(this.connection.getSigningKeyAlias()), this.lastFullConfigReplication)) {
            return false;
        }
        return this.connection.getSecondarySigningKeyAlias() == null || !this.afterTime(secondarySigningKeyModifiedTime = CertModifiedTimeTracker.getCertModifiedTime(this.connection.getSecondarySigningKeyAlias()), this.lastFullConfigReplication);
    }

    private boolean validateConnectionWsTrustTokenGenerator() {
        if (((IdpConnection)this.connection).getWsTrustSettings() != null && ((IdpConnection)this.connection).getWsTrustSettings().getAssertionToTokenMappingsMappings() != null) {
            for (TokenPluginAttributeMapping mapping : ((IdpConnection)this.connection).getWsTrustSettings().getAssertionToTokenMappingsMappings()) {
                if (!this.validateTokenGenerator(mapping.getPluginId())) {
                    return false;
                }
                List<AttributeSource> attributeSources = mapping.getAttributeMapping().getAttributeSources();
                if (attributeSources == null || this.validateAttributeDataSources(attributeSources)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateIdpConnectionInboundProvisioning() {
        ScimUserProvisioning provisioningSettings = ((IdpConnection)this.connection).getInboundProvisioning();
        if (provisioningSettings != null) {
            if (!this.validatePluginInstance(provisioningSettings.getIdentityStoreProvisioner())) {
                return false;
            }
            if (provisioningSettings.getReadUsersAttributeMapping() != null) {
                List<AttributeSource> readUsersAttributeSources = provisioningSettings.getReadUsersAttributeMapping().getAttributeSources();
                List<AttributeSource> readGroupsAttributeSources = provisioningSettings.getReadGroupsAttributeMapping().getAttributeSources();
                List<AttributeSource> writeUsersAttributeSources = provisioningSettings.getWriteUsersAttributeMapping().getAttributeSources();
                List<AttributeSource> writeGroupsAttributeSources = provisioningSettings.getWriteGroupsAttributeMapping().getAttributeSources();
                return this.validateAttributeDataSources(readUsersAttributeSources) && this.validateAttributeDataSources(readGroupsAttributeSources) && this.validateAttributeDataSources(writeUsersAttributeSources) && this.validateAttributeDataSources(writeGroupsAttributeSources);
            }
        }
        return true;
    }

    private boolean validateIdpConnectionOidcSettings() {
        if (((IdpConnection)this.connection).getOidcSettings() != null && ((IdpConnection)this.connection).getOidcSettings().getClientSecret() != null) {
            return this.validateConfigurationEncryptionKey();
        }
        return true;
    }

    private boolean validateIdpConnectionJITProvisioning() {
        if (((IdpConnection)this.connection).getUserProvisioning() != null) {
            List<AttributeSource> jitAttributeSources = ((IdpConnection)this.connection).getUserProvisioning().getAttributeSources();
            return this.validateAttributeDataSources(jitAttributeSources);
        }
        return true;
    }

    private boolean validateUnreplicatedChanges(Role role) {
        for (ReplicationStateManagerImpl.UnpreplicatedChange unreplicatedChange : this.replicationStateManager.getUnreplicatedData()) {
            if (!role.toString().equals(unreplicatedChange.getType()) || !this.connection.getName().equals(unreplicatedChange.getOldName()) && !this.connection.getEntityId().equals(unreplicatedChange.getOldId())) continue;
            return false;
        }
        return true;
    }

    private boolean validateConnectionModuleConfigurations() {
        return this.connection.getConnectionModuleConfigurations() == null || this.connection.getConnectionModuleConfigurations().isEmpty();
    }
}

