/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.jose4j.jwk.JsonWebKey;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.ReplicationStateManager;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public abstract class SelectiveReplicationValidator {
    protected Calendar lastFullConfigReplication = null;
    protected final ClientSettingManager clientSettingManager;
    protected final C2cContractManager apcManager;
    protected final SpAdapterManager spAdapterManager;
    protected final IdpAdapterManager idpAdapterManager;
    protected final BearerAccessTokenMgmtPluginManager atmManager;
    protected final TokenGeneratorManager tokenGeneratorManager;
    protected final TokenProcessorManager tokenProcessorManager;
    protected final WsTrustRequestContractManager wsTrustRequestContractManager;
    protected final ReplicationStateManager replicationStateManager;
    protected static final Log log = LogFactory.getLog(SelectiveReplicationValidator.class);

    public SelectiveReplicationValidator() {
        Mediator mediator = MgmtFactory.getMediator();
        if (mediator.getConfigPublishDate() != null) {
            this.lastFullConfigReplication = new XmlCalendar(mediator.getConfigPublishDate());
        }
        this.clientSettingManager = MgmtFactory.getClientSettingManager();
        this.apcManager = MgmtFactory.getC2cContractManager();
        this.spAdapterManager = MgmtFactory.getSpAdapterManager();
        this.idpAdapterManager = MgmtFactory.getIdpAdapterManager();
        this.atmManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        this.tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
        this.tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
        this.wsTrustRequestContractManager = MgmtFactory.getWsTrustRequestContractManager();
        this.replicationStateManager = MgmtFactory.getReplicationStateManager();
    }

    protected boolean validateApc(String contractId) {
        C2cContract apc = this.apcManager.getContract(contractId);
        if (apc != null) {
            Calendar lastModified = apc.getLastModified();
            return !this.afterTime(lastModified, this.lastFullConfigReplication);
        }
        return true;
    }

    protected boolean validateAtm(String atmId) {
        Object atmInstance = this.atmManager.getInstance(atmId);
        return this.validatePluginInstance((ConfigurablePluginInstance)atmInstance);
    }

    protected boolean validateTokenGenerator(String tokenGeneratorId) {
        Object tokenGenerator = this.tokenGeneratorManager.getInstance(tokenGeneratorId);
        return this.validatePluginInstance((ConfigurablePluginInstance)tokenGenerator);
    }

    protected boolean validatePluginInstance(ConfigurablePluginInstance pluginInstance) {
        if (pluginInstance != null) {
            Calendar lastModified = pluginInstance.getLastModified();
            return !this.afterTime(lastModified, this.lastFullConfigReplication);
        }
        return true;
    }

    protected boolean validateAttributeDataSources(List<AttributeSource> attributeSources) {
        for (AttributeSource attributeSource : attributeSources) {
            Calendar dsLastModified;
            if (attributeSource.getDataSource() == null || !this.afterTime(dsLastModified = attributeSource.getDataSource().getLastModified(), this.lastFullConfigReplication)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateConfigurationEncryptionKey() {
        JsonWebKey currentMasterKey = (JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0);
        Long keyCreationDate = (Long)currentMasterKey.getOtherParameterValue("creationDate", Long.class);
        if (keyCreationDate != null) {
            XmlCalendar creationTime = new XmlCalendar(new Date(keyCreationDate * 1000L));
            return !this.afterTime((Calendar)creationTime, this.lastFullConfigReplication);
        }
        return true;
    }

    protected boolean afterTime(Calendar lastModified, Calendar lastReplicationTime) {
        return lastModified != null && lastModified.after(lastReplicationTime);
    }

    protected boolean afterTime(Date lastModified, Calendar lastReplicationTime) {
        if (lastReplicationTime == null) {
            return true;
        }
        return lastModified != null && lastModified.after(lastReplicationTime.getTime());
    }
}

