/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.api;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.crypto.Cert;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.api.ConnectionDeserializer;
import org.sourceid.saml20.domain.util.api.ConnectionMigrationException;
import org.sourceid.saml20.domain.util.api.ConnectionSerializer;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.Defense;
import org.sourceid.util.license.LicenseManagerAdapter;

public class ConnectionMigrationMgr {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConnectionManager connMgr = MgmtFactory.getConnectionManager();
    private LicenseManagerAdapter licenseManager = new LicenseManagerAdapter();

    public byte[] getConnectionXmlBytes(String entityId, Role role) {
        ConnectionBase conn = role == Role.IDP ? this.connMgr.getIdpConnection(entityId) : this.connMgr.getSpConnection(entityId);
        Defense.notNull(conn, "No " + role + " connection found for entity id: " + entityId);
        ConnectionSerializer serializer = new ConnectionSerializer(conn);
        byte[] data = serializer.serializeToBytes();
        return data;
    }

    public ConnectionBase saveConnection(InputStream inputStream, boolean allowUpdate) throws ConnectionMigrationException {
        ConnectionBase connection = this.getConnectionWithBasicValidation(inputStream, allowUpdate, null);
        return this.saveConnection(connection);
    }

    public ConnectionBase saveConnection(ConnectionBase connection) {
        connection.setCreationTime((Calendar)new XmlCalendar(new Date()));
        if (connection.getRoleType() == Role.IDP) {
            this.connMgr.saveIdpConnection((IdpConnection)connection);
        } else {
            this.connMgr.saveSpConnection((SpConnection)connection);
        }
        return connection;
    }

    public ConnectionBase getConnectionWithBasicValidation(InputStream inputStream, boolean allowUpdate, AdministrativeUser administrativeUser) throws ConnectionMigrationException {
        try {
            ArrayList<String> errorsFound;
            ConnectionDeserializer deserializer = new ConnectionDeserializer(inputStream);
            List<String> problems = deserializer.getProblems();
            this.checkThrow(problems);
            ConnectionBase connection = deserializer.getConnection();
            Role roleType = connection.getRoleType();
            String entityId = connection.getEntityId();
            ConnectionBase existingConn = roleType == Role.IDP ? this.connMgr.getIdpConnection(entityId) : this.connMgr.getSpConnection(entityId);
            ExpressionManager expressionManager = ExpressionManager.getInstance();
            if (connection.hasExpressions()) {
                if (administrativeUser != null && !administrativeUser.isExpressionAdmin()) {
                    problems.add("The " + roleType + " connection cannot be imported because it contains expressions and  your administrative account do not have the permission to create or update ognl expressions.");
                } else if (!expressionManager.isEvaluateExpressionsOn()) {
                    problems.add("The " + roleType + " connection cannot be imported because it contains expressions in the mappings and ognl expressions have not been explicitly turned on in org.sourceid.common.ExpressionManager.xml.  To correct this, set \"evaluateExpressions\" to \"true\" in pingfederate/server/default/data/config-store/org.sourceid.common.ExpressionManager.xml and reimport the connection.");
                }
            }
            if (existingConn != null) {
                if (!allowUpdate) {
                    problems.add("An " + roleType + " connection with entity id " + entityId + " already exists.  To update a connection, enable the 'Allow Update' setting.");
                }
                String systemId = existingConn.getId();
                connection.setId(systemId);
            } else if (!this.licenseManager.canAddConnection()) {
                problems.add("Your current license does not allow an additional connection. To upgrade your license, please contact Ping Identity Sales via e-mail sales@pingidentity.com or by telephone (+1 877.898.2905 or +1 303.468.2882)");
            } else if (connection.getLicenseConnectionGroupAssignment() != null && !connection.getLicenseConnectionGroupAssignment().isEmpty() && !this.licenseManager.canAddConnectionToGroup(connection, errorsFound = new ArrayList<String>())) {
                problems.addAll(errorsFound);
            }
            this.validate(connection, problems);
            this.checkThrow(problems);
            return connection;
        }
        catch (ConnectionMigrationException cme) {
            throw cme;
        }
        catch (Exception e) {
            String baseMsg = "Unexpected exception saving connection.";
            ConnectionMigrationException cme = new ConnectionMigrationException(baseMsg, Collections.singletonList(e.toString()));
            cme.initCause(e);
            throw cme;
        }
    }

    private void checkThrow(List<String> problems) throws ConnectionMigrationException {
        if (!problems.isEmpty()) {
            throw new ConnectionMigrationException("Unable to save connection.", problems);
        }
    }

    void validate(ConnectionBase conn, List<String> problems) {
        SoapAuthInfo soapAuthIn;
        Role roleType;
        String id;
        String name = conn.getName();
        if (this.connMgr.isNameInUse(name, id = conn.getId(), roleType = conn.getRoleType())) {
            problems.add("The connection name " + name + " is already in use for " + roleType + " connections.");
        }
        if ((soapAuthIn = conn.getSoapAuthIn()).isHasBasicEntry()) {
            String username = soapAuthIn.getBasicAuthInfo().getUsername();
            String usedBy = this.connMgr.basicAuthInUserNameUsedBy(username, id);
            this.usedByCheck(usedBy, "For inbound SOAP authentication the HTTP basic username " + username, problems);
        }
        if (soapAuthIn.isHasCertEntry()) {
            SoapAuthInfo.CertAuthInfo certAuthInfo = soapAuthIn.getCertAuthInfo();
            if (certAuthInfo.isAnchored()) {
                String subjectDN = certAuthInfo.getSubjectDN();
                String usedBy = this.connMgr.certAuthInSubjectDbUsedBy(subjectDN, id);
                this.usedByCheck(usedBy, "For inbound SOAP authentication using an anchored certificate the Subject DN " + subjectDN, problems);
            } else {
                X509Certificate x509 = certAuthInfo.getCert();
                Cert cert = new Cert(null, x509);
                String usedBy = this.connMgr.certAuthInCertUsedBy(cert, id);
                this.usedByCheck(usedBy, "For inbound SOAP authentication using an unanchored certificate the given cert", problems);
            }
        }
        this.validateConnectionModules(conn, problems);
        this.validateSpConnWSTrustSettings(conn, problems);
        this.validateLDAPBinaryAttribute(conn, problems);
    }

    private void validateLDAPBinaryAttribute(ConnectionBase conn, List<String> problems) {
        if (conn.getRoleType() != Role.SP) {
            return;
        }
        SpConnection connToValidate = (SpConnection)conn;
        HashMap<String, Set<String>> missingBinaryAttrFromDs = new HashMap<String, Set<String>>();
        for (AdapterToAssertionMapping adapterToAssertionMapping : connToValidate.getAdapterMappings()) {
            this.validateAttributeSource(missingBinaryAttrFromDs, adapterToAssertionMapping.getDefaultAttributeMapping());
            for (AttributeMapping attrMapping : adapterToAssertionMapping.getAttributeMappingList()) {
                this.validateAttributeSource(missingBinaryAttrFromDs, attrMapping);
            }
        }
        for (Map.Entry entry : missingBinaryAttrFromDs.entrySet()) {
            problems.add("Data Store ID: [" + (String)entry.getKey() + "] needs to define " + entry.getValue() + " as a Binary Attribute");
        }
    }

    protected void validateAttributeSource(Map<String, Set<String>> missingBinaryAttrFromDs, AttributeMapping mapping) {
        if (mapping == null) {
            return;
        }
        for (AttributeSource attrSource : mapping.getAttributeSources()) {
            for (String encodingType : attrSource.getAttributeEncodingTypeMap().keySet()) {
                String datasourceId = attrSource.getDataSourceId();
                List<String> binaryAttrList = MgmtFactory.getDataSourceManager().getLdapDataSource(datasourceId).getBinaryAttributes();
                if (binaryAttrList.contains(encodingType)) continue;
                if (missingBinaryAttrFromDs.get(datasourceId) == null) {
                    HashSet<String> missingAttrs = new HashSet<String>();
                    missingAttrs.add(encodingType);
                    missingBinaryAttrFromDs.put(datasourceId, missingAttrs);
                    continue;
                }
                missingBinaryAttrFromDs.get(datasourceId).add(encodingType);
            }
        }
    }

    private void validateSpConnWSTrustSettings(ConnectionBase conn, List<String> problems) {
        SpConnection connToValidate;
        WsTrustFederatedWscSettings connToValidateWsTrustSettings;
        if (conn.getRoleType() == Role.SP && (connToValidateWsTrustSettings = (connToValidate = (SpConnection)conn).getWsTrustSettings()) != null) {
            Set<AppliesTo> inUseAppliesTos = MetaDataFactory.getMetadataDirectory().getAppliesToInUseForSpConnections(connToValidateWsTrustSettings.getAppliesTo(), conn.getId());
            for (AppliesTo inUseAppliesTo : inUseAppliesTos) {
                problems.add("Partner Service Identifier '" + inUseAppliesTo.toString() + "' is already in use");
            }
        }
    }

    void usedByCheck(String usedBy, String ctx, List<String> problems) {
        if (usedBy != null) {
            problems.add(ctx + " is already in use by " + usedBy);
        }
    }

    public void deleteConnection(String entityId, Role role) {
        if (role == Role.IDP) {
            IdpConnection idpConnection = this.connMgr.getIdpConnection(entityId);
            this.connMgr.deleteIdpConnection(idpConnection);
        } else {
            SpConnection spConnection = this.connMgr.getSpConnection(entityId);
            this.connMgr.deleteSpConnection(spConnection);
        }
    }

    private void validateConnectionModules(ConnectionBase conn, List<String> problems) {
        List<ConnectionModuleConfiguration> connectionModuleConfigurations = conn.getConnectionModuleConfigurations();
        if (connectionModuleConfigurations != null) {
            ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
            for (ConnectionModuleConfiguration moduleConfiguration : connectionModuleConfigurations) {
                if (moduleConfiguration != null) {
                    moduleSupport.validateConfigurationForImport(moduleConfiguration, problems, conn.getRoleType());
                    continue;
                }
                this.log.warn((Object)"Unable to validate connection module for import.  Module is null.");
            }
        }
    }

    void setLicenseManager(LicenseManagerAdapter licenseManager) {
        this.licenseManager = licenseManager;
    }
}

