/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.api;

import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import java.security.cert.X509Certificate;
import org.sourceid.common.Util;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.impl.SoapAuthStoreImpl;
import org.sourceid.config.soapauth.xml.CertAuthType;
import org.sourceid.config.soapauth.xml.SoapAuth;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.InCertAuthInfo;

class SoapAuthSupport
extends SoapAuthStoreImpl {
    private Cert verificationCert;
    private PkCert authPkCert;

    public SoapAuthSupport(SoapAuth xml, Cert verificationCert, PkCert authPkCert) {
        this(xml);
        this.verificationCert = verificationCert;
        this.authPkCert = authPkCert;
        this.reparse();
    }

    public SoapAuthSupport(SoapAuth xml) {
        this.soapAuth = xml;
        this.fieldObfuscator = FieldObfuscator.PwdObfuscator;
    }

    @Override
    protected void setAlias(CertAuthType certAuthType, String alias) {
        certAuthType.setAlias("local reference");
    }

    @Override
    protected void loadCertInfo(String alias, SoapAuthInfo soapAuthInfo, boolean isOutgoing) {
        SoapAuthInfo.CertAuthInfo certAuthInfo = null;
        if (isOutgoing && this.authPkCert != null) {
            X509Certificate x509cert = this.authPkCert.getX509Certificate();
            String subjectDN = Util.canonicalizeX500DN(x509cert.getSubjectDN().getName());
            certAuthInfo = new SoapAuthInfo.CertAuthInfo(subjectDN, null, x509cert, this.authPkCert.getAlias());
        } else if (this.verificationCert != null) {
            ConnectionCerts connectionCerts = new ConnectionCerts();
            connectionCerts.setActiveVerificationCert(this.verificationCert);
            certAuthInfo = new InCertAuthInfo(connectionCerts);
        }
        soapAuthInfo.setCertAuthInfo(certAuthInfo);
    }

    @Override
    protected void save() {
    }
}

