/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.api.ws;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.util.api.ConnectionMigrationException;
import org.sourceid.saml20.domain.util.api.ConnectionMigrationMgr;
import org.sourceid.saml20.metadata.Role;

public class ConnectionMigrationWS {
    protected Log log = LogFactory.getLog(this.getClass());
    private ConnectionMigrationMgr connectionMigrationMgr = new ConnectionMigrationMgr();

    public void saveConnection(String xml, boolean allowUpdate) throws IOException {
        try {
            this.log.info((Object)("saveConnection called with allowUpdate: " + allowUpdate));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("saveConnection called with xml: " + xml));
            }
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            ConnectionBase conn = this.connectionMigrationMgr.saveConnection(is, allowUpdate);
            this.log.info((Object)(conn.getRoleType() + " connection with name " + conn.getName() + " and entity id " + conn.getEntityId() + " saved"));
        }
        catch (ConnectionMigrationException e) {
            this.log.error((Object)("Problem in saving connection from ConnectionMigrationWS: " + e.getMessage()), (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    public void deleteConnection(String entityId, String role) throws IOException {
        this.log.info((Object)("deleteConnection called with entityId=" + entityId + " role=" + role));
        Role roleObj = Role.valueOf(role.toUpperCase());
        this.connectionMigrationMgr.deleteConnection(entityId, roleObj);
    }

    public String getConnection(String entityId, String role) throws IOException {
        String xmlStr = "";
        this.log.info((Object)("getConnection called with entityId=" + entityId + " role=" + role));
        Role roleObj = Role.valueOf(role.toUpperCase());
        byte[] bytes = this.connectionMigrationMgr.getConnectionXmlBytes(entityId, roleObj);
        if (bytes != null) {
            xmlStr = new String(bytes, StandardCharsets.UTF_8);
        }
        return xmlStr;
    }
}

