/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.validation;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EntityIDType;

public class CommonValidator {
    public static final int MAX_LEN_GENERAL_ID = 33;
    public static final int MAX_LEN_ADAPTER_ID = 33;
    public static final int MAX_LEN_DATA_STORE_ID = 53;
    public static final int MAX_LEN_AD_DOMAIN_ID = 52;

    public static boolean isValidURI(String uriStr) {
        boolean isValid = false;
        try {
            URI.create(uriStr);
            isValid = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return isValid;
    }

    public static boolean isValidEntityId(String entityId) {
        boolean isValid = false;
        if (!StringUtils.isBlank((String)entityId)) {
            EntityDescriptorType entityDescriptorType = EntityDescriptorType.Factory.newInstance();
            entityDescriptorType.setEntityID(entityId);
            EntityIDType entityIDType = entityDescriptorType.xgetEntityID();
            isValid = entityIDType.validate();
        }
        return isValid;
    }

    public static boolean isValidAdapterInstanceId(String instanceId) {
        boolean isValid = ValidationUtil.isAlphaNumeric(instanceId);
        return isValid &= instanceId.length() < 33;
    }
}

