/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.dsig;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.pingcommons.util.NumberUtils;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.QueryStringSignatureUtil;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.config.ConfigurationException;
import org.sourceid.protocol.saml11.xml.AssertionDocument;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.w3c.dom.Element;
import sun.security.util.HostnameChecker;

public class SimpleSignatureEngine
implements SignatureEngine {
    protected boolean validateVerificationCerts = true;
    private Log log = LogFactory.getLog(this.getClass());
    private TrustedCAsManager trustedCAsManager;

    public void setTrustedCAsManager(TrustedCAsManager trustedCAsManager) {
        this.trustedCAsManager = trustedCAsManager;
    }

    @Override
    public void signXml(OutMessageContext outMsgCtx) throws BindingException {
        try {
            ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(outMsgCtx);
            this.signXml(connection, outMsgCtx.getXmlObject());
        }
        catch (SigningException e) {
            throw new BindingException("Unable to sign xml message.", e);
        }
    }

    @Override
    public void verifyXmlSignature(InMessageContext msgCtxIn, boolean bindingDictatesSigning) throws BindingException {
        String entityId = msgCtxIn.getEntityId();
        if (entityId != null) {
            XmlObject docXmlObj = msgCtxIn.getXmlObject();
            XmlObject typeXmlObj = XmlBeansUtil.unwrapDocumentToType(docXmlObj);
            boolean checkSig = true;
            if (msgCtxIn.isRequest() && typeXmlObj instanceof RequestAbstractType) {
                RequestAbstractType reqAbsType = (RequestAbstractType)typeXmlObj;
                checkSig = reqAbsType.isSetSignature();
            } else if (typeXmlObj instanceof StatusResponseType) {
                StatusResponseType statusRespType = (StatusResponseType)typeXmlObj;
                checkSig = statusRespType.isSetSignature();
            }
            if (checkSig) {
                ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(msgCtxIn);
                SignatureResult signatureResult = this.verifyXmlSignature(docXmlObj, connection);
                msgCtxIn.setSignatureResult(signatureResult);
            } else {
                msgCtxIn.setSignatureStatus(SignatureStatus.NOT_PRESENT);
            }
        }
        msgCtxIn.setSignatureRequired(bindingDictatesSigning);
    }

    @Override
    public QueryStringSignatureUtil.SignedQuery signQuery(OutMessageContext outMsgCtx, String query) throws BindingException {
        try {
            ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(outMsgCtx);
            PrivateKey signingKey = this.getSigningKey(connection);
            return QueryStringSignatureUtil.signQuery(query, signingKey, connection.getSigningAlgorithm());
        }
        catch (SigningException e) {
            throw new BindingException("Unable to sign query string.", e);
        }
    }

    @Override
    public void verifyQuerySignature(InMessageContext msgCtxIn, String queryStr) throws BindingException {
        String entityId = msgCtxIn.getEntityId();
        if (entityId != null) {
            QueryStringSignatureUtil.NormalizedQueryString normalizedQS = this.normalizeQueryStringForSaml2Sig(queryStr);
            if (normalizedQS.hasSignature()) {
                ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(msgCtxIn);
                List<X509Certificate> verificationKeys = this.getVerificationCerts(connection, msgCtxIn.getSignatureResult());
                EnumSet<SignatureStatus> stati = EnumSet.noneOf(SignatureStatus.class);
                for (X509Certificate cert : verificationKeys) {
                    PublicKey pubKey = cert != null ? cert.getPublicKey() : null;
                    String norm = normalizedQS.getQueryString();
                    SignatureStatus signatureStatus = QueryStringSignatureUtil.verifyQuerySignature(norm, pubKey);
                    stati.add(signatureStatus);
                }
                msgCtxIn.setSignatureStatus(this.reduce(stati));
            } else {
                msgCtxIn.setSignatureStatus(SignatureStatus.NOT_PRESENT);
            }
        }
        msgCtxIn.setSignatureRequired(true);
    }

    QueryStringSignatureUtil.NormalizedQueryString normalizeQueryStringForSaml2Sig(String qs) {
        Map<String, String> params = Util.parseQueryString(qs, false);
        if (params.containsKey("Signature") && params.containsKey("SigAlg")) {
            boolean isRequest = params.containsKey("SAMLRequest");
            String samlParamName = isRequest ? "SAMLRequest" : "SAMLResponse";
            StringBuilder sb = new StringBuilder();
            String msg = params.get(samlParamName);
            sb.append(samlParamName).append("=").append(msg);
            if (params.containsKey("RelayState")) {
                String relayState = params.get("RelayState");
                sb.append("&").append("RelayState").append("=").append(relayState);
            }
            String alg = params.get("SigAlg");
            sb.append("&SigAlg=").append(alg);
            String sig = params.get("Signature");
            sb.append("&Signature=").append(sig);
            return new QueryStringSignatureUtil.NormalizedQueryString(sb.toString(), true);
        }
        return new QueryStringSignatureUtil.NormalizedQueryString(qs, false);
    }

    @Override
    public org.sourceid.saml20.xmlbinding.assertion.AssertionType signAssertion(OutMessageContext outMsgCtx, org.sourceid.saml20.xmlbinding.assertion.AssertionType assertion) throws SigningException {
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(outMsgCtx);
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(assertion);
        if (outMsgCtx instanceof WsTrustOutMessageContext) {
            this.signXml(connection, (XmlObject)assertionDoc, true);
        } else {
            this.signXml(connection, (XmlObject)assertionDoc, false);
        }
        return assertionDoc.getAssertion();
    }

    @Override
    public org.sourceid.saml20.xmlbinding.assertion.AssertionType signAssertion(org.sourceid.saml20.xmlbinding.assertion.AssertionType assertion, ConnectionBase connection) throws SigningException {
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(assertion);
        this.signXml(connection, (XmlObject)assertionDoc);
        return assertionDoc.getAssertion();
    }

    @Override
    public AssertionType signAssertion(OutMessageContext outMsgCtx, AssertionType assertion) throws SigningException {
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(outMsgCtx);
        org.sourceid.protocol.saml11.xml.AssertionDocument doc = AssertionDocument.Factory.newInstance();
        doc.setAssertion(assertion);
        if (outMsgCtx instanceof WsTrustOutMessageContext) {
            this.signXml(connection, (XmlObject)doc, true);
        } else {
            this.signXml(connection, (XmlObject)doc, false);
        }
        return doc.getAssertion();
    }

    @Override
    public SignatureResult verifyAssertionSignature(org.sourceid.saml20.xmlbinding.assertion.AssertionType assertion) {
        if (assertion.isSetSignature()) {
            String issuerId = assertion.getIssuer().getStringValue();
            ConnectionBase conn = MetadataSupport.getBaseConnectionMetadata(issuerId, Role.IDP);
            AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
            assertionDoc.setAssertion(assertion);
            return this.verifyXmlSignature((XmlObject)assertionDoc, conn);
        }
        return new SignatureResult(SignatureStatus.NOT_PRESENT);
    }

    private List<X509Certificate> getVerificationCerts(ConnectionBase connection, SignatureResult signatureResult) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        ConnectionCerts dsigVerificationCerts = connection.getDsigVerificationCerts();
        if (dsigVerificationCerts != null) {
            for (Cert cert : dsigVerificationCerts.getActiveVerificationCerts()) {
                this.checkCertAddKey(cert, connection, certs, signatureResult);
            }
        } else {
            String message = "No dsig verification certificate configured for " + connection.getEncodedEntityId();
            signatureResult.addComment(message);
        }
        return certs;
    }

    private void checkCertAddKey(Cert cert, ConnectionBase connection, List<X509Certificate> certs, SignatureResult signatureResult) {
        if (cert != null) {
            X509Certificate verifyingCertificate = cert.getX509Certificate();
            try {
                if (this.validateVerificationCerts) {
                    verifyingCertificate.checkValidity();
                    CertificateHelper.checkRevocation(cert);
                }
                certs.add(verifyingCertificate);
            }
            catch (CertificateExpiredException ex) {
                signatureResult.addComment(connection.getEncodedEntityId() + " has expired digital signature verification certificate " + cert.getSerialNumberForDisplay() + ". " + ex.getMessage());
            }
            catch (CertificateNotYetValidException ex) {
                signatureResult.addComment(connection.getEncodedEntityId() + " has a digital signature verification certificate that is not yet valid  " + cert.getSerialNumberForDisplay() + ". " + ex.getMessage());
            }
            catch (RevokedCertException e) {
                signatureResult.addComment(connection.getEncodedEntityId() + " has a digital signature verification certificate that has been revoked  " + cert.getSerialNumberForDisplay() + ". " + e.getMessage());
            }
        }
    }

    @Override
    public void signXml(ConnectionBase connection, XmlObject doc) throws SigningException {
        this.signXml(connection, doc, false);
    }

    private void signXml(ConnectionBase connection, XmlObject doc, boolean includeRefInKeyInfo) throws SigningException {
        PrivateKey signingKey = this.getSigningKey(connection);
        String signatureAlgorithm = connection.getSigningAlgorithm();
        X509Certificate cert = connection.getSigningKeyCertificate().getX509Certificate();
        boolean includeCertInKeyInfo = connection.isIncludeCertInXmlSigs();
        boolean includeRawKeyInKeyValue = connection.isIncludeRawKeyInXmlSigs();
        XmlSignatureUtil.signXml(doc, signatureAlgorithm, signingKey, cert, includeCertInKeyInfo, includeRefInKeyInfo, includeRawKeyInKeyValue);
    }

    private PrivateKey getSigningKey(ConnectionBase connection) {
        PrivateKey signingKey = connection.getSigningKey();
        if (signingKey == null) {
            throw new ProcessRuntimeException("No signing key configured for " + connection.getEntityId());
        }
        return signingKey;
    }

    @Override
    public SignatureResult verifyAssertionSignature(AssertionType assertion, String idpId) {
        if (assertion.isSetSignature()) {
            ConnectionBase conn = MetadataSupport.getBaseConnectionMetadata(idpId, Role.IDP);
            org.sourceid.protocol.saml11.xml.AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
            assertionDoc.setAssertion(assertion);
            return this.verifyXmlSignature((XmlObject)assertionDoc, conn);
        }
        return new SignatureResult(SignatureStatus.NOT_PRESENT);
    }

    SignatureStatus reduce(Set<SignatureStatus> stati) {
        int size = stati.size();
        if (size == 0) {
            return SignatureStatus.UNVERIFIED;
        }
        if (size == 1) {
            return stati.iterator().next();
        }
        if (stati.contains((Object)SignatureStatus.NOT_PRESENT)) {
            if (stati.contains((Object)SignatureStatus.VALID) || stati.contains((Object)SignatureStatus.INVALID)) {
                String s = "Something very bad happened - how can a signature be not present and valid/invalid? " + stati;
                throw new IllegalStateException(s);
            }
            return SignatureStatus.NOT_PRESENT;
        }
        if (stati.contains((Object)SignatureStatus.VALID)) {
            return SignatureStatus.VALID;
        }
        if (stati.contains((Object)SignatureStatus.INVALID)) {
            return SignatureStatus.INVALID;
        }
        throw new IllegalStateException("Logic dictates that this will never happen - perhaps my logic is flawed? " + stati);
    }

    @Override
    public SignatureResult verifyXmlSignature(XmlObject xml, ConnectionBase conn) {
        SignatureResult sigResult = new SignatureResult();
        sigResult.setStatus(SignatureStatus.UNVERIFIED);
        if (conn.isUsingDynamicDsigTrust()) {
            sigResult = this.verifyXmlSigAgainstSubjectDN(xml, conn);
        } else {
            this.verifyXmlSigAgainstStaticCerts(xml, conn, sigResult);
        }
        return sigResult;
    }

    @Override
    public SignatureResult verifyXmlSignature(Element element, ConnectionBase conn) {
        SignatureResult sigResult = new SignatureResult();
        sigResult.setStatus(SignatureStatus.UNVERIFIED);
        if (conn.isUsingDynamicDsigTrust()) {
            sigResult = this.verifyXmlSigAgainstSubjectDN(element, conn);
        } else {
            sigResult.addComment("Verification against Static Certificate not supported in this scenario.");
            this.verifyXmlSigAgainstStaticCerts(element, conn, sigResult);
        }
        return sigResult;
    }

    private SignatureResult verifyXmlSigAgainstSubjectDN(Element element, ConnectionBase conn) {
        return this.verifyXmlSigAgainstSubjectDN(new XmlSignatureVerifier(element), conn);
    }

    private SignatureResult verifyXmlSigAgainstSubjectDN(XmlObject xml, ConnectionBase conn) {
        return this.verifyXmlSigAgainstSubjectDN(new XmlSignatureVerifier(xml), conn);
    }

    private SignatureResult verifyXmlSigAgainstSubjectDN(XmlSignatureVerifier verifier, ConnectionBase conn) {
        if (conn.getDsigVerificationExpectedIssuerDN() != null) {
            verifier.setTrustAnchors(this.trustedCAsManager.getTrustAnchorsByDN(conn.getDsigVerificationExpectedIssuerDN()));
        } else {
            verifier.setTrustAnchors(this.trustedCAsManager.getAllTrustAnchors());
        }
        verifier.setExpectedSubjectDN(conn.getDsigVerificationExpectedSubjectDN());
        return verifier.getSignatureResult();
    }

    private void verifyXmlSigAgainstStaticCerts(XmlObject xml, ConnectionBase conn, SignatureResult sigResult) {
        this.verifyXmlSigAgainstStaticCerts(new XmlSignatureVerifier(xml), conn, sigResult);
    }

    private void verifyXmlSigAgainstStaticCerts(Element element, ConnectionBase conn, SignatureResult sigResult) {
        this.verifyXmlSigAgainstStaticCerts(new XmlSignatureVerifier(element), conn, sigResult);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyXmlSigAgainstStaticCerts(XmlSignatureVerifier verifier, ConnectionBase conn, SignatureResult sigResult) {
        if (!verifier.hasSignature()) {
            sigResult.setStatus(SignatureStatus.NOT_PRESENT);
            return;
        }
        List<X509Certificate> verificationCerts = this.getVerificationCerts(conn, sigResult);
        if (verifier.isCertInKeyInfo()) {
            Iterator<X509Certificate> i = verificationCerts.iterator();
            while (i.hasNext()) {
                X509Certificate cert = i.next();
                if (verifier.getEmbeddedX509Cert().equals(cert)) continue;
                String serial = NumberUtils.createHexStringForDisplay((BigInteger)cert.getSerialNumber());
                sigResult.addComment("Not checking signature with configured verification cert " + serial + " because it does not match the embeded certificate in the signature.");
                i.remove();
            }
        }
        EnumSet<SignatureStatus> stati = EnumSet.noneOf(SignatureStatus.class);
        for (X509Certificate cert : verificationCerts) {
            block12: {
                try {
                    verifier.setProvidedX509Cert(cert);
                    SignatureResult resultForGivenCert = verifier.getSignatureResult();
                    for (String string : resultForGivenCert.getCommentary()) {
                        void var10_12;
                        if (verificationCerts.size() > 1) {
                            String serial = NumberUtils.createHexStringForDisplay((BigInteger)cert.getSerialNumber());
                            String string2 = string + " (using cert " + serial + ")";
                        }
                        sigResult.addComment((String)var10_12);
                    }
                    stati.add(resultForGivenCert.getStatus());
                    if (!stati.contains((Object)SignatureStatus.VALID)) break block12;
                    if (conn.getConnectiontype() != ConnectionBase.ConnectionType.DYNAMIC) break;
                    verifier.setTrustAnchors(this.trustedCAsManager.getAllTrustAnchors());
                    try {
                        cert.checkValidity();
                    }
                    catch (CertificateException e) {
                        throw new ConfigurationException(e);
                    }
                    if (!verifier.isCertChainValid()) {
                        throw new ConfigurationException("The cert chain is not trusted for a cert issued by " + cert.getIssuerDN().getName());
                    }
                    if (!this.verifyCertSubject(conn.getEntityId(), cert)) {
                        throw new ConfigurationException("The cert " + cert.getSubjectDN() + " does not match entityid " + conn.getEntityId());
                    }
                    if (!verifier.isCertKnownToBeRevoked()) break;
                    throw new ConfigurationException("Following cert has been revoked " + cert.getSubjectDN().getName() + " with serial number " + NumberUtils.createHexStringForDisplay((BigInteger)cert.getSerialNumber()) + " issued by " + cert.getIssuerDN().getName());
                }
                catch (Exception ex) {
                    sigResult.addComment(ex.getMessage());
                    stati.add(SignatureStatus.INVALID);
                }
            }
            verifier = new XmlSignatureVerifier(verifier.getXmlObject());
        }
        sigResult.setStatus(this.reduce(stati));
    }

    private boolean verifyCertSubject(String entityId, X509Certificate cert) {
        boolean verified;
        block7: {
            verified = true;
            if (entityId != null && cert != null) {
                try {
                    String host = entityId;
                    if (entityId.startsWith("http://") || entityId.startsWith("https://")) {
                        URL entityUrl = new URL(entityId);
                        host = entityUrl.getHost();
                        if (host != null && host.startsWith("[") && host.endsWith("]")) {
                            host = host.substring(1, host.length() - 1);
                        }
                        if (!this.validateHostname(host, cert)) {
                            verified = host.startsWith("saml.") || host.startsWith("SAML.") ? this.validateHostname(host.substring(5), cert) : false;
                        }
                        break block7;
                    }
                    verified = this.validateHostname(host, cert);
                }
                catch (MalformedURLException e) {
                    this.log.error((Object)("MalformedURLException: " + e.getMessage()));
                    verified = false;
                }
            } else {
                verified = false;
            }
        }
        return verified;
    }

    private boolean validateHostname(String hostname, X509Certificate cert) {
        boolean validated = true;
        try {
            HostnameChecker checker = HostnameChecker.getInstance((byte)1);
            checker.match(hostname, cert);
        }
        catch (CertificateException e) {
            this.log.error((Object)("The cert does not match the entity: " + e.getMessage() + " cert subjectDN: " + cert.getSubjectDN()));
            validated = false;
        }
        return validated;
    }

    @Override
    public SignatureStatus verifyXmlSignatureWithEmbeddedCert(XmlObject xml, String expectedCN) {
        SignatureStatus signatureStatus = SignatureStatus.UNVERIFIED;
        XmlSignatureVerifier verifier = new XmlSignatureVerifier(xml);
        verifier.setTrustAnchors(this.trustedCAsManager.getAllTrustAnchors());
        X509Certificate cert = verifier.getEmbeddedX509Cert();
        if (cert != null) {
            try {
                cert.checkValidity();
            }
            catch (CertificateException e) {
                throw new ConfigurationException(e);
            }
            if (!verifier.isCertChainValid()) {
                throw new ConfigurationException("The cert chain is not trusted for a cert issued by " + cert.getIssuerDN().getName());
            }
            if (verifier.isCertKnownToBeRevoked()) {
                throw new ConfigurationException("Following cert has been revoked " + cert.getSubjectDN().getName() + " with serial number " + NumberUtils.createHexStringForDisplay((BigInteger)cert.getSerialNumber()) + " issued by " + cert.getIssuerDN().getName());
            }
            signatureStatus = verifier.getSignatureStatus();
            if (signatureStatus == SignatureStatus.VALID && expectedCN != null && !this.verifyCertSubject(expectedCN, cert)) {
                signatureStatus = SignatureStatus.INVALID;
            }
        }
        return signatureStatus;
    }
}

