/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.encryption;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevocationCheckerNullImpl;
import com.pingidentity.crypto.RevokedCertException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.XmlEncryption;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.protocol.dsig10.xml.RetrievalMethodType;
import org.sourceid.protocol.xmlenc10.xml.EncryptedDataType;
import org.sourceid.protocol.xmlenc10.xml.EncryptedKeyDocument;
import org.sourceid.protocol.xmlenc10.xml.EncryptedKeyType;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeDocument;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDDocument;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.log.internal.Saml2Masker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionEngineImpl
implements EncryptionEngine {
    private static final Log log = LogFactory.getLog(EncryptionEngineImpl.class);
    private static final String MSG_ERROR_INVALID_NAMEID = "Invalid <NameID>.";
    private static final String MSG_ERROR_INVALID_ATTRIBUTE = "Invalid <Attribute>.";
    private static final String MSG_ERROR_UNABLE_TO_DECRYPT_USING_PRIMARY_DECRYPTION_KEY = "Unable to decrypt from Primary Decryption key. Attempting decryption using Secondary Decryption key.";
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final Saml2Masker masker = new Saml2Masker();
    private RevocationChecker revocationChecker = new RevocationCheckerNullImpl();

    public void setRevocationChecker(RevocationChecker revocationChecker) {
        this.revocationChecker = revocationChecker;
    }

    @Override
    public EncryptedElementType encryptAssertion(ConnectionBase connection, AssertionType assertionType, Set<String> maskedAttrs) throws XMLEncryptionException, NoSuchAlgorithmException, NoEncryptionKeyException {
        PublicKey pubKey = this.getEncryptionKey(connection);
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        String encryptionAlg = encryptionPolicy.getEncryptionAlgorithm();
        String keyTransportAlg = encryptionPolicy.getKeyTransportAlgorithm();
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(assertionType);
        if (assertionType.isSetSignature()) {
            try {
                assertionDoc = XmlBeansUtil.canonicalize(assertionDoc, AssertionDocument.class);
            }
            catch (Exception e) {
                throw new XMLEncryptionException("Problem c14ning assertion prior to encryption", e);
            }
        }
        if (log.isDebugEnabled()) {
            AssertionDocument maskedDoc = assertionDoc;
            if (maskedAttrs != null && !maskedAttrs.isEmpty()) {
                maskedDoc = this.masker.mask((XmlObject)assertionDoc, maskedAttrs);
            }
            log.debug((Object)("Assertion before encryption: " + (XmlObject)maskedDoc));
        }
        AssertionType assertion = assertionDoc.getAssertion();
        EncryptedElementType encryptedElement = XmlEncryption.encrypt((XmlObject)assertion, pubKey, encryptionAlg, keyTransportAlg);
        this.checkCreateSeparateEncryptedKeyBlock(connection.getEntityId(), encryptedElement);
        return encryptedElement;
    }

    @Override
    public AssertionType decryptAssertion(ConnectionBase connection, EncryptedElementType encryptedAssertion, String myRecip, Set<String> maskedAttrs) throws NoEncryptionKeyException, XMLEncryptionException {
        PkCert decryptionKey = null;
        AssertionType assertion = null;
        try {
            decryptionKey = this.getDecryptionKey(connection, "<EncryptedAssertion>");
            assertion = this.decryptAssertion(myRecip, encryptedAssertion, decryptionKey, maskedAttrs);
        }
        catch (XMLEncryptionException | NoEncryptionKeyException e) {
            log.debug((Object)MSG_ERROR_UNABLE_TO_DECRYPT_USING_PRIMARY_DECRYPTION_KEY, e);
            decryptionKey = this.getSecondaryDecryptionKey(connection, "<EncryptedAssertion>");
            assertion = this.decryptAssertion(myRecip, encryptedAssertion, decryptionKey, maskedAttrs);
        }
        return assertion;
    }

    AssertionType decryptAssertion(String myEntityId, EncryptedElementType encryptedAssertion, PkCert pkCert, Set<String> maskedAttrs) throws XMLEncryptionException {
        XmlObject decryptedObj = this.decrypt(myEntityId, encryptedAssertion, pkCert);
        AssertionDocument assertionDoc = (AssertionDocument)decryptedObj;
        AssertionType assertionType = assertionDoc.getAssertion();
        if (log.isDebugEnabled()) {
            AssertionDocument assertionDocument = AssertionDocument.Factory.newInstance();
            assertionDocument.setAssertion(assertionType);
            AssertionDocument maskedDoc = assertionDocument;
            if (maskedAttrs != null && !maskedAttrs.isEmpty()) {
                maskedDoc = this.masker.mask((XmlObject)assertionDocument, maskedAttrs);
            }
            log.debug((Object)("Assertion after decryption: " + (XmlObject)maskedDoc));
        }
        return assertionType;
    }

    @Override
    public EncryptedElementType encryptNameID(ConnectionBase connection, NameIDType nameIDType) throws XMLEncryptionException, NoSuchAlgorithmException, NoEncryptionKeyException {
        PublicKey publicKey = this.getEncryptionKey(connection);
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        String encryptionAlg = encryptionPolicy.getEncryptionAlgorithm();
        String keyTransportAlg = encryptionPolicy.getKeyTransportAlgorithm();
        NameIDDocument nameIdDoc = NameIDDocument.Factory.newInstance();
        nameIdDoc.setNameID(nameIDType);
        EncryptedElementType encryptedElement = XmlEncryption.encrypt((XmlObject)nameIdDoc.getNameID(), publicKey, encryptionAlg, keyTransportAlg);
        this.checkCreateSeparateEncryptedKeyBlock(connection.getEntityId(), encryptedElement);
        return encryptedElement;
    }

    @Override
    public NameIDType decryptNameID(ConnectionBase connection, EncryptedElementType encryptedNameID, String myRecip) throws NoEncryptionKeyException, XMLEncryptionException {
        String nameIdTag = "<EncryptedNameID>";
        PkCert decryptionKey = null;
        NameIDType nameID = null;
        try {
            decryptionKey = this.getDecryptionKey(connection, nameIdTag);
            nameID = this.decryptNameID(myRecip, encryptedNameID, decryptionKey);
        }
        catch (XMLEncryptionException | NoEncryptionKeyException e) {
            log.debug((Object)MSG_ERROR_UNABLE_TO_DECRYPT_USING_PRIMARY_DECRYPTION_KEY, e);
            decryptionKey = this.getSecondaryDecryptionKey(connection, nameIdTag);
            nameID = this.decryptNameID(myRecip, encryptedNameID, decryptionKey);
        }
        return nameID;
    }

    NameIDType decryptNameID(String myEntityId, EncryptedElementType encryptedNameID, PkCert pkCert) throws XMLEncryptionException {
        NameIDDocument nameIdDoc;
        XmlObject decrypted = this.decrypt(myEntityId, encryptedNameID, pkCert);
        try {
            nameIdDoc = NameIDDocument.Factory.parse((Node)XmlBeansUtil.newDomNode(decrypted));
        }
        catch (XmlException ex) {
            throw new XMLEncryptionException(MSG_ERROR_INVALID_NAMEID, (Exception)((Object)ex));
        }
        return nameIdDoc.getNameID();
    }

    @Override
    public EncryptedElementType encryptAttribute(ConnectionBase connection, AttributeType attributeType) throws XMLEncryptionException, NoSuchAlgorithmException, NoEncryptionKeyException {
        PublicKey publicKey = this.getEncryptionKey(connection);
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        String encryptionAlg = encryptionPolicy.getEncryptionAlgorithm();
        String keyTransportAlg = encryptionPolicy.getKeyTransportAlgorithm();
        AttributeDocument attribDoc = AttributeDocument.Factory.newInstance();
        attribDoc.setAttribute(attributeType);
        AttributeType attr = attribDoc.getAttribute();
        EncryptedElementType encryptedElement = XmlEncryption.encrypt((XmlObject)attr, publicKey, encryptionAlg, keyTransportAlg);
        this.checkCreateSeparateEncryptedKeyBlock(connection.getEntityId(), encryptedElement);
        return encryptedElement;
    }

    @Override
    public AttributeType decryptAttribute(ConnectionBase connection, EncryptedElementType encryptedAttr, String myEntityId) throws NoEncryptionKeyException, XMLEncryptionException {
        PkCert decryptionKey = null;
        AttributeType attribute = null;
        try {
            decryptionKey = this.getDecryptionKey(connection, "<EncryptedAttribute>");
            attribute = this.decryptAttribute(myEntityId, encryptedAttr, decryptionKey);
        }
        catch (XMLEncryptionException | NoEncryptionKeyException e) {
            log.debug((Object)MSG_ERROR_UNABLE_TO_DECRYPT_USING_PRIMARY_DECRYPTION_KEY, e);
            decryptionKey = this.getSecondaryDecryptionKey(connection, "<EncryptedAttribute>");
            attribute = this.decryptAttribute(myEntityId, encryptedAttr, decryptionKey);
        }
        return attribute;
    }

    AttributeType decryptAttribute(String myEntityId, EncryptedElementType encryptedAttribute, PkCert pkCert) throws XMLEncryptionException {
        XmlObject decrypted = this.decrypt(myEntityId, encryptedAttribute, pkCert);
        try {
            AttributeDocument attribDoc = AttributeDocument.Factory.parse((Node)XmlBeansUtil.newDomNode(decrypted));
            return attribDoc.getAttribute();
        }
        catch (XmlException ex) {
            throw new XMLEncryptionException(MSG_ERROR_INVALID_ATTRIBUTE, (Exception)((Object)ex));
        }
    }

    @Override
    public XmlObject decrypt(ConnectionBase connection, EncryptedElementType encryptedElement, String myRecip) throws NoEncryptionKeyException, XMLEncryptionException {
        XmlObject decrypted;
        String nameIdTag = "<EncryptedData>";
        try {
            PkCert decryptionKey = this.getDecryptionKey(connection, nameIdTag);
            decrypted = this.decrypt(myRecip, encryptedElement, decryptionKey);
        }
        catch (XMLEncryptionException | NoEncryptionKeyException e) {
            log.debug((Object)MSG_ERROR_UNABLE_TO_DECRYPT_USING_PRIMARY_DECRYPTION_KEY, e);
            PkCert decryptionKey = this.getSecondaryDecryptionKey(connection, nameIdTag);
            decrypted = this.decrypt(myRecip, encryptedElement, decryptionKey);
        }
        return decrypted;
    }

    private XmlObject decrypt(String myEntityId, EncryptedElementType encryptedElement, PkCert pkCert) throws XMLEncryptionException {
        EncryptedKeyType[] encryptedKeyArray = encryptedElement.getEncryptedKeyArray();
        EncryptedKeyType encryptedKey = null;
        if (encryptedKeyArray.length > 0) {
            encryptedKey = this.deferenceEncryptedKeyBlock(encryptedElement);
        }
        if (encryptedKey == null) {
            encryptedKey = this.getEncryptedKey(myEntityId, encryptedKeyArray);
        }
        if (encryptedKey == null) {
            return XmlEncryption.decrypt((XmlObject)encryptedElement.getEncryptedData(), pkCert);
        }
        return XmlEncryption.decrypt((XmlObject)encryptedElement.getEncryptedData(), (XmlObject)encryptedKey, pkCert);
    }

    private PublicKey getEncryptionKey(ConnectionBase connection) throws NoEncryptionKeyException {
        Cert cert = connection.getEncryptionSettings().getEncryptionCert();
        if (cert != null) {
            X509Certificate x509Certificate = cert.getX509Certificate();
            try {
                this.revocationChecker.check(cert.getChain());
            }
            catch (RevokedCertException e) {
                String id = connection.getEncodedEntityId();
                String msg = "The certificate configured for encryption " + id + "  has been revoked";
                throw new NoEncryptionKeyException(msg, e);
            }
            return x509Certificate.getPublicKey();
        }
        throw new NoEncryptionKeyException("No encryption key is configured for " + connection.getEntityId());
    }

    private PkCert getDecryptionKey(ConnectionBase connection, String xmlElement) throws NoEncryptionKeyException {
        PrivateKey decryptionKey = connection.getEncryptionSettings().getDecryptionKey();
        if (decryptionKey == null) {
            String errorMessage = this.getNoEncryptionKeyMessage(connection.getEntityId(), xmlElement);
            throw new NoEncryptionKeyException(errorMessage);
        }
        return connection.getEncryptionSettings().getDecryptionPkCert();
    }

    private PkCert getSecondaryDecryptionKey(ConnectionBase connection, String xmlElement) throws NoEncryptionKeyException {
        PrivateKey decryptionKey = connection.getEncryptionSettings().getSecondaryDecryptionKey();
        if (decryptionKey == null) {
            String errorMessage = this.getNoEncryptionKeyMessage(connection.getEntityId(), xmlElement);
            throw new NoEncryptionKeyException(errorMessage);
        }
        return connection.getEncryptionSettings().getSecondaryDecryptionPkCert();
    }

    private String getNoEncryptionKeyMessage(String entityId, String xmlElement) {
        return "No decryption key is configured for " + entityId + ". We are unable to decrypt " + xmlElement;
    }

    private EncryptedKeyType getEncryptedKey(String localEntityId, EncryptedKeyType[] encryptedKeyArray) {
        EncryptedKeyType encryptedKey = null;
        if (encryptedKeyArray.length > 0) {
            EncryptedKeyType encryptedKeyWithoutRecipient = null;
            for (EncryptedKeyType encKey : encryptedKeyArray) {
                if (!encKey.isSetRecipient()) {
                    encryptedKeyWithoutRecipient = encKey;
                    continue;
                }
                if (!localEntityId.equals(encKey.getRecipient())) continue;
                encryptedKey = encKey;
                break;
            }
            if (encryptedKey == null) {
                encryptedKey = encryptedKeyWithoutRecipient;
            }
        }
        return encryptedKey;
    }

    private void checkCreateSeparateEncryptedKeyBlock(String entityId, EncryptedElementType encryptedElement) throws XMLEncryptionException {
        if (this.config.getBooleanValue("CreateSeparateEncryptedKeyBlock", false)) {
            try {
                EncryptedDataType encryptedData = encryptedElement.getEncryptedData();
                KeyInfoType keyInfo = encryptedData.getKeyInfo();
                EncryptedKeyType encryptedKey = this.getEncryptedKey(keyInfo);
                encryptedData.unsetKeyInfo();
                encryptedKey.setRecipient(entityId);
                encryptedElement.addNewEncryptedKey().set((XmlObject)encryptedKey);
            }
            catch (XmlException ex) {
                throw new XMLEncryptionException("Internal error", (Exception)((Object)ex));
            }
        }
    }

    private EncryptedKeyType getEncryptedKey(KeyInfoType keyInfo) throws XmlException {
        Document w3node = XmlBeansUtil.newDomNode((XmlObject)keyInfo);
        Element elem = (Element)w3node.getFirstChild();
        Element encryptedKey = (Element)elem.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
        return EncryptedKeyDocument.Factory.parse((Node)encryptedKey).getEncryptedKey();
    }

    private EncryptedKeyType deferenceEncryptedKeyBlock(EncryptedElementType encryptedElement) {
        RetrievalMethodType[] retrievalMethods;
        EncryptedKeyType encKey = null;
        EncryptedDataType encryptedData = encryptedElement.getEncryptedData();
        KeyInfoType keyInfo = encryptedData.getKeyInfo();
        if (keyInfo != null && (retrievalMethods = keyInfo.getRetrievalMethodArray()) != null && retrievalMethods.length > 0) {
            RetrievalMethodType retrievalMethod = retrievalMethods[0];
            String methodType = retrievalMethod.getType();
            String uri = retrievalMethod.getURI();
            if ("http://www.w3.org/2001/04/xmlenc#EncryptedKey".equals(methodType) && uri != null) {
                encKey = this.locateEncryptedKey(uri, encryptedElement.getEncryptedKeyArray());
                encryptedData.unsetKeyInfo();
            }
        }
        return encKey;
    }

    private EncryptedKeyType locateEncryptedKey(String uri, EncryptedKeyType[] encryptedKeyArray) {
        EncryptedKeyType encryptedKey = null;
        if (uri != null && uri.length() > 0 && uri.charAt(0) == '#') {
            String id = uri.substring(1);
            if (encryptedKeyArray.length > 0) {
                for (EncryptedKeyType encKey : encryptedKeyArray) {
                    String encKeyId = encKey.getId();
                    if (encKeyId == null || !encKeyId.equals(id)) continue;
                    encryptedKey = encKey;
                    break;
                }
            }
        }
        return encryptedKey;
    }
}

