/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.encryption;

import java.util.Set;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class EncryptionSupport {
    private static final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);

    public static AssertionType decryptAssertion(ConnectionBase conn, EncryptedElementType encryptedAssertion, String myRecip, Set<String> maskedAttrs) {
        try {
            return encryptionEngine.decryptAssertion(conn, encryptedAssertion, myRecip, maskedAttrs);
        }
        catch (XMLEncryptionException ex) {
            throw new ProcessRuntimeException("Unable to decrypt the assertion.", ex);
        }
        catch (NoEncryptionKeyException ex) {
            throw new ProcessRuntimeException("No decryption key to decrypt the assertion.", ex);
        }
    }
}

