/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata;

import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.xmlbinding.metadata.EndpointType;
import org.sourceid.saml20.xmlbinding.metadata.IndexedEndpointType;

public class EndpointUtil {
    public static Endpoint toEndpoint(EndpointType ept, URL baseUrl) {
        String responseLocation = ept.isSetResponseLocation() ? ept.getResponseLocation() : null;
        return new Endpoint(ept.getBinding(), ept.getLocation(), responseLocation, baseUrl);
    }

    public static EndpointType toEndpointType(Endpoint endpoint) {
        EndpointType endpointType = EndpointType.Factory.newInstance();
        endpointType.setBinding(endpoint.getBinding());
        endpointType.setLocation(endpoint.getLocation());
        if (endpoint.hasResponseLocation()) {
            endpointType.setResponseLocation(endpoint.getResponseLocation());
        }
        return endpointType;
    }

    public static IndexedEndpoints toIndexedEndpoints(IndexedEndpointType[] indexedEndpointTypes, URL baseUrl) {
        IndexedEndpoints indexedEndpoints = new IndexedEndpoints();
        boolean hasTrueDefault = false;
        for (int i = indexedEndpointTypes.length - 1; i >= 0; --i) {
            boolean trueDefault;
            IndexedEndpointType indexedEndpointType = indexedEndpointTypes[i];
            int index = indexedEndpointType.getIndex();
            indexedEndpoints.setEndpoint(index, EndpointUtil.toEndpoint((EndpointType)indexedEndpointType, baseUrl));
            boolean bl = trueDefault = indexedEndpointType.isSetIsDefault() && indexedEndpointType.getIsDefault();
            if (trueDefault) {
                hasTrueDefault = true;
            }
            boolean isDefault = !indexedEndpoints.hasDefault() && i == 0;
            isDefault |= trueDefault;
            if (!(isDefault |= !indexedEndpointType.isSetIsDefault() && !hasTrueDefault)) continue;
            indexedEndpoints.setDefault(index);
        }
        return indexedEndpoints;
    }

    public static IndexedEndpointType[] toIndexedEndpointTypes(IndexedEndpoints indexedEndpoints) {
        LinkedList<IndexedEndpointType> indexedEndpointTypes = new LinkedList<IndexedEndpointType>();
        if (indexedEndpoints != null) {
            for (Map.Entry<Integer, Endpoint> entry : indexedEndpoints.getEndpointsMap().entrySet()) {
                IndexedEndpointType indexedEndpointType = IndexedEndpointType.Factory.newInstance();
                indexedEndpointType.setIndex(entry.getKey().intValue());
                Endpoint endpoint = entry.getValue();
                indexedEndpointType.setLocation(endpoint.getLocation());
                indexedEndpointType.setBinding(endpoint.getBinding());
                if (endpoint.hasResponseLocation()) {
                    indexedEndpointType.setResponseLocation(endpoint.getResponseLocation());
                }
                indexedEndpointTypes.add(indexedEndpointType);
                if (!indexedEndpoints.isDefault(indexedEndpointType.getIndex())) continue;
                indexedEndpointType.setIsDefault(true);
            }
        }
        return indexedEndpointTypes.toArray(new IndexedEndpointType[indexedEndpointTypes.size()]);
    }

    public static EndpointGroup toEndpointGroup(EndpointType[] endpointTypes, URL baseUrl) {
        EndpointGroup endpointGroup = new EndpointGroup();
        LinkedList<Endpoint> endpoints = new LinkedList<Endpoint>();
        for (EndpointType endPointType : endpointTypes) {
            Endpoint endpoint = EndpointUtil.toEndpoint(endPointType, baseUrl);
            endpoints.add(endpoint);
        }
        endpointGroup.setEndpoints(endpoints);
        return endpointGroup;
    }

    public static EndpointType[] toEndpointTypes(EndpointGroup endpointGroup) {
        LinkedList<EndpointType> endpointTypes = new LinkedList<EndpointType>();
        if (endpointGroup != null) {
            for (Endpoint endpoint : endpointGroup.getEndpoints()) {
                EndpointType endpointType = EndpointUtil.toEndpointType(endpoint);
                endpointTypes.add(endpointType);
            }
        }
        return endpointTypes.toArray(new EndpointType[endpointTypes.size()]);
    }
}

