/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.local;

import com.pingidentity.common.util.Base64URL;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.sourceid.common.IDGenerator;

public class PathUtil {
    private static final String SLASH = "/";
    private static final int NONCE_LENGTH = 5;
    private static final String NONCE_SEPARATOR = "_";
    private final String resumePathPrefix;
    private final String localPathSuffix;

    public PathUtil(String resumePathPrefix, String localPathSuffix) {
        this.resumePathPrefix = resumePathPrefix;
        this.localPathSuffix = localPathSuffix;
    }

    public String convertToResumePath(String path, String qualifier, String contextId) {
        if (this.isResumePath(path)) {
            return path;
        }
        String firstPathElement = this.getFirstPathElement(path);
        int idx = path.lastIndexOf(".");
        path = idx > -1 ? path.substring(0, idx) : path;
        StringBuilder sb = new StringBuilder();
        sb.append(firstPathElement);
        if (contextId != null) {
            sb.append(SLASH).append(contextId);
        }
        sb.append(this.resumePathPrefix);
        if (qualifier != null) {
            sb.append(qualifier);
        }
        sb.append(path);
        sb.append(this.localPathSuffix);
        return sb.toString();
    }

    public String replaceContextId(String resumePath, String contextId) {
        if (!this.isResumePath(resumePath)) {
            throw new IllegalArgumentException("Path " + resumePath + " is not a resume path");
        }
        String[] parts = this.getParts(resumePath);
        StringBuilder result = new StringBuilder();
        result.append(parts[0]);
        if (contextId != null) {
            result.append(SLASH).append(contextId);
        }
        result.append(parts[2]);
        return result.toString();
    }

    public boolean isResumePath(String path) {
        return path.contains(this.resumePathPrefix) && path.endsWith(this.localPathSuffix);
    }

    public Map<String, Object> getDecodedParamMap(String path) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isResumePath(path) && this.getParts(path)[1] != null) {
            map.putAll(this.decodeParams(this.getParts(path)[1]));
        }
        return map;
    }

    public String encodeParamMap(String path, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        String[] parts = this.getParts(path);
        sb.append(parts[0]);
        String encodedParams = this.encodeParams(params);
        if (StringUtils.isNotEmpty((String)encodedParams)) {
            sb.append(SLASH);
            sb.append(encodedParams);
        }
        sb.append(parts[2]);
        return sb.toString();
    }

    public String getContextId(String pathWithoutContextRoot) {
        return this.isResumePath(pathWithoutContextRoot) ? this.removeNonce(this.getParts(pathWithoutContextRoot)[1]) : null;
    }

    public String insertNonce(String resumePath) {
        if (resumePath == null) {
            return null;
        }
        if (!this.isResumePath(resumePath)) {
            return resumePath;
        }
        String[] parts = this.getParts(resumePath);
        String contextId = parts[1];
        if (contextId == null) {
            return resumePath;
        }
        contextId = this.removeNonce(contextId);
        String nonce = IDGenerator.rndAlphaNumeric(5);
        return parts[0] + SLASH + nonce + NONCE_SEPARATOR + contextId + parts[2];
    }

    public String stripPathParams(String path) {
        Object strippedPath = "";
        if (StringUtils.isNotEmpty((String)path)) {
            String[] parts = this.getParts(path);
            strippedPath = parts[0] + parts[2];
        }
        return strippedPath;
    }

    String getFirstPathElement(String path) {
        int pathParamStart = path.indexOf(SLASH, 1);
        pathParamStart = pathParamStart >= 0 ? pathParamStart : 0;
        return path.substring(0, pathParamStart);
    }

    String[] getParts(String path) {
        String pathParam = null;
        int pathParamStart = path.indexOf(SLASH, 1);
        pathParamStart = pathParamStart >= 0 ? pathParamStart : 0;
        int pathParamEnd = 0;
        if (this.isResumePath(path)) {
            pathParamEnd = path.indexOf(this.resumePathPrefix, pathParamStart);
            pathParamEnd = pathParamEnd >= 0 ? pathParamEnd : pathParamStart;
            pathParam = pathParamStart == pathParamEnd ? null : path.substring(pathParamStart + 1, pathParamEnd);
        } else {
            pathParamEnd = path.indexOf(SLASH, pathParamStart + 1);
            pathParamEnd = pathParamEnd >= 0 ? pathParamEnd : pathParamStart;
            pathParam = pathParamStart == pathParamEnd ? null : path.substring(pathParamStart + 1, pathParamEnd);
        }
        String beginning = path.substring(0, pathParamStart);
        String end = path.substring(pathParamEnd);
        return new String[]{beginning, pathParam, end};
    }

    public String encodeParams(Map<String, Object> params) {
        String encodedPathSegment = "";
        if (params != null && !params.isEmpty()) {
            try {
                String jsonText = JSONValue.toJSONString(params);
                encodedPathSegment = Base64URL.encodeToString((byte[])jsonText.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return encodedPathSegment;
    }

    public Map<String, Object> decodeParams(String encodedParams) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String json = Base64URL.decodeToString((String)encodedParams, (String)"UTF-8");
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(json);
            if (!(obj instanceof JSONObject)) {
                throw new IllegalArgumentException("Invalid JSON object");
            }
            JSONObject jsonObject = (JSONObject)obj;
            map.putAll((Map<String, Object>)jsonObject);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return map;
    }

    private String removeNonce(String contextId) {
        if (contextId == null) {
            return null;
        }
        int separatorIndex = contextId.indexOf(NONCE_SEPARATOR);
        if (separatorIndex == -1) {
            return contextId;
        }
        return contextId.substring(separatorIndex + 1);
    }

    public String getRemainingPathFromResumePath(String path) {
        if (this.isResumePath(path) && this.getParts(path)[2] != null) {
            int st = path.indexOf(this.resumePathPrefix) + this.resumePathPrefix.length();
            int end = path.indexOf(this.localPathSuffix);
            return path.substring(st, end);
        }
        return path;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String endpoint = "";
        if (StringUtils.isEmpty((String)request.getContextPath())) {
            endpoint = request.getRequestURI();
        } else if (!StringUtils.isEmpty((String)request.getRequestURI())) {
            endpoint = request.getRequestURI().substring(request.getContextPath().length());
        }
        return endpoint;
    }
}

