/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.local.impl;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.metadata.local.IDPLocalPathMappings;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.metadata.local.SPLocalPathMappings;
import org.sourceid.saml20.metadata.local.impl.MetadataLocalUtil;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.profiles.ProfileProcessFactory;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ExtensionsType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.ExtensionRootType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.IDPLocalPathsType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.LocalPathsDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.SPLocalPathsType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.URLGroup;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.UrlToAdapterMapType;
import org.sourceid.websso.Protocol;
import org.w3c.dom.Node;

public class MetadataLocalXmlLoaderImpl
implements MetadataLocal,
AutoReloadable {
    private static final String FILE_NAME = "sourceid-saml2-local-metadata.xml";
    private static final String LEGACY_ERROR_MESSAGE = "Please contact your system administrator for assistance regarding this error.";
    private static final String ERROR_MESSAGE = "errorDetail.idpSsoFailure";
    private volatile EntityDescriptorDocument entityDescDoc;
    private volatile EntityDescriptorType entityDescType;
    private volatile ExtensionRootType extensionRootType;
    private volatile XmlLoader xmlLoader;
    private volatile SysDirInfo sysDirInfo;
    private volatile URL baseUrl;
    private volatile PathUtil pathUtil;
    private ProfileProcessFactory profileProcessFactory;
    private boolean processFactoryStale = false;

    public void setExtensionRootType(ExtensionRootType extensionRootType) {
        this.extensionRootType = extensionRootType;
    }

    public void setEntityDescType(EntityDescriptorType entityDescType) {
        this.entityDescType = entityDescType;
    }

    public MetadataLocalXmlLoaderImpl() {
        this.reload();
    }

    @Override
    public synchronized void save() {
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), FILE_NAME, (XmlObject)this.entityDescDoc);
        this.reload();
    }

    @Override
    public synchronized void reload() {
        this.profileProcessFactory = null;
        this.xmlLoader = GlobalRegistry.getService(XmlLoader.class);
        this.sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        this.entityDescDoc = (EntityDescriptorDocument)this.xmlLoader.load(this.sysDirInfo.getDataDirectory(), FILE_NAME);
        this.processDoc(this.entityDescDoc);
        this.pathUtil = new PathUtil(this.getLocalResumePathPrefix(), this.getLocalPathSuffix());
        this.processFactoryStale = true;
    }

    private void processDoc(EntityDescriptorDocument entityDescDoc) {
        this.entityDescType = entityDescDoc.getEntityDescriptor();
        if (!this.entityDescType.isSetExtensions()) {
            throw new ConfigurationException("sourceid-saml2-local-metadata.xml does not contain extensions.");
        }
        ExtensionsType extensionsType = this.entityDescType.getExtensions();
        try {
            XmlObject xml = XmlBeansUtil.getFirstChild((XmlObject)extensionsType);
            XmlBeansUtil.validate(xml);
            this.extensionRootType = (ExtensionRootType)xml;
        }
        catch (InvalidXmlException e) {
            throw new ConfigurationException(e);
        }
        if (this.extensionRootType.isSetBaseURL()) {
            try {
                this.baseUrl = new URL(this.extensionRootType.getBaseURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getWsFedID() {
        return this.extensionRootType.getWsFedID();
    }

    @Override
    public void setWsFedID(String wsFedId) {
        this.extensionRootType.setWsFedID(wsFedId);
    }

    @Override
    public String getDynaFedID() {
        return this.extensionRootType.getDynaFedID();
    }

    @Override
    public void setDynaFedID(String id) {
        this.extensionRootType.setDynaFedID(id);
    }

    @Override
    public String getSaml1xId() {
        return this.extensionRootType.getSaml1XId();
    }

    @Override
    public void setSaml1xId(String saml1xId) {
        this.extensionRootType.setSaml1XId(saml1xId);
    }

    @Override
    public String getEntityId() {
        return this.entityDescType.getEntityID();
    }

    @Override
    public void setEntityId(String entityId) {
        this.entityDescType.setEntityID(entityId);
    }

    @Override
    public byte[] getSourceId() {
        return HashUtil.hashToBytes((String)this.getEntityId(), (HashAlgorithm)HashAlgorithm.SHA1);
    }

    @Override
    public byte[] getSaml1xSourceId() {
        if (StringUtils.isBlank((String)this.getSaml1xSrcId())) {
            return HashUtil.hashToBytes((String)this.getSaml1xId(), (HashAlgorithm)HashAlgorithm.SHA1);
        }
        return HexBin.stringToBytes((String)this.getSaml1xSrcId());
    }

    @Override
    public void setSaml1xSrcId(String saml1xSrcId) {
        this.extensionRootType.setSaml1XSrcId(saml1xSrcId);
    }

    @Override
    public String getSaml1xSrcId() {
        return this.extensionRootType.getSaml1XSrcId();
    }

    @Override
    public synchronized String getApplicationURL(String name) {
        URLGroup[] urlGroups;
        for (URLGroup urlGroup : urlGroups = this.extensionRootType.getApplicationURLs().getURLGroupArray()) {
            if (!urlGroup.getName().equals(name)) continue;
            return urlGroup.getSuccessURL();
        }
        return null;
    }

    @Override
    public synchronized void setApplicationURL(String name, String url, boolean success) {
        String previousSuccessURL = null;
        String previousFailureURL = null;
        URLGroup[] urlGroups = this.extensionRootType.getApplicationURLs().getURLGroupArray();
        for (int i = 0; i < urlGroups.length; ++i) {
            URLGroup tmpUrlGroup = urlGroups[i];
            if (!tmpUrlGroup.getName().equals(name)) continue;
            previousSuccessURL = tmpUrlGroup.getSuccessURL();
            previousFailureURL = tmpUrlGroup.getFailureURL();
            this.extensionRootType.getApplicationURLs().removeURLGroup(i);
            break;
        }
        URLGroup urlGroup = this.extensionRootType.getApplicationURLs().addNewURLGroup();
        urlGroup.setName(name);
        if (previousSuccessURL != null) {
            urlGroup.setSuccessURL(previousSuccessURL);
        }
        if (previousFailureURL != null) {
            urlGroup.setFailureURL(previousFailureURL);
        }
        if (success) {
            urlGroup.setSuccessURL(url);
        } else {
            urlGroup.setFailureURL(url);
        }
    }

    @Override
    public synchronized void removeApplicationURL(String name) {
        URLGroup[] urlGroups = this.extensionRootType.getApplicationURLs().getURLGroupArray();
        for (int i = 0; i < urlGroups.length; ++i) {
            URLGroup tmpUrlGroup = urlGroups[i];
            if (!tmpUrlGroup.getName().equals(name)) continue;
            this.extensionRootType.getApplicationURLs().removeURLGroup(i);
            break;
        }
    }

    @Override
    public synchronized IDPLocalPathMappings getIdpLocalPathMappings() {
        IDPLocalPathMappings pathMappings = new IDPLocalPathMappings();
        LocalPathsDescriptorType localPathsDescriptor = this.extensionRootType.getLocalPathsDescriptor();
        String suffix = localPathsDescriptor.getSuffix();
        IDPLocalPathsType idpLocalPaths = localPathsDescriptor.getIDPLocalPaths();
        pathMappings.setInitiateSSOPath(idpLocalPaths.getInitiateSingleSignOn() + suffix);
        pathMappings.setInitiateSLOPath(idpLocalPaths.getInitiateSingleLogOut() + suffix);
        pathMappings.setInitiateCDC("/idp/writecdc" + suffix);
        return pathMappings;
    }

    public synchronized String getLocalPathSuffix() {
        LocalPathsDescriptorType localPathsDescriptor = this.extensionRootType.getLocalPathsDescriptor();
        return localPathsDescriptor.getSuffix();
    }

    public synchronized String getLocalResumePathPrefix() {
        LocalPathsDescriptorType localPathsDescriptor = this.extensionRootType.getLocalPathsDescriptor();
        return localPathsDescriptor.getResumePathPrefix();
    }

    @Override
    public PathUtil getPathUtil() {
        return this.pathUtil;
    }

    @Override
    public synchronized SPLocalPathMappings getSpLocalPathMappings() {
        SPLocalPathMappings pathMappings = new SPLocalPathMappings();
        LocalPathsDescriptorType localPathsDescriptor = this.extensionRootType.getLocalPathsDescriptor();
        SPLocalPathsType spLocalPathsType = localPathsDescriptor.getSPLocalPaths();
        String suffix = localPathsDescriptor.getSuffix();
        pathMappings.setInitiateSSOPath(spLocalPathsType.getInitiateSingleSignOn() + suffix);
        pathMappings.setInitiateCdcSSOPath(spLocalPathsType.getInitiateCDCSingleSignOn() + suffix);
        pathMappings.setInitiateSLOPath(spLocalPathsType.getInitiateSingleLogOut() + suffix);
        pathMappings.setTerminateLocalLinksPath(spLocalPathsType.getTerminateAccountLinks() + suffix);
        String initAttrQueryPath = spLocalPathsType.getInitiateAttributeQuery();
        initAttrQueryPath = initAttrQueryPath == null ? "/sp/startAttributeQuery" : initAttrQueryPath;
        pathMappings.setInitiateAttributeQueryPath(initAttrQueryPath + suffix);
        return pathMappings;
    }

    @Override
    public IndexedEndpoints getIdpArtifactResolutionServices() {
        IndexedEndpoints arss = new IndexedEndpoints();
        arss.setEndpoint(0, new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", "/idp/ARS.ssaml2"));
        arss.setDefault(0);
        return arss;
    }

    @Override
    public IndexedEndpoints getSpArtifactResolutionServices() {
        IndexedEndpoints arss = new IndexedEndpoints();
        arss.setEndpoint(0, new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", "/sp/ARS.ssaml2"));
        arss.setDefault(0);
        return arss;
    }

    @Override
    public EndpointGroup getSingleSignOnServices() {
        EndpointGroup ssos = new EndpointGroup();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(4);
        String idpSsoLocation = "/idp/SSO.saml2";
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", idpSsoLocation));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", idpSsoLocation));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", idpSsoLocation));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", idpSsoLocation));
        ssos.setEndpoints(endpoints);
        return ssos;
    }

    @Override
    public EndpointGroup getIdpSingleLogoutServices() {
        String idpSloLocation = "/idp/SLO.saml2";
        EndpointGroup slos = new EndpointGroup();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(4);
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", idpSloLocation));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", idpSloLocation));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", idpSloLocation));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", "/idp/SLO.ssaml2"));
        slos.setEndpoints(endpoints);
        return slos;
    }

    @Override
    public IndexedEndpoints getAssertionConsumerServices() {
        IndexedEndpoints acss = new IndexedEndpoints();
        String acs = "/sp/ACS.saml2";
        acss.setEndpoint(0, new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", acs));
        acss.setEndpoint(1, new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", acs));
        acss.setEndpoint(2, new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:PAOS", acs));
        acss.setDefault(0);
        return acss;
    }

    @Override
    public EndpointGroup getSpSingleLogoutServices() {
        String slo = "/sp/SLO.saml2";
        EndpointGroup slos = new EndpointGroup();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(4);
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", slo));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", slo));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", slo));
        endpoints.add(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", "/sp/SLO.ssaml2"));
        slos.setEndpoints(endpoints);
        return slos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileProcessFactory getProfileProcessFactory() {
        MetadataLocalXmlLoaderImpl metadataLocalXmlLoaderImpl = this;
        synchronized (metadataLocalXmlLoaderImpl) {
            if (this.profileProcessFactory != null) {
                return this.profileProcessFactory;
            }
        }
        ProfileProcessFactory result = null;
        while (result == null) {
            MetadataLocalXmlLoaderImpl metadataLocalXmlLoaderImpl2 = this;
            synchronized (metadataLocalXmlLoaderImpl2) {
                this.processFactoryStale = false;
            }
            result = new ProfileProcessFactory(this);
            metadataLocalXmlLoaderImpl2 = this;
            synchronized (metadataLocalXmlLoaderImpl2) {
                if (this.processFactoryStale) {
                    result = null;
                } else {
                    this.profileProcessFactory = result;
                }
            }
        }
        return result;
    }

    @Override
    public URL getBaseURL() {
        return this.baseUrl;
    }

    @Override
    public String getBaseUrl() {
        return this.extensionRootType.getBaseURL();
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.extensionRootType.setBaseURL(baseUrl);
    }

    @Override
    public boolean getEnableWsFedIdP() {
        return true;
    }

    @Override
    public boolean getEnableSaml20IdP() {
        return true;
    }

    @Override
    public boolean getEnableWsFedSp() {
        return true;
    }

    @Override
    public boolean getEnableSaml20Sp() {
        return true;
    }

    @Override
    public boolean getEnableSaml11Ap() {
        return true;
    }

    @Override
    public boolean getEnableSaml11Rp() {
        return true;
    }

    @Override
    public boolean getEnableSaml10Ap() {
        return true;
    }

    @Override
    public boolean getEnableSaml10Rp() {
        return true;
    }

    @Override
    public boolean getEnableX509Discovery() {
        return true;
    }

    @Override
    public boolean getEnableIdpDiscovery() {
        return true;
    }

    @Override
    public boolean getDisableAutomaticConnectionValidation() {
        return this.extensionRootType.getDisableAutomaticConnectionValidation();
    }

    @Override
    public void setDisableAutomaticConnectionValidation(boolean disableAutomaticConnectionValidation) {
        this.extensionRootType.setDisableAutomaticConnectionValidation(disableAutomaticConnectionValidation);
    }

    @Override
    public void setDataStoreValidationInterval(int interval) {
        this.extensionRootType.setDataStoreValidationInterval(interval);
    }

    @Override
    public int getDataStoreValidationInterval() {
        return this.extensionRootType.getDataStoreValidationInterval();
    }

    @Override
    public void setRequestHeaderNameForCorrelationId(String headerName) {
        this.extensionRootType.setRequestHeaderNameForCorrelationId(headerName);
    }

    @Override
    public String getRequestHeaderNameForCorrelationId() {
        return this.extensionRootType.getRequestHeaderNameForCorrelationId();
    }

    @Override
    public void setCustomGlobalHttpHeaderName(String customGlobalHttpHeaderName) {
        this.extensionRootType.setCustomGlobalHttpHeaderName(customGlobalHttpHeaderName);
    }

    @Override
    public String getCustomGlobalHttpHeaderName() {
        return this.extensionRootType.getCustomGlobalHttpHeaderName();
    }

    @Override
    public void setClientIpHeaderIndex(LocalSettings.ForwardedHeaderIndex clientIpHeaderIndex) {
        this.extensionRootType.setClientIpHeaderIndex(clientIpHeaderIndex.toString());
    }

    @Override
    public LocalSettings.ForwardedHeaderIndex getClientIpHeaderIndex() {
        return LocalSettings.ForwardedHeaderIndex.valueOf(this.extensionRootType.getClientIpHeaderIndex().toUpperCase());
    }

    @Override
    public void setForwardedHostHeaderName(String forwardedHostHeaderName) {
        this.extensionRootType.setForwardedHostHeaderName(forwardedHostHeaderName);
    }

    @Override
    public String getForwardedHostHeaderName() {
        return this.extensionRootType.getForwardedHostHeaderName();
    }

    @Override
    public void setForwardedHostHeaderIndex(LocalSettings.ForwardedHeaderIndex forwardedHostHeaderIndex) {
        this.extensionRootType.setForwardedHostHeaderIndex(forwardedHostHeaderIndex.toString());
    }

    @Override
    public LocalSettings.ForwardedHeaderIndex getForwardedHostHeaderIndex() {
        return LocalSettings.ForwardedHeaderIndex.valueOf(this.extensionRootType.getForwardedHostHeaderIndex().toUpperCase());
    }

    @Override
    public boolean isProxyTerminatesHttpsConns() {
        return this.extensionRootType.getProxyTerminatesHttpsConns();
    }

    @Override
    public void setProxyTerminatesHttpsConns(boolean proxyTerminates) {
        this.extensionRootType.setProxyTerminatesHttpsConns(proxyTerminates);
    }

    @Override
    public String getMetadataSigningKeyAlias() {
        return this.extensionRootType.getMetadataSigningKeyAlias();
    }

    @Override
    public void setMetadataSigningKeyAlias(String alias) {
        this.extensionRootType.setMetadataSigningKeyAlias(alias);
    }

    @Override
    public String getMetadataSigningAlgorithm() {
        return this.extensionRootType.getMetadataSigningAlgorithm();
    }

    @Override
    public void setMetadataSigningAlgorithm(String metadataSigningAlgorithm) {
        this.extensionRootType.setMetadataSigningAlgorithm(metadataSigningAlgorithm);
    }

    @Override
    public String getMetadataSigningKeyMD5Fingerprint() {
        return this.extensionRootType.getMetadataSigningKeyMD5Fingerprint();
    }

    @Override
    public void setMetadataSigningKeyMD5Fingerprint(String md5FingerPrint) {
        this.extensionRootType.setMetadataSigningKeyMD5Fingerprint(md5FingerPrint);
    }

    @Override
    public GDuration getCacheDuration() {
        return this.entityDescType.getCacheDuration();
    }

    @Override
    public void setCacheDuration(GDuration duration) {
        this.entityDescType.setCacheDuration(duration);
    }

    @Override
    public boolean getEnableSpWsTrustSts() {
        return true;
    }

    @Override
    public boolean getEnableInboundProvisioning() {
        return true;
    }

    @Override
    public boolean getEnableIdpWsTrustSts() {
        return true;
    }

    @Override
    public boolean isConfirmSlo() {
        return this.extensionRootType.getConfirmIdpSlo();
    }

    @Override
    public void setConfirmSlo(boolean confirm) {
        this.extensionRootType.setConfirmIdpSlo(confirm);
    }

    @Override
    public String getErrorPageMsg() {
        String errPageMsg = this.extensionRootType.getErrPageMsg();
        if (errPageMsg == null || errPageMsg.trim().equals(LEGACY_ERROR_MESSAGE)) {
            errPageMsg = ERROR_MESSAGE;
        }
        return errPageMsg;
    }

    @Override
    public void setErrorPageMsg(String errorPageMsg) {
        this.extensionRootType.setErrPageMsg(errorPageMsg);
    }

    @Override
    public synchronized List<UrlToTargetMapping> getUrlToTargetMappings() {
        UrlToAdapterMapType[] maps;
        ArrayList<UrlToTargetMapping> list = new ArrayList<UrlToTargetMapping>();
        for (UrlToAdapterMapType urlMap : maps = this.extensionRootType.getUrlToAdapterMapArray()) {
            TargetSessionId.TargetSessionType type = TargetSessionId.TargetSessionType.valueOf(urlMap.getTargetType());
            list.add(new UrlToTargetMapping(urlMap.getUrl(), type, urlMap.getAdapterInstance()));
        }
        return list;
    }

    @Override
    public synchronized void setUrlToTargetMappings(List<UrlToTargetMapping> list) {
        UrlToAdapterMapType[] urlToAdapterMapTypeArray = new UrlToAdapterMapType[list.size()];
        int i = 0;
        for (UrlToTargetMapping oneMap : list) {
            urlToAdapterMapTypeArray[i] = UrlToAdapterMapType.Factory.newInstance();
            urlToAdapterMapTypeArray[i].setUrl(oneMap.getUrl());
            urlToAdapterMapTypeArray[i].setTargetType(oneMap.getTargetType().name());
            urlToAdapterMapTypeArray[i].setAdapterInstance(oneMap.getTargetId());
            ++i;
        }
        this.extensionRootType.setUrlToAdapterMapArray(urlToAdapterMapTypeArray);
    }

    @Override
    public synchronized ContactInfo getContactInfo() {
        ContactInfo result = new ConnectionUtil().getContactInfo(this.entityDescType);
        if (result != null) {
            return result;
        }
        return new ContactInfo();
    }

    @Override
    public synchronized void setContactInfo(ContactInfo contactInfo) {
        new ConnectionUtil().fillInContactInfo(this.entityDescType, contactInfo);
    }

    @Override
    public String getSpWsFedEndpoint() {
        return "/sp/prp.wsf";
    }

    @Override
    public String getIdpWsFedEndpoint() {
        return "/idp/prp.wsf";
    }

    @Override
    public String getSaml1xSoapEndpoint() {
        return "/idp/soap.ssaml1";
    }

    @Override
    public String getSaml1xIsxEndpoint() {
        return "/idp/isx.saml1";
    }

    @Override
    public String getSaml1xAcsEndpoint() {
        return "/sp/acs.saml1";
    }

    @Override
    public String getAttributeService() {
        return "/idp/attrsvc.ssaml2";
    }

    @Override
    public synchronized IdpDiscovery getIdpDiscovery() {
        return MetadataLocalUtil.getIdpDiscovery(this.extensionRootType.getIdpDiscovery());
    }

    @Override
    public synchronized void setIdpDiscovery(IdpDiscovery idpDiscovery) {
        MetadataLocalUtil.setIdpDiscovery(this.extensionRootType, idpDiscovery);
    }

    @Override
    public String getSpWsTrustStsEndpoint() {
        return "/sp/sts.wst";
    }

    @Override
    public String getIdpWsTrustStsEndpoint() {
        return "/idp/sts.wst";
    }

    @Override
    public Set<Protocol> getEnabledIdpProtocols() {
        EnumSet<Protocol> protocols = EnumSet.noneOf(Protocol.class);
        if (this.getEnableSaml10Ap()) {
            protocols.add(Protocol.SAML10);
        }
        if (this.getEnableSaml11Ap()) {
            protocols.add(Protocol.SAML11);
        }
        if (this.getEnableSaml20IdP()) {
            protocols.add(Protocol.SAML20);
        }
        if (this.getEnableWsFedIdP()) {
            protocols.add(Protocol.WSFED);
        }
        return protocols;
    }

    @Override
    public Set<Protocol> getEnabledSpProtocols() {
        EnumSet<Protocol> protocols = EnumSet.noneOf(Protocol.class);
        if (this.getEnableSaml10Rp()) {
            protocols.add(Protocol.SAML10);
        }
        if (this.getEnableSaml11Rp()) {
            protocols.add(Protocol.SAML11);
        }
        if (this.getEnableSaml20Sp()) {
            protocols.add(Protocol.SAML20);
        }
        if (this.getEnableWsFedSp()) {
            protocols.add(Protocol.WSFED);
        }
        if (this.getEnableOIDCSp()) {
            protocols.add(Protocol.OIDC);
        }
        return protocols;
    }

    @Override
    public synchronized String toXml() {
        String xml = null;
        if (this.entityDescDoc != null) {
            String alias = this.getMetadataSigningKeyAlias();
            String fingerprint = this.getMetadataSigningKeyMD5Fingerprint();
            if (StringUtils.isNotEmpty((String)alias) && StringUtils.isEmpty((String)fingerprint)) {
                PkCertManager certMgr = MgmtFactory.getDsigPkCertManager();
                PkCert pkCert = certMgr.getPkCert(alias);
                fingerprint = pkCert.getFingerPrint(HashAlgorithm.MD5);
                this.setMetadataSigningKeyMD5Fingerprint(fingerprint);
            }
            xml = XmlBeansUtil.xmlText((XmlObject)this.entityDescDoc);
        }
        return xml;
    }

    @Override
    public synchronized void importLocalSettings(String xml) throws XmlException {
        Node node = XmlBeansUtil.parseToNode(xml);
        EntityDescriptorDocument entityDescDoc = EntityDescriptorDocument.Factory.parse((Node)node);
        EntityDescriptorType entityDescType = entityDescDoc.getEntityDescriptor();
        if (!entityDescType.isSetExtensions()) {
            throw new ConfigurationException("The server settings does not contain extensions.");
        }
        ExtensionsType extensionsType = entityDescType.getExtensions();
        try {
            XmlObject obj = XmlBeansUtil.getFirstChild((XmlObject)extensionsType);
            XmlBeansUtil.validate(obj);
            ExtensionRootType extensionRootType = (ExtensionRootType)obj;
            String MD5Fingerprint = extensionRootType.getMetadataSigningKeyMD5Fingerprint();
            if (StringUtils.isNotEmpty((String)MD5Fingerprint)) {
                Cert metaSigningPkCert = null;
                PkCertManager certMgr = MgmtFactory.getDsigPkCertManager();
                Set<PkCert> pkCerts = certMgr.getPkCerts();
                for (PkCert pkCert : pkCerts) {
                    if (!pkCert.getFingerPrint(HashAlgorithm.MD5).equalsIgnoreCase(MD5Fingerprint)) continue;
                    metaSigningPkCert = pkCert;
                    break;
                }
                if (metaSigningPkCert == null) {
                    throw new ConfigurationException("Unable to find the key with MD5Fingerprint " + MD5Fingerprint);
                }
                String metadataSigningKeyAlias = metaSigningPkCert.getAlias();
                extensionRootType.setMetadataSigningKeyAlias(metadataSigningKeyAlias);
            }
        }
        catch (InvalidXmlException e) {
            throw new ConfigurationException(e);
        }
        this.entityDescDoc = entityDescDoc;
        this.save();
    }

    @Override
    public Optional<Boolean> getEnableClientCertAuth() {
        if (this.extensionRootType.isSetEnableClientCertHeaderAuth()) {
            return Optional.of(this.extensionRootType.getEnableClientCertHeaderAuth());
        }
        return Optional.empty();
    }

    @Override
    public void setEnableClientCertAuth(Boolean enableClientCertAuth) {
        if (enableClientCertAuth == null) {
            this.extensionRootType.unsetEnableClientCertHeaderAuth();
        } else {
            this.extensionRootType.setEnableClientCertHeaderAuth(enableClientCertAuth.booleanValue());
        }
    }

    @Override
    public String getClientCertEncodingFormat() {
        return this.extensionRootType.getClientCertEncodingFormat();
    }

    @Override
    public void setClientCertEncodingFormat(String clientCertEncodingFormat) {
        this.extensionRootType.setClientCertEncodingFormat(clientCertEncodingFormat);
    }

    @Override
    public void setClientCertSSLHeaderName(String clientCertSSLHeaderName) {
        this.extensionRootType.setClientCertSSLHeaderName(clientCertSSLHeaderName);
    }

    @Override
    public String getClientCertSSLHeaderName() {
        return this.extensionRootType.getClientCertSSLHeaderName();
    }

    @Override
    public void setClientCertChainSSLHeaderName(String clientCertChainSSLHeaderName) {
        this.extensionRootType.setClientCertChainSSLHeaderName(clientCertChainSSLHeaderName);
    }

    @Override
    public String getClientCertChainSSLHeaderName() {
        return this.extensionRootType.getClientCertChainSSLHeaderName();
    }

    @Override
    public boolean getEnableOIDCSp() {
        return true;
    }
}

