/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner;

import java.util.Arrays;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class ConnectionDbEntry {
    private String id;
    private String entityId;
    private String name;
    private Role role = Role.IDP;
    private boolean active;
    private boolean wsTrustEnabled;
    private boolean idpInitiatedSSOEnabled;
    private boolean spInitiatedSSOEnabled;
    private boolean dynamic;
    private long lastModifiedMillis;
    private String fileSystemPath;
    private final String targetUrl;
    private final byte[] sourceId;
    private final Protocol protocol;
    private boolean hasSSOToOAuthAttrMapping;
    private final String oAuthApcId;
    private boolean hasConnBasedPluginOverrides;

    public ConnectionDbEntry(String id, String entityId, Role role, boolean active, boolean dynamic, boolean wsTrustEnabled, boolean idpInitiatedSSOEnabled, boolean spInitiatedSSOEnabled, long lastModifiedMillis, String fileSystemPath, String targetUrl, byte[] sourceId, Protocol protocol, boolean hasSSOToOAuthAttrMapping, String oAuthApcId, String name, boolean hasConnBasedPluginOverrides) {
        this.id = id;
        this.entityId = entityId;
        this.role = role;
        this.active = active;
        this.wsTrustEnabled = wsTrustEnabled;
        this.idpInitiatedSSOEnabled = idpInitiatedSSOEnabled;
        this.spInitiatedSSOEnabled = spInitiatedSSOEnabled;
        this.dynamic = dynamic;
        this.lastModifiedMillis = lastModifiedMillis;
        this.fileSystemPath = fileSystemPath;
        this.targetUrl = targetUrl;
        this.sourceId = Arrays.copyOf(sourceId, sourceId.length);
        this.protocol = protocol;
        this.hasSSOToOAuthAttrMapping = hasSSOToOAuthAttrMapping;
        this.oAuthApcId = oAuthApcId;
        this.name = name;
        this.hasConnBasedPluginOverrides = hasConnBasedPluginOverrides;
    }

    public String getId() {
        return this.id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getName() {
        return this.name;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isWsTrustEnabled() {
        return this.wsTrustEnabled;
    }

    public boolean isIdpInitiatedSSOEnabled() {
        return this.idpInitiatedSSOEnabled;
    }

    public boolean isSpInitiatedSSOEnabled() {
        return this.spInitiatedSSOEnabled;
    }

    public boolean getDynamic() {
        return this.dynamic;
    }

    public String getFileSystemPath() {
        return this.fileSystemPath;
    }

    public long getLastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public byte[] getSourceId() {
        return Arrays.copyOf(this.sourceId, this.sourceId.length);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean hasSSOToOAuthAttrMapping() {
        return this.hasSSOToOAuthAttrMapping;
    }

    public String getOAuthApcId() {
        return this.oAuthApcId;
    }

    public boolean hasConnBasedPluginOverrides() {
        return this.hasConnBasedPluginOverrides;
    }
}

