/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.xml.XPathUtil;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.scim11.schema.Schema;
import com.pingidentity.scim11.schema.SchemaAttribute;
import com.pingidentity.scim11.schema.SchemaSubAttribute;
import com.pingidentity.sdk.oauth20.Scope;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.protocol.dsig10.xml.X509DataType;
import org.sourceid.protocol.xmlenc10.xml.EncryptionMethodType;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.saml1x.xmlbinding.metadata.SourceIDDocument;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeNameMapping;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthnContextMapping;
import org.sourceid.saml20.domain.ConditionType;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.DecryptionPolicy;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.Entity;
import org.sourceid.saml20.domain.GroupConstants;
import org.sourceid.saml20.domain.IdentityStoreProvisionerInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.IncomingBindings;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.KeyRotationSettings;
import org.sourceid.saml20.domain.LoggingMode;
import org.sourceid.saml20.domain.MaskedAttributeContract;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.OAuthAssertionGrantAttributeContract;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.OAuthSettings;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.Organization;
import org.sourceid.saml20.domain.ScimUserConstants;
import org.sourceid.saml20.domain.ScimUserConstantsFactory;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.WsFedSpSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.impl.AdapterMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.CertNotFoundException;
import org.sourceid.saml20.domain.mgmt.impl.IdpAdapterMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.mgmt.impl.TokenGeneratorMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.TokenProcessorMgmtConfigSupport;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.domain.scim.ScimVersion;
import org.sourceid.saml20.domain.scim.model.Schema;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;
import org.sourceid.saml20.domain.scim.model.Scim2Schema;
import org.sourceid.saml20.domain.scim.model.Scim2SchemaAttribute;
import org.sourceid.saml20.domain.scim.model.Scim2SubAttribute;
import org.sourceid.saml20.metadata.EndpointUtil;
import org.sourceid.saml20.metadata.partner.AttributeSourceConfigHelper;
import org.sourceid.saml20.metadata.partner.ProtocolUtil;
import org.sourceid.saml20.profiles.idp.HandleAuthnRequest;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterConfigurationType;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;
import org.sourceid.saml20.xmlbinding.adapterconf.TokenProcessorConfigurationType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.metadata.AffiliationDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.AttributeAuthorityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.AttributeConsumingServiceType;
import org.sourceid.saml20.xmlbinding.metadata.AttributeQueryDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ContactType;
import org.sourceid.saml20.xmlbinding.metadata.ContactTypeType;
import org.sourceid.saml20.xmlbinding.metadata.EndpointType;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ExtensionsType;
import org.sourceid.saml20.xmlbinding.metadata.IDPSSODescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.IndexedEndpointType;
import org.sourceid.saml20.xmlbinding.metadata.KeyDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.KeyTypes;
import org.sourceid.saml20.xmlbinding.metadata.LocalizedNameType;
import org.sourceid.saml20.xmlbinding.metadata.LocalizedURIType;
import org.sourceid.saml20.xmlbinding.metadata.OrganizationType;
import org.sourceid.saml20.xmlbinding.metadata.RequestedAttributeType;
import org.sourceid.saml20.xmlbinding.metadata.RoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.SPSSODescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.SSODescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AccountLinkingAndMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AdapterToAssertionMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AdditionalAllowedEntities;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AdditionalAllowedEntitiesConfiguration;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AdditionalEntity;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMapType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeQueryPolicyType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeServicePolicyType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeSourceType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AuthnContextMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AvailableCertType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.C2CContractMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.C2CContractToAssertionMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ConnectionOverrideAdapterConfigurationType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ConnectionOverrideConfigType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ConnectionOverrideTokenProcessorConfigurationType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ConnectionTemplatePropertiesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ConnectionTemplatePropertyType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DecryptionPolicyType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DsigAliasesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EnabledProfilesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EncryptAttributeType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EncryptionPolicyType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EncryptionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EntityExtensionDocument;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EntityExtensionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtendedAttributeContractType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtendedAttributeType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtendedPropertyType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.IdentityStoreProvisionerType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.IdpExtensionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.InboundProvisioningReadGroupsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.InboundProvisioningReadUsersType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.InboundProvisioningType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.InboundProvisioningWriteGroupsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.InboundProvisioningWriteUsersType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.IncomingBindingsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.KeyRotationSettingsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.LinkingMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.MessageCustomizationHook;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.MetadataSynchronizationSettingsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.NameIdentifierMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.OAuthSAMLBearerMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.OAuthSettingsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.OIDCRequestParamType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.OIDCSettingsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFAvailableCertsRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFIdpWsTrustRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFInboundProvisioningRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFNoopRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFOAuthRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFOIDCRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFSpWsTrustRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.RoleExtensionDocument;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.RoleExtensionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.Scim2CustomAttributeType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.Scim2SchemaType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.Scim2SubAttributeType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.SpExtensionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.TargetAttributeMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.TokenAuthorizationIssuanceCriteriaType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.TokenAuthorizationIssuanceCriterionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.TokenPluginMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.UrlWhitelistEntryType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.UrlWhitelistType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.UserProvisioningType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.VirtualIdentityType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.WsFedSettingsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.WsTrustSettingsType;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class ConnectionUtil {
    private static final Log log = LogFactory.getLog(ConnectionUtil.class);
    private static final EndpointGroup OUT_SSO_NONE = new EndpointGroup(new Endpoint("NONE-SCHEMA-WORKAROUND", "NONE"));
    private static final int DEFAULT_ATTRIBUTE_CONSUMING_SERVICE_IDX = 0;
    private static final String DEFAULT_ATTRIBUTE_CONSUMING_SERVICE_NAME = "AttributeContract";
    private static final String LANGUAGE_EN = "en";
    private static final String LOCAL_LANGUAGE = "en";
    private static final String METADATA_EXT_NS = "urn:sourceid.org:saml2:metadata-extension:v2";
    private static final String IS_ACTIVE = "isActive";
    private static final String ATTR_NAME_BASE_URL = "baseUrl";
    private static final String ATTR_NAME_LOG_LEVEL = "LogLevel";
    private static final String ATTR_NAME_NAME = "name";
    private static final String ATTR_NAME_APPLICATION_NAME = "applicationName";
    private static final String ATTR_NAME_APPLICATION_ICON = "applicationIcon";
    public static final String DECL_MDX = "declare namespace mdx='urn:sourceid.org:saml2:metadata-extension:v2";
    public static final String XPATH_ROLE_EXT = "declare namespace mdx='urn:sourceid.org:saml2:metadata-extension:v2' .//mdx:RoleExtension";
    private static final String XPATH_ENTITY_EXT = "declare namespace mdx='urn:sourceid.org:saml2:metadata-extension:v2' .//mdx:EntityExtension";
    private static final String XPATH_DSIG = "declare namespace mdx='urn:sourceid.org:saml2:metadata-extension:v2' .//mdx:DigitialSignatureAliases";
    private static final String XPATH_ENC = "declare namespace mdx='urn:sourceid.org:saml2:metadata-extension:v2' .//mdx:Encryption";
    private static final String XPATH_SOURCEID = "declare namespace saml1md='urn:oasis:names:tc:SAML:profiles:v1metadata' .//saml1md:SourceID";
    public static final String LEGACY_ERR_PG_MSG = "Please contact your system administrator for assistance regarding this error.";
    public static final String ERR_PG_MSG = "errorDetail.spSsoFailure";
    private final transient PluginManagementSupport idpAdapterMgmtSupport;
    private final transient PluginManagementSupport spAdapterMgmtSupport;
    private final transient PluginManagementSupport tokenProcessorMgmtSupport;
    private final transient PluginManagementSupport tokenGeneratorMgmtSupport;
    private final transient IdpAdapterMgmtConfigSupport idpAdapterConfigSupport = new IdpAdapterMgmtConfigSupport();
    private final transient AdapterMgmtConfigSupport spAdapterConfigSupport = new AdapterMgmtConfigSupport();
    private final transient TokenProcessorMgmtConfigSupport tokenProcessorConfigSupport = new TokenProcessorMgmtConfigSupport();
    private final transient TokenGeneratorMgmtConfigSupport tokenGeneratorConfigSupport = new TokenGeneratorMgmtConfigSupport();
    private final transient AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private final transient C2cContractManager c2cContractManager = MgmtFactory.getC2cContractManager();
    private final transient ConfigStore config = ConfigStoreFarm.getConfig(HandleAuthnRequest.class);

    public ConnectionUtil() {
        PluginManagementFactory pluginManagementFactory = new PluginManagementFactory();
        this.idpAdapterMgmtSupport = pluginManagementFactory.makeIdpAdapterMgmtSupport();
        this.spAdapterMgmtSupport = pluginManagementFactory.makeSpAdapterMgmtSupport();
        this.tokenProcessorMgmtSupport = pluginManagementFactory.makeTokenProcessorMgmtSupport();
        this.tokenGeneratorMgmtSupport = pluginManagementFactory.makeTokenGeneratorMgmtSupport();
    }

    public ConnectionBase toConn(EntityDescriptorType entityDescriptorType) {
        RoleDescriptorType[] roleDescArray = entityDescriptorType.getRoleDescriptorArray();
        boolean attributeQueryDescriptorDefined = false;
        boolean idpWsTrustRoleDescriptorDefined = false;
        boolean spWsTrustRoleDescriptorDefined = false;
        boolean oAuthRoleDescriptorDefined = false;
        boolean inboundProvRoleDescriptorDefined = false;
        boolean noopRoleDescriptorDefined = false;
        if (roleDescArray.length > 0) {
            for (RoleDescriptorType roleDescType : roleDescArray) {
                if (roleDescType instanceof AttributeQueryDescriptorType) {
                    attributeQueryDescriptorDefined = true;
                    continue;
                }
                if (roleDescType instanceof PFIdpWsTrustRoleDescriptorType) {
                    idpWsTrustRoleDescriptorDefined = true;
                    continue;
                }
                if (roleDescType instanceof PFSpWsTrustRoleDescriptorType) {
                    spWsTrustRoleDescriptorDefined = true;
                    continue;
                }
                if (roleDescType instanceof PFOAuthRoleDescriptorType) {
                    oAuthRoleDescriptorDefined = true;
                    continue;
                }
                if (roleDescType instanceof PFInboundProvisioningRoleDescriptorType) {
                    inboundProvRoleDescriptorDefined = true;
                    continue;
                }
                if (!(roleDescType instanceof PFNoopRoleDescriptorType)) continue;
                noopRoleDescriptorDefined = true;
            }
        }
        IDPSSODescriptorType[] idpSsoArray = entityDescriptorType.getIDPSSODescriptorArray();
        SPSSODescriptorType[] spSsoArray = entityDescriptorType.getSPSSODescriptorArray();
        AttributeAuthorityDescriptorType[] attributeAuthorityArray = entityDescriptorType.getAttributeAuthorityDescriptorArray();
        if (idpSsoArray.length > 0 || spSsoArray.length == 0 && attributeAuthorityArray.length > 0 || idpWsTrustRoleDescriptorDefined || oAuthRoleDescriptorDefined || inboundProvRoleDescriptorDefined) {
            return this.toIdpConn(entityDescriptorType);
        }
        if (spSsoArray.length > 0 || attributeQueryDescriptorDefined || spWsTrustRoleDescriptorDefined || noopRoleDescriptorDefined) {
            return this.toSpConn(entityDescriptorType);
        }
        return null;
    }

    public IdpConnection toIdpConn(EntityDescriptorType entityDescType) {
        RoleDescriptorType[] roleDescArray;
        String entityId = entityDescType.getEntityID();
        IdpConnection idpConnection = new IdpConnection(entityId);
        idpConnection.setEntityIdOnDisk(entityId);
        this.fillBaseConn(idpConnection, entityDescType);
        IDPSSODescriptorType[] idpSsoArray = entityDescType.getIDPSSODescriptorArray();
        if (idpSsoArray.length > 0) {
            this.getIdpSsoConnInfoFromXmlBean(entityDescType, idpConnection);
        } else {
            this.resetEnabledProfiles(idpConnection.getEnabledProfiles());
        }
        AttributeAuthorityDescriptorType[] attributeAuthorityArray = entityDescType.getAttributeAuthorityDescriptorArray();
        if (attributeAuthorityArray.length > 0) {
            this.getAttributeAuthorityFromXmlBean(idpConnection, attributeAuthorityArray[0], entityDescType);
        }
        if ((roleDescArray = entityDescType.getRoleDescriptorArray()).length > 0) {
            for (RoleDescriptorType roleDescType : roleDescArray) {
                if (roleDescType instanceof PFIdpWsTrustRoleDescriptorType) {
                    this.processRoleExtensionBaseConnInfo(roleDescType, idpConnection);
                    this.fillWsTrustSpSettings(idpConnection, (PFIdpWsTrustRoleDescriptorType)roleDescType);
                    continue;
                }
                if (roleDescType instanceof PFOAuthRoleDescriptorType) {
                    this.processRoleExtensionBaseConnInfo(roleDescType, idpConnection);
                    this.fillOAuthSettings(idpConnection, (PFOAuthRoleDescriptorType)roleDescType);
                    continue;
                }
                if (roleDescType instanceof PFInboundProvisioningRoleDescriptorType) {
                    this.processRoleExtensionBaseConnInfo(roleDescType, idpConnection);
                    this.fillInboundProvisioningDomain(idpConnection, (PFInboundProvisioningRoleDescriptorType)roleDescType);
                    continue;
                }
                if (!(roleDescType instanceof PFOIDCRoleDescriptorType)) continue;
                this.processRoleExtensionBaseConnInfo(roleDescType, idpConnection);
                this.fillOIDCRPSettings(idpConnection, (PFOIDCRoleDescriptorType)roleDescType);
            }
        }
        return idpConnection;
    }

    private void resetEnabledProfiles(EnabledProfiles enabledProfiles) {
        enabledProfiles.setIdpInitiatedSLOEnabled(false);
        enabledProfiles.setIdpInitiatedSSOEnabled(false);
        enabledProfiles.setSpInitiatedSLOEnabled(false);
        enabledProfiles.setSpInitiatedSSOEnabled(false);
    }

    private void getIdpSsoConnInfoFromXmlBean(EntityDescriptorType entityDescType, IdpConnection idpConnection) {
        IDPSSODescriptorType idpType = entityDescType.getIDPSSODescriptorArray(0);
        EndpointType[] ssoServiceArray = idpType.getSingleSignOnServiceArray();
        String dummyLocation = OUT_SSO_NONE.getPrimaryEndpoint().getFullLocation();
        EndpointGroup ssoServices = ssoServiceArray.length == 0 || ssoServiceArray[0].getLocation().equals(dummyLocation) ? new EndpointGroup() : EndpointUtil.toEndpointGroup(ssoServiceArray, this.getBaseUrl(entityDescType));
        idpConnection.setSingleSignOnServices(ssoServices);
        boolean wantAuthnReqsSigned = idpType.isSetWantAuthnRequestsSigned() && idpType.getWantAuthnRequestsSigned();
        idpConnection.setWantAuthnRequestsSigned(wantAuthnReqsSigned);
        idpConnection.setAttributeContract(this.getAttributeContract(idpType, idpConnection.getProtocol()));
        try {
            RoleExtensionType roleExtensionType = this.processBaseConnectionInfo((SSODescriptorType)idpType, idpConnection, entityDescType);
            if (roleExtensionType != null && roleExtensionType.isSetIDP()) {
                String errPageMsg;
                IdpExtensionType idpExt = roleExtensionType.getIDP();
                idpConnection.setAssertionSigned(idpExt.getAssertionsSigned());
                idpConnection.setDefaultTargetResource(idpExt.getDefaultTargetResource());
                ArrayList<AuthnContextMapping> authnContextMappings = new ArrayList<AuthnContextMapping>();
                for (AuthnContextMappingType domainAuthnContextMappingType : idpExt.getAuthnContextMappingArray()) {
                    authnContextMappings.add(new AuthnContextMapping(domainAuthnContextMappingType.getLocal(), domainAuthnContextMappingType.getRemote()));
                }
                idpConnection.setAuthnContextMappings(authnContextMappings);
                this.getTargetAttributeMappings(idpExt.getTargetAttributeMappingArray(), idpConnection);
                this.getConnectionContractMappings(idpExt.getConnectionContractMappingArray(), idpConnection);
                this.getJitProvisioning(idpExt.getUserProvisioning(), idpConnection);
                AccountLinkingAndMappingType linkingMappingType = idpExt.getAccountLinkingAndMapping();
                if (linkingMappingType != null) {
                    boolean isLinking = linkingMappingType.getType() == LinkingMappingType.LINKING;
                    idpConnection.setLinking(isLinking);
                    idpConnection.setIncludeAdditionalAttributes(linkingMappingType.getIncludeAdditionalAttributes());
                }
                String string = errPageMsg = idpExt.isSetErrPageMsg() ? idpExt.getErrPageMsg() : ERR_PG_MSG;
                if (LEGACY_ERR_PG_MSG.equals(errPageMsg)) {
                    errPageMsg = ERR_PG_MSG;
                }
                idpConnection.setErrorPageMsg(errPageMsg);
                String[] maskedAttributeArray = idpExt.getMaskedAttributeArray();
                HashSet<String> maskedAttrs = new HashSet<String>(Arrays.asList(maskedAttributeArray));
                idpConnection.setMaskedAttributeNames(maskedAttrs);
                if (idpExt.isSetOAuthApcId()) {
                    idpConnection.setOAuthApcId(idpExt.getOAuthApcId());
                } else if (idpExt.isSetSsoToOAuthMapping()) {
                    AttributeMappingType ssoToOAuthMapping = idpExt.getSsoToOAuthMapping();
                    AttributeMapping am = new AttributeMapping();
                    this.fillAttrMappingFromXml(ssoToOAuthMapping, am);
                    UserKeyAttrMapping userKeyAttrMapping = new UserKeyAttrMapping(am, this.authzServerManager.getKeyNameContract());
                    idpConnection.setSsoToOAuthAttrMapping(userKeyAttrMapping);
                }
            }
        }
        catch (CertificateException ex) {
            log.info((Object)ex.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)ex);
            }
            throw new RuntimeException("Exception in importing certificates from metadata.", ex);
        }
    }

    public URL getBaseUrl(EntityDescriptorType entityDescType) {
        return this.getUrl(entityDescType, ATTR_NAME_BASE_URL);
    }

    public URL getApplicationIconUrl(EntityDescriptorType entityDescType) {
        return this.getUrl(entityDescType, ATTR_NAME_APPLICATION_ICON);
    }

    private URL getUrl(EntityDescriptorType entityDescType, String attribute) {
        URL url = null;
        String urlStr = XmlBeansUtil.getAttributeValue((XmlObject)entityDescType, METADATA_EXT_NS, attribute);
        if (urlStr != null) {
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e) {
                log.warn((Object)(attribute + " URL not a url " + urlStr + e));
            }
        }
        return url;
    }

    public ContactInfo getContactInfo(EntityDescriptorType entityDescType) {
        ContactType[] contacts = entityDescType.getContactPersonArray();
        return this.getFirstContact(contacts);
    }

    private ContactInfo getContactInfo(SSODescriptorType ssoDescType) {
        ContactType[] contacts = ssoDescType.getContactPersonArray();
        return this.getFirstContact(contacts);
    }

    private ContactInfo getFirstContact(ContactType[] contacts) {
        ContactInfo contact = null;
        if (contacts != null && contacts.length > 0) {
            String[] emails;
            contact = new ContactInfo();
            contact.setCompany(contacts[0].getCompany());
            contact.setFirstName(contacts[0].getGivenName());
            contact.setLastName(contacts[0].getSurName());
            String[] phones = contacts[0].getTelephoneNumberArray();
            if (phones.length > 0) {
                contact.setPhone(phones[0]);
            }
            if ((emails = contacts[0].getEmailAddressArray()).length > 0) {
                contact.setEmail(emails[0]);
            }
        }
        return contact;
    }

    private String[] localizedNamesToStringArray(LocalizedNameType[] nameTypes) {
        String[] returnArray = new String[nameTypes.length];
        for (int i = 0; i < nameTypes.length; ++i) {
            returnArray[i] = nameTypes[i].getStringValue();
        }
        return returnArray;
    }

    private Organization getOrganization(EntityDescriptorType entityDescType) {
        Organization org = null;
        OrganizationType organizationType = entityDescType.getOrganization();
        if (organizationType != null) {
            org = new Organization();
            org.setOrganizationNames(this.localizedNamesToStringArray(organizationType.getOrganizationNameArray()));
            org.setOrganizationDisplayNames(this.localizedNamesToStringArray(organizationType.getOrganizationDisplayNameArray()));
            LocalizedURIType[] urlTypes = organizationType.getOrganizationURLArray();
            String[] tmpUris = new String[urlTypes.length];
            for (int i = 0; i < urlTypes.length; ++i) {
                tmpUris[i] = urlTypes[i].getStringValue();
            }
            org.setOrganizationURLs(tmpUris);
        }
        return org;
    }

    private AttributeContract getAttributeContract(IDPSSODescriptorType idpType, Protocol protocol) {
        AssertionAttributeContract contract = new AssertionAttributeContract(false, false, protocol);
        AttributeType[] attributes = idpType.getAttributeArray();
        if (attributes != null) {
            for (AttributeType attribute : attributes) {
                contract.addMutableAttributeName(attribute.getName());
            }
        }
        return contract;
    }

    private void getTargetAttributeMappings(TargetAttributeMappingType[] targetAttrMappings, IdpConnection idpConnection) {
        ArrayList<TargetAttributeMapping> mappings = new ArrayList<TargetAttributeMapping>();
        if (targetAttrMappings != null) {
            for (TargetAttributeMappingType attribMappingFromConfig : targetAttrMappings) {
                TargetAttributeMapping targetAttrMap = new TargetAttributeMapping();
                String adapterInstanceId = attribMappingFromConfig.getAdapterInstanceId();
                if (!StringUtils.isBlank((String)adapterInstanceId)) {
                    if (attribMappingFromConfig.isSetAdapterConfiguration()) {
                        ConnectionOverrideAdapterConfigurationType configType = attribMappingFromConfig.getAdapterConfiguration();
                        AuthnAdapterInstance instance = (AuthnAdapterInstance)this.spAdapterMgmtSupport.createInstanceFromConfigType(attribMappingFromConfig.getAdapterInstanceId(), (ConfigType)configType, configType.getParentId(), idpConnection.getEntityId());
                        targetAttrMap.setConnectionOverrideInstance(instance);
                    }
                    this.setSpAdapterInstanceId(targetAttrMap, adapterInstanceId);
                }
                targetAttrMap.setRestrictVirtualServerIds(attribMappingFromConfig.getRestrictVirtualServerIds());
                targetAttrMap.setRestrictedVirtualServerIds(Arrays.asList(attribMappingFromConfig.getRestrictedVirtualServerIdArray()));
                this.getAttributeMapping(attribMappingFromConfig.getAttributeSource(), attribMappingFromConfig.getAttributeMapArray(), attribMappingFromConfig.getTokenAuthorizationIssuanceCriteria(), (AttributeMapping)targetAttrMap);
                mappings.add(targetAttrMap);
            }
        }
        idpConnection.setTargetAttributeMappings(mappings);
    }

    private void getConnectionContractMappings(C2CContractMappingType[] xmlConnContractMappings, IdpConnection idpConnection) {
        ArrayList<C2cContractAttributeMapping> mappings = new ArrayList<C2cContractAttributeMapping>();
        if (xmlConnContractMappings != null) {
            for (C2CContractMappingType connContractMappingFromConfig : xmlConnContractMappings) {
                C2cContractAttributeMapping contractAttrMap = new C2cContractAttributeMapping();
                this.setC2cContractAttributeMappingId(connContractMappingFromConfig, contractAttrMap);
                contractAttrMap.setRestrictVirtualServerIds(connContractMappingFromConfig.getRestrictVirtualServerIds());
                contractAttrMap.setRestrictedVirtualServerIds(Arrays.asList(connContractMappingFromConfig.getRestrictedVirtualServerIdArray()));
                this.getAttributeMapping(connContractMappingFromConfig.getAttributeSourceArray(), connContractMappingFromConfig.getAttributeMapArray(), connContractMappingFromConfig.getTokenAuthorizationIssuanceCriteria(), (AttributeMapping)contractAttrMap);
                mappings.add(contractAttrMap);
            }
        }
        idpConnection.setC2cContractMappings(mappings);
    }

    protected void setC2cContractAttributeMappingId(C2CContractMappingType mappingType, C2cContractAttributeMapping mapping) {
        mapping.setContractId(mappingType.getC2CContractId());
    }

    public void fillAttrMappingFromXml(AttributeMappingType amType, AttributeMapping attributeMapping) {
        this.getAttributeMapping(amType.getAttributeSourceArray(), amType.getAttributeMapArray(), amType.getTokenAuthorizationIssuanceCriteria(), attributeMapping);
    }

    private void getAttributeMapping(AttributeSourceType attribSourceType, AttributeMapType[] attrMaps, TokenAuthorizationIssuanceCriteriaType issuanceCriteria, AttributeMapping attrMapping) {
        AttributeSourceType[] attribSourceTypeArray = new AttributeSourceType[]{attribSourceType};
        this.getAttributeMapping(attribSourceTypeArray, attrMaps, issuanceCriteria, attrMapping);
    }

    private void getAttributeMapping(AttributeSourceType[] attribSourceTypeArray, AttributeMapType[] attrMaps, TokenAuthorizationIssuanceCriteriaType tokenAuthorizationIssuanceCriteria, AttributeMapping attrMapping) {
        this.getAttributeMapping(attribSourceTypeArray, attrMaps, tokenAuthorizationIssuanceCriteria, attrMapping, false);
    }

    private void getAttributeMapping(AttributeSourceType[] attribSourceTypeArray, AttributeMapType[] attrMaps, TokenAuthorizationIssuanceCriteriaType tokenAuthorizationIssuanceCriteria, AttributeMapping attrMapping, boolean shouldDefaultContextSourceId) {
        for (AttributeSourceType attributeSourceType : attribSourceTypeArray) {
            if (attributeSourceType == null) continue;
            attrMapping.addAttributeSource(this.createAttributeSource(attributeSourceType));
        }
        if (tokenAuthorizationIssuanceCriteria != null) {
            for (AttributeSourceType attributeSourceType : tokenAuthorizationIssuanceCriteria.getTokenAuthorizationIssuanceCriterionArray()) {
                attrMapping.addTokenAuthorizationIssuanceCriteria(this.createTokenAuthorizationIssuanceCriterion((TokenAuthorizationIssuanceCriterionType)attributeSourceType));
            }
        }
        for (AttributeSourceType attributeSourceType : attrMaps) {
            String attrName = attributeSourceType.getName();
            SourceType sourceType = SourceTypeString.strToType(attributeSourceType.getType());
            AttrMappingValue attrMappingValue = shouldDefaultContextSourceId && SourceType.CONTEXT.equals((Object)sourceType) && attributeSourceType.getAttributeSourceId() == null ? new AttrMappingValue(sourceType, attributeSourceType.isSetValue() ? attributeSourceType.getValue() : attributeSourceType.getValueText(), attributeSourceType.getDelimiter(), "context") : new AttrMappingValue(sourceType, attributeSourceType.isSetValue() ? attributeSourceType.getValue() : attributeSourceType.getValueText(), attributeSourceType.getDelimiter(), attributeSourceType.getAttributeSourceId());
            List<AttrMappingValue> existingAttrMappingValueList = attrMapping.getAttributeMappingValues(attrName);
            List<AttrMappingValue> attrMappingValueList = existingAttrMappingValueList == null ? new ArrayList<AttrMappingValue>() : existingAttrMappingValueList;
            attrMappingValueList.add(attrMappingValue);
            attrMapping.putAttributeMapping(attrName, attrMappingValueList);
        }
    }

    protected void setSpAdapterInstanceId(TargetAttributeMapping targetAttrMap, String adapterInstanceId) {
        targetAttrMap.setAdapterInstanceId(adapterInstanceId);
    }

    private TokenAuthorizationIssuanceCriterion createTokenAuthorizationIssuanceCriterion(TokenAuthorizationIssuanceCriterionType tokenAuthorizationIssuanceCriterionType) {
        TokenAuthorizationIssuanceCriterion tokenAuthorizationIssuanceCriterion = new TokenAuthorizationIssuanceCriterion();
        tokenAuthorizationIssuanceCriterion.setAttrSourceTypeAsString(tokenAuthorizationIssuanceCriterionType.getAttrSourceType());
        String attrSourceId = tokenAuthorizationIssuanceCriterionType.getAttrSourceId();
        if (StringUtils.isNotEmpty((String)attrSourceId)) {
            tokenAuthorizationIssuanceCriterion.setAttrSourceId(attrSourceId);
        }
        tokenAuthorizationIssuanceCriterion.setAttrName(tokenAuthorizationIssuanceCriterionType.getAttrName());
        tokenAuthorizationIssuanceCriterion.setConditionById(tokenAuthorizationIssuanceCriterionType.getCondition());
        tokenAuthorizationIssuanceCriterion.setComparisonValue(tokenAuthorizationIssuanceCriterionType.getComparisonValue());
        tokenAuthorizationIssuanceCriterion.setErrorResult(tokenAuthorizationIssuanceCriterionType.getErrorResult());
        tokenAuthorizationIssuanceCriterion.setExpr(tokenAuthorizationIssuanceCriterionType.isSetExpr() ? tokenAuthorizationIssuanceCriterionType.getExpr() : tokenAuthorizationIssuanceCriterionType.getExprText());
        return tokenAuthorizationIssuanceCriterion;
    }

    private AttributeSource createAttributeSource(AttributeSourceType attribSourceType) {
        AttributeSource attribSource = AttributeSourceConfigHelper.createAttributeSourceFromXML(attribSourceType);
        if (!StringUtils.isBlank((String)attribSource.getDataSourceId())) {
            this.setDatasrcIdOnAttrSrc(attribSource, attribSource.getDataSourceId());
        }
        return attribSource;
    }

    protected void setDatasrcIdOnAttrSrc(AttributeSource attribSource, String dataSourceId) {
        attribSource.setDataSourceId(dataSourceId);
    }

    public Affiliation toAffiliation(EntityDescriptorType entityDescType) {
        String[] affiliationMembers;
        AffiliationDescriptorType affiliationDescType = entityDescType.getAffiliationDescriptor();
        Affiliation affiliation = new Affiliation();
        affiliation.setAffiliationId(entityDescType.getEntityID());
        affiliation.setAffiliationOwnerId(affiliationDescType.getAffiliationOwnerID());
        affiliation.setId(entityDescType.getID());
        String active = XmlBeansUtil.getAttributeValue((XmlObject)entityDescType, METADATA_EXT_NS, IS_ACTIVE);
        affiliation.setActive(Boolean.valueOf(active));
        ExtensionsType extensionsType = entityDescType.getExtensions();
        List<XmlObject> children = XmlBeansUtil.getChildren((XmlObject)extensionsType);
        if (children != null) {
            for (XmlObject obj : children) {
                RoleExtensionType roleExtensionType;
                if (!(obj instanceof RoleExtensionType) || !(roleExtensionType = (RoleExtensionType)obj).isSetLastModified()) continue;
                affiliation.setLastModified(roleExtensionType.getLastModified());
            }
        }
        if ((affiliationMembers = affiliationDescType.getAffiliateMemberArray()) != null) {
            for (String member : affiliationMembers) {
                affiliation.addMember(member);
            }
        }
        return affiliation;
    }

    public EntityDescriptorType toEntityDescriptorType(Affiliation affiliation) {
        EntityDescriptorType entityDescType = EntityDescriptorType.Factory.newInstance();
        entityDescType.setID(affiliation.getId());
        entityDescType.setEntityID(affiliation.getAffiliationId());
        XmlBeansUtil.setAttributeValue((XmlObject)entityDescType, Boolean.toString(affiliation.isActive()), METADATA_EXT_NS, IS_ACTIVE);
        this.buildBaseAffiliationDescType(entityDescType, affiliation);
        return entityDescType;
    }

    private void buildBaseAffiliationDescType(EntityDescriptorType entityDescType, Affiliation affiliation) {
        AffiliationDescriptorType affiliationDescType = entityDescType.addNewAffiliationDescriptor();
        affiliationDescType.setID(affiliation.getAffiliationId());
        affiliationDescType.setAffiliationOwnerID(affiliation.getAffiliationOwnerId());
        RoleExtensionDocument roleExtdoc = RoleExtensionDocument.Factory.newInstance();
        RoleExtensionType roleExtensionType = roleExtdoc.addNewRoleExtension();
        if (affiliation.getLastModified() != null) {
            roleExtensionType.setLastModified(affiliation.getLastModified());
            ExtensionsType extensionsType = entityDescType.addNewExtensions();
            XmlBeansUtil.setChildren((XmlObject)extensionsType, new XmlObject[]{roleExtensionType});
        }
        this.loadAffiliationMembers(affiliationDescType, (ArrayList)affiliation.getMembers());
    }

    private void loadAffiliationMembers(AffiliationDescriptorType affiliationDescriptorType, ArrayList<String> members) {
        String[] array = new String[members.size()];
        for (int i = 0; i < members.size(); ++i) {
            array[i] = members.get(i);
        }
        affiliationDescriptorType.setAffiliateMemberArray(array);
    }

    private void fillBaseConn(ConnectionBase connBase, EntityDescriptorType entityDescType) {
        String id = entityDescType.getID();
        this.setSystemIdOnConn(connBase, id);
        URL baseUrl = this.getBaseUrl(entityDescType);
        connBase.setBaseUrl(baseUrl);
        connBase.setOrganization(this.getOrganization(entityDescType));
        connBase.setContactInfo(this.getContactInfo(entityDescType));
        String active = XmlBeansUtil.getAttributeValue((XmlObject)entityDescType, METADATA_EXT_NS, IS_ACTIVE);
        connBase.setActive(Boolean.valueOf(active));
        String name = XmlBeansUtil.getAttributeValue((XmlObject)entityDescType, METADATA_EXT_NS, ATTR_NAME_NAME);
        name = StringUtils.isBlank((String)name) ? entityDescType.getEntityID() : name;
        connBase.setName(name);
        String logLevel = XmlBeansUtil.getAttributeValue((XmlObject)entityDescType, METADATA_EXT_NS, ATTR_NAME_LOG_LEVEL);
        LoggingMode loggingMode = LoggingMode.STANDARD;
        if (logLevel != null) {
            try {
                loggingMode = LoggingMode.valueOf(logLevel);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        connBase.setLoggingMode(loggingMode);
        ProtocolUtil.setProtocolOnDomain(entityDescType, connBase);
        List<VirtualIdentity> virtualIdentities = connBase.getVirtualIdentities();
        EntityExtensionType entityExtType = this.getEntityExtType(entityDescType);
        if (entityExtType != null) {
            AdditionalAllowedEntitiesConfiguration additionalAllowedEntitiesConfiguration;
            ConnectionTemplatePropertyType[] connectionTemplatePropertyArray;
            int length;
            if (entityExtType.isSetLicenseGroup()) {
                connBase.setLicenseConnectionGroupAssignment(entityExtType.getLicenseGroup());
            }
            String configuredDefaultVirtualEntityID = null;
            if (entityExtType.isSetDefaultVirtualIdentity()) {
                configuredDefaultVirtualEntityID = entityExtType.getDefaultVirtualIdentity().getEntityID();
            } else if (entityExtType.sizeOfVirtualIdentityArray() > 0) {
                configuredDefaultVirtualEntityID = entityExtType.getVirtualIdentityArray(0).getEntityID();
            }
            byte[] defaultVirtualSourceId = null;
            if (configuredDefaultVirtualEntityID != null) {
                VirtualIdentity defaultVirtualIdentity = new VirtualIdentity();
                defaultVirtualIdentity.setVirtualEntityId(configuredDefaultVirtualEntityID, DomainMode.CONFIGTIME);
                defaultVirtualIdentity.setVirtualEntityId(configuredDefaultVirtualEntityID, DomainMode.RUNTIME);
                defaultVirtualSourceId = HashUtil.hashToBytes((String)configuredDefaultVirtualEntityID, (HashAlgorithm)HashAlgorithm.SHA1);
                defaultVirtualIdentity.setVirtualSourceId(defaultVirtualSourceId);
                connBase.setDefaultVirtualIdentity(defaultVirtualIdentity);
                virtualIdentities.add(defaultVirtualIdentity);
            }
            for (int i = 0; i < entityExtType.sizeOfVirtualIdentityArray(); ++i) {
                VirtualIdentityType virtualIdentityType = entityExtType.getVirtualIdentityArray(i);
                String configuredVirtualEntityID = virtualIdentityType.getEntityID();
                byte[] virtualSourceId = HashUtil.hashToBytes((String)configuredVirtualEntityID, (HashAlgorithm)HashAlgorithm.SHA1);
                if (Arrays.equals(defaultVirtualSourceId, virtualSourceId)) continue;
                VirtualIdentity virtualIdentity = new VirtualIdentity();
                virtualIdentity.setVirtualEntityId(configuredVirtualEntityID, DomainMode.CONFIGTIME);
                virtualIdentity.setVirtualEntityId(configuredVirtualEntityID, DomainMode.RUNTIME);
                virtualIdentity.setVirtualSourceId(virtualSourceId);
                virtualIdentities.add(virtualIdentity);
            }
            if (entityExtType.isSetConnectionTemplateProperties() && (length = (connectionTemplatePropertyArray = entityExtType.getConnectionTemplateProperties().getPropertyArray()).length) > 0) {
                HashMap<String, String> connectionTemplateProperties = new HashMap<String, String>();
                for (ConnectionTemplatePropertyType connectionTemplateProperty : connectionTemplatePropertyArray) {
                    String propertyName = connectionTemplateProperty.getName();
                    String propertyValue = connectionTemplateProperty.getValue();
                    connectionTemplateProperties.put(propertyName, propertyValue);
                }
                connBase.setConnectionTemplateProperties(connectionTemplateProperties);
            }
            connBase.setDsigVerificationExpectedSubjectDN(entityExtType.getDsigVerificationExpectedSubjectDN());
            connBase.setDsigVerificationExpectedIssuerDN(entityExtType.getDsigVerificationExpectedIssuerDN());
            if (entityExtType.getMetadataSynchronizationSettings() != null) {
                this.getSigningKeyRotationSettingsFromXml(entityExtType.getMetadataSynchronizationSettings().getSigningKeyRotationSettings(), connBase);
            }
            if (entityExtType.isSetAdditionalAllowedEntitiesConfiguration() && (additionalAllowedEntitiesConfiguration = entityExtType.getAdditionalAllowedEntitiesConfiguration()).getAllowAdditionalEntities()) {
                connBase.setAllowAdditionalEntities(additionalAllowedEntitiesConfiguration.getAllowAdditionalEntities());
                connBase.setAllowAllEntities(additionalAllowedEntitiesConfiguration.getAllowAdditionalEntities() && additionalAllowedEntitiesConfiguration.getAllowAllEntities());
                if (!additionalAllowedEntitiesConfiguration.getAllowAllEntities()) {
                    connBase.setAdditionalAllowedEntities(Arrays.stream(additionalAllowedEntitiesConfiguration.getAdditionalAllowedEntities().getAdditionalEntityArray()).map(entity -> new Entity(entity.getEntityId(), entity.getEntityDescription())).collect(Collectors.toList()));
                }
            }
            this.populateExtendedProperties(connBase, name, entityExtType);
            String metadataUrlId = entityExtType.getMetadataUrlId();
            connBase.setMetadataUrlId(metadataUrlId);
            connBase.setEnableAutoMetadataUpdate(entityExtType.getEnableAutoMetadataUpdate());
            connBase.setAlwaysSignArtifactResponse(entityExtType.getAlwaysSignArtifactResponse());
        }
        this.fillInAvailableCerts(entityDescType, connBase);
        this.processDigitialSignatureAliases(entityDescType, connBase);
        this.getEncryptionFromXml(entityDescType, connBase);
        this.loadModulesIntoConnection(connBase);
    }

    private void populateExtendedProperties(ConnectionBase connBase, String name, EntityExtensionType entityExtType) {
        LinkedHashMap<String, ParamValues> extendedProperties = new LinkedHashMap<String, ParamValues>();
        ExtendedPropertyType[] extendedPropertyArray = entityExtType.getExtendedPropertiesArray();
        int length = extendedPropertyArray.length;
        if (length > 0) {
            for (ExtendedPropertyType extendedProperty : extendedPropertyArray) {
                String propertyName = extendedProperty.getName();
                String propertyValue = extendedProperty.getValue();
                if (extendedProperties.containsKey(propertyName)) {
                    ArrayList<String> values = new ArrayList<String>();
                    ParamValues paramValues = (ParamValues)extendedProperties.get(propertyName);
                    if (paramValues == null) continue;
                    values.addAll(paramValues.getElements());
                    values.add(propertyValue);
                    ParamValues newParamValues = new ParamValues();
                    newParamValues.setElements(values);
                    extendedProperties.put(propertyName, newParamValues);
                    continue;
                }
                ParamValues newParamValues = new ParamValues();
                newParamValues.setElements(new ArrayList<String>(Arrays.asList(propertyValue)));
                extendedProperties.put(propertyName, newParamValues);
            }
        }
        connBase.setExtendedProperties(extendedProperties);
    }

    /*
     * WARNING - void declaration
     */
    protected void fillWsTrustIdpSettings(SpConnection spConn, PFSpWsTrustRoleDescriptorType pfSpWsTrustRoleDescriptorType) {
        void var10_17;
        WsTrustSettingsType config = pfSpWsTrustRoleDescriptorType.getWsTrustSettings();
        WsTrustFederatedWscSettings settings = new WsTrustFederatedWscSettings();
        WsTrustTokenAttributeContract attributeContract = this.getWsTrustAttributeContract(config.getExtendedAttributeContract());
        settings.setAttributeContract(attributeContract);
        settings.setUseSamlHoK(config.getUseSamlHoK());
        settings.setEncryptAssertion(config.getEncryptAssertion());
        settings.setRequestContractId(config.getRequestContractId());
        settings.setAbortIfNotFulfilledFromRequest(config.getAbortIfNotFulfilledFromRequest());
        settings.setEnableOAuthAssertionProfiles(config.getEnableOAuthSamlBearer());
        if (config.getAppliesToArray() != null) {
            HashSet<AppliesTo> appliesToUrls = new HashSet<AppliesTo>();
            for (String string : config.getAppliesToArray()) {
                appliesToUrls.add(new AppliesTo(string));
            }
            settings.setAppliesTo(appliesToUrls);
        }
        TokenPluginMappingType[] tokenMappings = config.getTokenToAssertionMappingArray();
        for (MessageCustomizationHook messageCustomizationHook : pfSpWsTrustRoleDescriptorType.getMessageCustomizationHookArray()) {
            String contextName = messageCustomizationHook.getContextName();
            String expression = messageCustomizationHook.getStringValue();
            MessageCustomization value = new MessageCustomization();
            value.setExpression(expression);
            spConn.getWsTrustMessageCustomizationHooks().put(contextName, value);
        }
        ArrayList<TokenPluginAttributeMapping> arrayList = new ArrayList<TokenPluginAttributeMapping>();
        TokenPluginMappingType[] tokenPluginMappingTypeArray = tokenMappings;
        int n = tokenPluginMappingTypeArray.length;
        boolean bl = false;
        while (var10_17 < n) {
            TokenPluginMappingType mapping = tokenPluginMappingTypeArray[var10_17];
            AttributeMapping attributeMapping = this.getAttributeMapping(mapping.getAttributeMapping());
            attributeMapping.updateMappingTargetName(AssertionMapKeys.getNameIdValueKey(), AssertionMapKeys.getGenericNameIdValueKey());
            TokenPluginAttributeMapping tokenMapping = new TokenPluginAttributeMapping();
            tokenMapping.setAttributeMapping(attributeMapping);
            tokenMapping.setPluginId(mapping.getPluginId());
            tokenMapping.setRestrictVirtualServerIds(mapping.getRestrictVirtualServerIds());
            tokenMapping.setRestrictedVirtualServerIds(Arrays.asList(mapping.getRestrictedVirtualServerIdArray()));
            arrayList.add(tokenMapping);
            if (mapping.sizeOfTokenProcessorConfigurationArray() > 0) {
                ConnectionOverrideTokenProcessorConfigurationType configType = mapping.getTokenProcessorConfigurationArray(0);
                TokenProcessorInstance instance = (TokenProcessorInstance)this.tokenProcessorMgmtSupport.createInstanceFromConfigType(mapping.getPluginId(), (ConfigType)configType, configType.getParentId(), spConn.getEntityId());
                tokenMapping.setConnectionOverrideInstance(instance);
            }
            ++var10_17;
        }
        settings.setTokenToAssertionMappings(arrayList);
        if (config.getTokenType() != null) {
            settings.setTokenType(config.getTokenType());
        }
        settings.setAssertionValidityAfterMinutes((int)config.getAssertionValidityAfterMinutes());
        settings.setAssertionValidityBeforeMinutes(config.getAssertionValidityBeforeMinutes());
        spConn.setWsTrustSettings(settings);
    }

    protected void fillWsTrustSpSettings(IdpConnection idpConn, PFIdpWsTrustRoleDescriptorType idpWsTrustRoleDescriptorType) {
        WsTrustSettingsType wsTrustSettings = idpWsTrustRoleDescriptorType.getWsTrustSettings();
        WsTrustFederatedWspSettings settings = new WsTrustFederatedWspSettings();
        WsTrustTokenAttributeContract attributeContract = this.getWsTrustAttributeContract(wsTrustSettings.getExtendedAttributeContract());
        settings.setAttributeContract(attributeContract);
        settings.setDefaultAssertionToTokenMappingsMappingId(wsTrustSettings.getDefaultAssertionToTokenMappingId());
        TokenPluginMappingType[] assertionToTokenMappings = wsTrustSettings.getAssertionToTokenMappingArray();
        ArrayList<TokenPluginAttributeMapping> mappingsCollection = new ArrayList<TokenPluginAttributeMapping>();
        for (TokenPluginMappingType mapping : assertionToTokenMappings) {
            AttributeMapping attributeMapping = this.getAttributeMapping(mapping.getAttributeMapping());
            attributeMapping.updateSourceValueName(SourceType.ASSERTION, AssertionMapKeys.getNameIdValueKey(), AssertionMapKeys.getGenericNameIdValueKey());
            TokenPluginAttributeMapping tokenMapping = new TokenPluginAttributeMapping();
            tokenMapping.setAttributeMapping(attributeMapping);
            tokenMapping.setPluginId(mapping.getPluginId());
            tokenMapping.setRestrictVirtualServerIds(mapping.getRestrictVirtualServerIds());
            tokenMapping.setRestrictedVirtualServerIds(Arrays.asList(mapping.getRestrictedVirtualServerIdArray()));
            if (mapping.sizeOfPluginConfigurationArray() > 0) {
                ConnectionOverrideConfigType configType = mapping.getPluginConfigurationArray(0);
                TokenGeneratorInstance instance = (TokenGeneratorInstance)this.tokenGeneratorMgmtSupport.createInstanceFromConfigType(mapping.getPluginId(), (ConfigType)configType, configType.getParentId(), idpConn.getEntityId());
                tokenMapping.setConnectionOverrideInstance(instance);
            }
            mappingsCollection.add(tokenMapping);
        }
        settings.setAssertionToTokenMappings(mappingsCollection);
        settings.setDecryptAssertion(wsTrustSettings.getDecryptAssertion());
        idpConn.setWsTrustSettings(settings);
    }

    protected void fillOAuthSettings(IdpConnection idpConn, PFOAuthRoleDescriptorType idpOAuthRoleDescriptorType) {
        ExtendedAttributeContractType extendedAttributeContractType;
        ExtendedAttributeType[] extendedAttributes;
        OAuthSettingsType oAuthSettingsType = idpOAuthRoleDescriptorType.getOAuthSettings();
        OAuthSettings settings = new OAuthSettings();
        OAuthAssertionGrantAttributeContract attributeContract = new OAuthAssertionGrantAttributeContract();
        if (oAuthSettingsType.getOAuthSAMLBearerAttributeContract() != null && (extendedAttributes = (extendedAttributeContractType = oAuthSettingsType.getOAuthSAMLBearerAttributeContract()).getExtendedAttributeArray()) != null) {
            ExtendedAttributeType[] extendedAttributeTypeArray = extendedAttributes;
            int n = extendedAttributeTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ExtendedAttributeType extendedAttribute = extendedAttributeTypeArray[i];
                String attributeName = extendedAttribute.getAttributeName();
                attributeContract.addMutableAttributeName(attributeName);
                if (extendedAttribute.getNamespace() != null) {
                    attributeContract.addMutableAttributeInfo(attributeName, extendedAttribute.getNamespace());
                }
                if (!extendedAttribute.getMaskValue()) continue;
                attributeContract.addMaskedAttributeName(attributeName);
            }
        }
        settings.setOAuthAssertionGrantAttributeContract(attributeContract);
        if (oAuthSettingsType.getOAuthSAMLBearerMappingArray() != null) {
            OAuthSAMLBearerMappingType[] oAuthSAMLBearerMappingArray;
            for (OAuthSAMLBearerMappingType oAuthSAMLBearerMappingType : oAuthSAMLBearerMappingArray = oAuthSettingsType.getOAuthSAMLBearerMappingArray()) {
                if (!oAuthSAMLBearerMappingType.isSetTokenManagerId()) {
                    oAuthSAMLBearerMappingType.setTokenManagerId("default");
                }
                OAuthAssertionGrantMapping oAuthSAMLBearerMapping = new OAuthAssertionGrantMapping(oAuthSAMLBearerMappingType.getTokenManagerId());
                this.fillAttrMappingFromXml((AttributeMappingType)oAuthSAMLBearerMappingType, oAuthSAMLBearerMapping);
                oAuthSAMLBearerMapping.updateSourceValueName(SourceType.ASSERTION, AssertionMapKeys.getNameIdValueKey(), AssertionMapKeys.getGenericNameIdValueKey());
                settings.getOAuthAssertionGrantMappingList().add(oAuthSAMLBearerMapping);
            }
        }
        idpConn.setOAuthSettings(settings);
    }

    protected void fillOIDCRPSettings(IdpConnection idpConn, PFOIDCRoleDescriptorType idpOIDCRoleDescriptorType) {
        OIDCSettingsType settingsType = idpOIDCRoleDescriptorType.getOpenIDConnectSettings();
        OIDCSettings settings = new OIDCSettings();
        settings.setTokenEndpoint(new Endpoint(null, settingsType.getTokenEndpoint(), idpConn.getBaseUrl()));
        settings.setJwksUri(new Endpoint(null, settingsType.getJWKSUri(), idpConn.getBaseUrl()));
        Scope scopes = Scope.getScope((String)settingsType.getScopes());
        settings.setScopes(scopes);
        settings.setProfile(OIDCProfile.valueOf(settingsType.getProfile()));
        settings.setBasicAuth(settingsType.getBasicAuth());
        if (settingsType.getJwtSecuredAuthorizationResponseModeType() != null) {
            settings.setJwtSecuredAuthorizationResponseModeType(settingsType.getJwtSecuredAuthorizationResponseModeType());
        } else {
            settings.setJwtSecuredAuthorizationResponseModeType("disabled");
        }
        settings.setPrivateKeyJwtAuth(settingsType.getPrivateJwtAuth());
        settings.setClientSecretJwtAuth(settingsType.getClientSecretJwtAuth());
        settings.setSigningAlgorithm(settingsType.getSigningAlgorithm());
        settings.setType(settingsType.getTypeClaim());
        settings.setAudience(settingsType.getAudienceClaim());
        settings.setLifetime(settingsType.getLifetimeClaim());
        settings.setIncludeNotBeforeClaim(settingsType.getIncludeNbfClaim());
        settings.setRequestSigningAlgorithm(settingsType.getRequestObjectSigningAlgorithm());
        settings.setUserInfoEndpoint(new Endpoint(null, settingsType.getUserInfoEndpoint(), idpConn.getBaseUrl()));
        settings.setClientId(settingsType.getClientID());
        settings.setClientSecret(settingsType.getClientSecret());
        OIDCRequestParamType[] requestParams = settingsType.getRequestParamArray();
        if (requestParams != null) {
            ArrayList<OIDCRequestParamSetting> reqParams = new ArrayList<OIDCRequestParamSetting>(requestParams.length);
            for (OIDCRequestParamType requestParam : requestParams) {
                SourceType sourceType = this.populateSourceType(requestParam);
                String delimiter = null;
                String authenticationSourceId = null;
                if (SourceType.TRACKED_HTTP_PARAMS.equals((Object)sourceType)) {
                    delimiter = ".";
                    authenticationSourceId = "trackedparams";
                }
                OIDCRequestParamSetting param = new OIDCRequestParamSetting(requestParam.getName(), new AttrMappingValue(sourceType, requestParam.getValue(), delimiter, authenticationSourceId), requestParam.getOverride());
                reqParams.add(param);
            }
            settings.setRequestParams(reqParams);
        }
        settings.setEnableProofKeyForCodeExchange(settingsType.getEnableProofKeyForCodeExchange());
        if (settingsType.isSetTrackUserSessionsForLogout()) {
            settings.setTrackUserSessionsForLogout(settingsType.getTrackUserSessionsForLogout());
        }
        if (settingsType.getPushedAuthorizationRequestEndpoint() != null) {
            settings.setPushedAuthorizationRequestEndpoint(new Endpoint(null, settingsType.getPushedAuthorizationRequestEndpoint(), idpConn.getBaseUrl()));
        }
        if (settingsType.getLogoutEndpoint() != null) {
            settings.setLogoutEndpoint(new Endpoint(null, settingsType.getLogoutEndpoint(), idpConn.getBaseUrl()));
        }
        idpConn.setOidcSettings(settings);
    }

    private SourceType populateSourceType(OIDCRequestParamType requestParam) {
        SourceType sourceType = StringUtils.isEmpty((String)requestParam.getType()) ? (StringUtils.isEmpty((String)requestParam.getValue()) ? SourceType.NO_MAPPING : SourceType.TEXT) : SourceTypeString.strToType(requestParam.getType());
        return sourceType;
    }

    protected void fillInboundProvisioningDomain(IdpConnection idpConn, PFInboundProvisioningRoleDescriptorType inboundProvisioningRoleDescriptorType) {
        InboundProvisioningType inboundProvisioningType = inboundProvisioningRoleDescriptorType.getInboundProvisioning();
        ScimUserProvisioning inboundProvisioning = new ScimUserProvisioning();
        String scimVersion = inboundProvisioningType.getScimVersion();
        if (ScimVersion.SCIM20.name().equals(scimVersion)) {
            inboundProvisioning.setVersion(ScimVersion.SCIM20);
        } else {
            inboundProvisioning.setVersion(ScimVersion.SCIM11);
        }
        inboundProvisioning.setDocumentationUri(inboundProvisioningType.getDocumentationUri());
        this.getAttributeMapping(inboundProvisioningType.getWriteUsersMapping().getAttributeSource(), inboundProvisioningType.getWriteUsersMapping().getAttributeMapArray(), null, inboundProvisioning.getWriteUsersAttributeMapping());
        this.getAttributeMapping(inboundProvisioningType.getReadUsersMapping().getAttributeSource(), inboundProvisioningType.getReadUsersMapping().getAttributeMapArray(), null, inboundProvisioning.getReadUsersAttributeMapping());
        if (this.isInboundProvisioningWriteGroupsExists(inboundProvisioningType)) {
            this.getAttributeMapping(inboundProvisioningType.getWriteGroupsMapping().getAttributeSource(), inboundProvisioningType.getWriteGroupsMapping().getAttributeMapArray(), null, inboundProvisioning.getWriteGroupsAttributeMapping());
        }
        if (this.isInboundProvisioningReadGroupsExist(inboundProvisioningType)) {
            this.getAttributeMapping(inboundProvisioningType.getReadGroupsMapping().getAttributeSource(), inboundProvisioningType.getReadGroupsMapping().getAttributeMapArray(), null, inboundProvisioning.getReadGroupsAttributeMapping());
        }
        MaskedAttributeContract readUserContract = inboundProvisioning.getReadUsersAttributeContract();
        this.fillMaskedAttributeContract(inboundProvisioningType.getReadUsersMapping().getExtendedAttributeContract(), readUserContract);
        this.fillInboundProvisioningReadContract(inboundProvisioning, readUserContract);
        if (inboundProvisioning.getReadGroupsAttributeContract() != null && inboundProvisioningType.getReadGroupsMapping() != null) {
            MaskedAttributeContract readGroupContract = inboundProvisioning.getReadGroupsAttributeContract();
            this.fillMaskedAttributeContract(inboundProvisioningType.getReadGroupsMapping().getExtendedAttributeContract(), readGroupContract);
            this.fillInboundProvisioningReadContract(inboundProvisioning, readGroupContract, true);
        }
        inboundProvisioning.setPermanentlyDeleteUsersOnDelete(inboundProvisioningType.getPermanentlyDeleteUsersOnDelete());
        if (ScimVersion.SCIM20.equals((Object)inboundProvisioning.getVersion())) {
            this.fillInboundProvisioningCustomScim2Domain(inboundProvisioning, inboundProvisioningType);
        } else {
            this.fillInboundProvisioningCustomScimDomain(inboundProvisioning, inboundProvisioningType);
        }
        IdentityStoreProvisionerType identityStoreProvisioner = inboundProvisioningType.getReadUsersMapping().getIdentityStoreProvisioner();
        if (identityStoreProvisioner != null) {
            inboundProvisioning.setUserRepositoryType(InboundProvisioningUserRepositoryType.IDENTITY_STORE);
            IdentityStoreProvisionerInstance identityStoreProvisionerInstance = new IdentityStoreProvisionerInstance();
            identityStoreProvisionerInstance.setId(identityStoreProvisioner.getId());
            identityStoreProvisionerInstance.setName(identityStoreProvisioner.getDescription());
            inboundProvisioning.setIdentityStoreProvisionerId(identityStoreProvisionerInstance.getId());
        } else {
            inboundProvisioning.setUserRepositoryType(InboundProvisioningUserRepositoryType.ACTIVE_DIRECTORY);
        }
        idpConn.setInboundProvisioning(inboundProvisioning);
    }

    protected void fillInboundProvisioningCustomScimDomain(ScimUserProvisioning targetInboundProvisioningDomain, InboundProvisioningType sourceInboundProvisioningType) {
        com.pingidentity.scim11.schema.Schema sourceSchema = sourceInboundProvisioningType.getScim();
        if (sourceSchema != null) {
            Schema targetSchema = ConnectionUtil.getDomainSchema(sourceSchema);
            targetInboundProvisioningDomain.setCustomScim(targetSchema);
        }
    }

    protected void fillInboundProvisioningCustomScim2Domain(ScimUserProvisioning targetInboundProvisioningDomain, InboundProvisioningType sourceInboundProvisioningType) {
        Scim2SchemaType sourceSchema = sourceInboundProvisioningType.getScim2();
        if (sourceSchema != null) {
            Scim2Schema targetSchema = new Scim2Schema();
            targetSchema.setSchema(sourceSchema.getName());
            targetSchema.setDescription(sourceSchema.getDescription());
            targetSchema.setName(sourceSchema.getName());
            Scim2CustomAttributeType[] customAttributes = sourceSchema.getCustomAttributes().getCustomAttributeArray();
            if (customAttributes != null) {
                ArrayList<Scim2SchemaAttribute> targetAttributes = new ArrayList<Scim2SchemaAttribute>();
                for (Scim2CustomAttributeType customAttribute : customAttributes) {
                    Scim2SchemaAttribute targetCustomAttribute = new Scim2SchemaAttribute();
                    targetCustomAttribute.setName(customAttribute.getName());
                    targetCustomAttribute.setType(customAttribute.getType());
                    targetCustomAttribute.setDescription(customAttribute.getDescription());
                    targetCustomAttribute.setMutability(customAttribute.getMutability());
                    targetCustomAttribute.setUniqueness(customAttribute.getUniqueness());
                    targetCustomAttribute.setRequired(customAttribute.getRequired());
                    targetCustomAttribute.setReturned(customAttribute.getReturned());
                    targetCustomAttribute.setCaseExact(customAttribute.getCaseExact());
                    targetCustomAttribute.setMultiValued(customAttribute.getMultivalued());
                    Scim2CustomAttributeType.CanonicalValues canonicalValues = customAttribute.getCanonicalValues();
                    if (canonicalValues != null) {
                        String[] values = canonicalValues.getCanonicalValueArray();
                        targetCustomAttribute.setCanonicalValues(new ArrayList<String>(Arrays.asList(values)));
                    }
                    if (customAttribute.getSubAttributes() != null) {
                        ArrayList<Scim2SubAttribute> subAttributes = new ArrayList<Scim2SubAttribute>();
                        for (Scim2SubAttributeType subAttribute : customAttribute.getSubAttributes().getSubAttributeArray()) {
                            Scim2SubAttribute targetSubAttr = new Scim2SubAttribute();
                            targetSubAttr.setName(subAttribute.getName());
                            targetSubAttr.setDescription(subAttribute.getDescription());
                            targetSubAttr.setType(subAttribute.getType());
                            targetSubAttr.setMutability(subAttribute.getMutability());
                            targetSubAttr.setUniqueness(subAttribute.getUniqueness());
                            targetSubAttr.setRequired(subAttribute.getRequired());
                            targetSubAttr.setReturned(subAttribute.getReturned());
                            targetSubAttr.setCaseExact(subAttribute.getCaseExact());
                            subAttributes.add(targetSubAttr);
                        }
                        targetCustomAttribute.setSubAttributes(subAttributes);
                    }
                    targetAttributes.add(targetCustomAttribute);
                }
                targetSchema.setAttributes(targetAttributes);
            }
            targetInboundProvisioningDomain.setCustomScim2Schema(targetSchema);
        }
    }

    public static Schema getDomainSchema(com.pingidentity.scim11.schema.Schema sourceSchema) {
        Schema targetSchema = new Schema();
        if (sourceSchema.getAttributes() != null) {
            com.pingidentity.scim11.schema.SchemaAttribute[] sourceSchemaAttributes = sourceSchema.getAttributes().getAttributeArray();
            HashSet<String> schemas = new HashSet<String>();
            ArrayList<SchemaAttribute> targetAttributes = new ArrayList<SchemaAttribute>();
            ArrayList<SchemaAttribute> targetSchemaAttributesList = new ArrayList<SchemaAttribute>();
            for (com.pingidentity.scim11.schema.SchemaAttribute sourceSchemaAttribute : sourceSchemaAttributes) {
                SchemaAttribute targetSchemaAttribute = new SchemaAttribute();
                targetSchemaAttribute.setName(sourceSchemaAttribute.getName());
                targetSchemaAttribute.setMultiValued(sourceSchemaAttribute.getMultiValued());
                targetSchemaAttribute.setSchema(sourceSchemaAttribute.getSchema());
                schemas.add(targetSchemaAttribute.getSchema());
                if (sourceSchemaAttribute.getSubAttributes() != null) {
                    SchemaSubAttribute[] sourceSubAttributeArray;
                    ArrayList<org.sourceid.saml20.domain.scim.model.SchemaSubAttribute> targetSubAttributes = new ArrayList<org.sourceid.saml20.domain.scim.model.SchemaSubAttribute>();
                    for (SchemaSubAttribute sourceSubAttribute : sourceSubAttributeArray = sourceSchemaAttribute.getSubAttributes().getSubAttributeArray()) {
                        org.sourceid.saml20.domain.scim.model.SchemaSubAttribute targetSubAttribute = new org.sourceid.saml20.domain.scim.model.SchemaSubAttribute();
                        targetSubAttribute.setName(sourceSubAttribute.getName());
                        if (sourceSubAttribute.getName().equals("type")) {
                            targetSubAttribute.getCanonicalValues().addAll(Arrays.asList(sourceSubAttribute.getCanonicalValuesArray()));
                        }
                        targetSubAttributes.add(targetSubAttribute);
                    }
                    ArrayList<org.sourceid.saml20.domain.scim.model.SchemaSubAttribute> targetSubAttrs = new ArrayList<org.sourceid.saml20.domain.scim.model.SchemaSubAttribute>();
                    targetSubAttrs.addAll(targetSubAttributes);
                    targetSchemaAttribute.setSubAttributes(targetSubAttrs);
                    if (targetSchemaAttribute.getSubAttributes().size() > 0) {
                        targetSchemaAttribute.setType("complex");
                    }
                }
                targetSchemaAttributesList.add(targetSchemaAttribute);
            }
            targetAttributes.addAll(targetSchemaAttributesList);
            targetSchema.setAttributes(targetAttributes);
            targetSchema.setSchema(sourceSchema.getSchema());
            if (schemas.size() == 0 && sourceSchema.getSchema() != null) {
                schemas.add(sourceSchema.getSchema());
            }
            targetSchema.setSchemas(schemas);
        }
        return targetSchema;
    }

    protected void fillInboundProvisioningCustomScimType(InboundProvisioningType targetInboundProvisioningType, ScimUserProvisioning sourceScimUserProvisioningDomain) {
        Schema sourceSchema = sourceScimUserProvisioningDomain.getCustomScim();
        com.pingidentity.scim11.schema.Schema targetSchema = ConnectionUtil.getXmlSchema(sourceSchema);
        targetInboundProvisioningType.setScim(targetSchema);
    }

    public static com.pingidentity.scim11.schema.Schema getXmlSchema(Schema sourceSchema) {
        com.pingidentity.scim11.schema.Schema targetSchema = Schema.Factory.newInstance();
        List<SchemaAttribute> sourceSchemaAttributes = sourceSchema.getAttributes();
        if (sourceSchemaAttributes != null) {
            Schema.Attributes targetSchemaAttributes = Schema.Attributes.Factory.newInstance();
            com.pingidentity.scim11.schema.SchemaAttribute[] targetAttributes = new com.pingidentity.scim11.schema.SchemaAttribute[sourceSchemaAttributes.size()];
            int attributeCounter = 0;
            for (SchemaAttribute sourceAttribute : sourceSchemaAttributes) {
                com.pingidentity.scim11.schema.SchemaAttribute targetAttribute = SchemaAttribute.Factory.newInstance();
                targetAttribute.setName(sourceAttribute.getName());
                targetAttribute.setMultiValued(sourceAttribute.isMultiValued().booleanValue());
                targetAttribute.setSchema(sourceAttribute.getSchema());
                List<org.sourceid.saml20.domain.scim.model.SchemaSubAttribute> sourceAttributeSubAttributes = sourceAttribute.getSubAttributes();
                if (sourceAttributeSubAttributes != null) {
                    int subAttributeSize = sourceAttributeSubAttributes.size();
                    SchemaSubAttribute[] targetSubAttributesArray = new SchemaSubAttribute[subAttributeSize];
                    int subAttributeCounter = 0;
                    for (org.sourceid.saml20.domain.scim.model.SchemaSubAttribute sourceSubAttribute : sourceAttributeSubAttributes) {
                        SchemaSubAttribute targetSubAttribute = SchemaSubAttribute.Factory.newInstance();
                        targetSubAttribute.setName(sourceSubAttribute.getName());
                        if (sourceSubAttribute.getName().equals("type")) {
                            int canonicalValuesCounter = 0;
                            String[] targetCanonicalValues = new String[sourceSubAttribute.getCanonicalValues().size()];
                            Iterator<String> iterator = sourceSubAttribute.getCanonicalValues().iterator();
                            while (iterator.hasNext()) {
                                String sourceCanonicalValue;
                                targetCanonicalValues[canonicalValuesCounter] = sourceCanonicalValue = iterator.next();
                                ++canonicalValuesCounter;
                            }
                            targetSubAttribute.setCanonicalValuesArray(targetCanonicalValues);
                        }
                        targetSubAttributesArray[subAttributeCounter] = targetSubAttribute;
                        ++subAttributeCounter;
                    }
                    SchemaAttribute.SubAttributes targetAttributeSubAttributes = SchemaAttribute.SubAttributes.Factory.newInstance();
                    targetAttributeSubAttributes.setSubAttributeArray(targetSubAttributesArray);
                    targetAttribute.setSubAttributes(targetAttributeSubAttributes);
                    if (subAttributeCounter > 0) {
                        targetAttribute.setType("complex");
                    }
                }
                targetAttributes[attributeCounter] = targetAttribute;
                ++attributeCounter;
            }
            targetSchemaAttributes.setAttributeArray(targetAttributes);
            if (sourceSchema.getSchemas() != null && sourceSchema.getSchemas().iterator().hasNext()) {
                targetSchema.setSchema(sourceSchema.getSchemas().iterator().next());
            }
            targetSchema.setAttributes(targetSchemaAttributes);
        }
        return targetSchema;
    }

    private void fillInboundProvisioningReadContract(ScimUserProvisioning inboundProvisioning, MaskedAttributeContract contract) {
        this.fillInboundProvisioningReadContract(inboundProvisioning, contract, false);
    }

    private void fillInboundProvisioningReadContract(ScimUserProvisioning inboundProvisioning, MaskedAttributeContract contract, boolean forGroups) {
        HashSet<String> immutableAttributeNamesForReadUser = new HashSet<String>();
        Map<String, List<AttrMappingValue>> writeMapping = forGroups ? inboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping() : inboundProvisioning.getWriteUsersAttributeMapping().getAttributeMapping();
        for (Map.Entry<String, List<AttrMappingValue>> writeMappingEntry : writeMapping.entrySet()) {
            for (AttrMappingValue value : writeMappingEntry.getValue()) {
                if (value.getType() == SourceType.SCIM_USER || value.getType() == SourceType.SCIM_GROUP) {
                    String scimAttribute = value.getValue();
                    immutableAttributeNamesForReadUser.add(scimAttribute);
                    contract.removeMutableAttributeName(scimAttribute);
                    continue;
                }
                if (value.getType() != SourceType.EXPRESSION) continue;
                try {
                    List<String> supportedScimAttrs;
                    Object parsedExpression = Ognl.parseExpression((String)value.getValue());
                    OgnlHelper ognlHelper = new OgnlHelper();
                    ognlHelper.searchForAllVariableNames(parsedExpression);
                    if (forGroups) {
                        supportedScimAttrs = GroupConstants.getAllIds();
                    } else {
                        ScimUserConstants userConstants = ScimUserConstantsFactory.getScimUserConstants(inboundProvisioning.getVersion());
                        supportedScimAttrs = userConstants.getAllIds();
                    }
                    for (String ognlAttr : ognlHelper.getList()) {
                        if (!supportedScimAttrs.contains(ognlAttr)) continue;
                        immutableAttributeNamesForReadUser.add(ognlAttr);
                        contract.removeMutableAttributeName(ognlAttr);
                    }
                }
                catch (OgnlException e1) {
                    log.warn((Object)"Unable to parse OGNL Expression to retrieve SCIM attributes");
                }
            }
        }
        contract.setImmutableAttributeNames(immutableAttributeNamesForReadUser);
    }

    private void loadModulesIntoConnection(ConnectionBase connBase) {
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        List<ConnectionModuleConfiguration> moduleConfigs = moduleSupport.getConfigurations(connBase.getEntityId(), connBase.getRoleType());
        connBase.setConnectionModuleConfigurations(moduleConfigs);
    }

    protected void setSystemIdOnConn(ConnectionBase connBase, String id) {
        connBase.setId(id);
    }

    protected EntityExtensionType getEntityExtType(EntityDescriptorType entityDescType) {
        ExtensionsType extensions = entityDescType.getExtensions();
        return XPathUtil.selectFirst((XmlObject)extensions, XPATH_ENTITY_EXT, EntityExtensionType.class, entityDescType.getID());
    }

    public SpConnection toSpConn(EntityDescriptorType entityDescType) {
        String entityId = entityDescType.getEntityID();
        SpConnection spConnection = new SpConnection(entityId);
        spConnection.setEntityIdOnDisk(entityId);
        this.fillBaseConn(spConnection, entityDescType);
        SPSSODescriptorType[] spSsoArray = entityDescType.getSPSSODescriptorArray();
        if (spSsoArray.length > 0) {
            this.getSpSsoConnInfoFromXmlBean(entityDescType, spConnection);
        } else {
            this.resetEnabledProfiles(spConnection.getEnabledProfiles());
        }
        RoleDescriptorType[] roleDescArray = entityDescType.getRoleDescriptorArray();
        if (roleDescArray.length > 0) {
            for (RoleDescriptorType roleDescType : roleDescArray) {
                if (roleDescType instanceof AttributeQueryDescriptorType) {
                    AttributeQueryDescriptorType attributeQueryDescType = (AttributeQueryDescriptorType)roleDescType;
                    this.getAttributeQueryDescFromXmlBean(spConnection, attributeQueryDescType);
                    continue;
                }
                if (roleDescType instanceof PFSpWsTrustRoleDescriptorType) {
                    this.processRoleExtensionBaseConnInfo(roleDescType, spConnection);
                    this.fillWsTrustIdpSettings(spConnection, (PFSpWsTrustRoleDescriptorType)roleDescType);
                    continue;
                }
                if (!(roleDescType instanceof PFNoopRoleDescriptorType)) continue;
                this.processRoleExtensionBaseConnInfo(roleDescType, spConnection);
            }
        }
        String applicationName = XmlBeansUtil.getAttributeValue((XmlObject)entityDescType, METADATA_EXT_NS, ATTR_NAME_APPLICATION_NAME);
        spConnection.setApplicationName(applicationName);
        URL applicationIconUrl = this.getApplicationIconUrl(entityDescType);
        spConnection.setApplicationIconUrl(applicationIconUrl);
        return spConnection;
    }

    private void processAvailableCerts(PFAvailableCertsRoleDescriptorType roleDescType, ConnectionBase conn) {
        HashSet<Cert> availableCerts = new HashSet<Cert>();
        for (AvailableCertType availableCertType : roleDescType.getAvailableCertArray()) {
            try {
                Cert cert = Cert.importCert(availableCertType.getBase64EncodedCert());
                cert.setAlias(availableCertType.getAlias());
                availableCerts.add(cert);
            }
            catch (CertificateException e) {
                log.warn((Object)("Unable to load cert " + availableCertType.getAlias() + " for connection " + conn.getEntityId() + " due to " + e.getMessage() + ". This cert will not be usable with the connection."));
            }
        }
        conn.getDsigVerificationCerts().setOtherVerificationCerts(availableCerts);
    }

    private boolean isLegacyRedundantSigningEnabled() {
        return this.config.getBooleanValue("EnableRedundantSigning", false);
    }

    private boolean isSignResponseAsRequired(SPSSODescriptorType spssoDescriptorType) {
        Protocol protocol = ProtocolUtil.getProtocol((RoleDescriptorType)spssoDescriptorType);
        if (Protocol.SAML20.equals(protocol)) {
            if (spssoDescriptorType.isSetSignResponseAsRequired()) {
                return !spssoDescriptorType.getWantAssertionsSigned() || spssoDescriptorType.getSignResponseAsRequired();
            }
            return this.isLegacyRedundantSigningEnabled() || !spssoDescriptorType.getWantAssertionsSigned();
        }
        return true;
    }

    private void getSpSsoConnInfoFromXmlBean(EntityDescriptorType entityDescType, SpConnection spConnection) {
        SPSSODescriptorType spType = entityDescType.getSPSSODescriptorArray(0);
        spConnection.setAuthnRequestsSigned(spType.isSetAuthnRequestsSigned() && spType.getAuthnRequestsSigned());
        IndexedEndpointType[] acsArray = spType.getAssertionConsumerServiceArray();
        IndexedEndpoints acsEndpts = EndpointUtil.toIndexedEndpoints(acsArray, this.getBaseUrl(entityDescType));
        spConnection.setAssertionConsumerServiceEndpoints(acsEndpts);
        spConnection.setWantAssertionsSigned(spType.getWantAssertionsSigned());
        spConnection.setSignResponseAsRequired(this.isSignResponseAsRequired(spType));
        try {
            RoleExtensionType roleExtensionType = this.processBaseConnectionInfo((SSODescriptorType)spType, spConnection, entityDescType);
            if (roleExtensionType != null && roleExtensionType.isSetSP()) {
                String[] nameIdFormatArray;
                SpExtensionType spExtType = roleExtensionType.getSP();
                spConnection.setAssertionValidityAfterMinutes(spExtType.getAssertionValidityAfterMinutes());
                spConnection.setAssertionValidityBeforeMinutes(spExtType.getAssertionValidityBeforeMinutes());
                if (spExtType.isSetDefaultTargetResource()) {
                    spConnection.setDefaultTargetResource(spExtType.getDefaultTargetResource());
                }
                if (spExtType.getConnectionTargetType() != null) {
                    spConnection.setConnectionTargetType(spExtType.getConnectionTargetType());
                } else {
                    spConnection.setConnectionTargetType("Standard");
                }
                NameIdentifierMappingType nameIdentifierType = spExtType.getNameIdentifierMappingType();
                if (nameIdentifierType != null) {
                    spConnection.setIncludeAdditionalAttributes(nameIdentifierType.getIncludeAdditionalAttributes());
                    spConnection.setIncludeAdditionalTransientAttributes(nameIdentifierType.getIncludeAdditionalTransientAttributes());
                }
                if ((nameIdFormatArray = spType.getNameIDFormatArray()).length == 0) {
                    spConnection.setNameIdFormats(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
                } else {
                    spConnection.setNameIdFormats(Arrays.asList(nameIdFormatArray));
                }
                ArrayList<AdapterToAssertionMapping> adapterMappings = new ArrayList<AdapterToAssertionMapping>();
                ArrayList<C2cContractToAssertionMapping> c2cMappings = new ArrayList<C2cContractToAssertionMapping>();
                for (AdapterToAssertionMappingType adapterToAssertionMappingType : spExtType.getAdapterToAssertionMappingArray()) {
                    adapterMappings.add(this.convertToAdapterToAssertionMapping(adapterToAssertionMappingType, spConnection.getEntityId()));
                }
                for (AdapterToAssertionMappingType adapterToAssertionMappingType : spExtType.getC2CContractToAssertionMappingArray()) {
                    c2cMappings.add(this.convertToC2cContractToAssertionMapping((C2CContractToAssertionMappingType)adapterToAssertionMappingType));
                }
                spConnection.setAdapterMappings(adapterMappings);
                spConnection.setC2cMappings(c2cMappings);
                boolean enableCDCDuringSSO = HandleAuthnRequest.isEnableCDCDuringSSO();
                if (spExtType.isSetEnableCDCDuringSSO()) {
                    enableCDCDuringSSO = spExtType.getEnableCDCDuringSSO();
                }
                spConnection.setEnableCDCDuringSSO(enableCDCDuringSSO);
                if (spConnection.getProtocol() == Protocol.WSFED) {
                    WsFedSpSettings wsFedSettings = new WsFedSpSettings();
                    wsFedSettings.setTokenType(WsTrustTokenType.SAML11);
                    if (spExtType.isSetWsFedSettings()) {
                        WsFedSettingsType wsFedSettingsType = spExtType.getWsFedSettings();
                        try {
                            WsTrustTokenType wsTrustTokenType = WsTrustTokenType.valueOf(wsFedSettingsType.getTokenType());
                            wsFedSettings.setTokenType(wsTrustTokenType);
                            wsFedSettings.setWsTrustVersion(wsFedSettingsType.getWsTrustVersion());
                        }
                        catch (Exception exception) {
                            log.error((Object)exception);
                        }
                    }
                    spConnection.setWsFedSettings(wsFedSettings);
                }
            }
            this.setAttributeContract(spType, spConnection);
        }
        catch (CertificateException ex) {
            log.info((Object)ex.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)ex);
            }
            throw new RuntimeException("Exception in importing certificates from metadata.", ex);
        }
    }

    private AdapterToAssertionMapping convertToAdapterToAssertionMapping(AdapterToAssertionMappingType mappingType, String entityId) {
        AdapterToAssertionMapping adapterToAssertionMapping = new AdapterToAssertionMapping();
        if (mappingType.isSetAdapterConfiguration()) {
            ConnectionOverrideAdapterConfigurationType configType = mappingType.getAdapterConfiguration();
            IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)this.idpAdapterMgmtSupport.createInstanceFromConfigType(mappingType.getAdapterInstanceId(), (ConfigType)configType, configType.getParentId(), entityId);
            adapterToAssertionMapping.setConnectionOverrideInstance(instance);
        }
        adapterToAssertionMapping.setAbortIfNotFoundInAnyDataSources(mappingType.getAbortIfNotFoundInAnyDataSources());
        AttributeMappingType[] attrMappingTypes = mappingType.getAttributeMappingArray();
        List<AttributeMapping> attributeMappingList = this.getAttributeMappingList(attrMappingTypes);
        adapterToAssertionMapping.setAttributeMappingList(attributeMappingList);
        AttributeMapping attributeMapping = this.getAttributeMapping(mappingType.getDefaultAttributeMapping());
        adapterToAssertionMapping.setDefaultAttributeMapping(attributeMapping);
        adapterToAssertionMapping.setRestrictVirtualServerIds(mappingType.getRestrictVirtualServerIds());
        adapterToAssertionMapping.setRestrictedVirtualServerIds(Arrays.asList(mappingType.getRestrictedVirtualServerIdArray()));
        this.setIdpAdapterInstanceID(adapterToAssertionMapping, mappingType.getAdapterInstanceId());
        return adapterToAssertionMapping;
    }

    private C2cContractToAssertionMapping convertToC2cContractToAssertionMapping(C2CContractToAssertionMappingType mappingType) {
        C2cContractToAssertionMapping c2cContractToAssertionMapping = new C2cContractToAssertionMapping();
        c2cContractToAssertionMapping.setAbortIfNotFoundInAnyDataSources(mappingType.getAbortIfNotFoundInAnyDataSources());
        AttributeMappingType[] attrMappingTypes = mappingType.getAttributeMappingArray();
        List<AttributeMapping> attributeMappingList = this.getAttributeMappingList(attrMappingTypes);
        c2cContractToAssertionMapping.setAttributeMappingList(attributeMappingList);
        AttributeMapping attributeMapping = this.getAttributeMapping(mappingType.getDefaultAttributeMapping());
        c2cContractToAssertionMapping.setDefaultAttributeMapping(attributeMapping);
        c2cContractToAssertionMapping.setRestrictVirtualServerIds(mappingType.getRestrictVirtualServerIds());
        c2cContractToAssertionMapping.setRestrictedVirtualServerIds(Arrays.asList(mappingType.getRestrictedVirtualServerIdArray()));
        this.setC2cContractToAssertionMappingId(mappingType, c2cContractToAssertionMapping);
        return c2cContractToAssertionMapping;
    }

    protected void setC2cContractToAssertionMappingId(C2CContractToAssertionMappingType mappingType, C2cContractToAssertionMapping c2cContractToAssertionMapping) {
        c2cContractToAssertionMapping.setContractId(mappingType.getC2CContractId());
    }

    protected void setIdpAdapterInstanceID(AdapterToAssertionMapping adapterToAssertionMapping, String adapterInstanceId) {
        adapterToAssertionMapping.setAdapterInstanceId(adapterInstanceId);
    }

    private List<AttributeMapping> getAttributeMappingList(AttributeMappingType[] attribMappingTypes) {
        ArrayList<AttributeMapping> retList = new ArrayList<AttributeMapping>();
        for (AttributeMappingType attribMappingType : attribMappingTypes) {
            retList.add(this.getAttributeMapping(attribMappingType));
        }
        return retList;
    }

    public AttributeMapping getAttributeMapping(AttributeMappingType attribMappingType) {
        AttributeMapping attribMapping = null;
        if (attribMappingType != null) {
            attribMapping = new AttributeMapping();
            this.getAttributeMapping(attribMappingType.getAttributeSourceArray(), attribMappingType.getAttributeMapArray(), attribMappingType.getTokenAuthorizationIssuanceCriteria(), attribMapping);
        }
        return attribMapping;
    }

    public AttributeMapping getFragmentInputAttributeMapping(AttributeMappingType attribMappingType) {
        AttributeMapping attribMapping = null;
        if (attribMappingType != null) {
            attribMapping = new AttributeMapping();
            this.getAttributeMapping(attribMappingType.getAttributeSourceArray(), attribMappingType.getAttributeMapArray(), attribMappingType.getTokenAuthorizationIssuanceCriteria(), attribMapping, true);
        }
        return attribMapping;
    }

    private WsTrustTokenAttributeContract getWsTrustAttributeContract(ExtendedAttributeContractType extendedAttributeContractType) {
        WsTrustTokenAttributeContract attributeContract = new WsTrustTokenAttributeContract();
        this.fillMaskedAttributeContract(extendedAttributeContractType, attributeContract);
        return attributeContract;
    }

    private void fillMaskedAttributeContract(ExtendedAttributeContractType extendedAttributeContractType, MaskedAttributeContract attributeContract) {
        ExtendedAttributeType[] extendedAttributes;
        if (extendedAttributeContractType != null && (extendedAttributes = extendedAttributeContractType.getExtendedAttributeArray()) != null) {
            for (ExtendedAttributeType extendedAttribute : extendedAttributes) {
                String attributeName = extendedAttribute.getAttributeName();
                attributeContract.addMutableAttributeName(attributeName);
                if (extendedAttribute.getNamespace() != null) {
                    attributeContract.addMutableAttributeInfo(attributeName, extendedAttribute.getNamespace());
                }
                if (!extendedAttribute.getMaskValue()) continue;
                attributeContract.addMaskedAttributeName(attributeName);
            }
        }
    }

    private void setAttributeContract(SPSSODescriptorType spType, SpConnection spConn) {
        boolean isWsFedJwt = spConn.getProtocol() == Protocol.WSFED && spConn.getWsFedSettings() != null && spConn.getWsFedSettings().getTokenType() == WsTrustTokenType.JWT;
        AttributeContract contract = isWsFedJwt ? new AttributeContract() : new AssertionAttributeContract(spConn.sendPseudonymAsNameId(), spConn.sendTransientAsNameId());
        AttributeConsumingServiceType[] attributeCSs = spType.getAttributeConsumingServiceArray();
        if (attributeCSs != null && attributeCSs.length > 0) {
            RequestedAttributeType[] reqAttribTypeArray;
            AttributeConsumingServiceType attribConsumingSvcType = attributeCSs[0];
            for (RequestedAttributeType aReqAttribTypeArray : reqAttribTypeArray = attribConsumingSvcType.getRequestedAttributeArray()) {
                String attributeNameFormat = aReqAttribTypeArray.getNameFormat();
                if (StringUtils.isBlank((String)attributeNameFormat)) {
                    if (spConn.getProtocol() == Protocol.SAML11) {
                        ConfigStore createResponseConfig = ConfigStoreFarm.getConfig(CreateResponse.class);
                        attributeNameFormat = createResponseConfig.getStringValue("ns", "ns:unspecified");
                    } else if (spConn.getProtocol() == Protocol.WSFED) {
                        if (!isWsFedJwt) {
                            attributeNameFormat = "http://schemas.xmlsoap.org/claims";
                        }
                    } else if (spConn.getProtocol() == Protocol.SAML20) {
                        attributeNameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:basic";
                    }
                }
                contract.addMutableAttributeInfo(aReqAttribTypeArray.getName(), attributeNameFormat);
            }
        }
        spConn.setAttributeContract(contract);
    }

    private RoleExtensionType processBaseConnectionInfo(SSODescriptorType ssoDescriptorType, ConnectionBase connBase, EntityDescriptorType edtype) throws CertificateException {
        ProtocolUtil.setProtocolOnDomain((RoleDescriptorType)ssoDescriptorType, connBase);
        URL baseUrl = this.getBaseUrl(edtype);
        IndexedEndpointType[] indexedEndpoints = ssoDescriptorType.getArtifactResolutionServiceArray();
        IndexedEndpoints artifactResolutionServices = EndpointUtil.toIndexedEndpoints(indexedEndpoints, baseUrl);
        connBase.setArtifactResolutionServices(artifactResolutionServices);
        EndpointGroup sloGroup = EndpointUtil.toEndpointGroup(ssoDescriptorType.getSingleLogoutServiceArray(), baseUrl);
        connBase.setSingleLogoutServices(sloGroup);
        EndpointGroup nimGroup = EndpointUtil.toEndpointGroup(ssoDescriptorType.getManageNameIDServiceArray(), baseUrl);
        connBase.setManageNameIdService(nimGroup.getPrimaryEndpoint());
        RoleExtensionType roleExtensionType = null;
        if (ssoDescriptorType.isSetExtensions()) {
            String ctxId;
            ExtensionsType extensionsType = ssoDescriptorType.getExtensions();
            SourceIDDocument.SourceID sourceID = XPathUtil.selectFirst((XmlObject)extensionsType, XPATH_SOURCEID, SourceIDDocument.SourceID.class, ctxId = connBase.getEncodedEntityId());
            if (sourceID != null) {
                String sourceIdHexString = sourceID.getStringValue();
                byte[] sourceId = HexBin.stringToBytes((String)sourceIdHexString);
                connBase.setSourceId(sourceId);
                connBase.setSourceIdOnDisk(sourceId);
            }
            if ((roleExtensionType = XPathUtil.selectFirst((XmlObject)extensionsType, XPATH_ROLE_EXT, RoleExtensionType.class, ctxId)) != null) {
                connBase.setArtifactTimeoutSeconds(roleExtensionType.getArtifactTimeoutSeconds());
                if (roleExtensionType.isSetIncomingBindings()) {
                    IncomingBindings incomingBindings = connBase.getIncomingBindings();
                    IncomingBindingsType incomingBindingType = roleExtensionType.getIncomingBindings();
                    incomingBindings.setArtifactBinding(incomingBindingType.getArtifact());
                    incomingBindings.setPostBinding(incomingBindingType.getPOST());
                    incomingBindings.setRedirectBinding(incomingBindingType.getRedirect());
                    incomingBindings.setSoapBinding(incomingBindingType.getSOAP());
                }
                if (roleExtensionType.isSetEnabledProfiles()) {
                    EnabledProfiles enabledProfiles = connBase.getEnabledProfiles();
                    EnabledProfilesType enabledProfilesType = roleExtensionType.getEnabledProfiles();
                    enabledProfiles.setIdpInitiatedSSOEnabled(enabledProfilesType.getIDPInitiatedSSO());
                    enabledProfiles.setIdpInitiatedSLOEnabled(enabledProfilesType.getIDPInitiatedSLO());
                    enabledProfiles.setSpInitiatedSSOEnabled(enabledProfilesType.getSPInitiatedSSO());
                    enabledProfiles.setSpInitiatedSLOEnabled(enabledProfilesType.getSPInitiatedSLO());
                }
                if (roleExtensionType.isSetIsActive()) {
                    connBase.setActive(roleExtensionType.getIsActive());
                }
                if (roleExtensionType.isSetLastModified()) {
                    connBase.setLastModified(roleExtensionType.getLastModified());
                }
                if (roleExtensionType.isSetCreationTime()) {
                    connBase.setCreationTime(roleExtensionType.getCreationTime());
                }
                if (roleExtensionType.isSetSelectiveReplicationTime()) {
                    connBase.setSelectiveReplicationTime(roleExtensionType.getSelectiveReplicationTime());
                }
                this.fillRedirectValidationWhitelist(connBase, roleExtensionType);
                for (MessageCustomizationHook hook : roleExtensionType.getMessageCustomizationHookArray()) {
                    String contextName = hook.getContextName();
                    String expression = hook.getStringValue();
                    MessageCustomization value = new MessageCustomization();
                    value.setExpression(expression);
                    connBase.getMessageCustomizationHooks().put(contextName, value);
                }
            }
        }
        this.getKeyDescriptors(ssoDescriptorType, connBase);
        ContactInfo contact = this.getContactInfo(ssoDescriptorType);
        if (contact != null) {
            connBase.setContactInfo(contact);
        }
        return roleExtensionType;
    }

    private void fillRedirectValidationWhitelist(ConnectionBase connBase, RoleExtensionType roleExtType) {
        if (roleExtType.getRedirectValidationWhitelist() != null) {
            ArrayList<UrlWhitelistEntry> whitelist = new ArrayList<UrlWhitelistEntry>();
            for (UrlWhitelistEntryType xmlEntry : roleExtType.getRedirectValidationWhitelist().getUrlWhitelistEntryArray()) {
                UrlWhitelistEntry entry = new UrlWhitelistEntry(xmlEntry.getDomainPattern(), xmlEntry.getPath(), xmlEntry.getAllowQueryAndFragment(), xmlEntry.getRequireHttps());
                whitelist.add(entry);
            }
            connBase.setRedirectValidationWhitelist(whitelist);
        }
    }

    private void getEncryptionFromXml(EntityDescriptorType entityDescriptorType, ConnectionBase connBase) {
        EncryptionSettings encryptionSettings = connBase.getEncryptionSettings();
        EncryptionType encryptionType = XPathUtil.selectFirst((XmlObject)entityDescriptorType, XPATH_ENC, EncryptionType.class, null);
        if (encryptionType != null) {
            this.getEncryptionKeysFromXml(encryptionType, encryptionSettings, entityDescriptorType, connBase.getDsigVerificationCerts().getAllVerificationCerts());
            if (encryptionType.isSetEncryptionPolicy()) {
                EncryptAttributeType[] encryptAttributeArray;
                EncryptionPolicyType encryptionPolicyType = encryptionType.getEncryptionPolicy();
                EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
                if (encryptionPolicyType.isSetEncryptionAlgorithm() && !StringUtils.isBlank((String)encryptionPolicyType.getEncryptionAlgorithm())) {
                    this.logUnsupportedAlgorithms(encryptionPolicyType.getEncryptionAlgorithm(), connBase.getEntityId());
                    encryptionPolicy.setEncryptionAlgorithm(encryptionPolicyType.getEncryptionAlgorithm());
                }
                if (encryptionPolicyType.isSetKeyTransportAlgorithm() && !StringUtils.isBlank((String)encryptionPolicyType.getKeyTransportAlgorithm())) {
                    encryptionPolicy.setKeyTransportAlgorithm(encryptionPolicyType.getKeyTransportAlgorithm());
                }
                if (encryptionPolicyType.isSetEncryptAssertion()) {
                    encryptionPolicy.setEncryptAssertion(encryptionPolicyType.getEncryptAssertion());
                }
                if (encryptionPolicyType.isSetEncryptSubjectNameID()) {
                    encryptionPolicy.setEncryptSubjectNameID(encryptionPolicyType.getEncryptSubjectNameID());
                }
                if (encryptionPolicyType.isSetSLOEncryptSubjectNameID()) {
                    encryptionPolicy.setSloEncryptSubjectNameID(encryptionPolicyType.getSLOEncryptSubjectNameID());
                }
                for (EncryptAttributeType encryptAttributeType : encryptAttributeArray = encryptionPolicyType.getEncryptAttributeArray()) {
                    encryptionPolicy.addEncryptAttribute(encryptAttributeType.getName());
                }
            }
            if (encryptionType.isSetDecryptionPolicy()) {
                DecryptionPolicyType decryptionPolicyType = encryptionType.getDecryptionPolicy();
                DecryptionPolicy decryptionPolicy = encryptionSettings.getDecryptionPolicy();
                if (decryptionPolicyType.isSetAssertionEncrypted()) {
                    decryptionPolicy.setAssertionEncrypted(decryptionPolicyType.getAssertionEncrypted());
                }
                if (decryptionPolicyType.isSetSubjectNameIDEncrypted()) {
                    decryptionPolicy.setSubjectNameIDEncrypted(decryptionPolicyType.getSubjectNameIDEncrypted());
                }
                if (decryptionPolicyType.isSetAttributeEncrypted()) {
                    decryptionPolicy.setAttributeEncrypted(decryptionPolicyType.getAttributeEncrypted());
                }
                if (decryptionPolicyType.isSetSLOSubjectNameIDEncrypted()) {
                    decryptionPolicy.setSloSubjectNameIDEncrypted(decryptionPolicyType.getSLOSubjectNameIDEncrypted());
                }
            }
        }
    }

    protected void getSigningKeyRotationSettingsFromXml(KeyRotationSettingsType rotationSettingsType, ConnectionBase connBase) {
        if (rotationSettingsType != null) {
            KeyRotationSettings rotationSettings = new KeyRotationSettings();
            rotationSettings.setKeySize(rotationSettingsType.getKeySize());
            rotationSettings.setRotationBufferMins(rotationSettingsType.getRotationBufferMins());
            rotationSettings.setSignatureAlgorithm(rotationSettingsType.getSignatureAlgorithm());
            rotationSettings.setValidityPeriodDays(rotationSettingsType.getValidityPeriodDays());
            connBase.setSigningKeyRotationSettings(rotationSettings);
        }
    }

    protected void getEncryptionKeysFromXml(EncryptionType encryptionType, EncryptionSettings encryptionSettings, EntityDescriptorType entityDescriptorType, Set<Cert> availableCerts) {
        PkCert pkCert;
        PkCertAndConnectionCertManager dsigPkCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
        if (encryptionType.isSetDecryptionKeyAlias() && !StringUtils.isBlank((String)encryptionType.getDecryptionKeyAlias())) {
            String decryptionKeyAlias = encryptionType.getDecryptionKeyAlias();
            encryptionSettings.setDecryptionKeyAlias(decryptionKeyAlias);
            pkCert = dsigPkCertManager.getPkCert(decryptionKeyAlias);
            encryptionSettings.setDecryptionPkCert(pkCert);
        }
        String secondaryDecryptionKeyAlias = encryptionType.getSecondaryDecryptionKeyAlias();
        if (encryptionType.isSetSecondaryDecryptionKeyAlias() && !StringUtils.isBlank((String)secondaryDecryptionKeyAlias)) {
            encryptionSettings.setSecondaryDecryptionKeyAlias(secondaryDecryptionKeyAlias);
            pkCert = dsigPkCertManager.getPkCert(secondaryDecryptionKeyAlias);
            encryptionSettings.setSecondaryDecryptionPkCert(pkCert);
        }
        if (encryptionType.isSetEncryptionCertAlias() && !StringUtils.isBlank((String)encryptionType.getEncryptionCertAlias())) {
            String encryptionCertAlias = encryptionType.getEncryptionCertAlias();
            Cert cert = this.getPartnerCert(entityDescriptorType, encryptionCertAlias, availableCerts);
            encryptionSettings.setEncryptionCert(cert);
        }
    }

    private Cert findCertWithAlias(String alias, Set<Cert> certs) throws CertNotFoundException {
        for (Cert cert : certs) {
            if (!alias.equals(cert.getAlias())) continue;
            return cert;
        }
        throw new CertNotFoundException("Could not find cert with alias " + alias + " in the given list.");
    }

    private void getKeyDescriptors(SSODescriptorType ssoDescriptorType, ConnectionBase connBase) throws CertificateException {
        KeyDescriptorType[] keyDescriptorTypeArray = ssoDescriptorType.getKeyDescriptorArray();
        if (keyDescriptorTypeArray != null && keyDescriptorTypeArray.length > 0) {
            ConnectionCerts connectionCerts = connBase.getDsigVerificationCerts();
            Cert firstEncryptionCert = null;
            LinkedHashSet<Cert> activeCerts = new LinkedHashSet<Cert>();
            LinkedHashSet<Cert> inactiveCerts = new LinkedHashSet<Cert>();
            for (KeyDescriptorType keyDescriptorType : keyDescriptorTypeArray) {
                EncryptionMethodType[] encryptionMethods;
                X509DataType[] x509DataArray;
                KeyInfoType keyInfoType;
                KeyTypes.Enum use = keyDescriptorType.getUse();
                if (use == KeyTypes.SIGNING || use == null) {
                    keyInfoType = keyDescriptorType.getKeyInfo();
                    x509DataArray = keyInfoType.getX509DataArray();
                    if (x509DataArray == null) continue;
                    for (X509DataType x509DataType : x509DataArray) {
                        byte[][] certs = x509DataType.getX509CertificateArray();
                        if (certs == null) continue;
                        for (byte[] cert1 : certs) {
                            Cert cert = Cert.importCert(cert1);
                            activeCerts.add(cert);
                        }
                    }
                    continue;
                }
                if (use != KeyTypes.ENCRYPTION) continue;
                keyInfoType = keyDescriptorType.getKeyInfo();
                x509DataArray = keyInfoType.getX509DataArray();
                EncryptionSettings encryptionSettings = connBase.getEncryptionSettings();
                if (x509DataArray != null) {
                    for (X509DataType x509DataType : x509DataArray) {
                        byte[][] certs = x509DataType.getX509CertificateArray();
                        if (certs == null) continue;
                        for (byte[] cert1 : certs) {
                            Cert cert = Cert.importCert(cert1);
                            if (firstEncryptionCert == null) {
                                firstEncryptionCert = cert;
                            }
                            inactiveCerts.add(cert);
                            encryptionSettings.setEncryptionCert(cert);
                        }
                    }
                }
                if ((encryptionMethods = keyDescriptorType.getEncryptionMethodArray()).length <= 0) continue;
                EncryptionPolicy encPolicy = encryptionSettings.getEncryptionPolicy();
                encPolicy.setEncryptionAlgorithm(encryptionMethods[0].getAlgorithm());
            }
            if (activeCerts.isEmpty() && firstEncryptionCert != null) {
                activeCerts.add(firstEncryptionCert);
            }
            connectionCerts.setVerificationCerts(new ArrayList<Cert>(activeCerts), inactiveCerts);
        }
    }

    public void fillInIdpAttributeTypes(IDPSSODescriptorType idpssoDesc, AttributeContract attribContract) {
        for (String attribName : attribContract.getMutableAttributeNames()) {
            AttributeType attributeType = idpssoDesc.addNewAttribute();
            attributeType.setName(attribName);
            String attributeNameFormat = attribContract.getMutableAttributeNameFormat(attribName);
            if (attributeNameFormat == null) {
                attributeNameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:basic";
            }
            attributeType.setNameFormat(attributeNameFormat);
        }
    }

    protected void setTargetAttributeMapping(IdpExtensionType idpExt, Collection<TargetAttributeMapping> targetAttrMappings) {
        for (TargetAttributeMapping targetAttributeMapping : targetAttrMappings) {
            AuthnAdapterInstance instance;
            List<TokenAuthorizationIssuanceCriterion> list;
            TargetAttributeMappingType xmlType = idpExt.addNewTargetAttributeMapping();
            String adapterInstanceId = targetAttributeMapping.getAdapterInstanceId();
            if (adapterInstanceId != null) {
                this.setIdpAdapterIdOnTargetAttrMappingType(xmlType, adapterInstanceId);
            }
            xmlType.setRestrictVirtualServerIds(targetAttributeMapping.isRestrictVirtualServerIds());
            if (targetAttributeMapping.isRestrictVirtualServerIds()) {
                List<String> restrictedVirtualServerIds = targetAttributeMapping.getRestrictedVirtualServerIds();
                String[] restrictedVirtualServerIdArray = restrictedVirtualServerIds.toArray(new String[restrictedVirtualServerIds.size()]);
                xmlType.setRestrictedVirtualServerIdArray(restrictedVirtualServerIdArray);
            }
            Map<String, List<AttrMappingValue>> attributeMapping = targetAttributeMapping.getAttributeMapping();
            for (Map.Entry entry : attributeMapping.entrySet()) {
                String attribName = (String)entry.getKey();
                for (AttrMappingValue attribValue : (List)entry.getValue()) {
                    AttributeMapType attribMapType = xmlType.addNewAttributeMap();
                    attribMapType.setName(attribName);
                    attribMapType.setType(attribValue.getTypeString());
                    attribMapType.setValueText(attribValue.getValue());
                    if (attribValue.getDelimiter() == null) continue;
                    attribMapType.setDelimiter(attribValue.getDelimiter());
                }
            }
            AttributeSource attributeSource = targetAttributeMapping.getAttributeSource();
            if (attributeSource != null) {
                AttributeSourceType attributeSourceType = xmlType.addNewAttributeSource();
                this.fillInAttributeSource(attributeSourceType, attributeSource);
            }
            if ((list = targetAttributeMapping.getTokenAuthorizationIssuanceCriteria()) != null) {
                TokenAuthorizationIssuanceCriteriaType tokenAuthorizationIssuanceCriteriaType = xmlType.addNewTokenAuthorizationIssuanceCriteria();
                for (TokenAuthorizationIssuanceCriterion issuanceCriterion : list) {
                    this.fillInTokenAuthorizationIssuanceCriteria(tokenAuthorizationIssuanceCriteriaType, issuanceCriterion);
                }
            }
            if ((instance = targetAttributeMapping.getConnectionOverrideInstance()) == null || !instance.isConnectionBasedPlugin()) continue;
            ConnectionOverrideAdapterConfigurationType configType = xmlType.addNewAdapterConfiguration();
            this.spAdapterConfigSupport.fillInDoc(instance, (ConfigType)configType);
            configType.setParentId(instance.getParentId());
        }
    }

    private void setConnectionContractMappingType(IdpExtensionType idpExt, Collection<C2cContractAttributeMapping> connContractMappings) {
        for (C2cContractAttributeMapping connContractMapping : connContractMappings) {
            C2CContractMappingType xmlType = idpExt.addNewConnectionContractMapping();
            String contractId = connContractMapping.getContractId();
            C2cContract contract = this.c2cContractManager.getContract(contractId);
            xmlType.setC2CContractId(contractId);
            if (contract != null) {
                xmlType.setC2CContractName(contract.getName());
            }
            xmlType.setRestrictVirtualServerIds(connContractMapping.isRestrictVirtualServerIds());
            if (connContractMapping.isRestrictVirtualServerIds()) {
                List<String> restrictedVirtualServerIds = connContractMapping.getRestrictedVirtualServerIds();
                String[] restrictedVirtualServerIdArray = restrictedVirtualServerIds.toArray(new String[restrictedVirtualServerIds.size()]);
                xmlType.setRestrictedVirtualServerIdArray(restrictedVirtualServerIdArray);
            }
            this.fillInAttributeMappingType((AttributeMappingType)xmlType, connContractMapping);
        }
    }

    protected void setIdpAdapterIdOnTargetAttrMappingType(TargetAttributeMappingType xmlType, String adapterInstanceId) {
        xmlType.setAdapterInstanceId(adapterInstanceId);
    }

    private void fillInAttributeSource(AttributeSourceType attributeSourceType, AttributeSource attributeSource) {
        AttributeSourceConfigHelper.fillInAttributeSource(attributeSourceType, attributeSource);
    }

    protected void setIdOnXmlBean(EntityDescriptorType entityDescriptorType, ConnectionBase connBase) {
        entityDescriptorType.setID(connBase.getId());
    }

    private EntityDescriptorType buildBaseEntityDescType(ConnectionBase connBase) {
        EntityDescriptorType entityDescriptorType = EntityDescriptorType.Factory.newInstance();
        entityDescriptorType.setEntityID(connBase.getEntityId());
        XmlBeansUtil.setAttributeValue((XmlObject)entityDescriptorType, connBase.getName(), METADATA_EXT_NS, ATTR_NAME_NAME);
        this.setIdOnXmlBean(entityDescriptorType, connBase);
        if (connBase.getBaseUrl() != null) {
            URL baseUrl = connBase.getBaseUrl();
            String baseUrlStr = baseUrl.toExternalForm();
            XmlBeansUtil.setAttributeValue((XmlObject)entityDescriptorType, baseUrlStr, METADATA_EXT_NS, ATTR_NAME_BASE_URL);
        }
        String logMode = connBase.getLoggingMode().toString();
        XmlBeansUtil.setAttributeValue((XmlObject)entityDescriptorType, logMode, METADATA_EXT_NS, ATTR_NAME_LOG_LEVEL);
        VirtualIdentity defaultVirtualIdentity = connBase.getDefaultVirtualIdentity();
        String defaultVirtualEntityId = defaultVirtualIdentity.getVirtualEntityId(DomainMode.CONFIGTIME);
        ExtensionsType extensionsType = entityDescriptorType.addNewExtensions();
        EntityExtensionDocument eed = EntityExtensionDocument.Factory.newInstance();
        EntityExtensionType eext = eed.addNewEntityExtension();
        String pfVersion = System.getProperty("pingfederate.version");
        if (pfVersion != null) {
            eext.setPFVersion(pfVersion);
        }
        if (connBase.getLicenseConnectionGroupAssignment() != null) {
            eext.setLicenseGroup(connBase.getLicenseConnectionGroupAssignment());
        }
        if (!StringUtils.isBlank((String)defaultVirtualEntityId)) {
            VirtualIdentityType virtualIdentityType = eext.addNewDefaultVirtualIdentity();
            virtualIdentityType.setEntityID(defaultVirtualEntityId);
        }
        for (VirtualIdentity virtualIdentity : connBase.getVirtualIdentities()) {
            String virtualEntityId = virtualIdentity.getVirtualEntityId(DomainMode.CONFIGTIME);
            if (!StringUtils.isNotEmpty((String)virtualEntityId)) continue;
            VirtualIdentityType virtualIdentityType = eext.addNewVirtualIdentity();
            virtualIdentityType.setEntityID(virtualEntityId);
        }
        Map<String, String> connectionTemplateProperties = connBase.getConnectionTemplateProperties();
        if (connectionTemplateProperties != null) {
            ConnectionTemplatePropertiesType connectionTemplatePropertiesType = eext.addNewConnectionTemplateProperties();
            for (Map.Entry<String, String> entry : connectionTemplateProperties.entrySet()) {
                ConnectionTemplatePropertyType connectionTemplateProperty = connectionTemplatePropertiesType.addNewProperty();
                connectionTemplateProperty.setName(entry.getKey());
                connectionTemplateProperty.setValue(entry.getValue());
            }
        }
        this.fillInDsigAlias(eext, connBase);
        if (connBase.isUsingDynamicDsigTrust()) {
            eext.setDsigVerificationExpectedSubjectDN(connBase.getStringDsigVerificationExpectedSubjectDNas());
            if (connBase.getStringDsigVerificationExpectedIssuerDNas() != null) {
                eext.setDsigVerificationExpectedIssuerDN(connBase.getStringDsigVerificationExpectedIssuerDNas());
            }
        }
        this.fillInEncryption(eext, connBase.getEncryptionSettings());
        this.fillInSigningKeyRotationSettings(eext, connBase.getSigningKeyRotationSettings());
        this.fillInModules(eext, connBase);
        this.fillInAdditionalAdditionalAllowedEntitiesConfiguration(eext, connBase);
        eext.setMetadataUrlId(connBase.getMetadataUrlId());
        eext.setEnableAutoMetadataUpdate(connBase.isEnableAutoMetadataUpdate());
        eext.setAlwaysSignArtifactResponse(connBase.isAlwaysSignArtifactResponse());
        XmlBeansUtil.setAttributeValue((XmlObject)entityDescriptorType, Boolean.toString(connBase.isActive()), METADATA_EXT_NS, IS_ACTIVE);
        ArrayList<ExtendedPropertyType> extProperties = new ArrayList<ExtendedPropertyType>();
        for (Map.Entry<String, String> entry : connBase.getExtendedProperties().entrySet()) {
            for (String value : ((ParamValues)entry.getValue()).getElements()) {
                ExtendedPropertyType extendedProperty = eext.addNewExtendedProperties();
                extendedProperty.setName(entry.getKey());
                extendedProperty.setValue(value);
                extProperties.add(extendedProperty);
            }
        }
        eext.setExtendedPropertiesArray(extProperties.toArray(new ExtendedPropertyType[extProperties.size()]));
        XmlBeansUtil.setChildren((XmlObject)extensionsType, new XmlObject[]{eext});
        return entityDescriptorType;
    }

    private void fillInWsTrustIdpSettings(PFSpWsTrustRoleDescriptorType spWsTrustRoleDescriptorType, SpConnection spConn) {
        WsTrustFederatedWscSettings settings = spConn.getWsTrustSettings();
        if (settings != null) {
            Set<String> mutableAttributeNames;
            WsTrustTokenAttributeContract attributeContract;
            WsTrustSettingsType config = spWsTrustRoleDescriptorType.addNewWsTrustSettings();
            config.setUseSamlHoK(settings.isUseSamlHoK());
            config.setEncryptAssertion(settings.isEncryptAssertion());
            config.setAbortIfNotFulfilledFromRequest(settings.isAbortIfNotFulfilledFromRequest());
            config.setEnableOAuthSamlBearer(settings.isEnableOAuthAssertionProfiles());
            if (settings.getRequestContractId() != null) {
                config.setRequestContractId(settings.getRequestContractId());
            }
            if (!settings.getAppliesTo().isEmpty()) {
                String[] appliesToArray = new String[settings.getAppliesTo().size()];
                int i = 0;
                for (AppliesTo appliesTo : settings.getAppliesTo()) {
                    appliesToArray[i++] = appliesTo.toString();
                }
                config.setAppliesToArray(appliesToArray);
            }
            if (settings.hasIssueToken()) {
                config.setTokenType(settings.getTokenType());
            }
            if ((attributeContract = settings.getAttributeContract()) != null && (mutableAttributeNames = attributeContract.getMutableAttributeNames()) != null && !mutableAttributeNames.isEmpty()) {
                ExtendedAttributeContractType extendedAttributeContractType = config.addNewExtendedAttributeContract();
                for (String mutableAttributeName : mutableAttributeNames) {
                    ExtendedAttributeType extendedAttributeType = extendedAttributeContractType.addNewExtendedAttribute();
                    extendedAttributeType.setAttributeName(mutableAttributeName);
                    boolean maskValue = attributeContract.getMaskedAttributeNames().contains(mutableAttributeName);
                    extendedAttributeType.setMaskValue(maskValue);
                    if (!attributeContract.getMutableAttributesInfo().containsKey(mutableAttributeName)) continue;
                    extendedAttributeType.setNamespace(attributeContract.getMutableAttributesInfo().get(mutableAttributeName));
                }
            }
            for (TokenPluginAttributeMapping tokenMapping : settings.getTokenToAssertionMappings()) {
                TokenPluginMappingType tokenPluginMappingType = config.addNewTokenToAssertionMapping();
                AttributeMappingType attributeMappingType = tokenPluginMappingType.addNewAttributeMapping();
                this.fillInAttributeMappingType(attributeMappingType, tokenMapping.getAttributeMapping());
                TokenProcessorInstance instance = (TokenProcessorInstance)tokenMapping.getConnectionOverrideInstance();
                if (instance != null && instance.isConnectionBasedPlugin()) {
                    ConnectionOverrideTokenProcessorConfigurationType configType = tokenPluginMappingType.addNewTokenProcessorConfiguration();
                    this.tokenProcessorConfigSupport.fillInTokenProcessorConfigType(instance, (TokenProcessorConfigurationType)configType);
                    this.tokenProcessorConfigSupport.fillInDoc(instance, (ConfigType)configType);
                    configType.setParentId(instance.getParentId());
                }
                tokenPluginMappingType.setPluginId(tokenMapping.getPluginId());
                tokenPluginMappingType.setRestrictVirtualServerIds(tokenMapping.isRestrictVirtualServerIds());
                if (!tokenMapping.isRestrictVirtualServerIds()) continue;
                List<String> restrictedVirtualServerIds = tokenMapping.getRestrictedVirtualServerIds();
                tokenPluginMappingType.setRestrictedVirtualServerIdArray(restrictedVirtualServerIds.toArray(new String[restrictedVirtualServerIds.size()]));
            }
            config.setAssertionValidityAfterMinutes((long)settings.getAssertionValidityAfterMinutes());
            config.setAssertionValidityBeforeMinutes(settings.getAssertionValidityBeforeMinutes());
            spWsTrustRoleDescriptorType.setWsTrustSettings(config);
        }
    }

    private void fillInOAuthSettings(PFOAuthRoleDescriptorType oAuthRoleDescriptorType, IdpConnection idpConn) {
        OAuthSettings oAuthSettings = idpConn.getOAuthSettings();
        if (oAuthSettings != null) {
            Set<String> mutableAttributeNames;
            OAuthSettingsType oAuthSettingsType = oAuthRoleDescriptorType.addNewOAuthSettings();
            for (OAuthAssertionGrantMapping oAuthSAMLBearerMapping : oAuthSettings.getOAuthAssertionGrantMappingList()) {
                OAuthSAMLBearerMappingType attrMappingType = oAuthSettingsType.addNewOAuthSAMLBearerMapping();
                attrMappingType.setTokenManagerId(oAuthSAMLBearerMapping.getTokenManagerId());
                this.fillInAttributeMappingType((AttributeMappingType)attrMappingType, oAuthSAMLBearerMapping);
            }
            OAuthAssertionGrantAttributeContract attributeContract = oAuthSettings.getOAuthAssertionGrantAttributeContract();
            if (attributeContract != null && (mutableAttributeNames = attributeContract.getMutableAttributeNames()) != null && !mutableAttributeNames.isEmpty()) {
                ExtendedAttributeContractType extendedAttributeContractType = oAuthSettingsType.addNewOAuthSAMLBearerAttributeContract();
                for (String mutableAttributeName : mutableAttributeNames) {
                    ExtendedAttributeType extendedAttributeType = extendedAttributeContractType.addNewExtendedAttribute();
                    extendedAttributeType.setAttributeName(mutableAttributeName);
                    boolean maskValue = attributeContract.getMaskedAttributeNames().contains(mutableAttributeName);
                    extendedAttributeType.setMaskValue(maskValue);
                }
            }
            oAuthRoleDescriptorType.setOAuthSettings(oAuthSettingsType);
        }
    }

    private void fillOIDCRPSettings(PFOIDCRoleDescriptorType oidcRoleDescriptorType, IdpConnection idpConn) {
        OIDCSettings settings = idpConn.getOidcSettings();
        if (settings != null) {
            OIDCSettingsType settingsType = oidcRoleDescriptorType.addNewOpenIDConnectSettings();
            if (settings.getJwksUri() != null) {
                settingsType.setJWKSUri(settings.getJwksUri().getLocation());
            }
            if (settings.getTokenEndpoint() != null) {
                settingsType.setTokenEndpoint(settings.getTokenEndpoint().getLocation());
            }
            if (settings.getScopes() != null && !settings.getScopes().getScopeSet().isEmpty()) {
                settingsType.setScopes(settings.getScopes().getScopeStr());
            }
            settingsType.setProfile(settings.getProfile().name());
            settingsType.setJwtSecuredAuthorizationResponseModeType(settings.getJwtSecuredAuthorizationResponseModeType());
            if (settings.getUserInfoEndpoint() != null) {
                settingsType.setUserInfoEndpoint(settings.getUserInfoEndpoint().getLocation());
            }
            settingsType.setClientID(settings.getClientId());
            settingsType.setClientSecret(settings.getClientSecret());
            settingsType.setBasicAuth(settings.isBasicAuth());
            settingsType.setPrivateJwtAuth(settings.isPrivateKeyJwtAuth());
            settingsType.setClientSecretJwtAuth(settings.isClientSecretJwtAuth());
            settingsType.setTypeClaim(settings.getType());
            settingsType.setAudienceClaim(settings.getAudience());
            settingsType.setLifetimeClaim(settings.getLifetime());
            settingsType.setIncludeNbfClaim(settings.isIncludeNotBeforeClaim());
            if (settings.getSigningAlgorithm() != null) {
                settingsType.setSigningAlgorithm(settings.getSigningAlgorithm());
            }
            if (settings.getRequestSigningAlgorithm() != null) {
                settingsType.setRequestObjectSigningAlgorithm(settings.getRequestSigningAlgorithm());
            }
            List<OIDCRequestParamSetting> reqParams = settings.getRequestParams();
            OIDCRequestParamType[] requestParamArray = this.fillOIDCReqParamSettings(reqParams);
            settingsType.setRequestParamArray(requestParamArray);
            settingsType.setEnableProofKeyForCodeExchange(settings.isEnableProofKeyForCodeExchange());
            settingsType.setTrackUserSessionsForLogout(settings.isTrackUserSessionsForLogout());
            if (settings.getPushedAuthorizationRequestEndpoint() != null) {
                settingsType.setPushedAuthorizationRequestEndpoint(settings.getPushedAuthorizationRequestEndpoint().getLocation());
            }
            if (settings.getLogoutEndpoint() != null) {
                settingsType.setLogoutEndpoint(settings.getLogoutEndpoint().getLocation());
            }
            oidcRoleDescriptorType.setOpenIDConnectSettings(settingsType);
        }
    }

    private OIDCRequestParamType[] fillOIDCReqParamSettings(List<OIDCRequestParamSetting> reqParams) {
        OIDCRequestParamType[] requestParamArray = new OIDCRequestParamType[reqParams.size()];
        for (int i = 0; i < reqParams.size(); ++i) {
            OIDCRequestParamSetting reqParam = reqParams.get(i);
            OIDCRequestParamType param = OIDCRequestParamType.Factory.newInstance();
            param.setName(reqParam.getName());
            param.setValue(reqParam.getValue().getValue());
            param.setType(reqParam.getValue().getTypeString());
            param.setOverride(reqParam.isOverride().booleanValue());
            requestParamArray[i] = param;
        }
        return requestParamArray;
    }

    private void fillInboundProvisioningType(PFInboundProvisioningRoleDescriptorType inboundProvisioningRoleDescriptorType, IdpConnection idpConn) {
        ScimUserProvisioning inboundProvisioning = idpConn.getInboundProvisioning();
        if (inboundProvisioning != null) {
            Map<String, List<AttrMappingValue>> readGroupsMappings;
            InboundProvisioningType inboundProvisioningType = inboundProvisioningRoleDescriptorType.addNewInboundProvisioning();
            inboundProvisioningType.setScimVersion(inboundProvisioning.getVersion().name());
            inboundProvisioningType.setPermanentlyDeleteUsersOnDelete(inboundProvisioning.isPermanentlyDeleteUsersOnDelete());
            this.fillInboundProvisioningWriteUsersType(inboundProvisioningType, inboundProvisioning);
            this.fillInboundProvisioningReadUsersType(inboundProvisioningType, inboundProvisioning);
            Map<String, List<AttrMappingValue>> writeGroupsMappings = inboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping();
            if (writeGroupsMappings != null && !writeGroupsMappings.isEmpty()) {
                this.fillInInboundProvisioningWriteGroupsType(inboundProvisioningType, inboundProvisioning);
            }
            if ((readGroupsMappings = inboundProvisioning.getReadGroupsAttributeMapping().getAttributeMapping()) != null && !readGroupsMappings.isEmpty()) {
                this.fillInboundProvisioningReadGroupsType(inboundProvisioningType, inboundProvisioning);
            }
            if (ScimVersion.SCIM20.equals((Object)inboundProvisioning.getVersion())) {
                this.fillInboundProvisioningCustomScim2Type(inboundProvisioningType, inboundProvisioning);
            } else {
                this.fillInboundProvisioningCustomScimType(inboundProvisioningType, inboundProvisioning);
            }
            if (inboundProvisioning.getDocumentationUri() != null) {
                inboundProvisioningType.setDocumentationUri(inboundProvisioning.getDocumentationUri());
            }
            inboundProvisioningRoleDescriptorType.setInboundProvisioning(inboundProvisioningType);
        }
    }

    protected void fillInboundProvisioningCustomScim2Type(InboundProvisioningType targetInboundProvisioningType, ScimUserProvisioning sourceScimUserProvisioningDomain) {
        Scim2Schema sourceSchema = sourceScimUserProvisioningDomain.getCustomScim2Schema();
        if (sourceSchema != null && sourceSchema.getAttributes() != null) {
            Scim2SchemaType targetSchemaType = targetInboundProvisioningType.addNewScim2();
            targetSchemaType.setName(sourceSchema.getSchema());
            targetSchemaType.setDescription(sourceSchema.getDescription());
            Scim2SchemaType.CustomAttributes customAttributes = targetSchemaType.addNewCustomAttributes();
            for (Scim2SchemaAttribute customAttribute : sourceSchema.getAttributes()) {
                Scim2CustomAttributeType customAttributeType = customAttributes.addNewCustomAttribute();
                customAttributeType.setName(customAttribute.getName());
                customAttributeType.setDescription(customAttribute.getDescription());
                customAttributeType.setType(customAttribute.getType());
                customAttributeType.setCaseExact(customAttribute.getCaseExact().booleanValue());
                customAttributeType.setMutability(customAttribute.getMutability());
                customAttributeType.setUniqueness(customAttribute.getUniqueness());
                customAttributeType.setRequired(customAttribute.getRequired().booleanValue());
                customAttributeType.setReturned(customAttribute.getReturned());
                customAttributeType.setMultivalued(customAttribute.getMultiValued().booleanValue());
                List<String> sourceCanonicalValues = customAttribute.getCanonicalValues();
                if (sourceCanonicalValues != null && !sourceCanonicalValues.isEmpty()) {
                    String[] canonicalValuesArray = sourceCanonicalValues.toArray(new String[0]);
                    Scim2CustomAttributeType.CanonicalValues canonicalValues = customAttributeType.addNewCanonicalValues();
                    canonicalValues.setCanonicalValueArray(canonicalValuesArray);
                }
                if (customAttribute.getSubAttributes() == null || customAttribute.getSubAttributes().isEmpty()) continue;
                Scim2CustomAttributeType.SubAttributes subAttributesType = customAttributeType.addNewSubAttributes();
                List<Scim2SubAttribute> sourceSubAttributes = customAttribute.getSubAttributes();
                for (Scim2SubAttribute subAttribute : sourceSubAttributes) {
                    Scim2SubAttributeType subAttributeType = subAttributesType.addNewSubAttribute();
                    subAttributeType.setName(subAttribute.getName());
                    subAttributeType.setDescription(subAttribute.getDescription());
                    subAttributeType.setType(subAttribute.getType());
                    subAttributeType.setCaseExact(subAttribute.getCaseExact().booleanValue());
                    subAttributeType.setMutability(subAttribute.getMutability());
                    subAttributeType.setUniqueness(subAttribute.getUniqueness());
                    subAttributeType.setRequired(subAttribute.getRequired().booleanValue());
                    subAttributeType.setReturned(subAttribute.getReturned());
                }
            }
        }
    }

    protected boolean isInboundProvisioningReadGroupsExist(InboundProvisioningType inboundProvisioningType) {
        return inboundProvisioningType != null && inboundProvisioningType.getReadGroupsMapping() != null && (inboundProvisioningType.getReadGroupsMapping().getAttributeSource() != null || inboundProvisioningType.getReadGroupsMapping().getIdentityStoreProvisioner() != null) && inboundProvisioningType.getReadGroupsMapping().getAttributeMapArray() != null;
    }

    protected boolean isInboundProvisioningWriteGroupsExists(InboundProvisioningType inboundProvisioningType) {
        return inboundProvisioningType != null && inboundProvisioningType.getWriteGroupsMapping() != null && (inboundProvisioningType.getWriteGroupsMapping().getAttributeSource() != null || inboundProvisioningType.getWriteGroupsMapping().getIdentityStoreProvisioner() != null) && inboundProvisioningType.getWriteGroupsMapping().getAttributeMapArray() != null;
    }

    private void fillInboundProvisioningWriteUsersType(InboundProvisioningType inboundProvisioningType, ScimUserProvisioning inboundProvisioning) {
        InboundProvisioningWriteUsersType inboundProvisioningWriteUsersType = inboundProvisioningType.addNewWriteUsersMapping();
        if (inboundProvisioning.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
            IdentityStoreProvisionerInstance identityStoreProvisionerInstance = inboundProvisioning.getIdentityStoreProvisioner();
            IdentityStoreProvisionerType identityStoreProvisionerType = inboundProvisioningWriteUsersType.addNewIdentityStoreProvisioner();
            identityStoreProvisionerType.setId(identityStoreProvisionerInstance.getId());
            identityStoreProvisionerType.setDescription(identityStoreProvisionerInstance.getName());
        } else {
            AttributeSource attributeSource = inboundProvisioning.getWriteUsersAttributeMapping().getAttributeSource();
            AttributeSourceType attributeSourceType = inboundProvisioningWriteUsersType.addNewAttributeSource();
            if (attributeSource != null && attributeSourceType != null) {
                this.fillInAttributeSource(attributeSourceType, attributeSource);
            }
        }
        Map<String, List<AttrMappingValue>> attributeMap = inboundProvisioning.getWriteUsersAttributeMapping().getAttributeMapping();
        if (attributeMap != null && !attributeMap.isEmpty()) {
            for (Map.Entry<String, List<AttrMappingValue>> entry : attributeMap.entrySet()) {
                String attribame = entry.getKey();
                for (AttrMappingValue attribValue : entry.getValue()) {
                    AttributeMapType attribMapType = inboundProvisioningWriteUsersType.addNewAttributeMap();
                    attribMapType.setName(attribame);
                    attribMapType.setType(attribValue.getTypeString());
                    attribMapType.setValueText(attribValue.getValue());
                    if (attribValue.getDelimiter() == null) continue;
                    attribMapType.setDelimiter(attribValue.getDelimiter());
                }
            }
        }
    }

    private void fillInboundProvisioningReadUsersType(InboundProvisioningType inboundProvisioningType, ScimUserProvisioning inboundProvisioning) {
        Set<String> set;
        MaskedAttributeContract attributeContract;
        InboundProvisioningReadUsersType inboundProvisioningReadUsersType = inboundProvisioningType.addNewReadUsersMapping();
        if (inboundProvisioning.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
            IdentityStoreProvisionerInstance identityStoreProvisionerInstance = inboundProvisioning.getIdentityStoreProvisioner();
            IdentityStoreProvisionerType identityStoreProvisionerType = inboundProvisioningReadUsersType.addNewIdentityStoreProvisioner();
            identityStoreProvisionerType.setId(identityStoreProvisionerInstance.getId());
            identityStoreProvisionerType.setDescription(identityStoreProvisionerInstance.getName());
        } else {
            AttributeSource attributeSource = inboundProvisioning.getReadUsersAttributeMapping().getAttributeSource();
            AttributeSourceType attributeSourceType = inboundProvisioningReadUsersType.addNewAttributeSource();
            if (attributeSource != null && attributeSourceType != null) {
                this.fillInAttributeSource(attributeSourceType, attributeSource);
            }
        }
        Map<String, List<AttrMappingValue>> attributeMap = inboundProvisioning.getReadUsersAttributeMapping().getAttributeMapping();
        if (attributeMap != null && !attributeMap.isEmpty()) {
            for (Map.Entry entry : attributeMap.entrySet()) {
                String attribame = (String)entry.getKey();
                for (AttrMappingValue attribValue : (List)entry.getValue()) {
                    AttributeMapType attribMapType = inboundProvisioningReadUsersType.addNewAttributeMap();
                    attribMapType.setName(attribame);
                    attribMapType.setType(attribValue.getTypeString());
                    attribMapType.setValueText(attribValue.getValue());
                    if (attribValue.getDelimiter() == null) continue;
                    attribMapType.setDelimiter(attribValue.getDelimiter());
                }
            }
        }
        if ((attributeContract = inboundProvisioning.getReadUsersAttributeContract()) != null && (set = attributeContract.getMutableAttributeNames()) != null && !set.isEmpty()) {
            ExtendedAttributeContractType extendedAttributeContractType = inboundProvisioningReadUsersType.addNewExtendedAttributeContract();
            for (String mutableAttributeName : set) {
                ExtendedAttributeType extendedAttributeType = extendedAttributeContractType.addNewExtendedAttribute();
                extendedAttributeType.setAttributeName(mutableAttributeName);
                boolean maskValue = attributeContract.getMaskedAttributeNames().contains(mutableAttributeName);
                extendedAttributeType.setMaskValue(maskValue);
                if (!attributeContract.getMutableAttributesInfo().containsKey(mutableAttributeName)) continue;
                extendedAttributeType.setNamespace(attributeContract.getMutableAttributesInfo().get(mutableAttributeName));
            }
        }
    }

    private void fillInInboundProvisioningWriteGroupsType(InboundProvisioningType inboundProvisioningType, ScimUserProvisioning inboundProvisioning) {
        InboundProvisioningWriteGroupsType inboundProvisioningWriteGroupsType = inboundProvisioningType.addNewWriteGroupsMapping();
        if (inboundProvisioning.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
            IdentityStoreProvisionerInstance identityStoreProvisionerInstance = inboundProvisioning.getIdentityStoreProvisioner();
            IdentityStoreProvisionerType identityStoreProvisionerType = inboundProvisioningWriteGroupsType.addNewIdentityStoreProvisioner();
            identityStoreProvisionerType.setId(identityStoreProvisionerInstance.getId());
            identityStoreProvisionerType.setDescription(identityStoreProvisionerInstance.getName());
        } else {
            AttributeSource attributeSource = inboundProvisioning.getWriteGroupsAttributeMapping().getAttributeSource();
            AttributeSourceType attributeSourceType = inboundProvisioningWriteGroupsType.addNewAttributeSource();
            if (attributeSource != null && attributeSourceType != null) {
                this.fillInAttributeSource(attributeSourceType, attributeSource);
            }
        }
        Map<String, List<AttrMappingValue>> attributeMap = inboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping();
        if (attributeMap != null && !attributeMap.isEmpty()) {
            for (Map.Entry<String, List<AttrMappingValue>> entry : attributeMap.entrySet()) {
                String attribame = entry.getKey();
                for (AttrMappingValue attribValue : entry.getValue()) {
                    AttributeMapType attribMapType = inboundProvisioningWriteGroupsType.addNewAttributeMap();
                    attribMapType.setName(attribame);
                    attribMapType.setType(attribValue.getTypeString());
                    attribMapType.setValueText(attribValue.getValue());
                    if (attribValue.getDelimiter() == null) continue;
                    attribMapType.setDelimiter(attribValue.getDelimiter());
                }
            }
        }
    }

    private void fillInboundProvisioningReadGroupsType(InboundProvisioningType inboundProvisioningType, ScimUserProvisioning inboundProvisioning) {
        Set<String> set;
        MaskedAttributeContract attributeContract;
        InboundProvisioningReadGroupsType inboundProvisioningReadGroupsType = inboundProvisioningType.addNewReadGroupsMapping();
        if (inboundProvisioning.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
            IdentityStoreProvisionerInstance identityStoreProvisionerInstance = inboundProvisioning.getIdentityStoreProvisioner();
            IdentityStoreProvisionerType identityStoreProvisionerType = inboundProvisioningReadGroupsType.addNewIdentityStoreProvisioner();
            identityStoreProvisionerType.setId(identityStoreProvisionerInstance.getId());
            identityStoreProvisionerType.setDescription(identityStoreProvisionerInstance.getName());
        } else {
            AttributeSource attributeSource = inboundProvisioning.getReadGroupsAttributeMapping().getAttributeSource();
            AttributeSourceType attributeSourceType = inboundProvisioningReadGroupsType.addNewAttributeSource();
            if (attributeSource != null && attributeSourceType != null) {
                this.fillInAttributeSource(attributeSourceType, attributeSource);
            }
        }
        Map<String, List<AttrMappingValue>> attributeMap = inboundProvisioning.getReadGroupsAttributeMapping().getAttributeMapping();
        if (attributeMap != null && !attributeMap.isEmpty()) {
            for (Map.Entry entry : attributeMap.entrySet()) {
                String attribame = (String)entry.getKey();
                for (AttrMappingValue attribValue : (List)entry.getValue()) {
                    AttributeMapType attribMapType = inboundProvisioningReadGroupsType.addNewAttributeMap();
                    attribMapType.setName(attribame);
                    attribMapType.setType(attribValue.getTypeString());
                    attribMapType.setValueText(attribValue.getValue());
                    if (attribValue.getDelimiter() == null) continue;
                    attribMapType.setDelimiter(attribValue.getDelimiter());
                }
            }
        }
        if ((attributeContract = inboundProvisioning.getReadGroupsAttributeContract()) != null && (set = attributeContract.getMutableAttributeNames()) != null && !set.isEmpty()) {
            ExtendedAttributeContractType extendedAttributeContractType = inboundProvisioningReadGroupsType.addNewExtendedAttributeContract();
            for (String mutableAttributeName : set) {
                ExtendedAttributeType extendedAttributeType = extendedAttributeContractType.addNewExtendedAttribute();
                extendedAttributeType.setAttributeName(mutableAttributeName);
                boolean maskValue = attributeContract.getMaskedAttributeNames().contains(mutableAttributeName);
                extendedAttributeType.setMaskValue(maskValue);
                if (!attributeContract.getMutableAttributesInfo().containsKey(mutableAttributeName)) continue;
                extendedAttributeType.setNamespace(attributeContract.getMutableAttributesInfo().get(mutableAttributeName));
            }
        }
    }

    private void fillInWsTrustSpSettings(PFIdpWsTrustRoleDescriptorType idpWsTrustRoleDescriptorType, IdpConnection idpConn) {
        WsTrustFederatedWspSettings settings = idpConn.getWsTrustSettings();
        if (settings != null) {
            Set<String> mutableAttributeNames;
            WsTrustTokenAttributeContract attributeContract;
            WsTrustSettingsType wsTrustSettings = idpWsTrustRoleDescriptorType.addNewWsTrustSettings();
            Collection<TokenPluginAttributeMapping> tokenPluginAttributeMappings = settings.getAssertionToTokenMappingsMappings();
            if (tokenPluginAttributeMappings != null && !tokenPluginAttributeMappings.isEmpty()) {
                wsTrustSettings.setDefaultAssertionToTokenMappingId(settings.getDefaultAssertionToTokenMappingsMappingId());
                for (TokenPluginAttributeMapping tokenMapping : tokenPluginAttributeMappings) {
                    TokenPluginMappingType mappingType = wsTrustSettings.addNewAssertionToTokenMapping();
                    AttributeMappingType attributeMappingType = mappingType.addNewAttributeMapping();
                    this.fillInAttributeMappingType(attributeMappingType, tokenMapping.getAttributeMapping());
                    TokenGeneratorInstance instance = (TokenGeneratorInstance)tokenMapping.getConnectionOverrideInstance();
                    if (instance != null && instance.isConnectionBasedPlugin()) {
                        ConnectionOverrideConfigType configType = mappingType.addNewPluginConfiguration();
                        this.tokenGeneratorConfigSupport.fillInDoc(instance, (ConfigType)configType);
                        configType.setParentId(instance.getParentId());
                    }
                    mappingType.setPluginId(tokenMapping.getPluginId());
                    mappingType.setRestrictVirtualServerIds(tokenMapping.isRestrictVirtualServerIds());
                    if (!tokenMapping.isRestrictVirtualServerIds()) continue;
                    List<String> restrictedVirtualServerIds = tokenMapping.getRestrictedVirtualServerIds();
                    mappingType.setRestrictedVirtualServerIdArray(restrictedVirtualServerIds.toArray(new String[restrictedVirtualServerIds.size()]));
                }
            }
            if ((attributeContract = settings.getAttributeContract()) != null && (mutableAttributeNames = attributeContract.getMutableAttributeNames()) != null && !mutableAttributeNames.isEmpty()) {
                ExtendedAttributeContractType extendedAttributeContractType = wsTrustSettings.addNewExtendedAttributeContract();
                for (String mutableAttributeName : mutableAttributeNames) {
                    ExtendedAttributeType extendedAttributeType = extendedAttributeContractType.addNewExtendedAttribute();
                    extendedAttributeType.setAttributeName(mutableAttributeName);
                    boolean maskValue = attributeContract.getMaskedAttributeNames().contains(mutableAttributeName);
                    extendedAttributeType.setMaskValue(maskValue);
                    if (!attributeContract.getMutableAttributesInfo().containsKey(mutableAttributeName)) continue;
                    extendedAttributeType.setNamespace(attributeContract.getMutableAttributesInfo().get(mutableAttributeName));
                }
            }
            wsTrustSettings.setDecryptAssertion(settings.isDecryptAssertion());
            idpWsTrustRoleDescriptorType.setWsTrustSettings(wsTrustSettings);
        }
    }

    protected void fillInModules(EntityExtensionType eext, ConnectionBase connBase) {
    }

    protected void fillInAdditionalAdditionalAllowedEntitiesConfiguration(EntityExtensionType eext, ConnectionBase connBase) {
        AdditionalAllowedEntitiesConfiguration configuration = eext.addNewAdditionalAllowedEntitiesConfiguration();
        configuration.setAllowAdditionalEntities(connBase.isAllowAdditionalEntities());
        configuration.setAllowAllEntities(connBase.isAllowAdditionalEntities() && connBase.isAllowAllEntities());
        AdditionalAllowedEntities additionalAllowedEntities = configuration.addNewAdditionalAllowedEntities();
        if (connBase.isAllowAdditionalEntities() && !connBase.isAllowAllEntities()) {
            for (Entity entry : connBase.getAdditionalAllowedEntities()) {
                AdditionalEntity additionalEntity = additionalAllowedEntities.addNewAdditionalEntity();
                additionalEntity.setEntityId(entry.getEntityId());
                additionalEntity.setEntityDescription(entry.getEntityDescription());
            }
        }
    }

    protected void fillInSsoDesc(SSODescriptorType ssoDescriptorType, ConnectionBase connBase) {
        Endpoint manageNameIdService;
        ProtocolUtil.setProtocolOnXml((RoleDescriptorType)ssoDescriptorType, connBase);
        if (connBase.getArtifactResolutionServices() != null) {
            IndexedEndpoints arss = connBase.getArtifactResolutionServices();
            ssoDescriptorType.setArtifactResolutionServiceArray(EndpointUtil.toIndexedEndpointTypes(arss));
        }
        if (connBase.getSingleLogoutServices() != null) {
            EndpointGroup singleLogoutServices = connBase.getSingleLogoutServices();
            ssoDescriptorType.setSingleLogoutServiceArray(EndpointUtil.toEndpointTypes(singleLogoutServices));
        }
        if ((manageNameIdService = connBase.getManageNameIdService()) != null) {
            if (StringUtils.isBlank((String)manageNameIdService.getBinding())) {
                manageNameIdService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            }
            EndpointType[] manageNameIDServiceArray = EndpointUtil.toEndpointTypes(new EndpointGroup(manageNameIdService));
            ssoDescriptorType.setManageNameIDServiceArray(manageNameIDServiceArray);
        }
        RoleExtensionDocument roleExtdoc = RoleExtensionDocument.Factory.newInstance();
        RoleExtensionType roleExtensionType = roleExtdoc.addNewRoleExtension();
        roleExtensionType.setArtifactTimeoutSeconds(connBase.getArtifactTimeoutSeconds());
        this.setLastModOnXml(connBase, roleExtensionType);
        this.setCreationTimeOnXml(connBase, roleExtensionType);
        this.setSelectiveReplicationTimeOnXml(connBase, roleExtensionType);
        IncomingBindingsType incomingBindingsType = roleExtensionType.addNewIncomingBindings();
        incomingBindingsType.setArtifact(connBase.getIncomingBindings().getArtifactBinding());
        incomingBindingsType.setPOST(connBase.getIncomingBindings().getPostBinding());
        incomingBindingsType.setRedirect(connBase.getIncomingBindings().getRedirectBinding());
        incomingBindingsType.setSOAP(connBase.getIncomingBindings().getSoapBinding());
        EnabledProfilesType enabledProfilesType = roleExtensionType.addNewEnabledProfiles();
        enabledProfilesType.setIDPInitiatedSSO(connBase.getEnabledProfiles().isIdpInitiatedSSOEnabled());
        enabledProfilesType.setIDPInitiatedSLO(connBase.getEnabledProfiles().isIdpInitiatedSLOEnabled());
        enabledProfilesType.setSPInitiatedSSO(connBase.getEnabledProfiles().isSpInitiatedSSOEnabled());
        enabledProfilesType.setSPInitiatedSLO(connBase.getEnabledProfiles().isSpInitiatedSLOEnabled());
        this.fillInRedirectValidationWhitelist(roleExtensionType, connBase);
        for (Map.Entry<String, MessageCustomization> hook : connBase.getMessageCustomizationHooks().entrySet()) {
            MessageCustomizationHook messageCustomizationHook = roleExtensionType.addNewMessageCustomizationHook();
            messageCustomizationHook.setContextName(hook.getKey());
            messageCustomizationHook.setStringValue(hook.getValue().getExpression());
        }
        ExtensionsType extensionsType = ssoDescriptorType.addNewExtensions();
        if (connBase.hasNonStandardSourceId()) {
            SourceIDDocument sidDoc = SourceIDDocument.Factory.newInstance();
            byte[] sourceId = connBase.getSourceId();
            String sourceIdHexString = HexBin.bytesToString((byte[])sourceId);
            sourceIdHexString = sourceIdHexString.toLowerCase();
            sidDoc.setSourceID(sourceIdHexString);
            SourceIDDocument.SourceID sourceID = sidDoc.xgetSourceID();
            XmlBeansUtil.setChildren((XmlObject)extensionsType, new XmlObject[]{roleExtensionType, sourceID});
        } else {
            XmlBeansUtil.setChildren((XmlObject)extensionsType, new XmlObject[]{roleExtensionType});
        }
    }

    private void fillInRedirectValidationWhitelist(RoleExtensionType roleExtType, ConnectionBase connBase) {
        if (!Util.isEmpty(connBase.getRedirectValidationWhitelist())) {
            UrlWhitelistType whitelistType = roleExtType.addNewRedirectValidationWhitelist();
            for (UrlWhitelistEntry entry : connBase.getRedirectValidationWhitelist()) {
                UrlWhitelistEntryType xmlEntry = whitelistType.addNewUrlWhitelistEntry();
                xmlEntry.setRequireHttps(entry.isRequireHttps());
                xmlEntry.setAllowQueryAndFragment(entry.isAllowQueryAndFragment());
                xmlEntry.setPath(entry.getValidPath());
                xmlEntry.setDomainPattern(entry.getValidDomain());
            }
        }
    }

    protected void setLastModOnXml(ConnectionBase connBase, RoleExtensionType roleExtensionType) {
        if (connBase.getLastModified() != null) {
            roleExtensionType.setLastModified(connBase.getLastModified());
        }
    }

    protected void setCreationTimeOnXml(ConnectionBase connBase, RoleExtensionType roleExtensionType) {
        Calendar creationTime = connBase.getCreationTime();
        if (creationTime != null && !new Date(0L).equals(creationTime.getTime())) {
            roleExtensionType.setCreationTime(creationTime);
        }
    }

    protected void setSelectiveReplicationTimeOnXml(ConnectionBase connBase, RoleExtensionType roleExtensionType) {
        Calendar selectiveReplicationTime = connBase.getSelectiveReplicationTime();
        if (selectiveReplicationTime != null && !new Date(0L).equals(selectiveReplicationTime.getTime())) {
            roleExtensionType.setSelectiveReplicationTime(selectiveReplicationTime);
        }
    }

    protected void fillInEncryptionAliases(EncryptionSettings encryptionSettings, EntityExtensionType eext) {
        Cert encryptionCert;
        String decryptionKeyAlias = encryptionSettings.getDecryptionKeyAlias();
        String secondaryDecryptionKeyAlias = encryptionSettings.getSecondaryDecryptionKeyAlias();
        EncryptionType encryptionType = eext.getEncryption();
        if (decryptionKeyAlias != null) {
            encryptionType.setDecryptionKeyAlias(decryptionKeyAlias);
        }
        if (secondaryDecryptionKeyAlias != null) {
            encryptionType.setSecondaryDecryptionKeyAlias(secondaryDecryptionKeyAlias);
        }
        if ((encryptionCert = encryptionSettings.getEncryptionCert()) != null) {
            encryptionType.setEncryptionCertAlias(encryptionCert.getAlias());
        }
    }

    protected void fillInEncryption(EntityExtensionType eext, EncryptionSettings encryptionSettings) {
        EncryptionType encryptionType = eext.addNewEncryption();
        this.fillInEncryptionAliases(encryptionSettings, eext);
        EncryptionPolicyType encryptionPolicyType = encryptionType.addNewEncryptionPolicy();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        encryptionPolicyType.setEncryptionAlgorithm(encryptionPolicy.getEncryptionAlgorithm());
        encryptionPolicyType.setKeyTransportAlgorithm(encryptionPolicy.getKeyTransportAlgorithm());
        encryptionPolicyType.setEncryptAssertion(encryptionPolicy.isEncryptAssertion());
        encryptionPolicyType.setEncryptSubjectNameID(encryptionPolicy.isEncryptSubjectNameID());
        encryptionPolicyType.setSLOEncryptSubjectNameID(encryptionPolicy.isSloEncryptSubjectNameID());
        for (String attrib : encryptionPolicy.getEncryptAttributeList()) {
            encryptionPolicyType.addNewEncryptAttribute().setName(attrib);
        }
        DecryptionPolicyType decryptionPolicyType = encryptionType.addNewDecryptionPolicy();
        DecryptionPolicy decryptionPolicy = encryptionSettings.getDecryptionPolicy();
        decryptionPolicyType.setAssertionEncrypted(decryptionPolicy.isAssertionEncrypted());
        decryptionPolicyType.setSubjectNameIDEncrypted(decryptionPolicy.isSubjectNameIDEncrypted());
        decryptionPolicyType.setAttributeEncrypted(decryptionPolicy.isAttributeEncrypted());
        decryptionPolicyType.setSLOSubjectNameIDEncrypted(decryptionPolicy.isSloSubjectNameIDEncrypted());
    }

    protected void fillInSigningKeyRotationSettings(EntityExtensionType eext, KeyRotationSettings settings) {
        if (settings != null) {
            MetadataSynchronizationSettingsType syncSettingsType = eext.addNewMetadataSynchronizationSettings();
            KeyRotationSettingsType rotationSettingsType = syncSettingsType.addNewSigningKeyRotationSettings();
            rotationSettingsType.setKeySize(settings.getKeySize());
            rotationSettingsType.setRotationBufferMins(settings.getRotationBufferMins());
            rotationSettingsType.setSignatureAlgorithm(settings.getSignatureAlgorithm());
            rotationSettingsType.setValidityPeriodDays(settings.getValidityPeriodDays());
        }
    }

    private LocalizedNameType[] stringArrayToLocalizedNames(String[] names) {
        LocalizedNameType[] nameTypes = new LocalizedNameType[names.length];
        for (int i = 0; i < names.length; ++i) {
            nameTypes[i] = LocalizedNameType.Factory.newInstance();
            nameTypes[i].setStringValue(names[i]);
            nameTypes[i].setLang("en");
        }
        return nameTypes;
    }

    private void fillInOrganization(EntityDescriptorType entityDescriptorType, Organization org) {
        if (org != null) {
            OrganizationType orgType = entityDescriptorType.addNewOrganization();
            orgType.setOrganizationNameArray(this.stringArrayToLocalizedNames(org.getOrganizationNames()));
            orgType.setOrganizationDisplayNameArray(this.stringArrayToLocalizedNames(org.getOrganizationDisplayNames()));
            String[] uris = org.getOrganizationURLs();
            LocalizedURIType[] uriArray = new LocalizedURIType[uris.length];
            for (int i = 0; i < uris.length; ++i) {
                uriArray[i] = LocalizedURIType.Factory.newInstance();
                uriArray[i].setStringValue(uris[i]);
                uriArray[i].setLang("en");
            }
            orgType.setOrganizationURLArray(uriArray);
        }
    }

    public void fillInContactInfo(EntityDescriptorType entityDescriptorType, ContactInfo contact) {
        if (contact != null) {
            ContactType[] contacts = entityDescriptorType.getContactPersonArray();
            ContactType contactType = contacts.length < 1 ? entityDescriptorType.addNewContactPerson() : contacts[0];
            contactType.setContactType(ContactTypeType.ADMINISTRATIVE);
            if (!StringUtils.isBlank((String)contact.getCompany())) {
                contactType.setCompany(contact.getCompany().trim());
            } else if (contactType.isSetCompany()) {
                contactType.unsetCompany();
            }
            if (!StringUtils.isBlank((String)contact.getFirstName())) {
                contactType.setGivenName(contact.getFirstName().trim());
            } else if (contactType.isSetGivenName()) {
                contactType.unsetGivenName();
            }
            if (!StringUtils.isBlank((String)contact.getLastName())) {
                contactType.setSurName(contact.getLastName().trim());
            } else if (contactType.isSetSurName()) {
                contactType.unsetSurName();
            }
            if (!StringUtils.isBlank((String)contact.getPhone())) {
                String[] phoneArray = new String[]{contact.getPhone().trim()};
                contactType.setTelephoneNumberArray(phoneArray);
            } else {
                contactType.setTelephoneNumberArray(new String[0]);
            }
            if (!StringUtils.isBlank((String)contact.getEmail())) {
                String[] emailArray = new String[]{contact.getEmail().trim()};
                contactType.setEmailAddressArray(emailArray);
            } else {
                contactType.setEmailAddressArray(new String[0]);
            }
        }
    }

    public EntityDescriptorType toEntityDescriptorType(SpConnection spConn) {
        boolean hasOneDescriptor = false;
        EntityDescriptorType entityDescriptorType = this.buildBaseEntityDescType(spConn);
        EnabledProfiles profiles = spConn.getEnabledProfiles();
        if (profiles.isIdpInitiatedSSOEnabled() || profiles.isSpInitiatedSSOEnabled()) {
            hasOneDescriptor = true;
            SPSSODescriptorType spssoDesc = entityDescriptorType.addNewSPSSODescriptor();
            this.fillInSsoDesc((SSODescriptorType)spssoDesc, spConn);
            spssoDesc.setAssertionConsumerServiceArray(EndpointUtil.toIndexedEndpointTypes(spConn.getAssertionConsumerServiceEndpoints()));
            spssoDesc.setAuthnRequestsSigned(spConn.isAuthnRequestsSigned());
            spssoDesc.setWantAssertionsSigned(spConn.isWantAssertionsSigned());
            spssoDesc.setSignResponseAsRequired(spConn.isSignResponseAsRequired().booleanValue());
            RoleExtensionType roleExtensionType = this.getRoleExtensionType((RoleDescriptorType)spssoDesc);
            SpExtensionType spExtensionType = roleExtensionType.addNewSP();
            List<String> list = spConn.getNameIdFormats();
            String[] nameIdFormatArray = list.toArray(new String[list.size()]);
            spssoDesc.setNameIDFormatArray(nameIdFormatArray);
            this.fillInSpExtension(spExtensionType, spConn);
            AttributeContract attribContract = spConn.getAttributeContract();
            if (attribContract != null) {
                this.fillInAttributeConsumingServiceType(spssoDesc, attribContract);
            }
        }
        ArrayList<Object> roleDescriptorTypeList = new ArrayList<Object>();
        if (spConn.getAttributeRequester() != null) {
            AttributeQueryDescriptorType attributeQueryDesc = AttributeQueryDescriptorType.Factory.newInstance();
            this.fillInAttributeQueryDescriptor(attributeQueryDesc, spConn);
            roleDescriptorTypeList.add(attributeQueryDesc);
        }
        if (spConn.doesWsTrustSettingsExist()) {
            PFSpWsTrustRoleDescriptorType pfSpWsTrustRoleDescriptorType = PFSpWsTrustRoleDescriptorType.Factory.newInstance();
            ProtocolUtil.setProtocolOnXml((RoleDescriptorType)pfSpWsTrustRoleDescriptorType, spConn);
            this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)pfSpWsTrustRoleDescriptorType, spConn);
            this.fillInWsTrustIdpSettings(pfSpWsTrustRoleDescriptorType, spConn);
            roleDescriptorTypeList.add(pfSpWsTrustRoleDescriptorType);
            if (spConn.getWsTrustMessageCustomizationHooks() != null) {
                for (Map.Entry entry : spConn.getWsTrustMessageCustomizationHooks().entrySet()) {
                    MessageCustomizationHook messageCustomizationHook = pfSpWsTrustRoleDescriptorType.addNewMessageCustomizationHook();
                    messageCustomizationHook.setContextName((String)entry.getKey());
                    messageCustomizationHook.setStringValue(((MessageCustomization)entry.getValue()).getExpression());
                }
            }
        }
        if (!roleDescriptorTypeList.isEmpty()) {
            hasOneDescriptor = true;
            entityDescriptorType.setRoleDescriptorArray(roleDescriptorTypeList.toArray(new RoleDescriptorType[roleDescriptorTypeList.size()]));
        }
        if (!hasOneDescriptor && !spConn.getConnectionModuleConfigurations().isEmpty()) {
            PFNoopRoleDescriptorType noopDescriptorType = PFNoopRoleDescriptorType.Factory.newInstance();
            ProtocolUtil.setProtocolOnXml((RoleDescriptorType)noopDescriptorType, spConn);
            this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)noopDescriptorType, spConn);
            roleDescriptorTypeList.add(noopDescriptorType);
            entityDescriptorType.setRoleDescriptorArray(roleDescriptorTypeList.toArray(new RoleDescriptorType[roleDescriptorTypeList.size()]));
        }
        this.fillInOrganization(entityDescriptorType, spConn.getOrganization());
        this.fillInContactInfo(entityDescriptorType, spConn.getContactInfo());
        if (StringUtils.isNotBlank((String)spConn.getApplicationName())) {
            XmlBeansUtil.setAttributeValue((XmlObject)entityDescriptorType, spConn.getApplicationName(), METADATA_EXT_NS, ATTR_NAME_APPLICATION_NAME);
        }
        if (spConn.getApplicationIconUrl() != null) {
            URL applicationIconUrl = spConn.getApplicationIconUrl();
            String applicationIconUrlStr = applicationIconUrl.toExternalForm();
            XmlBeansUtil.setAttributeValue((XmlObject)entityDescriptorType, applicationIconUrlStr, METADATA_EXT_NS, ATTR_NAME_APPLICATION_ICON);
        }
        this.addAvailableCertTypes(entityDescriptorType, spConn);
        return entityDescriptorType;
    }

    private void fillInAvailableCerts(EntityDescriptorType entityDescriptorType, ConnectionBase connection) {
        PFAvailableCertsRoleDescriptorType availableCertsType = this.getAvailableCertsType(entityDescriptorType);
        if (availableCertsType != null) {
            connection.setPartnerCertsMigrated(true);
            this.processAvailableCerts(availableCertsType, connection);
        }
    }

    private PFAvailableCertsRoleDescriptorType getAvailableCertsType(EntityDescriptorType entityDescriptorType) {
        RoleDescriptorType[] roleDescArray = entityDescriptorType.getRoleDescriptorArray();
        if (roleDescArray.length > 0) {
            for (RoleDescriptorType roleDescType : roleDescArray) {
                if (!(roleDescType instanceof PFAvailableCertsRoleDescriptorType)) continue;
                return (PFAvailableCertsRoleDescriptorType)roleDescType;
            }
        }
        return null;
    }

    private void addAvailableCertTypes(EntityDescriptorType entityDescriptorType, ConnectionBase connection) {
        Set<Cert> certs = connection.getDsigVerificationCerts().getAllVerificationCerts();
        if (certs != null) {
            PFAvailableCertsRoleDescriptorType availableCertsType = PFAvailableCertsRoleDescriptorType.Factory.newInstance();
            for (Cert cert : certs) {
                AvailableCertType availableCertType = availableCertsType.addNewAvailableCert();
                availableCertType.setAlias(cert.getAlias());
                availableCertType.setBase64EncodedCert(cert.getEncoded());
            }
            availableCertsType.setProtocolSupportEnumeration(Collections.singletonList("urn:oasis:names:tc:SAML:2.0:protocol"));
            ArrayList<RoleDescriptorType> roleDescriptorTypes = new ArrayList<RoleDescriptorType>(Arrays.asList(entityDescriptorType.getRoleDescriptorArray()));
            roleDescriptorTypes.add((RoleDescriptorType)availableCertsType);
            entityDescriptorType.setRoleDescriptorArray(roleDescriptorTypes.toArray(new RoleDescriptorType[roleDescriptorTypes.size()]));
        }
    }

    private void fillInAttributeQueryDescriptor(AttributeQueryDescriptorType attributeQueryDesc, SpConnection spConn) {
        ProtocolUtil.setProtocolOnXml((RoleDescriptorType)attributeQueryDesc, spConn);
        AttributeRequester attributeRequester = spConn.getAttributeRequester();
        this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)attributeQueryDesc, spConn);
        RoleExtensionType roleExtensionType = this.getRoleExtensionType((RoleDescriptorType)attributeQueryDesc);
        SpExtensionType spExt = roleExtensionType.addNewSP();
        AttributeMapping attributeMapping = attributeRequester.getAttributeMapping();
        if (attributeMapping != null) {
            AdapterToAssertionMappingType mappingType = spExt.addNewAdapterToAssertionMapping();
            AttributeMappingType attributeMappingType = mappingType.addNewDefaultAttributeMapping();
            this.fillInAttributeMappingType(attributeMappingType, attributeMapping);
        }
        AttributeServicePolicyType attributeServicePolicyType = spExt.addNewAttributeServicePolicy();
        attributeServicePolicyType.setSignResponse(attributeRequester.isSignResponse());
        attributeServicePolicyType.setSignAssertion(attributeRequester.isSignAssertion());
        attributeServicePolicyType.setEncryptAssertion(attributeRequester.isEncryptAssertion());
        attributeServicePolicyType.setRequireSignedAttributeQuery(attributeRequester.isRequireSignedAttributeQuery());
        attributeServicePolicyType.setRequireEncryptedNameId(attributeRequester.isRequireEncryptedNameId());
        Set<String> attributeFilterList = attributeRequester.getAttributeFilterList();
        if (!Util.isEmpty(attributeFilterList)) {
            AttributeConsumingServiceType attribCSType = attributeQueryDesc.addNewAttributeConsumingService();
            attribCSType.setIndex(0);
            LocalizedNameType localNameType = attribCSType.addNewServiceName();
            localNameType.setStringValue("AttributeFilterList");
            localNameType.setLang("en");
            for (String attribName : attributeFilterList) {
                RequestedAttributeType reqAttribType = attribCSType.addNewRequestedAttribute();
                reqAttribType.setName(attribName);
                reqAttribType.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
            }
        }
    }

    private void fillInSpExtension(SpExtensionType spExtensionType, SpConnection spConn) {
        AdapterToAssertionMappingType mappingType;
        spExtensionType.setAssertionValidityAfterMinutes(spConn.getAssertionValidityAfterMinutes());
        spExtensionType.setAssertionValidityBeforeMinutes(spConn.getAssertionValidityBeforeMinutes());
        if (spConn.hasDefaultTargetResource()) {
            spExtensionType.setDefaultTargetResource(spConn.getDefaultTargetResource());
        }
        spExtensionType.setConnectionTargetType(spConn.getConnectionTargetType());
        for (AdapterToAssertionMapping adapterToAssertionMapping : spConn.getAdapterMappings()) {
            mappingType = spExtensionType.addNewAdapterToAssertionMapping();
            this.fillInAdapterToAssertionMappingType(adapterToAssertionMapping, mappingType);
        }
        for (C2cContractToAssertionMapping c2cContractToAssertionMapping : spConn.getC2cMappings()) {
            mappingType = spExtensionType.addNewC2CContractToAssertionMapping();
            this.fillInC2cContractToAssertionMappingType(c2cContractToAssertionMapping, (C2CContractToAssertionMappingType)mappingType);
        }
        NameIdentifierMappingType nameIdentifierMappingType = spExtensionType.addNewNameIdentifierMappingType();
        nameIdentifierMappingType.setIncludeAdditionalAttributes(spConn.isIncludeAdditionalAttributes());
        nameIdentifierMappingType.setIncludeAdditionalTransientAttributes(spConn.isIncludeAdditionalTransientAttributes());
        spExtensionType.setEnableCDCDuringSSO(spConn.isEnableCDCDuringSSO());
        WsFedSpSettings wsFedSpSettings = spConn.getWsFedSettings();
        if (spConn.getProtocol() == Protocol.WSFED && wsFedSpSettings != null) {
            WsFedSettingsType wsFedSettingsType = spExtensionType.addNewWsFedSettings();
            wsFedSettingsType.setTokenType(wsFedSpSettings.getTokenType().name());
            wsFedSettingsType.setWsTrustVersion(wsFedSpSettings.getWsTrustVersion());
        }
    }

    private void fillInAdapterToAssertionMappingType(AdapterToAssertionMapping mapping, AdapterToAssertionMappingType mappingType) {
        mappingType.setAbortIfNotFoundInAnyDataSources(mapping.isAbortIfNotFoundInAnyDataSources());
        mappingType.setRestrictVirtualServerIds(mapping.isRestrictVirtualServerIds());
        if (mapping.isRestrictVirtualServerIds()) {
            List<String> restrictedVirtualServerIds = mapping.getRestrictedVirtualServerIds();
            mappingType.setRestrictedVirtualServerIdArray(restrictedVirtualServerIds.toArray(new String[restrictedVirtualServerIds.size()]));
        }
        for (AttributeMapping attrMapping : mapping.getAttributeMappingList()) {
            AttributeMappingType attributeMappingType = mappingType.addNewAttributeMapping();
            this.fillInAttributeMappingType(attributeMappingType, attrMapping);
        }
        AttributeMapping defaultAttributeMapping = mapping.getDefaultAttributeMapping();
        if (defaultAttributeMapping != null) {
            AttributeMappingType attributeMappingType = mappingType.addNewDefaultAttributeMapping();
            this.fillInAttributeMappingType(attributeMappingType, defaultAttributeMapping);
        }
        this.setSpAdapterIdOnMappingType(mappingType, mapping.getAdapterInstanceId());
        IdpAuthnAdapterInstance instance = mapping.getConnectionOverrideInstance();
        if (instance != null && instance.isConnectionBasedPlugin()) {
            ConnectionOverrideAdapterConfigurationType configType = mappingType.addNewAdapterConfiguration();
            this.idpAdapterConfigSupport.fillInAdapterConfigType(instance, (AdapterConfigurationType)configType);
            this.idpAdapterConfigSupport.fillInDoc(instance, (ConfigType)configType);
            configType.setParentId(instance.getParentId());
        }
    }

    private void fillInC2cContractToAssertionMappingType(C2cContractToAssertionMapping mapping, C2CContractToAssertionMappingType mappingType) {
        mappingType.setAbortIfNotFoundInAnyDataSources(mapping.isAbortIfNotFoundInAnyDataSources());
        mappingType.setRestrictVirtualServerIds(mapping.isRestrictVirtualServerIds());
        if (mapping.isRestrictVirtualServerIds()) {
            List<String> restrictedVirtualServerIds = mapping.getRestrictedVirtualServerIds();
            mappingType.setRestrictedVirtualServerIdArray(restrictedVirtualServerIds.toArray(new String[restrictedVirtualServerIds.size()]));
        }
        for (AttributeMapping attrMapping : mapping.getAttributeMappingList()) {
            AttributeMappingType attributeMappingType = mappingType.addNewAttributeMapping();
            this.fillInAttributeMappingType(attributeMappingType, attrMapping);
        }
        AttributeMapping defaultAttributeMapping = mapping.getDefaultAttributeMapping();
        if (defaultAttributeMapping != null) {
            AttributeMappingType attributeMappingType = mappingType.addNewDefaultAttributeMapping();
            this.fillInAttributeMappingType(attributeMappingType, defaultAttributeMapping);
        }
        String contractId = mapping.getContractId();
        mappingType.setC2CContractId(contractId);
        C2cContract contract = this.c2cContractManager.getContract(contractId);
        if (contract != null) {
            mappingType.setC2CContractName(contract.getName());
        }
    }

    protected void setSpAdapterIdOnMappingType(AdapterToAssertionMappingType mappingType, String adapterId) {
        mappingType.setAdapterInstanceId(adapterId);
    }

    public void fillInAttributeMappingType(AttributeMappingType attrMappingType, AttributeMapping attrMapping) {
        List<AttributeSource> attributeSources = attrMapping.getAttributeSources();
        if (attributeSources != null) {
            for (AttributeSource attributeSource : attributeSources) {
                AttributeSourceType attributeSourceType = attrMappingType.addNewAttributeSource();
                this.fillInAttributeSource(attributeSourceType, attributeSource);
            }
        }
        Map<String, List<AttrMappingValue>> attributeMapping = attrMapping.getAttributeMapping();
        for (Map.Entry<String, List<AttrMappingValue>> entry : attributeMapping.entrySet()) {
            String attribName = entry.getKey();
            for (AttrMappingValue attribValue : entry.getValue()) {
                AttributeMapType attribMapType = attrMappingType.addNewAttributeMap();
                attribMapType.setName(attribName);
                attribMapType.setType(attribValue.getTypeString());
                if (attribValue.getAttributeSourceId() != null) {
                    attribMapType.setAttributeSourceId(attribValue.getAttributeSourceId());
                }
                attribMapType.setValueText(attribValue.getValue());
                if (attribValue.getDelimiter() == null) continue;
                attribMapType.setDelimiter(attribValue.getDelimiter());
            }
        }
        List<TokenAuthorizationIssuanceCriterion> list = attrMapping.getTokenAuthorizationIssuanceCriteria();
        if (list != null) {
            TokenAuthorizationIssuanceCriteriaType tokenAuthorizationIssuanceCriteriaType = attrMappingType.addNewTokenAuthorizationIssuanceCriteria();
            for (TokenAuthorizationIssuanceCriterion issuanceCriterion : list) {
                this.fillInTokenAuthorizationIssuanceCriteria(tokenAuthorizationIssuanceCriteriaType, issuanceCriterion);
            }
        }
    }

    private void fillInTokenAuthorizationIssuanceCriteria(TokenAuthorizationIssuanceCriteriaType tokenAuthorizationIssuanceCriteriaType, TokenAuthorizationIssuanceCriterion issuanceCriterion) {
        TokenAuthorizationIssuanceCriterionType tokenAuthorizationIssuanceCriterionType = tokenAuthorizationIssuanceCriteriaType.addNewTokenAuthorizationIssuanceCriterion();
        tokenAuthorizationIssuanceCriterionType.setAttrName(issuanceCriterion.getAttrName());
        String attrSourceId = issuanceCriterion.getAttrSourceId();
        if (StringUtils.isNotEmpty((String)attrSourceId)) {
            tokenAuthorizationIssuanceCriterionType.setAttrSourceId(attrSourceId);
        }
        tokenAuthorizationIssuanceCriterionType.setAttrSourceType(issuanceCriterion.getAttrSourceTypeAsString());
        tokenAuthorizationIssuanceCriterionType.setComparisonValue(issuanceCriterion.getComparisonValue());
        tokenAuthorizationIssuanceCriterionType.setErrorResult(issuanceCriterion.getErrorResult());
        tokenAuthorizationIssuanceCriterionType.setExprText(issuanceCriterion.getExpr());
        ConditionType conditionType = issuanceCriterion.getCondition();
        if (conditionType != null) {
            tokenAuthorizationIssuanceCriterionType.setCondition(conditionType.getId());
        }
    }

    public void fillInAttributeConsumingServiceType(SPSSODescriptorType spssoDesc, AttributeContract attrContract) {
        if (!attrContract.getMutableAttributeNames().isEmpty()) {
            AttributeConsumingServiceType attribCSType = spssoDesc.addNewAttributeConsumingService();
            attribCSType.setIndex(0);
            LocalizedNameType localNameType = attribCSType.addNewServiceName();
            localNameType.setStringValue(DEFAULT_ATTRIBUTE_CONSUMING_SERVICE_NAME);
            localNameType.setLang("en");
            for (String attribName : attrContract.getMutableAttributeNames()) {
                RequestedAttributeType reqAttribType = attribCSType.addNewRequestedAttribute();
                reqAttribType.setName(attribName);
                String attributeNameFormat = attrContract.getMutableAttributeNameFormat(attribName);
                if (attributeNameFormat == null) continue;
                reqAttribType.setNameFormat(attrContract.getMutableAttributeNameFormat(attribName));
            }
        }
    }

    public EntityDescriptorType toEntityDescriptorType(IdpConnection idpConn) {
        EntityDescriptorType entityDescriptorType = this.buildBaseEntityDescType(idpConn);
        EnabledProfiles profiles = idpConn.getEnabledProfiles();
        if (profiles.isIdpInitiatedSSOEnabled() || profiles.isSpInitiatedSSOEnabled()) {
            IDPSSODescriptorType idpssoDesc = entityDescriptorType.addNewIDPSSODescriptor();
            this.fillInSsoDesc((SSODescriptorType)idpssoDesc, idpConn);
            if (idpConn.getSingleSignOnServices() != null && !idpConn.getSingleSignOnServices().getEndpoints().isEmpty()) {
                idpssoDesc.setSingleSignOnServiceArray(EndpointUtil.toEndpointTypes(idpConn.getSingleSignOnServices()));
            } else {
                idpssoDesc.setSingleSignOnServiceArray(EndpointUtil.toEndpointTypes(OUT_SSO_NONE));
            }
            idpssoDesc.setWantAuthnRequestsSigned(idpConn.isWantAuthnRequestsSigned());
            AttributeContract attribContract = idpConn.getAttributeContract();
            if (attribContract != null) {
                this.fillInIdpAttributeTypes(idpssoDesc, attribContract);
            }
            RoleExtensionType roleExtensionType = this.getRoleExtensionType((RoleDescriptorType)idpssoDesc);
            IdpExtensionType idpExt = roleExtensionType.addNewIDP();
            idpExt.setAssertionsSigned(idpConn.isAssertionSigned());
            idpExt.setDefaultTargetResource(idpConn.getDefaultTargetResource());
            if (!idpConn.getAuthnContextMappings().isEmpty()) {
                AuthnContextMappingType[] authnContextMappingTypes = new AuthnContextMappingType[idpConn.getAuthnContextMappings().size()];
                int authnContextMappingIndex = 0;
                for (AuthnContextMapping mapping : idpConn.getAuthnContextMappings()) {
                    AuthnContextMappingType a = idpExt.addNewAuthnContextMapping();
                    a.setLocal(mapping.getLocal());
                    a.setRemote(mapping.getRemote());
                    authnContextMappingTypes[authnContextMappingIndex] = a;
                    ++authnContextMappingIndex;
                }
                idpExt.setAuthnContextMappingArray(authnContextMappingTypes);
            }
            Collection<TargetAttributeMapping> targetAttributeMappings = idpConn.getTargetAttributeMappings();
            this.setTargetAttributeMapping(idpExt, targetAttributeMappings);
            this.setConnectionContractMappingType(idpExt, idpConn.getC2cContractMappings());
            UserProvisioning userProvisioning = idpConn.getUserProvisioning();
            this.setJitProvisioning(idpExt, userProvisioning);
            AccountLinkingAndMappingType linkingAndMappingType = idpExt.addNewAccountLinkingAndMapping();
            LinkingMappingType.Enum linkingMappingType = idpConn.isLinking() ? LinkingMappingType.LINKING : LinkingMappingType.MAPPING;
            linkingAndMappingType.setType(linkingMappingType);
            linkingAndMappingType.setIncludeAdditionalAttributes(idpConn.isIncludeAdditionalAttributes());
            String errorPageMsg = idpConn.getErrorPageMsg();
            if (errorPageMsg != null) {
                idpExt.setErrPageMsg(errorPageMsg);
            }
            Set<String> maskedAttributeNames = idpConn.getMaskedAttributeNames();
            String[] maskedAttrs = maskedAttributeNames.toArray(new String[maskedAttributeNames.size()]);
            idpExt.setMaskedAttributeArray(maskedAttrs);
            if (idpConn.hasOAuthApcId()) {
                idpExt.setOAuthApcId(idpConn.getOAuthApcId());
            } else if (idpConn.hasSsoToOAuthAttrMapping()) {
                UserKeyAttrMapping ssoToOAuthAttrMapping = idpConn.getSsoToOAuthAttrMapping();
                AttributeMappingType attrMappingType = idpExt.addNewSsoToOAuthMapping();
                this.fillInAttributeMappingType(attrMappingType, ssoToOAuthAttrMapping);
            }
        }
        this.fillInOrganization(entityDescriptorType, idpConn.getOrganization());
        this.fillInContactInfo(entityDescriptorType, idpConn.getContactInfo());
        if (idpConn.getAttributeAuthority() != null) {
            AttributeAuthorityDescriptorType attribAuthorityDesc = entityDescriptorType.addNewAttributeAuthorityDescriptor();
            this.fillInAttributeAuthorityDesc(attribAuthorityDesc, idpConn);
        }
        ArrayList<Object> roleDescriptors = new ArrayList<Object>();
        if (idpConn.doesWsTrustSettingsExist()) {
            PFIdpWsTrustRoleDescriptorType pfIdpWsTrustRoleDescriptorType = PFIdpWsTrustRoleDescriptorType.Factory.newInstance();
            ProtocolUtil.setProtocolOnXml((RoleDescriptorType)pfIdpWsTrustRoleDescriptorType, idpConn);
            this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)pfIdpWsTrustRoleDescriptorType, idpConn);
            this.fillInWsTrustSpSettings(pfIdpWsTrustRoleDescriptorType, idpConn);
            roleDescriptors.add(pfIdpWsTrustRoleDescriptorType);
        }
        if (idpConn.doesOAuthSettingsExist()) {
            PFOAuthRoleDescriptorType pfOAuthRoleDescriptorType = PFOAuthRoleDescriptorType.Factory.newInstance();
            ProtocolUtil.setProtocolOnXml((RoleDescriptorType)pfOAuthRoleDescriptorType, idpConn);
            this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)pfOAuthRoleDescriptorType, idpConn);
            this.fillInOAuthSettings(pfOAuthRoleDescriptorType, idpConn);
            roleDescriptors.add(pfOAuthRoleDescriptorType);
        }
        if (idpConn.doesInboundProvisioningExist()) {
            PFInboundProvisioningRoleDescriptorType inboundProvisioningRoleDescriptorType = PFInboundProvisioningRoleDescriptorType.Factory.newInstance();
            ProtocolUtil.setProtocolOnXml((RoleDescriptorType)inboundProvisioningRoleDescriptorType, idpConn);
            this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)inboundProvisioningRoleDescriptorType, idpConn);
            this.fillInboundProvisioningType(inboundProvisioningRoleDescriptorType, idpConn);
            roleDescriptors.add(inboundProvisioningRoleDescriptorType);
        }
        if (idpConn.doesOIDCRPSettingsExist()) {
            PFOIDCRoleDescriptorType oidcRoleDescriptorType = PFOIDCRoleDescriptorType.Factory.newInstance();
            ProtocolUtil.setProtocolOnXml((RoleDescriptorType)oidcRoleDescriptorType, idpConn);
            this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)oidcRoleDescriptorType, idpConn);
            this.fillOIDCRPSettings(oidcRoleDescriptorType, idpConn);
            roleDescriptors.add(oidcRoleDescriptorType);
        }
        entityDescriptorType.setRoleDescriptorArray(roleDescriptors.toArray(new RoleDescriptorType[roleDescriptors.size()]));
        this.addAvailableCertTypes(entityDescriptorType, idpConn);
        return entityDescriptorType;
    }

    private void fillInAttributeAuthorityDesc(AttributeAuthorityDescriptorType attribAuthorityDesc, IdpConnection idpConn) {
        ProtocolUtil.setProtocolOnXml((RoleDescriptorType)attribAuthorityDesc, idpConn);
        AttributeAuthority attribAuth = idpConn.getAttributeAuthority();
        ArrayList<Endpoint> svcs = new ArrayList<Endpoint>();
        svcs.add(attribAuth.getAttributeService());
        EndpointGroup attribAuthorityServices = new EndpointGroup();
        attribAuthorityServices.setEndpoints(svcs);
        attribAuthorityDesc.setAttributeServiceArray(EndpointUtil.toEndpointTypes(attribAuthorityServices));
        this.fillInBaseInfo4RoleDescriptor((RoleDescriptorType)attribAuthorityDesc, idpConn);
        RoleExtensionType roleExtensionType = this.getRoleExtensionType((RoleDescriptorType)attribAuthorityDesc);
        IdpExtensionType idpExt = roleExtensionType.addNewIDP();
        AttributeNameMapping nameMapping = attribAuth.getAttributeNameMapping();
        Map<String, String> mapping = nameMapping.getAppAttributeToIdpAttributeNameMapping();
        if (!mapping.isEmpty()) {
            TargetAttributeMapping dummyTargetAttributeMapping = new TargetAttributeMapping();
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                SourceType assertionLabel = idpConn.getProtocol() == Protocol.OIDC ? SourceType.CLAIMS : SourceType.ASSERTION;
                dummyTargetAttributeMapping.addAttributeMapping(entry.getKey(), assertionLabel, entry.getValue());
            }
            ArrayList<TargetAttributeMapping> targetAttributeMappings = new ArrayList<TargetAttributeMapping>();
            targetAttributeMappings.add(dummyTargetAttributeMapping);
            this.setTargetAttributeMapping(idpExt, targetAttributeMappings);
        }
        AttributeQueryPolicyType attributeQueryPolicyType = idpExt.addNewAttributeQueryPolicy();
        attributeQueryPolicyType.setSignAttributeQuery(attribAuth.isSignAttributeQuery());
        attributeQueryPolicyType.setEncryptNameID(attribAuth.isEncryptNameId());
        attributeQueryPolicyType.setRequireSignedResponse(attribAuth.isRequireSignedResponse());
        attributeQueryPolicyType.setRequireSignedAssertion(attribAuth.isRequireSignedAssertion());
        attributeQueryPolicyType.setRequireEncryptedAssertion(attribAuth.isRequireEncryptedAssertion());
        attributeQueryPolicyType.setMaskAttributeValues(attribAuth.isMaskAttributeValues());
    }

    private void fillInBaseInfo4RoleDescriptor(RoleDescriptorType roleDescriptorType, ConnectionBase connBase) {
        RoleExtensionDocument roleExtdoc = RoleExtensionDocument.Factory.newInstance();
        RoleExtensionType roleExtensionType = roleExtdoc.addNewRoleExtension();
        if (roleExtensionType.isSetIsActive()) {
            roleExtensionType.setIsActive(connBase.isActive());
        }
        this.setLastModOnXml(connBase, roleExtensionType);
        this.setCreationTimeOnXml(connBase, roleExtensionType);
        this.setSelectiveReplicationTimeOnXml(connBase, roleExtensionType);
        ExtensionsType extensionsType = roleDescriptorType.addNewExtensions();
        XmlBeansUtil.setChildren((XmlObject)extensionsType, new XmlObject[]{roleExtensionType});
    }

    protected void fillInDsigAlias(EntityExtensionType eext, ConnectionBase connBase) {
        String signingAlgorithm;
        DsigAliasesType dsigAliasesType = eext.addNewDigitialSignatureAliases();
        String signingKeyAlias = connBase.getSigningKeyAlias();
        Map<String, PkCert> altSigningKeyMap = connBase.getAltSigningKeyAliasToCertMap();
        if (!StringUtils.isBlank((String)signingKeyAlias)) {
            dsigAliasesType.setSigningKeyAlias(signingKeyAlias);
            dsigAliasesType.setIncludeX509InXmlSig(connBase.isIncludeCertInXmlSigs());
            dsigAliasesType.setIncludeRawKeyInXmlSig(connBase.isIncludeRawKeyInXmlSigs());
            if (altSigningKeyMap != null) {
                for (String altSigningCertAlias : altSigningKeyMap.keySet()) {
                    if (altSigningCertAlias == null) continue;
                    dsigAliasesType.addAlternativeSigningKeyAlias(altSigningCertAlias);
                }
            }
        }
        if (!StringUtils.isBlank((String)(signingAlgorithm = connBase.getSigningAlgorithm()))) {
            dsigAliasesType.setSigningAlgorithm(signingAlgorithm);
        }
        if (!connBase.isUsingDynamicDsigTrust()) {
            for (Cert cert : connBase.getDsigVerificationCerts().getActiveVerificationCerts()) {
                if (cert == null || !StringUtils.isNotBlank((String)cert.getAlias())) continue;
                dsigAliasesType.addActiveVerificationCertAlias(cert.getAlias());
            }
        }
    }

    private RoleExtensionType getRoleExtensionType(RoleDescriptorType roleDescriptorType) {
        ExtensionsType extensionsType = roleDescriptorType.getExtensions();
        XmlObject xml = XmlBeansUtil.getFirstChild((XmlObject)extensionsType);
        return (RoleExtensionType)xml;
    }

    public void getAttributeAuthorityFromXmlBean(IdpConnection idpConnection, AttributeAuthorityDescriptorType attributeAuthority, EntityDescriptorType entityDescriptorType) {
        RoleExtensionType roleExtensionType;
        URL baseUrl = this.getBaseUrl(entityDescriptorType);
        EndpointType[] attribSvces = attributeAuthority.getAttributeServiceArray();
        AttributeAuthority attribAuthority = new AttributeAuthority();
        if (attribSvces.length > 0) {
            EndpointType attribSvcEndPoint = attribSvces[0];
            Endpoint svc = EndpointUtil.toEndpoint(attribSvcEndPoint, baseUrl);
            attribAuthority.setAttributeService(svc);
        }
        if ((roleExtensionType = this.processRoleExtensionBaseConnInfo((RoleDescriptorType)attributeAuthority, idpConnection)) != null && roleExtensionType.isSetIDP()) {
            IdpExtensionType idpExt = roleExtensionType.getIDP();
            this.getAttributeNameMappings(idpExt.getTargetAttributeMappingArray(), attribAuthority);
            AttributeQueryPolicyType attributeQueryPolicy = idpExt.getAttributeQueryPolicy();
            if (attributeQueryPolicy != null) {
                attribAuthority.setSignAttributeQuery(attributeQueryPolicy.getSignAttributeQuery());
                attribAuthority.setEncryptNameId(attributeQueryPolicy.getEncryptNameID());
                attribAuthority.setRequireSignedResponse(attributeQueryPolicy.getRequireSignedResponse());
                attribAuthority.setRequireSignedAssertion(attributeQueryPolicy.getRequireSignedAssertion());
                attribAuthority.setRequireEncryptedAssertion(attributeQueryPolicy.getRequireEncryptedAssertion());
                attribAuthority.setMaskAttributeValues(attributeQueryPolicy.getMaskAttributeValues());
            }
        }
        idpConnection.setAttributeAuthority(attribAuthority);
    }

    private RoleExtensionType processRoleExtensionBaseConnInfo(RoleDescriptorType roleDescriptorType, ConnectionBase connBase) {
        ExtensionsType extensionsType = roleDescriptorType.getExtensions();
        RoleExtensionType roleExtensionType = XPathUtil.selectFirst((XmlObject)extensionsType, XPATH_ROLE_EXT, RoleExtensionType.class, connBase.getEncodedEntityId());
        if (roleExtensionType != null) {
            if (roleExtensionType.isSetLastModified()) {
                connBase.setLastModified(roleExtensionType.getLastModified());
            }
            if (roleExtensionType.isSetCreationTime()) {
                connBase.setCreationTime(roleExtensionType.getCreationTime());
            }
            if (roleExtensionType.isSetSelectiveReplicationTime()) {
                connBase.setSelectiveReplicationTime(roleExtensionType.getSelectiveReplicationTime());
            }
        }
        return roleExtensionType;
    }

    protected void processDigitialSignatureAliases(EntityDescriptorType entityDescriptorType, ConnectionBase connBase) {
        DsigAliasesType dsigAliases = XPathUtil.selectFirst((XmlObject)entityDescriptorType, XPATH_DSIG, DsigAliasesType.class, null);
        if (dsigAliases != null) {
            Cert cert;
            boolean doSigningKey = dsigAliases.isSetSigningKeyAlias() && !StringUtils.isBlank((String)dsigAliases.getSigningKeyAlias());
            PkCertAndConnectionCertManager dsigPkCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
            if (doSigningKey) {
                String signingKeyAlias = dsigAliases.getSigningKeyAlias();
                connBase.setSigningKeyAlias(signingKeyAlias);
                PkCert pkCert = dsigPkCertManager.getPkCert(signingKeyAlias);
                connBase.setSigningKey(pkCert);
                if (StringUtils.isNotBlank((String)signingKeyAlias)) {
                    for (String altSigningAlias : dsigAliases.getAlternativeSigningKeyAliasArray()) {
                        pkCert = dsigPkCertManager.getPkCert(altSigningAlias);
                        if (pkCert == null) continue;
                        connBase.addAltSigningKeyAlias(pkCert.getAlias(), pkCert);
                    }
                }
                connBase.setIncludeCertInXmlSigs(dsigAliases.getIncludeX509InXmlSig());
                connBase.setIncludeRawKeyInXmlSigs(dsigAliases.getIncludeRawKeyInXmlSig());
                String signingAlgorithm = dsigAliases.getSigningAlgorithm();
                connBase.setSigningAlgorithm(signingAlgorithm);
            }
            for (int i = 0; i < dsigAliases.getActiveVerificationCertAliasArray().length; ++i) {
                String alias = dsigAliases.getActiveVerificationCertAliasArray()[i];
                if (!StringUtils.isNotBlank((String)alias)) continue;
                connBase.getDsigVerificationCerts().addActiveVerificationCert(this.getPartnerCert(entityDescriptorType, alias, connBase.getDsigVerificationCerts().getAllVerificationCerts()));
            }
            if (dsigAliases.isSetVerificationCertAlias() && !StringUtils.isBlank((String)dsigAliases.getVerificationCertAlias())) {
                String verifyCertAlias = dsigAliases.getVerificationCertAlias();
                cert = this.getPartnerCert(entityDescriptorType, verifyCertAlias, connBase.getDsigVerificationCerts().getAllVerificationCerts());
                connBase.getDsigVerificationCerts().setActiveVerificationCert(cert);
            }
            if (dsigAliases.isSetSecondaryVerificationCertAlias() && !StringUtils.isBlank((String)dsigAliases.getSecondaryVerificationCertAlias())) {
                String alias = dsigAliases.getSecondaryVerificationCertAlias();
                cert = this.getPartnerCert(entityDescriptorType, alias, connBase.getDsigVerificationCerts().getAllVerificationCerts());
                connBase.getDsigVerificationCerts().setSecondaryVerificationCert(cert);
            }
        }
    }

    private Cert getPartnerCert(EntityDescriptorType entityDescriptorType, String alias, Set<Cert> availableConnCerts) {
        if (this.getAvailableCertsType(entityDescriptorType) != null) {
            try {
                return this.findCertWithAlias(alias, availableConnCerts);
            }
            catch (CertNotFoundException e) {
                log.warn((Object)("Could not find cert with alias " + alias + " in the connection config."));
                return null;
            }
        }
        PkCertAndConnectionCertManager dsigPkCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
        return dsigPkCertManager.getCert(alias);
    }

    private void getAttributeNameMappings(TargetAttributeMappingType[] targetAttrMappings, AttributeAuthority attribAuthority) {
        AttributeNameMapping attributeNameMapping = new AttributeNameMapping();
        if (targetAttrMappings != null && targetAttrMappings.length > 0) {
            AttributeMapType[] attrMaps;
            TargetAttributeMappingType targetAttributeMappingType = targetAttrMappings[0];
            for (AttributeMapType attrMap : attrMaps = targetAttributeMappingType.getAttributeMapArray()) {
                attributeNameMapping.addAttributeNameMapping(attrMap.getName(), attrMap.isSetValue() ? attrMap.getValue() : attrMap.getValueText());
            }
        }
        attribAuthority.setAttributeNameMapping(attributeNameMapping);
    }

    private void getAttributeQueryDescFromXmlBean(SpConnection spConnection, AttributeQueryDescriptorType attributeQueryDescType) {
        RoleExtensionType roleExtensionType;
        AttributeRequester attributeRequester = new AttributeRequester();
        AttributeConsumingServiceType[] attributeConsumingServices = attributeQueryDescType.getAttributeConsumingServiceArray();
        if (attributeConsumingServices != null && attributeConsumingServices.length > 0) {
            RequestedAttributeType[] reqAttribTypeArray;
            HashSet<String> attributeFilterList = new HashSet<String>();
            AttributeConsumingServiceType attribConsumingSvcType = attributeConsumingServices[0];
            for (RequestedAttributeType aReqAttribTypeArray : reqAttribTypeArray = attribConsumingSvcType.getRequestedAttributeArray()) {
                attributeFilterList.add(aReqAttribTypeArray.getName());
            }
            attributeRequester.setAttributeFilterList(attributeFilterList);
        }
        if ((roleExtensionType = this.processRoleExtensionBaseConnInfo((RoleDescriptorType)attributeQueryDescType, spConnection)) != null && roleExtensionType.isSetSP()) {
            AttributeServicePolicyType attributeServicePolicy;
            AttributeMappingType attributeMappingType;
            SpExtensionType spExt = roleExtensionType.getSP();
            AdapterToAssertionMappingType[] mappingTypeArray = spExt.getAdapterToAssertionMappingArray();
            if (mappingTypeArray != null && mappingTypeArray.length > 0 && (attributeMappingType = mappingTypeArray[0].getDefaultAttributeMapping()) != null) {
                AttributeMapping attributeMapping = this.getAttributeMapping(attributeMappingType);
                attributeRequester.setAttributeMapping(attributeMapping);
            }
            if ((attributeServicePolicy = spExt.getAttributeServicePolicy()) != null) {
                attributeRequester.setSignResponse(attributeServicePolicy.getSignResponse());
                attributeRequester.setSignAssertion(attributeServicePolicy.getSignAssertion());
                attributeRequester.setEncryptAssertion(attributeServicePolicy.getEncryptAssertion());
                attributeRequester.setRequireSignedAttributeQuery(attributeServicePolicy.getRequireSignedAttributeQuery());
                attributeRequester.setRequireEncryptedNameId(attributeServicePolicy.getRequireEncryptedNameId());
            }
        }
        spConnection.setAttributeRequester(attributeRequester);
    }

    private void setJitProvisioning(IdpExtensionType idpExt, UserProvisioning userProvisioning) {
        if (userProvisioning != null) {
            Map<String, List<AttrMappingValue>> attributeMap;
            UserProvisioningType userProvisioningType = idpExt.addNewUserProvisioning();
            userProvisioningType.setAttributeQuery(userProvisioning.isDoAttributeQuery());
            userProvisioningType.setErrorHandling(userProvisioning.getErrorHandling().toString());
            if (UserProvisioning.SqlMethodType.StoredProcedure.equals((Object)userProvisioning.getSqlMethod())) {
                userProvisioningType.setEventTrigger(UserProvisioning.EventTriggerType.AllSAMLAssertions.toString());
            } else {
                userProvisioningType.setEventTrigger(userProvisioning.getEventTrigger().toString());
            }
            userProvisioningType.setSqlMethod(userProvisioning.getSqlMethod().toString());
            AttributeSource attributeSource = userProvisioning.getAttributeSource();
            AttributeSourceType attributeSourceType = userProvisioningType.addNewAttributeSource();
            if (attributeSource != null && attributeSourceType != null) {
                this.fillInAttributeSource(attributeSourceType, attributeSource);
            }
            if ((attributeMap = userProvisioning.getAttributeMapping()) != null && !attributeMap.isEmpty()) {
                for (Map.Entry<String, List<AttrMappingValue>> entry : attributeMap.entrySet()) {
                    String attribame = entry.getKey();
                    for (AttrMappingValue attribValue : entry.getValue()) {
                        AttributeMapType attribMapType = userProvisioningType.addNewAttributeMap();
                        attribMapType.setName(attribame);
                        attribMapType.setType(attribValue.getTypeString());
                        attribMapType.setValueText(attribValue.getValue());
                        if (attribValue.getDelimiter() == null) continue;
                        attribMapType.setDelimiter(attribValue.getDelimiter());
                    }
                }
            }
        }
    }

    private void getJitProvisioning(UserProvisioningType userProvisioningType, IdpConnection idpConnection) {
        if (userProvisioningType != null) {
            UserProvisioning userProvisioning = new UserProvisioning();
            userProvisioning.setDoAttributeQuery(userProvisioningType.getAttributeQuery());
            if (UserProvisioning.ErrorHandlingType.AbortSSO.toString().equals(userProvisioningType.getErrorHandling())) {
                userProvisioning.setErrorHandling(UserProvisioning.ErrorHandlingType.AbortSSO);
            }
            if (UserProvisioning.EventTriggerType.AllSAMLAssertions.toString().equals(userProvisioningType.getEventTrigger())) {
                userProvisioning.setEventTrigger(UserProvisioning.EventTriggerType.AllSAMLAssertions);
            }
            if (UserProvisioning.SqlMethodType.StoredProcedure.toString().equals(userProvisioningType.getSqlMethod())) {
                userProvisioning.setSqlMethod(UserProvisioning.SqlMethodType.StoredProcedure);
            }
            this.getAttributeMapping(userProvisioningType.getAttributeSource(), userProvisioningType.getAttributeMapArray(), userProvisioningType.getTokenAuthorizationIssuanceCriteria(), (AttributeMapping)userProvisioning);
            idpConnection.setUserProvisioning(userProvisioning);
        }
    }

    private void logUnsupportedAlgorithms(String encryptionAlgorithm, String entityId) {
        boolean isTripleDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(encryptionAlgorithm);
        if (isTripleDES && PropertyInfo.isBCFIPSMode()) {
            log.warn((Object)("Loaded connection " + entityId + " uses Triple DES block encryption, but this algorithm is not supported when BCFIPS mode is enabled."));
        }
    }
}

