/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner.impl;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.JDBCHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.metadata.partner.IndexDb;
import org.sourceid.saml20.metadata.partner.NewConnFile;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ConnectionDbImpl
extends IndexDb
implements ConnectionDb {
    private static final String SYSTEM_ID = "SYSTEM_ID";
    private static final String ENTITY_ID = "ENTITY_ID";
    private static final String NAME = "NAME";
    private static final String CONN_TYPE = "CONN_TYPE";
    private static final String ACTIVE = "ACTIVE";
    private static final String DYNAMIC = "DYNAMIC";
    private static final String WS_TRUST_ENABLED = "WS_TRUST_ENABLED";
    private static final String IDP_INITIATED_SSO_ENABLED = "IDP_INITIATED_SSO_ENABLED";
    private static final String SP_INITIATED_SSO_ENABLED = "SP_INITIATED_SSO_ENABLED";
    private static final String FILE_PATH = "FILE_PATH";
    private static final String MODIFIED_TIME = "MODIFIED_TIME";
    private static final String TARGET_URL = "TARGET_URL";
    private static final String SOURCE_ID = "SOURCE_ID";
    private static final String PROTOCOL = "PROTOCOL";
    private static final String HAS_SSO_TO_OAUTH_ATTR_MAPPING = "HAS_SSO_TO_OAUTH_ATTR_MAPPING";
    private static final String OAUTH_APC_ID = "OAUTH_APC_ID";
    private static final String HAS_CONN_BASED_PLUGIN_OVERRIDES = "HAS_CBPOS";
    private static final String ALL_COLUMNS = StringUtils.join(Arrays.asList("SYSTEM_ID", "ENTITY_ID", "CONN_TYPE", "ACTIVE", "DYNAMIC", "WS_TRUST_ENABLED", "IDP_INITIATED_SSO_ENABLED", "SP_INITIATED_SSO_ENABLED", "FILE_PATH", "MODIFIED_TIME", "TARGET_URL", "SOURCE_ID", "PROTOCOL", "HAS_SSO_TO_OAUTH_ATTR_MAPPING", "OAUTH_APC_ID", "NAME", "HAS_CBPOS"), (String)",");
    private static final String SQL_CREATE_CONNECTIONS_TABLE = "CREATE TABLE IF NOT EXISTS CONNECTIONS(SYSTEM_ID VARCHAR(64) PRIMARY KEY, ENTITY_ID VARCHAR(1024) NOT NULL, CONN_TYPE VARCHAR(32) NOT NULL, ACTIVE BOOLEAN NOT NULL, DYNAMIC BOOLEAN NOT NULL, WS_TRUST_ENABLED BOOLEAN NOT NULL, IDP_INITIATED_SSO_ENABLED BOOLEAN NOT NULL, SP_INITIATED_SSO_ENABLED BOOLEAN NOT NULL, FILE_PATH VARCHAR(256) NOT NULL, MODIFIED_TIME BIGINT, TARGET_URL VARCHAR(1024) NOT NULL, SOURCE_ID VARCHAR(64), PROTOCOL VARCHAR(32), HAS_SSO_TO_OAUTH_ATTR_MAPPING BOOLEAN NOT NULL, OAUTH_APC_ID VARCHAR(16), NAME VARCHAR(512), HAS_CBPOS BOOLEAN NOT NULL)";
    private static final String SQL_CREATE_CONNS_TYPE_ENTITY_ID_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_TYPE_ENTITY_ID ON CONNECTIONS(CONN_TYPE,ENTITY_ID)";
    private static final String SQL_CREATE_CONNS_MODIFIED_TIME_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_MODIFIED_TIME ON CONNECTIONS(MODIFIED_TIME)";
    private static final String SQL_CREATE_CONNS_WITH_WS_TRUST_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_WITH_WS_TRUST ON CONNECTIONS(WS_TRUST_ENABLED)";
    private static final String SQL_CREATE_CONNS_TARGET_URL_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_TARGET_URL ON CONNECTIONS(TARGET_URL,CONN_TYPE)";
    private static final String SQL_CREATE_CONNS_SOURCE_ID_PROTOCOL_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_SOURCE_ID_PROTOCOL ON CONNECTIONS(PROTOCOL, SOURCE_ID)";
    private static final String SQL_CREATE_CONNS_HAS_SSO_TO_OAUTH_ATTR_MAPPING_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_HAS_SSO_TO_OAUTH_ATTR_MAPPING ON CONNECTIONS(HAS_SSO_TO_OAUTH_ATTR_MAPPING)";
    private static final String SQL_CREATE_CONNS_OAUTH_APC_ID_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_OAUTH_APC_ID ON CONNECTIONS(OAUTH_APC_ID)";
    private static final String SQL_CREATE_CONNS_NAME_INDEX = "CREATE INDEX IF NOT EXISTS IDX_CONNS_NAME_ID ON CONNECTIONS(CONN_TYPE,NAME)";
    private static final String SQL_UPDATE_CONN = "MERGE INTO CONNECTIONS(" + ALL_COLUMNS + ") VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_DELETE_CONN = "DELETE FROM CONNECTIONS WHERE SYSTEM_ID=?";
    private static final String SQL_DELETE_CONNS = "DELETE FROM CONNECTIONS LIMIT ?";
    private static final String SQL_SELECT_CONN = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE SYSTEM_ID = ?";
    private static final String SQL_SELECT_CONN_BY_ENTITY_ID = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE CONN_TYPE = ? AND ENTITY_ID = ?";
    private static final String SQL_SELECT_ALL_CONNS = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS";
    private static final String SQL_SELECT_ACTIVE_CONNS_COUNT = "SELECT COUNT(*) FROM CONNECTIONS WHERE CONN_TYPE = ? AND ACTIVE = ? AND DYNAMIC = ?";
    private static final String SQL_SELECT_ALL_CONN_TYPE_ACTIVE_CONNS = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE CONN_TYPE = ? AND ACTIVE = ? AND DYNAMIC = ?";
    private static final String SQL_SELECT_CONN_COUNT = "SELECT COUNT(*) FROM CONNECTIONS";
    private static final String SQL_SELECT_CONN_COUNT_FOR_LICENSING = "SELECT SUM (CASE WHEN CONVERT(IDP_INITIATED_SSO_ENABLED, INT) + CONVERT(SP_INITIATED_SSO_ENABLED, INT) >= 1 THEN CONVERT(WS_TRUST_ENABLED, INT) + 1 ELSE CONVERT(WS_TRUST_ENABLED, INT) END) AS TOTALCNT FROM CONNECTIONS";
    private static final String SQL_SELECT_WS_TRUST_CONNS = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE CONN_TYPE = ? AND WS_TRUST_ENABLED = TRUE";
    private static final String SQL_SELECT_CONNS_WITH_TARGET_URL = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE TARGET_URL = ? AND CONN_TYPE = ?";
    private static final String SQL_SELECT_CONNS_SOURCEID_AND_PROTOCOL = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE SOURCE_ID = ? AND PROTOCOL = ?";
    private static final String SQL_SELECT_CONNS_PROTOCOL = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE PROTOCOL = ? AND CONN_TYPE = ?";
    private static final String SQL_SELECT_CONNS_CONN_TYPE = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE CONN_TYPE = ?";
    private static final String SQL_SELECT_CONNS_NAME = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE CONN_TYPE = ? AND NAME = ?";
    private static final String SQL_SELECT_HAS_CONN_BASED_PLUGIN_OVERRIDES = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE CONN_TYPE = ? AND HAS_CBPOS = TRUE";
    private static final String SQL_SELECT_HAS_SSO_TO_OAUTH_ATTR_MAPPING_CONNS = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE HAS_SSO_TO_OAUTH_ATTR_MAPPING = TRUE AND ACTIVE = TRUE";
    private static final String SQL_SELECT_HAS_OAUTH_APC_ID_CONNS = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE OAUTH_APC_ID IS NOT NULL AND ACTIVE = TRUE";
    private static final String SQL_SELECT_CONNS_MODIFIED_SINCE = "SELECT " + ALL_COLUMNS + " FROM CONNECTIONS WHERE MODIFIED_TIME >= ?";
    private static final String SQL_SELECT_LATEST_UPDATE_TIMESTAMP = "SELECT MAX(MODIFIED_TIME) FROM CONNECTIONS";
    private static final String SQL_CREATE_NEW_CONN_FILES_TABLE = "CREATE TABLE IF NOT EXISTS NEW_CONN_FILES(SYSTEM_ID VARCHAR(64) PRIMARY KEY, FILE_PATH VARCHAR(256) NOT NULL)";
    private static final String SQL_ADD_NEW_CONN_FILE = "MERGE INTO NEW_CONN_FILES(SYSTEM_ID, FILE_PATH) VALUES (?, ?)";
    private static final String SQL_SELECT_NEW_CONN_FILES = "SELECT SYSTEM_ID, FILE_PATH FROM NEW_CONN_FILES";
    private static final String SQL_SELECT_NEW_CONN_FILE = "SELECT SYSTEM_ID, FILE_PATH FROM NEW_CONN_FILES WHERE SYSTEM_ID = ?";
    private static final String SQL_DELETE_NEW_CONN_FILE = "DELETE FROM NEW_CONN_FILES WHERE SYSTEM_ID = ?";
    private static final String SQL_DELETE_NEW_CONN_FILES = "DELETE FROM NEW_CONN_FILES";
    private static final String SQL_SELECT_NEW_CONN_FILE_COUNT = "SELECT COUNT(*) FROM NEW_CONN_FILES";

    public ConnectionDbImpl() {
        this.createTables();
    }

    public String getServiceName() {
        return "connection-index-db";
    }

    @Override
    public void saveEntry(ConnectionDbEntry conn) {
        this.saveEntries(Collections.singletonList(conn));
    }

    @Override
    public void saveEntries(Collection<ConnectionDbEntry> conns) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement statement = helper.getPreparedStatement(SQL_UPDATE_CONN);
            for (ConnectionDbEntry conn : conns) {
                statement.setString(1, conn.getId());
                statement.setString(2, conn.getEntityId());
                statement.setString(3, conn.getRole().name());
                statement.setBoolean(4, conn.isActive());
                statement.setBoolean(5, conn.getDynamic());
                statement.setBoolean(6, conn.isWsTrustEnabled());
                statement.setBoolean(7, conn.isIdpInitiatedSSOEnabled());
                statement.setBoolean(8, conn.isSpInitiatedSSOEnabled());
                statement.setString(9, conn.getFileSystemPath());
                statement.setLong(10, conn.getLastModifiedMillis());
                statement.setString(11, conn.getTargetUrl());
                statement.setString(12, this.getBase64SourceId(conn.getSourceId()));
                statement.setString(13, conn.getProtocol().name());
                statement.setBoolean(14, conn.hasSSOToOAuthAttrMapping());
                statement.setString(15, conn.getOAuthApcId());
                statement.setString(16, conn.getName());
                statement.setBoolean(17, conn.hasConnBasedPluginOverrides());
                statement.execute();
            }
            helper.commit();
        }
    }

    @Override
    public void deleteEntry(String id) {
        this.deleteEntries(Collections.singletonList(id));
    }

    @Override
    public void deleteEntries(Collection<String> ids) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement statement = helper.getPreparedStatement(SQL_DELETE_CONN);
            for (String id : ids) {
                statement.setString(1, id);
                statement.execute();
            }
            helper.commit();
        }
    }

    @Override
    public void deleteAllEntries() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement;
            helper.setAutoCommit(false);
            int deleted = 0;
            do {
                statement = helper.getPreparedStatement(SQL_DELETE_CONNS);
                statement.setInt(1, 1000);
            } while ((deleted = statement.executeUpdate()) == 1000);
            helper.commit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConnectionDbEntry getEntry(String id) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONN);
            statement.setString(1, id);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                ConnectionDbEntry connectionDbEntry = this.entryFromResultSet(resultSet);
                return connectionDbEntry;
            }
            ConnectionDbEntry connectionDbEntry = null;
            return connectionDbEntry;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConnectionDbEntry getEntryByEntityId(Role role, String entityId) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONN_BY_ENTITY_ID);
            statement.setString(1, role.name());
            statement.setString(2, entityId);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                ConnectionDbEntry connectionDbEntry = this.entryFromResultSet(resultSet);
                return connectionDbEntry;
            }
            ConnectionDbEntry connectionDbEntry = null;
            return connectionDbEntry;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
    }

    @Override
    public Collection<ConnectionDbEntry> getAllEntries() {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_ALL_CONNS);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                result.add(this.entryFromResultSet(resultSet));
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesByRoleAndStatus(Role role, boolean active, boolean dynamic) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_ALL_CONN_TYPE_ACTIVE_CONNS);
            statement.setString(1, role.toString());
            statement.setBoolean(2, active);
            statement.setBoolean(3, dynamic);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getActiveEntriesWithAnSSOToOAuthAttrMapping() {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_HAS_SSO_TO_OAUTH_ATTR_MAPPING_CONNS);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesModifiedSince(Date startTime) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONNS_MODIFIED_SINCE);
            statement.setLong(1, startTime.getTime());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entries", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getActiveEntriesWithAnOAuthApcId() {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_HAS_OAUTH_APC_ID_CONNS);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getEntryCountByRoleAndStatus(Role role, boolean active, boolean dynamic) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_ACTIVE_CONNS_COUNT);
            statement.setString(1, role.toString());
            statement.setBoolean(2, active);
            statement.setBoolean(3, dynamic);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getEntryCount() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_CONN_COUNT);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting conn count", e);
        }
    }

    @Override
    public int getConnectionCountForLicensing() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_CONN_COUNT_FOR_LICENSING);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
    }

    @Override
    public Collection<ConnectionDbEntry> getWstrustConnections(Role role) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_WS_TRUST_CONNS);
            statement.setString(1, role.toString());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesByTargetUrl(String targetUrl) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONNS_WITH_TARGET_URL);
            statement.setString(1, targetUrl);
            statement.setString(2, Role.SP.name());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesByProtocolAndSourceId(byte[] sourceId, Protocol protocol) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONNS_SOURCEID_AND_PROTOCOL);
            statement.setString(1, this.getBase64SourceId(sourceId));
            statement.setString(2, protocol.name());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesByRole(Role role) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONNS_CONN_TYPE);
            statement.setString(1, role.name());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesByProtocolAndRole(Protocol protocol, Role role) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONNS_PROTOCOL);
            statement.setString(1, protocol.name());
            statement.setString(2, role.name());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Date getLatestUpdateTimestamp() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_LATEST_UPDATE_TIMESTAMP);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                Date date = new Date(resultSet.getLong(1));
                return date;
            }
            try {
                throw new ProcessRuntimeException("Query for latest update timestamp returned NULL");
            }
            catch (SQLException e) {
                throw new ProcessRuntimeException("Error getting latest update timestamp", e);
            }
        }
    }

    @Override
    public Collection<NewConnFile> getNewConnFiles() {
        JDBCHelper helper = this.newJDBCHelper();
        try {
            ArrayList<NewConnFile> results = new ArrayList<NewConnFile>();
            helper.getPreparedStatement(SQL_SELECT_NEW_CONN_FILES);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                results.add(this.newConnFileFromResultSet(resultSet));
            }
            ArrayList<NewConnFile> arrayList = results;
            if (helper != null) {
                helper.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (helper != null) {
                    try {
                        helper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ProcessRuntimeException("Error getting new conn files", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NewConnFile getNewConnFile(String id) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_NEW_CONN_FILE);
            statement.setString(1, id);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                NewConnFile newConnFile = this.newConnFileFromResultSet(resultSet);
                return newConnFile;
            }
            NewConnFile newConnFile = null;
            return newConnFile;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting new conn file", e);
        }
    }

    @Override
    public void addNewConnFiles(Collection<NewConnFile> connFiles) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement statement = helper.getPreparedStatement(SQL_ADD_NEW_CONN_FILE);
            for (NewConnFile connFile : connFiles) {
                statement.setString(1, connFile.getId());
                statement.setString(2, connFile.getFilePath());
                statement.execute();
            }
            helper.commit();
        }
    }

    @Override
    public void deleteNewConnFiles() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_DELETE_NEW_CONN_FILES);
            statement.execute();
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error deleting new conn files", e);
        }
    }

    @Override
    public void deleteNewConnFile(String id) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_DELETE_NEW_CONN_FILE);
            statement.setString(1, id);
            statement.execute();
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error deleting new conn file", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getNewConnFileCount() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_NEW_CONN_FILE_COUNT);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting new conn file count", e);
        }
    }

    private NewConnFile newConnFileFromResultSet(ResultSet resultSet) throws SQLException {
        return new NewConnFile(resultSet.getString(SYSTEM_ID), resultSet.getString(FILE_PATH));
    }

    private ConnectionDbEntry entryFromResultSet(ResultSet resultSet) throws SQLException {
        return new ConnectionDbEntry(resultSet.getString(SYSTEM_ID), resultSet.getString(ENTITY_ID), Role.valueOf(resultSet.getString(CONN_TYPE)), resultSet.getBoolean(ACTIVE), resultSet.getBoolean(DYNAMIC), resultSet.getBoolean(WS_TRUST_ENABLED), resultSet.getBoolean(IDP_INITIATED_SSO_ENABLED), resultSet.getBoolean(SP_INITIATED_SSO_ENABLED), resultSet.getLong(MODIFIED_TIME), resultSet.getString(FILE_PATH), resultSet.getString(TARGET_URL), this.getSourceIdBytes(resultSet.getString(SOURCE_ID)), Protocol.valueOf(resultSet.getString(PROTOCOL)), resultSet.getBoolean(HAS_SSO_TO_OAUTH_ATTR_MAPPING), resultSet.getString(OAUTH_APC_ID), resultSet.getString(NAME), resultSet.getBoolean(HAS_CONN_BASED_PLUGIN_OVERRIDES));
    }

    private void createTables() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.execute(SQL_CREATE_CONNECTIONS_TABLE);
            helper.execute(SQL_CREATE_CONNS_TYPE_ENTITY_ID_INDEX);
            helper.execute(SQL_CREATE_CONNS_MODIFIED_TIME_INDEX);
            helper.execute(SQL_CREATE_CONNS_WITH_WS_TRUST_INDEX);
            helper.execute(SQL_CREATE_CONNS_TARGET_URL_INDEX);
            helper.execute(SQL_CREATE_CONNS_SOURCE_ID_PROTOCOL_INDEX);
            helper.execute(SQL_CREATE_CONNS_HAS_SSO_TO_OAUTH_ATTR_MAPPING_INDEX);
            helper.execute(SQL_CREATE_CONNS_OAUTH_APC_ID_INDEX);
            helper.execute(SQL_CREATE_CONNS_NAME_INDEX);
            helper.execute(SQL_CREATE_NEW_CONN_FILES_TABLE);
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error creating connection tables/indexes", e);
        }
    }

    private String getBase64SourceId(byte[] sourceId) {
        if (sourceId != null) {
            return B64.encode((byte[])sourceId);
        }
        return null;
    }

    private byte[] getSourceIdBytes(String base64SourceId) {
        byte[] sourceIdBytes = null;
        if (base64SourceId != null) {
            sourceIdBytes = B64.decodeToBytes((String)base64SourceId);
        }
        return sourceIdBytes;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesByName(String name, Role role) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONNS_NAME);
            statement.setString(1, role.name());
            statement.setString(2, name);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    @Override
    public Collection<ConnectionDbEntry> getEntriesWithConnBasedPluginOverrides(Role role) {
        ArrayList<ConnectionDbEntry> result = new ArrayList<ConnectionDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_HAS_CONN_BASED_PLUGIN_OVERRIDES);
            statement.setString(1, role.name());
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                ConnectionDbEntry entry = this.entryFromResultSet(resultSet);
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entries with conn-based plugin instances for role " + role, e);
        }
        return result;
    }
}

