/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner.impl;

import com.pingidentity.common.util.JDBCHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.metadata.partner.IndexDb;
import org.sourceid.saml20.metadata.partner.TargetAttributeMappingDb;
import org.sourceid.saml20.metadata.partner.TargetAttributeMappingDbEntry;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class TargetAttributeMappingDbImpl
extends IndexDb
implements TargetAttributeMappingDb {
    private static final String SYSTEM_ID = "SYSTEM_ID";
    private static final String ADAPTER_ID = "ADAPTER_ID";
    private static final String ALL_COLUMNS = StringUtils.join(Arrays.asList("SYSTEM_ID", "ADAPTER_ID"), (String)",");
    private static final String SQL_CREATE_TARGET_ATTRIBUTE_MAPPING_TABLE = "CREATE TABLE IF NOT EXISTS TARGET_ATTRIBUTE_MAPPING (SYSTEM_ID VARCHAR(64) NOT NULL, ADAPTER_ID VARCHAR(64) NOT NULL, PRIMARY KEY (SYSTEM_ID, ADAPTER_ID), CONSTRAINT FK_TARGET_ATTRIBUTE_MAPPING_SYSTEM_ID FOREIGN KEY (SYSTEM_ID) REFERENCES CONNECTIONS (SYSTEM_ID) ON DELETE CASCADE)";
    private static final String SQL_CREATE_TARGET_ATTRIBUTE_MAPPING_ADAPTER_ID_INDEX = "CREATE INDEX IF NOT EXISTS IDX_TARGET_ATTRIBUTE_MAPPING_ADAPTER_ID ON TARGET_ATTRIBUTE_MAPPING(ADAPTER_ID)";
    private static final String SQL_UPDATE_TARGET_ATTRIBUTE_MAPPING = "MERGE INTO TARGET_ATTRIBUTE_MAPPING(" + ALL_COLUMNS + ") VALUES(?,?)";
    private static final String SQL_SELECT_CONNS_BY_ADAPTER_ID = "SELECT " + ALL_COLUMNS + " FROM TARGET_ATTRIBUTE_MAPPING WHERE ADAPTER_ID = ?";
    private static final String SQL_DELETE_TARGET_ATTRIBUTE_MAPPING_BY_SYSTEM_ID = "DELETE FROM TARGET_ATTRIBUTE_MAPPING WHERE SYSTEM_ID = ?";

    public TargetAttributeMappingDbImpl() {
        this.createTables();
    }

    public String getServiceName() {
        return "target-attribute-mapping-index-db";
    }

    @Override
    public void deleteAndSaveEntries(String systemId, Collection<TargetAttributeMappingDbEntry> mappingsWithAUniqueSystemId) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement deleteStatement = helper.getPreparedStatement(SQL_DELETE_TARGET_ATTRIBUTE_MAPPING_BY_SYSTEM_ID);
            deleteStatement.setString(1, systemId);
            deleteStatement.execute();
            PreparedStatement insertStatement = helper.getPreparedStatement(SQL_UPDATE_TARGET_ATTRIBUTE_MAPPING);
            for (TargetAttributeMappingDbEntry mapping : mappingsWithAUniqueSystemId) {
                insertStatement.setString(1, mapping.getSystemId());
                insertStatement.setString(2, mapping.getAdapterId());
                insertStatement.execute();
            }
            helper.commit();
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public Collection<TargetAttributeMappingDbEntry> getEntriesByAdapterId(String adapterId) {
        ArrayList<TargetAttributeMappingDbEntry> result = new ArrayList<TargetAttributeMappingDbEntry>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_CONNS_BY_ADAPTER_ID);
            statement.setString(1, adapterId);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                result.add(this.entryFromResultSet(resultSet));
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    private TargetAttributeMappingDbEntry entryFromResultSet(ResultSet resultSet) throws SQLException {
        return new TargetAttributeMappingDbEntry(resultSet.getString(SYSTEM_ID), resultSet.getString(ADAPTER_ID));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    private void createTables() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.execute(SQL_CREATE_TARGET_ATTRIBUTE_MAPPING_TABLE);
            helper.execute(SQL_CREATE_TARGET_ATTRIBUTE_MAPPING_ADAPTER_ID_INDEX);
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error creating connection tables/indexes", e);
        }
    }
}

