/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.profiles.AdapterLogoutMode;
import org.sourceid.saml20.state.StateSupport;

public abstract class AdapterLogoutManager<AuthnBeanType> {
    protected StateSupport stateSupport = new StateSupport(MetaDataFactory.getLocalMetaData());
    protected Collection<AuthnBeanType> authnBeans = Collections.emptyList();
    protected HttpServletRequest req;
    protected HttpServletResponse resp;
    protected AdapterLogoutMode logoutMode;
    protected boolean overallResult;
    protected boolean isFirstAdapter = false;

    public AdapterLogoutManager(Collection<AuthnBeanType> authnBeans, HttpServletRequest req, HttpServletResponse resp, AdapterLogoutMode logoutMode, boolean initialResult) {
        if (authnBeans != null) {
            this.authnBeans = authnBeans;
        }
        this.req = req;
        this.resp = resp;
        this.logoutMode = logoutMode;
        this.overallResult = initialResult;
    }

    public AdapterLogoutManager(Collection<AuthnBeanType> authnBeans, HttpServletRequest req, HttpServletResponse resp, AdapterLogoutMode logoutMode, boolean initialResult, boolean isFirstAdapter) {
        this(authnBeans, req, resp, logoutMode, initialResult);
        this.isFirstAdapter = isFirstAdapter;
    }

    public boolean doLogout() throws AuthnAdapterException, IOException {
        int index = -1;
        Iterator<AuthnBeanType> i = this.authnBeans.iterator();
        while (i.hasNext()) {
            ++index;
            AuthnBeanType authnBean = i.next();
            boolean currentResult = false;
            if (this.logoutMode == AdapterLogoutMode.BACK_CHANNEL_ONLY) {
                currentResult = this.logoutAuthN(authnBean, null, null, null);
            } else {
                String resumePath = this.saveLogoutState();
                if (this.isFirstAdapter || index >= 1) {
                    resumePath = this.stateSupport.insertNonce(resumePath);
                }
                currentResult = this.logoutAuthN(authnBean, this.req, this.resp, resumePath);
            }
            if (this.logoutMode != AdapterLogoutMode.BACK_CHANNEL_ONLY && this.resp.isCommitted()) {
                return false;
            }
            this.overallResult = this.overallResult && currentResult;
            this.handleLogoutResult(this.overallResult, currentResult);
            i.remove();
        }
        return true;
    }

    public boolean getOverallResult() {
        return this.overallResult;
    }

    protected abstract boolean logoutAuthN(AuthnBeanType var1, HttpServletRequest var2, HttpServletResponse var3, String var4) throws AuthnAdapterException, IOException;

    protected abstract String saveLogoutState();

    protected void handleLogoutResult(boolean overallResult, boolean currentResult) {
    }
}

