/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.bindings.Artifact;
import org.sourceid.saml20.bindings.ArtifactV4;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.profiles.RequestHandlerBase;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.ArtifactResponseTypeUtil;
import org.sourceid.saml20.protocol.StatusResponseTypeUtil;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResolveDocument;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResolveType;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResponseType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.bindings.ArtifactSupport;
import org.sourceid.websso.profiles.RequestHandler;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

class HandleArtifactRequest
extends RequestHandlerBase
implements RequestHandler {
    private final ArtifactSupport artifactSupport = new ArtifactSupport();

    HandleArtifactRequest() {
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        OutMessageContext msgCtxOut = new OutMessageContext(inMsgCtx.getRoleType());
        ArtifactResponseDocument artRespDoc = ArtifactResponseDocument.Factory.newInstance();
        ArtifactResponseType artifactResponseType = artRespDoc.addNewArtifactResponse();
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, req).getVirtualEntityId(DomainMode.RUNTIME);
        StatusResponseTypeUtil.setDefaults(virtualServerId, (StatusResponseType)artifactResponseType, (RequestAbstractType)this.getArtifactResolveType(inMsgCtx));
        msgCtxOut.setXmlObject((XmlObject)artRespDoc);
        return msgCtxOut;
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, StatusResponseException {
        ArtifactResolveType artifactResolveType = this.getArtifactResolveType(inMsgCtx);
        String daart = artifactResolveType.getArtifact();
        TrackingIdSupport.addReference(daart);
        Artifact artifact = ArtifactV4.parse(daart);
        byte[] messageHandle = artifact.getMessageHandle();
        XmlObject storedXmlObj = this.artifactSupport.retrieveArtifact(messageHandle, inMsgCtx, outMsgCtx, daart, this.log);
        ArtifactResponseDocument artRespDoc = (ArtifactResponseDocument)outMsgCtx.getXmlObject();
        ArtifactResponseTypeUtil.addContent(artRespDoc.getArtifactResponse(), storedXmlObj);
    }

    private ArtifactResolveType getArtifactResolveType(InMessageContext inMsgCtx) {
        ArtifactResolveDocument artifactResolveDocument = (ArtifactResolveDocument)inMsgCtx.getXmlObject();
        return artifactResolveDocument.getArtifactResolve();
    }
}

