/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.SamlNameID;
import org.sourceid.saml20.service.WebSsoSession;

public class PartnerSessionGroup {
    private final String entityId;
    private final String virtualServerId;
    private final SamlNameID nameId;
    private final boolean maskNameId;
    private final Set<String> sessionIndices;

    public PartnerSessionGroup(WebSsoSession s) {
        this(s.getEntityId(), s.getVirtualServerId(), s.getNameId(), s.isMaskUserName());
        this.addSessionIndex(s.getSessionIndex());
    }

    public PartnerSessionGroup(String entityId, String virtualServerId, SamlNameID nameId, boolean maskNameId) {
        this.entityId = entityId;
        this.virtualServerId = virtualServerId;
        this.nameId = nameId;
        this.sessionIndices = new HashSet<String>();
        this.maskNameId = maskNameId;
    }

    public Set<String> getSessionIndices() {
        return this.sessionIndices;
    }

    public void addSessionIndex(String sessionIdx) {
        this.sessionIndices.add(sessionIdx);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getVirtualServerId() {
        return this.virtualServerId;
    }

    public SamlNameID getNameId() {
        return this.nameId;
    }

    public boolean isMaskNameId() {
        return this.maskNameId;
    }
}

