/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.protocol.InResponseToSupport;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.StatusCodeType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.saml20.xmlbinding.protocol.StatusType;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.ResumableResponseHandler;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public abstract class ResumableResponseHandlerBase
extends org.sourceid.websso.profiles.ResumableResponseHandlerBase
implements ResumableResponseHandler {
    private final InResponseToSupport inRespToSupport = new InResponseToSupport();

    @Override
    public void mainProcessTemplate(OutMessageContext reqMsgCtx, InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, InvalidResponseException, RenderPageException {
        XmlObject xmlObject = inMsgCtx.getXmlObject();
        StatusResponseType statusResponseType = (StatusResponseType)XmlBeansUtil.unwrapDocumentToType(xmlObject);
        this.validateXml(inMsgCtx);
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(inMsgCtx).toString());
        boolean isUnsolicitedResponse = this.validateInResponseTo(reqMsgCtx, statusResponseType);
        inMsgCtx.setUnsolicitedResponse(isUnsolicitedResponse);
        this.checkIssuer(reqMsgCtx, inMsgCtx);
        this.verifySignature(inMsgCtx, req);
        this.checkStatus(statusResponseType);
        this.doProcess(inMsgCtx, reqMsgCtx, req, resp);
    }

    protected boolean validateInResponseTo(OutMessageContext requestMsgCtx, StatusResponseType statusResponseType) throws InvalidResponseException {
        if (statusResponseType != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.RESPONSE_ID.toString(), (String)statusResponseType.getID());
        }
        if (requestMsgCtx != null) {
            String inResponseTo;
            XmlObject reqDoc = requestMsgCtx.getXmlObject();
            RequestAbstractType requestAbstractType = (RequestAbstractType)XmlBeansUtil.unwrapDocumentToType(reqDoc);
            String requestId = requestAbstractType.getID();
            ThreadContext.put((String)AuditLogger.MDC_KEY.REQUEST_ID.toString(), (String)requestId);
            String string = inResponseTo = statusResponseType == null ? null : statusResponseType.getInResponseTo();
            if (inResponseTo != null && !"".equals(inResponseTo)) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.IN_RESPONSE_TO.toString(), (String)inResponseTo);
            }
            if (!requestId.equals(inResponseTo)) {
                String message = "InResponseTo (" + inResponseTo + ") does not match id of request (" + requestId + ")";
                throw this.newIRE(message);
            }
            return false;
        }
        if (statusResponseType.isSetInResponseTo() && !this.inRespToSupport.relaxValidation()) {
            String inResponseTo = statusResponseType.getInResponseTo();
            String msg = "Invalid InResponseTo attribute (" + inResponseTo + ") - unsolicited responses cannot have an InResponseTo.";
            ThreadContext.put((String)AuditLogger.MDC_KEY.IN_RESPONSE_TO.toString(), (String)inResponseTo);
            throw this.newIRE(msg);
        }
        return true;
    }

    protected void checkStatus(StatusResponseType statusResponseType) throws InvalidResponseException {
        StatusType status = statusResponseType.getStatus();
        StatusCodeType statusCode = status.getStatusCode();
        TopLevelStatusCode topLevelStatusCode = TopLevelStatusCode.parse(statusCode.getValue());
        if (TopLevelStatusCode.SUCCESS != topLevelStatusCode) {
            ArrayList<String> secondLevelStatusCodes = new ArrayList<String>();
            while (statusCode.isSetStatusCode()) {
                statusCode = statusCode.getStatusCode();
                secondLevelStatusCodes.add(statusCode.getValue());
            }
            throw new InvalidSsoResponseException(topLevelStatusCode, secondLevelStatusCodes, status);
        }
    }
}

