/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import com.pingidentity.sdk.TransactionAwareAuthenticationAdapter;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.PolicyTreeState;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.SessionRegistryException;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class AuthenticationPolicyTreePostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationPolicyTreePostProcessor.class);
    private static final String POST_PROCESSING_TASKS = "postProcessingTasks";

    public void addPostProcessingTask(String instanceId, Map<String, Object> stateParams, IdpHashableAuthnBean authenticationBean) {
        String entityId = (String)stateParams.get("PartnerEntityId");
        IdpAuthenticationAdapter adapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapterWithConnectionOverride(instanceId, entityId);
        if (adapter instanceof TransactionAwareAuthenticationAdapter) {
            PostProcessingTask task = new PostProcessingTask(instanceId, entityId);
            this.addPostProcessingTask(stateParams, authenticationBean, task);
        }
    }

    public boolean isDeferAuthenticationBeanRegistration(Map<String, Object> stateParams, IdpHashableAuthnBean authenticationBean) {
        PostProcessingTask task = this.getPostProcessingTask(stateParams, authenticationBean);
        return task != null && task.isDeferAuthenticationSessionRegistration();
    }

    public void addDeferredAuthenticationBeanRegistrationInfo(Map<String, Object> stateParams, IdpHashableAuthnBean authenticationBean, IdpSessionRegistrySupport.AuthenticationBeanRegistrationInfo registrationInfo) {
        PostProcessingTask task = this.getPostProcessingTask(stateParams, authenticationBean);
        if (task != null) {
            task.addDeferredAuthenticationBeansRegistration(registrationInfo);
        }
    }

    public void doPostProcessing(HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams, Set<IdpHashableAuthnBean> successfullyAuthenticationBeans, AttributeMap policyResultMap) {
        for (Map.Entry<IdpHashableAuthnBean, PostProcessingTask> task : this.getPostProcessingTasks(stateParams).entrySet()) {
            if (successfullyAuthenticationBeans == null) {
                task.getValue().completeTask(request, response, stateParams, task.getKey().getAuthnIdentifiersMap(), null);
                continue;
            }
            if (!successfullyAuthenticationBeans.contains(task.getKey())) continue;
            task.getValue().completeTask(request, response, stateParams, task.getKey().getAuthnIdentifiersMap(), policyResultMap);
        }
    }

    private Map<IdpHashableAuthnBean, PostProcessingTask> getPostProcessingTasks(Map<String, Object> stateParams) {
        Map tasks = (Map)stateParams.get(POST_PROCESSING_TASKS);
        return tasks == null ? new HashMap() : tasks;
    }

    private void addPostProcessingTask(Map<String, Object> stateParams, IdpHashableAuthnBean authenticationBean, PostProcessingTask task) {
        Map<IdpHashableAuthnBean, PostProcessingTask> tasks = this.getPostProcessingTasks(stateParams);
        tasks.put(authenticationBean, task);
        stateParams.put(POST_PROCESSING_TASKS, tasks);
    }

    private PostProcessingTask getPostProcessingTask(Map<String, Object> stateParams, IdpHashableAuthnBean authenticationBean) {
        return this.getPostProcessingTasks(stateParams).get(authenticationBean);
    }

    private static class PostProcessingTask
    implements Serializable {
        private final String adapterInstanceId;
        private final String entityId;
        private IdpSessionRegistrySupport.AuthenticationBeanRegistrationInfo deferredAuthenticationBeansRegistration = null;

        private PostProcessingTask(String adapterInstanceId, String entityId) {
            this.adapterInstanceId = adapterInstanceId;
            this.entityId = entityId;
        }

        private TransactionAwareAuthenticationAdapter getTransactionAwareAuthenticationAdapter() {
            IdpAuthenticationAdapter adapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapterWithConnectionOverride(this.adapterInstanceId, this.entityId);
            if (adapter instanceof TransactionAwareAuthenticationAdapter) {
                return (TransactionAwareAuthenticationAdapter)adapter;
            }
            return null;
        }

        private boolean isDeferAuthenticationSessionRegistration() {
            TransactionAwareAuthenticationAdapter adapter = this.getTransactionAwareAuthenticationAdapter();
            return adapter != null && adapter.isDeferAuthenticationSessionRegistration();
        }

        private void addDeferredAuthenticationBeansRegistration(IdpSessionRegistrySupport.AuthenticationBeanRegistrationInfo registrationInfo) {
            this.deferredAuthenticationBeansRegistration = registrationInfo;
        }

        private void completeTask(HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams, Map<String, Object> authnIdentifiersMap, AttributeMap policyResultMap) {
            TransactionAwareAuthenticationAdapter adapter = this.getTransactionAwareAuthenticationAdapter();
            if (adapter != null) {
                Map<String, Object> parameters = this.getParameters(request, response, stateParams);
                if (policyResultMap != null) {
                    if (this.deferredAuthenticationBeansRegistration != null) {
                        try {
                            this.deferredAuthenticationBeansRegistration.register(request, response, stateParams);
                        }
                        catch (SessionRegistryException e) {
                            throw new ProcessRuntimeException("Unexpected error registering authn bean", e);
                        }
                        catch (SessionQuotaException e) {
                            logger.info("Session quota exceeded for deferred authentication bean registration for adapter instance '{}'. Calling adapter failure callbacks.", (Object)this.adapterInstanceId);
                            adapter.onTransactionFailure(request, response, Collections.unmodifiableMap(authnIdentifiersMap), parameters);
                            return;
                        }
                    }
                    adapter.onTransactionComplete(request, response, Collections.unmodifiableMap(authnIdentifiersMap), policyResultMap, parameters);
                } else {
                    adapter.onTransactionFailure(request, response, Collections.unmodifiableMap(authnIdentifiersMap), parameters);
                }
            }
        }

        private Map<String, Object> getParameters(HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams) {
            PolicyTreeState policyTreeState;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            String trackingId = TrackingIdSupport.generateTrackingId(request, response);
            String requestId = TrackingIdSupport.getRequestId();
            String transactionId = TransactionIdSupport.getTransactionId();
            String entityId = (String)stateParams.get("PartnerEntityId");
            String oauthClientId = (String)stateParams.get(Parameters.CLIENT_ID);
            String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
            Map<String, Object> chainedAttrs = (Map<String, Object>)stateParams.get("chainedAttributes");
            if (chainedAttrs == null && (policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams)) != null) {
                chainedAttrs = policyTreeState.getChainedAttributes();
            }
            parameters.put("com.pingidentity.adapter.input.parameter.tracking.id", trackingId);
            parameters.put("com.pingidentity.adapter.input.parameter.request.id", requestId);
            parameters.put("com.pingidentity.adapter.input.parameter.transaction.id", transactionId);
            parameters.put("com.pingidentity.adapter.input.parameter.partner.entityid", entityId);
            parameters.put("com.pingidentity.adapter.input.parameter.oauth.client.id", oauthClientId);
            if (StringUtils.isNotBlank((String)spAdapterId)) {
                parameters.put("com.pingidentity.adapter.input.parameter.sp.adapter.id", spAdapterId);
            }
            if (chainedAttrs != null) {
                parameters.put("com.pingidentity.adapter.input.parameter.chained.attributes", chainedAttrs);
            }
            return parameters;
        }
    }
}

