/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.xmlbinding.protocol.AuthnContextComparisonType;
import org.sourceid.saml20.xmlbinding.protocol.RequestedAuthnContextType;

public class AuthnCtxChecker {
    private boolean checkRequestedAuthnCtx = false;
    private Map<String, String> authnLevel = new HashMap<String, String>();
    private static AuthnCtxChecker instance = new AuthnCtxChecker();
    private Log log = LogFactory.getLog(this.getClass());

    private AuthnCtxChecker() {
        ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
        try {
            this.checkRequestedAuthnCtx = configStore.getBooleanValue("check-requested-authn-ctx", false);
            this.authnLevel = configStore.getMapValue("authentication-level");
        }
        catch (NoSuchValueException e) {
            this.log.info((Object)("Error in reading " + this.getClass().getName() + ".xml"));
        }
    }

    public static AuthnCtxChecker getInstance() {
        return instance;
    }

    public void validateAuthnCtx(RequestedAuthnContextType requestedAuthnContextType, String authnCtxClassRef) throws StatusResponseException {
        if (!this.checkRequestedAuthnCtx || requestedAuthnContextType == null) {
            return;
        }
        String[] requestedAuthnCtxClassRefs = requestedAuthnContextType.getAuthnContextClassRefArray();
        if (requestedAuthnCtxClassRefs == null || requestedAuthnCtxClassRefs.length == 0) {
            return;
        }
        AuthnContextComparisonType.Enum comparison = AuthnContextComparisonType.EXACT;
        if (requestedAuthnContextType.isSetComparison()) {
            comparison = requestedAuthnContextType.getComparison();
        }
        if (comparison == AuthnContextComparisonType.EXACT) {
            boolean match = false;
            for (String requestedCtx : requestedAuthnCtxClassRefs) {
                if (requestedCtx == null || !requestedCtx.equals(authnCtxClassRef)) continue;
                match = true;
                break;
            }
            if (!match) {
                this.processNoMatch(requestedAuthnCtxClassRefs, comparison, authnCtxClassRef, "Unable to satisfy the RequestedAuthnContext " + this.printRequestedCtx(requestedAuthnCtxClassRefs));
            }
        } else if (comparison == AuthnContextComparisonType.MINIMUM) {
            boolean match = false;
            for (String requestedCtx : requestedAuthnCtxClassRefs) {
                if (requestedCtx != null && requestedCtx.equals(authnCtxClassRef)) {
                    match = true;
                    break;
                }
                Integer requestedLevel = this.getAuthnLevel(requestedCtx);
                Integer suppliedLevel = this.getAuthnLevel(authnCtxClassRef);
                if (requestedLevel == null || suppliedLevel == null || requestedLevel > suppliedLevel) continue;
                match = true;
                break;
            }
            if (!match) {
                this.processNoMatch(requestedAuthnCtxClassRefs, comparison, authnCtxClassRef, "Unable to satisfy the RequestedAuthnContext " + this.printRequestedCtx(requestedAuthnCtxClassRefs) + " with comparison=" + comparison);
            }
        } else if (comparison == AuthnContextComparisonType.BETTER) {
            boolean match = false;
            for (String requestedCtx : requestedAuthnCtxClassRefs) {
                Integer requestedLevel = this.getAuthnLevel(requestedCtx);
                Integer suppliedLevel = this.getAuthnLevel(authnCtxClassRef);
                if (requestedLevel == null || suppliedLevel == null || requestedLevel >= suppliedLevel) continue;
                match = true;
                break;
            }
            if (!match) {
                this.processNoMatch(requestedAuthnCtxClassRefs, comparison, authnCtxClassRef, "Unable to satisfy the RequestedAuthnContext " + this.printRequestedCtx(requestedAuthnCtxClassRefs) + " with comparison=" + comparison);
            }
        } else if (comparison == AuthnContextComparisonType.MAXIMUM) {
            boolean match = false;
            for (String requestedCtx : requestedAuthnCtxClassRefs) {
                if (requestedCtx != null && requestedCtx.equals(authnCtxClassRef)) {
                    match = true;
                    break;
                }
                Integer requestedLevel = this.getAuthnLevel(requestedCtx);
                Integer suppliedLevel = this.getAuthnLevel(authnCtxClassRef);
                if (requestedLevel == null || suppliedLevel == null || requestedLevel < suppliedLevel) continue;
                match = true;
                break;
            }
            if (!match) {
                this.processNoMatch(requestedAuthnCtxClassRefs, comparison, authnCtxClassRef, "Unable to satisfy the RequestedAuthnContext " + this.printRequestedCtx(requestedAuthnCtxClassRefs) + " with comparison=" + comparison);
            }
        }
    }

    private void processNoMatch(String[] requestedAuthnCtxClassRefs, AuthnContextComparisonType.Enum comparison, String authnCtxClassRef, String msg) throws StatusResponseException {
        this.log.debug((Object)("requestedAuthnCtxClassRefs = " + this.printRequestedCtx(requestedAuthnCtxClassRefs)));
        this.log.debug((Object)("comparison = " + comparison));
        this.log.debug((Object)("authnCtxClassRef = " + authnCtxClassRef));
        this.log.info((Object)msg);
        throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "urn:oasis:names:tc:SAML:2.0:status:NoAuthnContext", msg);
    }

    private String printRequestedCtx(String[] requestedAuthnCtxClassRefs) {
        Object retV = "[";
        if (requestedAuthnCtxClassRefs != null) {
            boolean first = true;
            for (String ctx : requestedAuthnCtxClassRefs) {
                if (!first) {
                    retV = (String)retV + ",";
                }
                retV = (String)retV + ctx;
                first = false;
            }
        }
        retV = (String)retV + "]";
        return retV;
    }

    private Integer getAuthnLevel(String ctx) {
        Integer level = null;
        String levelStr = this.authnLevel.get(ctx);
        if (levelStr != null) {
            level = Integer.valueOf(levelStr);
        }
        return level;
    }
}

