/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.ognl.ExpressionCalculator;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigurationException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SimpleConditionEvaluator;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.PolicyTreeState;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.FragmentSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.wrapper.InMessageContext;

public class AuthnPolicyRuleEvaluator {
    private final Log log = LogFactory.getLog(AuthnPolicyRuleEvaluator.class);
    private static final String NOT_AUTHORIZED_TO_EVALUATE_OGNL = "Evaluation of OGNL expressions is not enabled. Skipping policy rule expression: ";
    private static final String PROBLEM_WITH_OGNL_EVALUATION = "Problem with OGNL expression evaluation.";
    private static final String OGNL_DID_NOT_EVALUATE_TO_BOOLEAN = "OGNL expression did not evaluate to Boolean, returning false for policy rule evaluation. Value is: ";
    private final AttributeRule attributeRule;

    public AuthnPolicyRuleEvaluator(AttributeRule attributeRule) {
        this.attributeRule = attributeRule;
    }

    public boolean isRuleConditionMet(HttpServletRequest request, HttpServletResponse resp, InMessageContext inMessageContext, Map<String, Object> stateParams, AuthnSourceKey previousAuthnSourceKey, AttributeMap previousAuthnAttributeMap, PolicyTreeState policyTreeState) {
        AttributeMap attributeMap;
        if (this.attributeRule.getAuthenticationSourceType() == null) {
            return SimpleConditionEvaluator.evaluate(previousAuthnAttributeMap, this.attributeRule, this.log);
        }
        if (SourceType.EXPRESSION.equals((Object)this.attributeRule.getAuthenticationSourceType())) {
            if (ExpressionManager.getInstance().isEvaluateExpressionsOff()) {
                this.log.warn((Object)(NOT_AUTHORIZED_TO_EVALUATE_OGNL + this.attributeRule.getExpression()));
                return false;
            }
            HashMap<String, AttributeMap> attributeMapSources = new HashMap<String, AttributeMap>();
            attributeMapSources.putAll(this.getAttributeMapSourcesFromAuthnAttributes(previousAuthnSourceKey, previousAuthnAttributeMap, policyTreeState));
            attributeMapSources.putAll(this.getAttributeMapSourcesFromRemainderOfSources(request, resp, inMessageContext, stateParams));
            try {
                Object parsedExpression = Ognl.parseExpression((String)this.attributeRule.getExpression());
                HashMap simpleAttributeMap = new HashMap();
                for (Map.Entry attributeValueEntry : AttributeMapping.createSubstitutionAttributes(attributeMapSources).entrySet()) {
                    simpleAttributeMap.put((String)attributeValueEntry.getKey(), attributeValueEntry.getValue());
                }
                Object value = ExpressionCalculator.calculate(parsedExpression, simpleAttributeMap, simpleAttributeMap);
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                this.log.debug((Object)(OGNL_DID_NOT_EVALUATE_TO_BOOLEAN + (Serializable)(value != null ? value.getClass() : "null")));
                return false;
            }
            catch (OgnlException e) {
                this.log.error((Object)PROBLEM_WITH_OGNL_EVALUATION, (Throwable)e);
                return false;
            }
        }
        switch (this.attributeRule.getAuthenticationSourceType()) {
            case ADAPTER: {
                AdapterAuthnSourceKey adapterAuthnSourceKey = new AdapterAuthnSourceKey(this.attributeRule.getAuthenticationSourceId());
                attributeMap = previousAuthnSourceKey.equals(adapterAuthnSourceKey) ? previousAuthnAttributeMap : this.getAttributeMapFromAuthnSourceKey(adapterAuthnSourceKey, policyTreeState);
                break;
            }
            case IDP_CONNECTION: {
                IdpConnAuthnSourceKey idpConnAuthnSourceKey = new IdpConnAuthnSourceKey(this.attributeRule.getAuthenticationSourceId());
                attributeMap = previousAuthnSourceKey.equals(idpConnAuthnSourceKey) ? previousAuthnAttributeMap : this.getAttributeMapFromAuthnSourceKey(idpConnAuthnSourceKey, policyTreeState);
                break;
            }
            case FRAGMENT: 
            case INPUTS: {
                FragmentSourceKey fragmentAuthnSourceKey = new FragmentSourceKey(this.attributeRule.getAuthenticationSourceId());
                attributeMap = this.getAttributeMapFromAuthnSourceKey(fragmentAuthnSourceKey, policyTreeState);
                break;
            }
            case CONTEXT: {
                attributeMap = AuthnSourceSupportBase.getContextAttributeMap(request, resp, inMessageContext, stateParams);
                break;
            }
            case TRACKED_HTTP_PARAMS: {
                attributeMap = this.getTrackedParameterAttributes(stateParams);
                break;
            }
            case EXTENDED_PROPERTIES: {
                attributeMap = this.getExtendedPropertiesAttributes(inMessageContext);
                break;
            }
            default: {
                return false;
            }
        }
        return SimpleConditionEvaluator.evaluate(attributeMap, this.attributeRule, this.log);
    }

    private AttributeMap getAttributeMapFromAuthnSourceKey(AuthnSourceKey authnSourceKey, PolicyTreeState policyTreeState) {
        if (policyTreeState.getAuthnPolicyAttrsHolder() != null && policyTreeState.getAuthnPolicyAttrsHolder().getAuthnSourceAttrMaps() != null) {
            return policyTreeState.getAuthnPolicyAttrsHolder().getAuthnSourceAttrMaps().get(authnSourceKey);
        }
        return new AttributeMap();
    }

    private AttributeMap getTrackedParameterAttributes(Map<String, Object> stateParams) {
        Map trackedParams = (Map)stateParams.get("pf.TrackedHttpParams");
        if (MapUtils.isNotEmpty((Map)trackedParams)) {
            AttributeMap trackedParamsAttributeMap = new AttributeMap();
            trackedParams.forEach((key, value) -> trackedParamsAttributeMap.put(key, AttrValueSupport.make((Collection)value)));
            return trackedParamsAttributeMap;
        }
        return new AttributeMap();
    }

    private AttributeMap getExtendedPropertiesAttributes(InMessageContext inMsgCtx) {
        Map<String, ParamValues> extendedParams = null;
        if ("oauth:authz".equals(inMsgCtx.getBinding()) && StringUtils.isNotEmpty((String)inMsgCtx.getEntityId())) {
            String clientId = inMsgCtx.getEntityId();
            Client client = MgmtFactory.getClientManager().getCachedClient(clientId);
            extendedParams = client.getExtendedParams();
        } else {
            String spConnectionEntityId = inMsgCtx.getEntityId();
            try {
                SpConnection spConnection = MetadataSupport.getSpConnection(spConnectionEntityId);
                extendedParams = spConnection.getExtendedProperties();
            }
            catch (ConfigurationException exception) {
                this.log.debug((Object)("no SP connection found: " + spConnectionEntityId), (Throwable)exception);
            }
        }
        AttributeMap extendedPropertiesAttributes = new AttributeMap();
        if (MapUtils.isNotEmpty(extendedParams)) {
            extendedParams.forEach((key, value) -> extendedPropertiesAttributes.put(key, AttrValueSupport.make((Collection)value.getElements())));
        }
        return extendedPropertiesAttributes;
    }

    private Map<String, AttributeMap> getAttributeMapSourcesFromAuthnAttributes(AuthnSourceKey previousAuthnSourceKey, AttributeMap previousAuthnAttributeMap, PolicyTreeState policyTreeState) {
        HashMap<AuthnSourceKey, AttributeMap> authnAttrs = new HashMap<AuthnSourceKey, AttributeMap>();
        if (policyTreeState.getAuthnPolicyAttrsHolder() != null && policyTreeState.getAuthnPolicyAttrsHolder().getAuthnSourceAttrMaps() != null) {
            authnAttrs.putAll(policyTreeState.getAuthnPolicyAttrsHolder().getAuthnSourceAttrMaps());
        }
        authnAttrs.put(previousAuthnSourceKey, previousAuthnAttributeMap);
        return AuthnSourceSupportBase.convertAuthnAttrsToAttributeMappingSources(authnAttrs);
    }

    private Map<String, AttributeMap> getAttributeMapSourcesFromRemainderOfSources(HttpServletRequest request, HttpServletResponse resp, InMessageContext inMessageContext, Map<String, Object> stateParams) {
        HashMap<String, AttributeMap> attributeMap = new HashMap<String, AttributeMap>();
        Map trackedParams = (Map)stateParams.get("pf.TrackedHttpParams");
        if (MapUtils.isNotEmpty((Map)trackedParams)) {
            AuthnPolicyUtil.addTrackedParamsToAttributeMappingSource(trackedParams, attributeMap);
        }
        Map<String, Object> extendedProperties = this.getExtendedPropertiesAttributes(inMessageContext).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        AuthnPolicyUtil.addExtendedPropertiesToAttributeMappingSource(extendedProperties, attributeMap);
        attributeMap.put("context", AuthnSourceSupportBase.getContextAttributeMap(request, resp, inMessageContext, stateParams));
        return attributeMap;
    }
}

