/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.xmlbinding.assertion.ConditionsType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestType;

public class AuthnRequestOptions {
    private Integer assertionConsumerServiceIndex = null;
    private String assertionConsumerServiceURL = null;
    private String protocolBinding = null;
    private SubjectType subject = null;
    private ConditionsType conditions = null;

    public Integer getAssertionConsumerServiceIndex() {
        return this.assertionConsumerServiceIndex;
    }

    public void setAssertionConsumerServiceIndex(Integer assertionConsumerServiceIndex) {
        this.assertionConsumerServiceIndex = assertionConsumerServiceIndex;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(String assertionConsumerServiceURL) {
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public void setProtocolBinding(String protocolBinding) {
        this.protocolBinding = protocolBinding;
    }

    public SubjectType getSubject() {
        return this.subject;
    }

    public void setSubject(SubjectType subject) {
        this.subject = subject;
    }

    public ConditionsType getConditions() {
        return this.conditions;
    }

    public void setConditions(ConditionsType conditions) {
        this.conditions = conditions;
    }

    public static AuthnRequestOptions getAuthnRequestOptions(AuthnRequestDocument authnRequestDoc) throws StatusResponseException {
        AuthnRequestOptions options = new AuthnRequestOptions();
        AuthnRequestType authnRequestType = authnRequestDoc.getAuthnRequest();
        if (authnRequestType.isSetAssertionConsumerServiceIndex() && authnRequestType.isSetAssertionConsumerServiceURL()) {
            TopLevelStatusCode requester = TopLevelStatusCode.REQUESTER;
            String s = "AuthnRequest cannot have both AssertionConsumerServiceIndex and AssertionConsumerServiceURL included.";
            throw new StatusResponseException(requester, s);
        }
        if (authnRequestType.isSetAssertionConsumerServiceIndex()) {
            int acsIdx = authnRequestType.getAssertionConsumerServiceIndex();
            options.setAssertionConsumerServiceIndex(acsIdx);
        } else {
            String assertionConsumerServiceURL = authnRequestType.getAssertionConsumerServiceURL();
            String protocolBinding = authnRequestType.getProtocolBinding();
            options.setAssertionConsumerServiceURL(assertionConsumerServiceURL);
            options.setProtocolBinding(protocolBinding);
        }
        options.setSubject(authnRequestType.getSubject());
        options.setConditions(authnRequestType.getConditions());
        return options;
    }
}

