/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.partner.C2CMappingDbEntryResult;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.authn.MappedAuthnSourcesAndApcs;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.authn.AuthnProcessor;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;

public class AuthnSourceSupport
extends AuthnSourceSupportBase {
    public static final String PARAM_PARTNER_ENTITY_ID = "PartnerEntityId";
    public static final String VIRTUAL_SERVER_ID = "VirtualServerId";

    @Override
    protected MappedAuthnSourcesAndApcs getMappedSources(HttpServletRequest req, Map<String, Object> stateParams, BaseMessageContext messageContext, ProxyScoping proxyScoping) throws AuthnProcessorException {
        String entityId = (String)stateParams.get(PARAM_PARTNER_ENTITY_ID);
        SpConnection sp = MetadataSupport.getSpConnection(entityId);
        Map<String, AdapterToAssertionMapping> mappedAdapters = sp.getMappedBaseAdapters();
        Set<AuthnSourceKey> mappedAuthnSourceKeys = new HashSet<AuthnSourceKey>();
        String virtualServerId = messageContext.getVirtualServerId();
        for (Map.Entry<String, AdapterToAssertionMapping> mappedAdapter : mappedAdapters.entrySet()) {
            AdapterToAssertionMapping adapterToAssertionMapping = mappedAdapter.getValue();
            if (adapterToAssertionMapping.isRestrictVirtualServerIds() && virtualServerId != null && !adapterToAssertionMapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
            String adapterId = (String)mappedAdapter.getKey();
            AdapterAuthnSourceKey adapterKey = this.adapterManager.idpAdapterHasConnectionBasedOverride(adapterId, entityId) ? new AdapterAuthnSourceKey(adapterId, entityId) : new AdapterAuthnSourceKey(adapterId);
            mappedAuthnSourceKeys.add(adapterKey);
        }
        HashSet<String> mappedContractIds = new HashSet<String>();
        for (C2cContractToAssertionMapping c2cContractToAssertionMapping : sp.getC2cMappings()) {
            if (c2cContractToAssertionMapping.isRestrictVirtualServerIds() && virtualServerId != null && !c2cContractToAssertionMapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
            mappedContractIds.add(c2cContractToAssertionMapping.getContractId());
        }
        HashSet<String> mappedIdpConns = new HashSet<String>();
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        if (MetadataLocalHelper.isEnableSp(metadataLocal) && !mappedContractIds.isEmpty()) {
            for (String mappedContractId : mappedContractIds) {
                Collection<C2CMappingDbEntryResult> results = MgmtFactory.getC2CMappingDb().getEntriesByContractId(mappedContractId);
                block3: for (C2CMappingDbEntryResult entry : results) {
                    IdpConnection conn;
                    if (!entry.getConnType().equals((Object)Role.IDP) || !entry.getActive() || (conn = MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(entry.getSystemId())) == null || !MgmtFactory.getConnectionManager().passesFilterByServerSettings(conn, false)) continue;
                    String idpConnVsid = VirtualIdentityUtil.resolve(null, conn, true).getVirtualEntityId(DomainMode.RUNTIME);
                    for (C2cContractAttributeMapping mapping : conn.getC2cContractMappings()) {
                        if (!mapping.getContractId().equals(mappedContractId) || mapping.isRestrictVirtualServerIds() && idpConnVsid != null && !mapping.getRestrictedVirtualServerIds().contains(idpConnVsid)) continue;
                        mappedIdpConns.add(conn.getId());
                        continue block3;
                    }
                }
            }
        }
        for (String mappedIdpConnId : mappedIdpConns) {
            mappedAuthnSourceKeys.add(new IdpConnAuthnSourceKey(mappedIdpConnId));
        }
        if (sp.getProtocol() == Protocol.SAML20) {
            mappedAuthnSourceKeys = this.applySaml2ProxyScoping(mappedAuthnSourceKeys, proxyScoping);
        }
        if (mappedAuthnSourceKeys.isEmpty() && mappedContractIds.isEmpty()) {
            throw new ProcessRuntimeException("No authentication sources (IdP adapters or IdP connections) configured/mapped for connection " + entityId);
        }
        return new MappedAuthnSourcesAndApcs(mappedAuthnSourceKeys, mappedContractIds);
    }

    private Set<AuthnSourceKey> applySaml2ProxyScoping(Set<AuthnSourceKey> mappedAuthnSourceKeys, ProxyScoping proxyScoping) throws AuthnProcessorException {
        if (proxyScoping == null || mappedAuthnSourceKeys.isEmpty()) {
            return mappedAuthnSourceKeys;
        }
        if (proxyScoping.hasProxyCount() && proxyScoping.getProxyCount() <= 0) {
            Set<AuthnSourceKey> filteredAuthnSourceKeys = this.filterAdapterSourceKeys(mappedAuthnSourceKeys);
            if (filteredAuthnSourceKeys.isEmpty()) {
                throw new AuthnProcessorException.ProxyCountException("The principal cannot be authenticated because the authentication request exceeds the proxy count and the server is not configured to authenticate the request directly.");
            }
            return filteredAuthnSourceKeys;
        }
        if (proxyScoping.hasIdpSet()) {
            HashSet<AuthnSourceKey> filteredAuthnSourceKeys = new HashSet<AuthnSourceKey>();
            Set<String> reqIdps = proxyScoping.getIdpSet();
            for (AuthnSourceKey mappedAuthnSourceKey : mappedAuthnSourceKeys) {
                IdpConnection idpConn;
                if (mappedAuthnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                    filteredAuthnSourceKeys.add(mappedAuthnSourceKey);
                    continue;
                }
                if (mappedAuthnSourceKey.getType() != AuthnSourceKey.AuthnSourceType.IDP_CONN || (idpConn = this.connectionManager.getIdpConnectionBySystemId(mappedAuthnSourceKey.getId())) == null || !reqIdps.contains(idpConn.getEntityId())) continue;
                filteredAuthnSourceKeys.add(mappedAuthnSourceKey);
            }
            return filteredAuthnSourceKeys;
        }
        return mappedAuthnSourceKeys;
    }

    private Set<AuthnSourceKey> filterAdapterSourceKeys(Set<AuthnSourceKey> mappedAuthnSourceKeys) {
        HashSet<AuthnSourceKey> filteredAuthnSourceKeys = new HashSet<AuthnSourceKey>();
        for (AuthnSourceKey mappedAuthnSourceKey : mappedAuthnSourceKeys) {
            if (mappedAuthnSourceKey.getType() != AuthnSourceKey.AuthnSourceType.ADAPTER) continue;
            filteredAuthnSourceKeys.add(mappedAuthnSourceKey);
        }
        return filteredAuthnSourceKeys;
    }

    @Override
    protected String makeNoMappingErrMsg(Map<String, Object> stateParams, String escapedParam) {
        String entityId = (String)stateParams.get(PARAM_PARTNER_ENTITY_ID);
        StringBuilder sb = new StringBuilder();
        sb.append("IdpAdapterId").append(" was specified as ").append(escapedParam);
        sb.append(" but ").append(entityId).append(" does not have a mapping defined for that IdP Adapter.");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logoutAuthN(IdpHashableAuthnBean authnBean, HttpServletRequest request, HttpServletResponse response, String resumePath) throws IOException, AuthnAdapterException {
        boolean success = true;
        if (authnBean != null && (authnBean.getAuthnSourceKey().getType() == AuthnSourceKey.AuthnSourceType.ADAPTER || authnBean.getAuthnSourceKey().getType() == AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY) && authnBean.isDoLogout()) {
            Map<String, Object> authnIdentifiersMap = authnBean.getAuthnIdentifiersMap();
            AuthnSourceKey authnSourceKey = authnBean.getAuthnSourceKey();
            try {
                AuthnProcessor<AuthnSourceKey> authnProcessor = this.getAuthnProcessor(authnSourceKey);
                success = authnProcessor.logoutAuthN(authnIdentifiersMap, request, response, authnSourceKey, resumePath);
            }
            finally {
                HttpServletRespProxy.clearRunnable(response);
            }
            if (response != null && !response.isCommitted() && success) {
                IdpSessionRegistrySupport.setBeansInvalidForLogout(Collections.singleton(authnBean));
            }
        }
        return success;
    }

    @Override
    protected void putExtraRenderParameters(Map<String, Object> renderParameters, Map<String, Object> stateParams) {
        String entityId = (String)stateParams.get(PARAM_PARTNER_ENTITY_ID);
        renderParameters.put("entityId", entityId);
    }

    @Override
    protected void putExtraParametersToSelectContext(Map<String, Object> extraParameters, Map<String, Object> stateParams, InMessageContext inMsgCtx) {
        String entityId = (String)stateParams.get(PARAM_PARTNER_ENTITY_ID);
        extraParameters.put("com.pingidentity.sdk.AdapterSelector.entityid", entityId);
    }

    @Override
    protected void addApplicationNameImage(Map<String, Object> stateParams, AuthnSourceKey authnSourceKey) {
        SpConnection conn = this.getSpConnection(stateParams);
        if (conn != null) {
            if (StringUtils.isNotBlank((String)conn.getApplicationName())) {
                stateParams.put("applicationName", conn.getApplicationName());
            }
            if (conn.getApplicationIconUrl() != null) {
                stateParams.put("applicationIcon", conn.getApplicationIconUrl().toExternalForm());
            }
        }
    }

    @Override
    protected AttributeMap getResultAuthnAttrsFromIdpConnection(HttpServletRequest req, IdpConnHashableAuthnBean authnBean, AttributeMap authnSourceAttrs, Map<String, ?> stateParams) {
        String spConnEntityId = (String)stateParams.get(PARAM_PARTNER_ENTITY_ID);
        SsoRespSupport ssoRespSupport = new SsoRespSupport(MetaDataFactory.getLocalMetaData());
        IdpConnection idpConnection = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(authnBean.getAuthnSourceKey().getId(), true);
        String contractId = MgmtFactory.getC2cContractManager().findMappedContractId(idpConnection, spConnEntityId);
        return idpConnection.executeC2cMapping(authnBean.getAssertionAttrs(), contractId, ssoRespSupport.makeIdpConnContextAttributes(authnBean, req));
    }
}

