/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.common.mgr.RestartConfigManager;
import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.common.util.EscapeUtils;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.locale.StandardTemplateMessage;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LocalIdentityAdapter;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.UserToCreate;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSession;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.localidentity.data.StringFieldData;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.AdvancedAuthnPolicy;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpAdapter;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.idp.AuthenticationPolicyTreePostProcessor;
import org.sourceid.saml20.profiles.idp.AuthnPolicyRuleEvaluator;
import org.sourceid.saml20.profiles.idp.AuthnTreeHelper;
import org.sourceid.saml20.profiles.idp.PolicyTreeState;
import org.sourceid.saml20.profiles.idp.authn.AuthnSelectionResult;
import org.sourceid.saml20.profiles.idp.authn.MappedAuthnSourcesAndApcs;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.ContextSourceKey;
import org.sourceid.saml20.service.FragmentSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.LocalIdentitySourceKey;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.AuthnSourceUserKeyValue;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.PasswordResetStateSupport;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.saml20.util.UserKeyAttributeUtil;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.PolicyTreeLogger;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.authn.AdapterAuthnProcessor;
import org.sourceid.websso.authn.ApiRedirectWrapper;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnPluginKey;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessor;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.authn.AuthnProcessorResult;
import org.sourceid.websso.authn.IdpConnAuthnProcessor;
import org.sourceid.websso.authn.LocalIdentityAuthnProcessor;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.servlet.reqparam.HttpServletReqProxy;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class AuthnSourceSupportBase {
    protected static final String PIPE = " | ";
    protected static final String AUTHN_SOURCE = "Authn Source";
    protected static final String SELECTOR = "Selector";
    protected static final String FRAGMENT = "Fragment";
    private static final String REGISTRATION_FRAGMENT_ID = "registrationFragmentId";
    private static final String REGISTRATION_FRAGMENT_ERROR_USER_CREATED_MESSAGE_KEY = "local.identity.registration.fragment.error.user.created";
    private static final String REGISTRATION_FRAGMENT_ERROR_USER_NOT_CREATED_MESSAGE_KEY = "local.identity.registration.fragment.error.user.not.created";
    private final int maximumFragmentsEncounteredAtRuntime = ConfigStoreFarm.getConfig(AuthnSourceSupportBase.class).getIntValue("maximumFragmentsEncounteredAtRuntime", 5);
    private static final AuthenticationPolicyTreePostProcessor authenticationPolicyTreePostProcessor = new AuthenticationPolicyTreePostProcessor();
    private static final Log log = LogFactory.getLog(AuthnSourceSupportBase.class);
    private final ConfigStore config = ConfigStoreFarm.getConfig("idp-adapter-support");
    private final boolean alwaysSetCookie = this.config.getBooleanValue("always-set-cookie", false);
    public static final String MAPPED_AUTHN_SOURCE_STATE_PARAM_NAME = "mappedAuthnSource";
    private static final String SINGLE_AUTHN_SOURCE_STATE_PARAM_NAME = "inProgressSingleAuthnSource";
    private static final String PREV_AUTHN_SEL_RESULT_STATE_PARAM_NAME = "prevAuthnSelectionResult";
    private static final String LAST_AUTHN_FAILED_STATE_PARAM_NAME = "lastAuthSourceFailed";
    private static final String AUTHORIZATION_EXCEPTION_INFO_PARAM_NAME = "authorizationExceptionInfo";
    private static final String AUTHN_SELECTOR_LEGACY_PARAM_NAME = "adapterSelectorLegacy";
    private static final String AUTHN_SELECTOR_CONTEXT_PARAM_NAME = "adapterSelectorContext";
    private static final String COOKIE_NAME = "pfidpaid";
    public static final String DO_NOT_DELETE_COOKIE = "DO_NOT_DELETE_COOKIE";
    public static final String PARAM_NAME_REMEMBER_CHOICE = "rememberChoice";
    private static final String PARAM_NAME_CHANGE_PASSWORD = "ChangePassword";
    private static final String COOKIE_IDP_PREFIX = "idp.";
    private static final String COOKIE_ADAPTER_PREFIX = "ad.";
    private static final String COOKIE_LOCAL_IDENTITY_PREFIX = "localidentity.";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String APPLICATION_ICON_URL = "applicationIcon";
    public static final String USERID_SUGGESTION = "suid";
    public static final String CHAINED_USERID_PARAM_NAME = "chainedUserId";
    public static final String INBOUND_ATTRIBUTES_PARAM_NAME = "inboundAttributes";
    public static final String CURRENT_AUTHN_API_APP_PARAM_NAME = "currentAuthnApiApp";
    private static final String RESTART_COUNT_KEY = "restartCount";
    public static final String ADAPTER_ACTION = "adapterAction";
    public static final String ADAPTER_USERNAME_AUTHENTICATED = "adapterUsernameAuthenticated";
    public static final String EXTENDED_PROPERTIES = "extendedProperties";
    public static final String CHAINED_ATTRIBUTES_NAME = "chainedAttributes";
    private static final String STATE_STACK_PARAM_NAME = "authnPolicyStateStack";
    public static final String CUMULATIVE_AUTHN_BEANS_PARAM_NAME = "cumulativeAuthnBeans";
    public static final String AUTHN_SELECTOR_EXTRA_PARAM_NAME_SESSIONS = "com.pingidentity.sdk.authnselector.sessions";
    public static final String AUTHN_SELECTOR_EXTRA_PARAM_NAME_CHILD_CONTEXTS = "com.pingidentity.sdk.authnselector.child.contexts";
    protected final AdapterManager adapterManager = MgmtFactory.getAdapterManager();
    private final AuthnSelectorManager authnSelectorManager = MgmtFactory.getAuthnSelectorManager();
    protected final AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
    protected final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
    private static final int AGE = 315360000;

    protected abstract MappedAuthnSourcesAndApcs getMappedSources(HttpServletRequest var1, Map<String, Object> var2, BaseMessageContext var3, ProxyScoping var4) throws AuthnProcessorException;

    protected abstract String makeNoMappingErrMsg(Map<String, Object> var1, String var2);

    public AttributeMap convertAuthnIds(AuthnSourceKey authnSourceKey, Map<String, Object> sourceAttrs) {
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
            return this.castToAttributeMap(sourceAttrs);
        }
        Set<String> maskedFields = this.getAdapterMaskedFields(authnSourceKey);
        boolean maskOgnlValues = this.getAdapterMaskOgnlValues(authnSourceKey);
        return AttrValueSupport.convert(sourceAttrs, maskedFields, (boolean)maskOgnlValues);
    }

    private AttributeMap castToAttributeMap(Map<String, Object> attrMap) {
        Map<String, Object> retypedAttrs = attrMap;
        return (AttributeMap)retypedAttrs;
    }

    protected void addApplicationNameImage(Map<String, Object> stateParams, AuthnSourceKey authnSourceKey) {
    }

    private AuthnSourceAttrsHolder lookupAuthN(AuthnSourceKey authnSourceKey, HttpServletRequest req, HttpServletResponse resp, AuthnPolicy authnPolicy, String resumePath, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException {
        AuthnSourceAttrsHolder authnAttrHolder = null;
        if (authnSourceKey != null) {
            AuthnProcessor<AuthnSourceKey> authnProcessor = this.getAuthnProcessor(authnSourceKey);
            AuthnProcessorResult authnProcessorResult = null;
            List<AuthnSourceKey> authnSourceKeys = this.getPreviousSuccessfulAuthnKeys(stateParams);
            authnSourceKeys.add(authnSourceKey);
            try {
                this.addApplicationNameImage(stateParams, authnSourceKey);
                if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                    stateParams.put("inMsgCtxTempHolder", inMsgCtx);
                    stateParams.put("outMsgCtxTempHolder", outMsgCtx);
                }
                authnProcessorResult = authnProcessor.lookupAuthN(req, resp, authnSourceKey, authnPolicy, resumePath, stateParams, adapterLogoutRequired);
            }
            catch (Exception ex) {
                if (ex.getMessage() != null) {
                    ThreadContext.put((String)AuditLogger.MDC_KEY.DESCRIPTION.toString(), (String)ex.getMessage());
                }
                throw ex;
            }
            finally {
                IdpAuditLogger.setAuthnSourceId(authnSourceKeys);
            }
            IdpHashableAuthnBean hashableAuthnBean = authnProcessorResult.getAuthnBean();
            this.afterInvokeAuthnSource(req, resp, authnSourceKey, hashableAuthnBean, stateParams);
            if (hashableAuthnBean != null) {
                AttributeMap authnAttrMap;
                boolean isAdapterAuthnSource = authnSourceKey.getType().equals((Object)AuthnSourceKey.AuthnSourceType.ADAPTER);
                if (isAdapterAuthnSource || authnSourceKey.getType().equals((Object)AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY)) {
                    try {
                        authnAttrMap = this.executeAdditionalMapping(authnSourceKey, hashableAuthnBean.getAuthnIdentifiersMap(), req, resp, stateParams);
                    }
                    catch (AuthorizationException exception) {
                        authnProcessorResult.auditFailedAuthenticationAttempt(exception.getMessage());
                        throw exception;
                    }
                    if (isAdapterAuthnSource) {
                        DeviceSharingType deviceSharingType = IdpSessionRegistrySupport.checkAndUpdateDeviceSharingType(req, resp, stateParams, IdpSessionRegistrySupport.getDeviceSharingType(authnAttrMap));
                        hashableAuthnBean.setDeviceSharingType(deviceSharingType);
                        IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
                        IdpAuthnAdapterInstance adapter = idpAdapterManager.getInstance(authnSourceKey);
                        String userKeyValue = UserKeyAttributeUtil.resolveUniqueUserKeyValue(adapter.getAdapterAuthnSourceKey(), adapter.getUniqueUserKeyAttribute(), authnAttrMap);
                        if (userKeyValue != null) {
                            List<AuthnSourceUserKeyValue> authnSourceUserKeyValueList = UserKeyAttributeUtil.getStateParamUserKeysToAssociateWithSessions(stateParams);
                            authnSourceUserKeyValueList.add(new AuthnSourceUserKeyValue(authnSourceKey, userKeyValue));
                            stateParams.put("adapterAuthnSourceIdsForUser", authnSourceUserKeyValueList);
                        }
                    }
                    if (!authnProcessorResult.isFromSession()) {
                        boolean checkRegisterForSso;
                        boolean bl = checkRegisterForSso = !AuthnAdapterResponse.AUTHN_STATUS.ACTION.equals((Object)authnProcessorResult.getAuthnStatus());
                        if (authenticationPolicyTreePostProcessor.isDeferAuthenticationBeanRegistration(stateParams, hashableAuthnBean)) {
                            IdpSessionRegistrySupport.AuthenticationBeanRegistrationInfo registrationInfo = IdpSessionRegistrySupport.getAuthenticationBeanRegistrationInfo(req, resp, stateParams, hashableAuthnBean, null, checkRegisterForSso, adapterLogoutRequired);
                            if (registrationInfo != null) {
                                authenticationPolicyTreePostProcessor.addDeferredAuthenticationBeanRegistrationInfo(stateParams, hashableAuthnBean, registrationInfo);
                            }
                        } else {
                            try {
                                IdpSessionRegistrySupport.checkRegisterAuthnBean(req, resp, stateParams, hashableAuthnBean, null, checkRegisterForSso, adapterLogoutRequired);
                            }
                            catch (SessionQuotaException e) {
                                authnProcessorResult.auditFailedAuthenticationAttempt(e.getMessage());
                                throw new AuthorizationException("Session limit exceeded.", e.getMessage(), "SESSION_QUOTA_EXCEEDED");
                            }
                        }
                    }
                } else {
                    IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)hashableAuthnBean;
                    authnAttrMap = this.executeIdpConnMapping(authnSourceKey, idpConnBean, req, authnProcessorResult.getSsoReqMsgCtx());
                }
                authnAttrHolder = new AuthnSourceAttrsHolder(authnProcessorResult.getAuthnStatus(), hashableAuthnBean, authnAttrMap);
            } else if (authnProcessorResult.getAuthnStatus() != null) {
                authnAttrHolder = new AuthnSourceAttrsHolder(authnProcessorResult.getAuthnStatus());
            }
            if (authnProcessorResult.getAuditorAuthenticationStatus() == AuthnAdapterResponse.AUTHN_STATUS.SUCCESS) {
                authnProcessorResult.auditAuthenticationAttempt();
            }
        }
        return authnAttrHolder;
    }

    private AttributeMap getResultAttrsFromAuthnSource(HttpServletRequest req, IdpHashableAuthnBean authnBean, AttributeMap authnSourceAttrs, Map<String, ?> stateParams) {
        AuthnSourceKey authnSourceKey = authnBean.getAuthnSourceKey();
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
            return this.getResultAuthnAttrsFromIdpConnection(req, (IdpConnHashableAuthnBean)authnBean, authnSourceAttrs, stateParams);
        }
        return authnSourceAttrs;
    }

    protected AttributeMap getResultAuthnAttrsFromIdpConnection(HttpServletRequest req, IdpConnHashableAuthnBean authnBean, AttributeMap authnSourceAttrs, Map<String, ?> stateParams) {
        return authnSourceAttrs;
    }

    public AttributeMap executeAdditionalMapping(AuthnSourceKey authnSourceKey, Map<String, Object> sourceAttrs, HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams) throws AuthnAdapterException, AuthorizationException {
        HashMap<String, Object> mergedAttributesMap = new HashMap();
        if (authnSourceKey.getType() != AuthnSourceKey.AuthnSourceType.ADAPTER) {
            mergedAttributesMap = sourceAttrs;
        } else if (sourceAttrs != null) {
            AttributeMap resultingAdapterAuthnAttributeMap;
            Object extendedPropertiesObject;
            IdpAdapter instance = this.getAdapterInstance(authnSourceKey);
            AttributeMapping instanceAttributeMapping = instance.getEffectiveAttributeMap();
            AuthnSourceAttributeMapping localAttributeMapping = new AuthnSourceAttributeMapping(instance, instanceAttributeMapping);
            Map<String, Object> retypedAttrs = sourceAttrs;
            AttributeMap sourceAttrMap = retypedAttrs instanceof AttributeMap ? (AttributeMap)retypedAttrs : AttrValueSupport.convert(sourceAttrs, (boolean)false);
            AttributeMap contextAttributes = new AttributeMap();
            contextAttributes.put(SourceContextType.CLIENT_IP.getId(), request.getRemoteAddr());
            contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)request));
            if (response != null) {
                contextAttributes.put(SourceContextType.SRI.getId(), SessionIdUtil.getInstance().getExtendedSriV2(request, response, stateParams));
            }
            if (stateParams != null && (extendedPropertiesObject = stateParams.get(EXTENDED_PROPERTIES)) instanceof Map) {
                for (Map.Entry entry : ((Map)extendedPropertiesObject).entrySet()) {
                    Object value = entry.getValue();
                    AttributeValue attrValue = value instanceof AttributeValue ? new AttributeValue((AttributeValue)value) : (value instanceof String ? new AttributeValue((String)value) : new AttributeValue((Collection)value));
                    contextAttributes.put("extproperties." + (String)entry.getKey(), attrValue);
                }
            }
            try {
                resultingAdapterAuthnAttributeMap = localAttributeMapping.executeMapping(sourceAttrMap, instanceAttributeMapping.getAttributeMapping().keySet(), contextAttributes);
            }
            catch (AttrLookupException e) {
                AsAuditLogger.setDescription("Attribute Mapping Exception");
                String string = e.getMessage().trim();
                log.error((Object)string, (Throwable)e);
                throw new AuthnAdapterException("Error occurred in Adapter attribute mapping / lookup: " + e.getMessage(), (Throwable)e);
            }
            HashMap convertedToObjectResultingAttributeMap = new HashMap();
            for (Map.Entry entry : resultingAdapterAuthnAttributeMap.entrySet()) {
                convertedToObjectResultingAttributeMap.put((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : sourceAttrs.entrySet()) {
                if (convertedToObjectResultingAttributeMap.containsKey(entry.getKey())) {
                    mergedAttributesMap.put((String)entry.getKey(), convertedToObjectResultingAttributeMap.get(entry.getKey()));
                    continue;
                }
                mergedAttributesMap.put((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : convertedToObjectResultingAttributeMap.entrySet()) {
                mergedAttributesMap.put((String)entry.getKey(), entry.getValue());
            }
            ArrayList<String> removeNullAttributes = new ArrayList<String>();
            for (String adapterAttribute : instanceAttributeMapping.getAttributeMapping().keySet()) {
                if (convertedToObjectResultingAttributeMap.containsKey(adapterAttribute)) continue;
                removeNullAttributes.add(adapterAttribute);
            }
            for (String removeNullAttribute : removeNullAttributes) {
                mergedAttributesMap.remove(removeNullAttribute);
            }
        }
        return this.convertAuthnIds(authnSourceKey, mergedAttributesMap);
    }

    public AttributeMap executeIdpConnMapping(AuthnSourceKey sourceKey, IdpConnHashableAuthnBean session, HttpServletRequest req, OutMessageContext ssoReqMsgCtx) {
        SsoRespSupport spRespSupport = new SsoRespSupport(MetaDataFactory.getLocalMetaData());
        TargetSessionId targetId = spRespSupport.getTargetSessionIdFromCtx(ssoReqMsgCtx, null);
        if (targetId == null || targetId.getType() != TargetSessionId.TargetSessionType.SP_CONN) {
            return session.getAssertionAttrs();
        }
        IdpConnection idpConnection = this.metadataDirectory.getIdpConnectionBySystemId(sourceKey.getId(), true);
        String contractId = MgmtFactory.getC2cContractManager().findMappedContractId(idpConnection, targetId.getId());
        AttributeMap contextAttributes = spRespSupport.makeIdpConnContextAttributes(session, req);
        AttributeMap mappedAttributes = idpConnection.executeC2cMapping(session.getAssertionAttrs(), contractId, contextAttributes);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapped APC Attributes: " + mappedAttributes));
        }
        return mappedAttributes;
    }

    private List<AuthnSourceKey> getPreviousSuccessfulAuthnKeys(Map<String, Object> stateParams) {
        List authnPolicyStateList = (List)stateParams.get(STATE_STACK_PARAM_NAME);
        AuthnPolicyAttrsHolder attrsHolder = null;
        if (CollectionUtils.isNotEmpty((Collection)authnPolicyStateList)) {
            attrsHolder = ((PolicyTreeState)authnPolicyStateList.get(authnPolicyStateList.size() - 1)).getAuthnPolicyAttrsHolder();
        }
        List<IdpHashableAuthnBean> authnPolicyBeans = Collections.emptyList();
        if (attrsHolder != null) {
            authnPolicyBeans = attrsHolder.getAuthnBeans();
        }
        LinkedList<AuthnSourceKey> successfulAuthnKeys = new LinkedList<AuthnSourceKey>();
        for (IdpHashableAuthnBean bean : authnPolicyBeans) {
            successfulAuthnKeys.add(bean.getAuthnSourceKey());
        }
        return successfulAuthnKeys;
    }

    public static List<AuthnSourceKey> getAuthnSourceKeys(IdpHashableAuthnBean[] beans) {
        LinkedList<AuthnSourceKey> authnSourceKeys = new LinkedList<AuthnSourceKey>();
        if (beans != null) {
            for (IdpHashableAuthnBean bean : beans) {
                authnSourceKeys.add(bean.getAuthnSourceKey());
            }
        }
        return authnSourceKeys;
    }

    public IdpAuthenticationResult lookupAuthNs(HttpServletRequest req, HttpServletResponse resp, AuthnPolicy authnPolicy, String resumePath, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, ResumeRequestFromAuthnResponseHandler reqHandler, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException {
        try {
            ApiRedirectWrapper<IdpAuthenticationResult> wrapper = new ApiRedirectWrapper<IdpAuthenticationResult>(req, resp, resumePath, stateParams, inMsgCtx, outMsgCtx, reqHandler);
            IdpAuthenticationResult idpAuthenticationResult = wrapper.wrap(() -> this.doLookupAuthNs(req, resp, authnPolicy, resumePath, stateParams, inMsgCtx, outMsgCtx, reqHandler, adapterLogoutRequired));
            return idpAuthenticationResult;
        }
        catch (AuthorizationRequestException e) {
            throw new ProcessRuntimeException("Unexpected exception during authentication policy processing", e);
        }
        finally {
            HttpServletRespProxy.clearRunnable(resp);
        }
    }

    private IdpAuthenticationResult doLookupAuthNs(HttpServletRequest req, HttpServletResponse resp, AuthnPolicy authnPolicy, String resumePath, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, ResumeRequestFromAuthnResponseHandler reqHandler, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException {
        AuthnSourceKey mappedKey;
        SpConnection spConnection = this.getSpConnection(stateParams);
        if (spConnection != null && !spConnection.isActive()) {
            throw new ProcessRuntimeException(spConnection.getEncodedEntityId() + " is not active.");
        }
        MappedSourcesWrapper mappedSources = new MappedSourcesWrapper(req, stateParams, authnPolicy, inMsgCtx);
        this.populateStateParamsWithResumeInfo(resumePath, stateParams, reqHandler);
        this.populateStateParamsWithExtendedProperties(inMsgCtx, stateParams);
        if (this.isAuthnSelectionEnabled(stateParams) && stateParams.get(AUTHN_SELECTOR_LEGACY_PARAM_NAME) == null && stateParams.get(SINGLE_AUTHN_SOURCE_STATE_PARAM_NAME) == null) {
            AuthnSelectionResult authnSelectionResult = this.doTreeAuthn(req, resp, resumePath, stateParams, authnPolicy, inMsgCtx, outMsgCtx, mappedSources, reqHandler, adapterLogoutRequired);
            if (authnSelectionResult.getResultType() == AuthnSelectionResult.ResultType.FINISHED && authnSelectionResult.getAuthenticatedBeans() != null) {
                authenticationPolicyTreePostProcessor.doPostProcessing(req, resp, stateParams, new HashSet<IdpHashableAuthnBean>(authnSelectionResult.getAuthenticatedBeans()), new AttributeMap((Map)authnSelectionResult.getPolicyResultMap()));
                List<IdpHashableAuthnBean> beans = authnSelectionResult.getAuthenticatedBeans();
                IdpHashableAuthnBean[] beanArray = new IdpHashableAuthnBean[beans.size()];
                beanArray = beans.toArray(beanArray);
                return new IdpAuthenticationResult(beanArray, authnSelectionResult.getPolicyResultMap(), authnSelectionResult.isApcResult(), authnSelectionResult.getApcId());
            }
            if (authnSelectionResult.getResultType() == AuthnSelectionResult.ResultType.FALL_THROUGH) {
                AuthnSourceKey mappedKey2 = null;
                for (AuthnSourceKey defaultAuthnSourceKey : this.authnSelectorConfigManager.getDefaultAuthnSourceKeys()) {
                    mappedKey2 = mappedSources.getMappedAuthnSourceKey(defaultAuthnSourceKey);
                    if (mappedKey2 == null) continue;
                    if (PolicyTreeLogger.get().isDebugEnabled()) {
                        PolicyTreeLogger.debug("Authn Policy Tree resulted in a default authn source selection: " + mappedKey2);
                    }
                    stateParams.put(SINGLE_AUTHN_SOURCE_STATE_PARAM_NAME, mappedKey2);
                    this.setDefaultAuthnApiApp(stateParams);
                    break;
                }
                if (mappedKey2 == null) {
                    if (this.authnSelectorConfigManager.isFailIfNoSelection()) {
                        throw new ProcessRuntimeException("Authn Policy Tree resulted in no authentication source selection.");
                    }
                    stateParams.put(AUTHN_SELECTOR_LEGACY_PARAM_NAME, Boolean.TRUE);
                    if (PolicyTreeLogger.get().isDebugEnabled()) {
                        PolicyTreeLogger.debug("Authn Policy Tree resulted in no authentication selection, performing legacy authentication selection.");
                    }
                }
            } else {
                if (authnSelectionResult.getResultType() == AuthnSelectionResult.ResultType.FINISHED && authnSelectionResult.getAuthenticatedBeans() == null) {
                    authenticationPolicyTreePostProcessor.doPostProcessing(req, resp, stateParams, null, null);
                }
                return null;
            }
        }
        if ((mappedKey = (AuthnSourceKey)stateParams.get(SINGLE_AUTHN_SOURCE_STATE_PARAM_NAME)) == null) {
            if (PolicyTreeLogger.get().isDebugEnabled()) {
                PolicyTreeLogger.debug("Authentication Policies disabled/evaluated, performing legacy authentication selection.");
            }
            mappedKey = this.doLegacySelection(req, resp, resumePath, stateParams, mappedSources);
        }
        if (mappedKey != null) {
            MetadataLocal metadataLocal;
            if (mappedKey.getType().equals((Object)AuthnSourceKey.AuthnSourceType.ADAPTER) && !MetadataLocalHelper.isEnableIdp(metadataLocal = MetaDataFactory.getLocalMetaData())) {
                throw new AuthorizationException("UNDEFINED", "Authorization Server is not configured to handle this authentication");
            }
            stateParams.put(SINGLE_AUTHN_SOURCE_STATE_PARAM_NAME, mappedKey);
            this.setDefaultAuthnApiApp(stateParams);
            AuthnSourceAttrsHolder authnSourceAttrHolder = this.lookupAuthN(mappedKey, req, resp, authnPolicy, resumePath, stateParams, inMsgCtx, outMsgCtx, adapterLogoutRequired);
            if (authnSourceAttrHolder != null && authnSourceAttrHolder.getAuthnBean() != null && !Util.isEmpty(authnSourceAttrHolder.getAuthnBean().getAuthnIdentifiersMap())) {
                if (AuthnAdapterResponse.AUTHN_STATUS.SUCCESS.equals((Object)authnSourceAttrHolder.getAuthnStatus())) {
                    authenticationPolicyTreePostProcessor.doPostProcessing(req, resp, stateParams, new HashSet<IdpHashableAuthnBean>(Collections.singletonList(authnSourceAttrHolder.getAuthnBean())), new AttributeMap((Map)authnSourceAttrHolder.getAuthnSourceAttrMap()));
                }
                if (!resp.isCommitted()) {
                    InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
                }
                IdpHashableAuthnBean bean = authnSourceAttrHolder.getAuthnBean();
                stateParams.put(MAPPED_AUTHN_SOURCE_STATE_PARAM_NAME, mappedKey);
                IdpHashableAuthnBean[] authnBeans = new IdpHashableAuthnBean[]{bean};
                AttributeMap authnAttrs = authnSourceAttrHolder.getAuthnSourceAttrMap();
                return new IdpAuthenticationResult(authnBeans, authnAttrs, false, null);
            }
            authenticationPolicyTreePostProcessor.doPostProcessing(req, resp, stateParams, null, null);
            return null;
        }
        return null;
    }

    private void populateStateParamsWithExtendedProperties(InMessageContext inMsgCtx, Map<String, Object> stateParams) {
        String entityId = inMsgCtx != null ? Objects.toString(inMsgCtx.getEntityId(), null) : null;
        String clientId = Objects.toString(stateParams.get(Parameters.CLIENT_ID), null);
        Map<String, Object> parameters = new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.IDP).entityId(entityId).clientId(clientId).build();
        if (MapUtils.isNotEmpty(parameters) && parameters.containsKey(AdapterDefaultTemplateParams.EXTENDED_PROPERTIES.getParamName())) {
            stateParams.put(AdapterDefaultTemplateParams.EXTENDED_PROPERTIES.getParamName(), parameters.get(AdapterDefaultTemplateParams.EXTENDED_PROPERTIES.getParamName()));
        }
    }

    private void setDefaultAuthnApiApp(Map<String, Object> stateParams) {
        if (MgmtFactory.getAuthnApiManager().isApiEnabled()) {
            AuthnApiApplication defaultApp = MgmtFactory.getAuthnApiManager().getDefaultApplication();
            if (defaultApp != null) {
                stateParams.put(CURRENT_AUTHN_API_APP_PARAM_NAME, defaultApp.getId());
            } else {
                stateParams.remove(CURRENT_AUTHN_API_APP_PARAM_NAME);
            }
        }
    }

    protected void populateStateParamsWithResumeInfo(String resumePath, Map<String, Object> stateParams, ResumeRequestFromAuthnResponseHandler reqHandler) {
        String origResumeUrl = (String)stateParams.get("authnPolicyInitialResumeUrl");
        if (origResumeUrl == null) {
            stateParams.put("authnPolicyInitialResumeUrl", resumePath);
        }
        if (reqHandler != null) {
            stateParams.put("OriginalResumeHandlerClassName", reqHandler.getClass().getName());
        }
    }

    protected boolean isAuthnSelectionEnabled(Map<String, Object> stateParams) {
        return this.authnSelectorConfigManager.isEnableIdpAuthnSelection();
    }

    protected AuthnSelectionResult doTreeAuthn(HttpServletRequest req, HttpServletResponse resp, String resumePath, Map<String, Object> stateParams, AuthnPolicy authnPolicy, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, MappedSourcesWrapper mappedSources, ResumeRequestFromAuthnResponseHandler reqHandler, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException {
        AuthnSelectionResult authnSelectionResult;
        do {
            try {
                AuditLogger.clearPoliciesUsed();
                authnSelectionResult = this.doTreeAuthnWorker(req, resp, resumePath, stateParams, authnPolicy, inMsgCtx, outMsgCtx, mappedSources, reqHandler, adapterLogoutRequired);
            }
            catch (IOException | AuthnAdapterException | AuthorizationException | AuthnProcessorException e) {
                this.cleanUpStateParams(stateParams);
                throw e;
            }
        } while (authnSelectionResult.getResultType() == AuthnSelectionResult.ResultType.RESTART);
        return authnSelectionResult;
    }

    private AuthnSelectionResult doTreeAuthnWorker(HttpServletRequest req, HttpServletResponse resp, String resumePath, Map<String, Object> stateParams, AuthnPolicy authnPolicy, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, MappedSourcesWrapper mappedSources, ResumeRequestFromAuthnResponseHandler reqHandler, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException {
        TreeAuthnWorkerResult treeAuthnWorkerResult;
        LinkedList<PolicyTreeState> stateStack = (LinkedList<PolicyTreeState>)stateParams.get(STATE_STACK_PARAM_NAME);
        if (CollectionUtils.isEmpty((Collection)stateStack)) {
            stateStack = new LinkedList<PolicyTreeState>();
            stateStack.add(new PolicyTreeState(null, 0, (AuthnSelectionResult)stateParams.get(PREV_AUTHN_SEL_RESULT_STATE_PARAM_NAME), null));
            stateParams.put(STATE_STACK_PARAM_NAME, stateStack);
        }
        if (stateStack.size() > 1) {
            AuditLogger.setPolicyName(((PolicyTreeState)stateStack.peekLast()).getPolicyName());
        }
        TreeAuthnState treeAuthnStateFromFragmentCompletion = null;
        do {
            TreeAuthnState treeAuthnState;
            PolicyTreeState policyTreeState;
            if ((policyTreeState = (PolicyTreeState)stateStack.peek()) == null) {
                throw new ProcessRuntimeException("No policy tree state found.");
            }
            if (treeAuthnStateFromFragmentCompletion != null) {
                treeAuthnState = treeAuthnStateFromFragmentCompletion;
                treeAuthnStateFromFragmentCompletion = null;
            } else {
                treeAuthnState = this.getTreeAuthnState(authnPolicy, mappedSources, stateParams, policyTreeState.getFragmentId(), policyTreeState);
                AuthnSelectionResult prevAuthnResult = policyTreeState.getPreviousAuthnSelResult();
                if (prevAuthnResult != null && prevAuthnResult.getResultType() != AuthnSelectionResult.ResultType.IN_PROGRESS) {
                    return prevAuthnResult;
                }
            }
            treeAuthnWorkerResult = this.doTreeAuthnWorker(req, resp, resumePath, stateParams, authnPolicy, inMsgCtx, outMsgCtx, mappedSources, reqHandler, adapterLogoutRequired, treeAuthnState, policyTreeState);
            if (treeAuthnWorkerResult.getFragmentPolicyTreeState() != null) {
                stateStack.push(treeAuthnWorkerResult.getFragmentPolicyTreeState());
                continue;
            }
            if (!policyTreeState.isFragmentPolicyState() || treeAuthnWorkerResult.getTreeAuthnState().getResult().getResultType().equals((Object)AuthnSelectionResult.ResultType.IN_PROGRESS)) continue;
            stateStack.pop();
            PolicyTreeState previousPolicyState = (PolicyTreeState)stateStack.peek();
            if (previousPolicyState == null) {
                throw new ProcessRuntimeException("No policy tree state found.");
            }
            TreeAuthnState previousTreeAuthnState = this.getTreeAuthnState(authnPolicy, mappedSources, stateParams, previousPolicyState.getFragmentId(), previousPolicyState);
            treeAuthnStateFromFragmentCompletion = this.generateTreeAuthnStateAfterFragmentCompletion(req, resp, resumePath, inMsgCtx, treeAuthnWorkerResult.getTreeAuthnState(), previousPolicyState, previousTreeAuthnState, stateParams);
        } while (treeAuthnWorkerResult.getFragmentPolicyTreeState() != null || treeAuthnStateFromFragmentCompletion != null);
        return treeAuthnWorkerResult.getTreeAuthnState().getResult();
    }

    private TreeAuthnState generateTreeAuthnStateAfterFragmentCompletion(HttpServletRequest req, HttpServletResponse resp, String resumePath, InMessageContext inMsgCtx, TreeAuthnState completedTreeAuthnState, PolicyTreeState previousPolicyTreeState, TreeAuthnState previousTreeAuthnState, Map<String, Object> stateParams) throws AuthnProcessorException, IOException, AuthorizationException {
        if (this.authnSelectorConfigManager.getLastModifiedMillis() != previousPolicyTreeState.getAuthnPolicyModifiedTime()) {
            TreeAuthnState treeAuthnState = new TreeAuthnState();
            treeAuthnState.setResult(new AuthnSelectionResult(AuthnSelectionResult.ResultType.RESTART));
            return treeAuthnState;
        }
        AuthnSelectionAction action = (AuthnSelectionAction)previousTreeAuthnState.getCurrentNodeRef().getNode().getData();
        AuthnSelectionResult fragmentResult = completedTreeAuthnState.getResult();
        AuthnSelectionResult result = previousTreeAuthnState.getResult();
        TreeNodeReference policyNodeRef = previousTreeAuthnState.getCurrentNodeRef();
        int currentTreeIndex = previousTreeAuthnState.getCurrentTreeIndex();
        List<AuthnSelectionTree> policyTrees = previousTreeAuthnState.getPolicyTrees();
        try {
            if (action instanceof FragmentAction) {
                FragmentAction fragmentAction = (FragmentAction)action;
                if (fragmentResult.getResultType().equals((Object)AuthnSelectionResult.ResultType.RESTART) || fragmentResult.getResultType().equals((Object)AuthnSelectionResult.ResultType.FALL_THROUGH)) {
                    result = fragmentResult;
                } else if (fragmentResult.getResultType().equals((Object)AuthnSelectionResult.ResultType.FAILED)) {
                    stateParams.put(LAST_AUTHN_FAILED_STATE_PARAM_NAME, Boolean.TRUE);
                    policyNodeRef = this.getMatchingChildNode(policyNodeRef, "Fail");
                } else if (fragmentResult.getResultType().equals((Object)AuthnSelectionResult.ResultType.FINISHED)) {
                    FragmentSourceKey authnSourceKey = new FragmentSourceKey(fragmentAction.getFragmentId());
                    boolean ruleMatch = false;
                    AttributeMap authnAttrMap = fragmentResult.getPolicyResultMap();
                    if (authnAttrMap == null) {
                        authnAttrMap = new AttributeMap();
                    }
                    this.addSuccessfulAuthnToAttrsHolder(authnSourceKey, null, authnAttrMap, previousPolicyTreeState, stateParams);
                    HashSet<String> availableMappedResults = new HashSet<String>();
                    if (policyNodeRef.getNode().hasChildren()) {
                        for (Tree.Node child : policyNodeRef.getNode().getChildren()) {
                            availableMappedResults.add(((AuthnSelectionAction)child.getData()).getContext());
                        }
                    }
                    for (AttributeRule attrRule : fragmentAction.getAttributeRules()) {
                        AuthnPolicyRuleEvaluator authnPolicyRuleEvaluator;
                        if (!availableMappedResults.contains(attrRule.getResult()) || !(authnPolicyRuleEvaluator = new AuthnPolicyRuleEvaluator(attrRule)).isRuleConditionMet(req, resp, inMsgCtx, stateParams, authnSourceKey, authnAttrMap, previousPolicyTreeState)) continue;
                        ruleMatch = true;
                        if (PolicyTreeLogger.get().isDebugEnabled()) {
                            Object policyTree = "";
                            AuthnSelectionTree currTree = policyTrees.get(currentTreeIndex);
                            if (currTree != null) {
                                policyTree = this.getNameForAuthnSelectionTree(currTree) + PIPE;
                            }
                            policyTree = (String)policyTree + "Authn Source | " + ((AuthnSourceKey)authnSourceKey).getFriendlyId() + " | Rule | " + attrRule.getResult();
                            PolicyTreeLogger.debug((String)policyTree);
                        }
                        policyNodeRef = this.getMatchingChildNode(policyNodeRef, attrRule.getResult());
                        break;
                    }
                    if (!ruleMatch && (policyNodeRef = this.getMatchingChildNode(policyNodeRef, "Success")).getNode().getData() instanceof NoOpAction) {
                        result = fragmentResult;
                    }
                }
            } else if (action instanceof LocalIdentityMappingAction) {
                LocalIdentityMappingAction lipMappingAction = (LocalIdentityMappingAction)action;
                LocalIdentityManager localIdentityManager = MgmtFactory.getLocalIdentityProfileManager();
                LocalIdentityProfile localIdentityProfile = localIdentityManager.getProfile(lipMappingAction.getLipId());
                String registrationFragmentId = (String)stateParams.get(REGISTRATION_FRAGMENT_ID);
                this.processFragmentResultForAlreadyExecutedLip(req, resp, resumePath, stateParams, localIdentityProfile, registrationFragmentId, fragmentResult);
            }
        }
        catch (AuthnProcessorException.NoMatchingNode e) {
            return this.getTreeStateForNoMatchingNodeException(e, previousPolicyTreeState, stateParams, new TreeAuthnState(policyNodeRef, result, policyTrees, currentTreeIndex));
        }
        return new TreeAuthnState(policyNodeRef, result, policyTrees, currentTreeIndex);
    }

    private TreeAuthnState getTreeStateForNoMatchingNodeException(AuthnProcessorException.NoMatchingNode e, PolicyTreeState policyTreeState, Map<String, Object> stateParams, TreeAuthnState treeAuthnState) throws AuthorizationException {
        PolicyTreeLogger.debug(e.getMessage());
        AuthnPolicyAttrsHolder attrsHolder = policyTreeState.getAuthnPolicyAttrsHolder();
        Boolean lastAuthnFailedObj = (Boolean)stateParams.get(LAST_AUTHN_FAILED_STATE_PARAM_NAME);
        boolean lastAuthnFailed = false;
        if (lastAuthnFailedObj != null) {
            lastAuthnFailed = lastAuthnFailedObj;
        }
        if ((attrsHolder == null || attrsHolder.getAuthnBeans().isEmpty()) && !lastAuthnFailed) {
            treeAuthnState.setCurrentNodeRef(new TreeNodeReference((Tree.Node<AuthnSelectionAction>)new Tree.Node((Object)new NoOpAction(NoOpAction.Type.CONTINUE)), true));
            return treeAuthnState;
        }
        PolicyTreeLogger.get().info((Object)"Authn Policy Tree's next action has been pruned, but the user has already begun authentication. Failing authentication.");
        this.checkThrowAuthorizationException(stateParams);
        treeAuthnState.setResult(new AuthnSelectionResult(AuthnSelectionResult.ResultType.FINISHED));
        return treeAuthnState;
    }

    public static PolicyTreeState getCurrentPolicyTreeState(Map<String, Object> stateParams) {
        Deque authnPolicyStateStack = (Deque)stateParams.get(STATE_STACK_PARAM_NAME);
        if (CollectionUtils.isNotEmpty((Collection)authnPolicyStateStack)) {
            return (PolicyTreeState)authnPolicyStateStack.peek();
        }
        return null;
    }

    private TreeAuthnWorkerResult doTreeAuthnWorker(HttpServletRequest req, HttpServletResponse resp, String resumePath, Map<String, Object> stateParams, AuthnPolicy authnPolicy, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, MappedSourcesWrapper mappedSources, ResumeRequestFromAuthnResponseHandler reqHandler, boolean adapterLogoutRequired, TreeAuthnState treeAuthnState, PolicyTreeState policyTreeState) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException {
        if (policyTreeState.getFragmentCount() > this.maximumFragmentsEncounteredAtRuntime) {
            throw new ConfigurationException(String.format("Invalid Configuration, more fragments encountered than allowed (%s). Please review your configuration.", this.maximumFragmentsEncounteredAtRuntime));
        }
        AuthnSelectionResult result = treeAuthnState.getResult();
        TreeNodeReference policyNodeRef = treeAuthnState.getCurrentNodeRef();
        int currentTreeIndex = treeAuthnState.getCurrentTreeIndex();
        List<AuthnSelectionTree> policyTrees = treeAuthnState.getPolicyTrees();
        Object policyTree = "";
        while (policyNodeRef != null && result.getResultType() == AuthnSelectionResult.ResultType.IN_PROGRESS) {
            try {
                AttributeMap authnAttrMap;
                AuthnSelectionAction action;
                if (CollectionUtils.isNotEmpty(policyTrees)) {
                    AuthnSelectionTree currTree = policyTrees.get(currentTreeIndex);
                    if (outMsgCtx != null && !policyTreeState.isFragmentPolicyState()) {
                        outMsgCtx.setSupplementalContext("handleFailuresLocally", currTree.isHandleFailuresLocally());
                    }
                    if (currTree != null) {
                        policyTreeState.setPolicyName(currTree.getName());
                        if (policyTreeState.isFragmentPolicyState()) {
                            AuditLogger.setFragmentName(currTree.getName());
                        } else {
                            AuditLogger.setPolicyName(currTree.getName());
                        }
                        policyTree = this.getNameForAuthnSelectionTree(currTree) + PIPE;
                        if (StringUtils.isNotBlank((String)currTree.getOverrideAuthnApiApplicationId())) {
                            stateParams.put(CURRENT_AUTHN_API_APP_PARAM_NAME, currTree.getOverrideAuthnApiApplicationId());
                        } else {
                            stateParams.remove(CURRENT_AUTHN_API_APP_PARAM_NAME);
                        }
                    } else {
                        policyTree = "";
                    }
                }
                if ((action = (AuthnSelectionAction)policyNodeRef.getNode().getData()) instanceof AuthnSourceAction) {
                    IdpAuthnAdapterInstance instance;
                    Map<String, Object> tmpMap;
                    AuthnSourceAction authnSourceAction = (AuthnSourceAction)action;
                    AuthnSourceKey authnSourceKey = authnSourceAction.getAuthnSourceKey();
                    AuthnSourceKey mappedKey = mappedSources.getMappedAuthnSourceKey(authnSourceKey);
                    if (mappedKey != null) {
                        authnSourceKey = mappedKey;
                    }
                    AuthnAdapterResponse.AUTHN_STATUS authnStatus = null;
                    IdpHashableAuthnBean authnBean = (IdpHashableAuthnBean)stateParams.remove("AuthnSelectionTreeReturnedIdpConnAuthnBean");
                    Boolean authnComplete = (Boolean)stateParams.remove("AuthnSelectionTreeIdpConnComplete");
                    stateParams.remove(LAST_AUTHN_FAILED_STATE_PARAM_NAME);
                    stateParams.remove(AUTHORIZATION_EXCEPTION_INFO_PARAM_NAME);
                    authnAttrMap = null;
                    if (authnBean != null) {
                        authnAttrMap = this.castToAttributeMap(authnBean.getAuthnIdentifiersMap());
                    }
                    if ((tmpMap = policyTreeState.getChainedAttributes()) == null) {
                        policyTreeState.setChainedAttributes(new HashMap<String, Object>());
                    }
                    if (authnComplete == null || !authnComplete.booleanValue()) {
                        if (PolicyTreeLogger.get().isDebugEnabled()) {
                            PolicyTreeLogger.debug((String)policyTree + "Authn Source | " + authnSourceKey.getFriendlyId());
                        }
                        this.checkAndSetInputUserId(stateParams, inMsgCtx, authnSourceAction, policyTreeState);
                        this.saveTreeState(policyNodeRef, result, policyTreeState);
                        try {
                            authnBean = null;
                            AuthnSourceAttrsHolder authnSourceAttrHolder = this.lookupAuthN(authnSourceKey, req, resp, authnPolicy, resumePath, stateParams, inMsgCtx, outMsgCtx, adapterLogoutRequired);
                            if (authnSourceAttrHolder != null) {
                                authnBean = authnSourceAttrHolder.getAuthnBean();
                                authnAttrMap = authnSourceAttrHolder.getAuthnSourceAttrMap();
                                authnStatus = authnSourceAttrHolder.getAuthnStatus();
                            }
                        }
                        catch (AuthorizationException e) {
                            log.info((Object)("Issuance criteria not satisfied: " + e.getMessage()));
                            stateParams.put(AUTHORIZATION_EXCEPTION_INFO_PARAM_NAME, AuthorizationExceptionInfo.fromException(e));
                            authnBean = null;
                        }
                    }
                    boolean failedAuthn = false;
                    if (authnBean != null && !Util.isEmpty(authnBean.getAuthnIdentifiersMap())) {
                        Tree.Node child2;
                        HashSet<String> availableMappedResults = new HashSet<String>();
                        if (policyNodeRef.getNode().hasChildren()) {
                            for (Tree.Node child2 : policyNodeRef.getNode().getChildren()) {
                                availableMappedResults.add(((AuthnSelectionAction)child2.getData()).getContext());
                            }
                        }
                        boolean ruleMatch = false;
                        child2 = authnSourceAction.getAttributeRules().iterator();
                        while (child2.hasNext()) {
                            AuthnPolicyRuleEvaluator authnPolicyRuleEvaluator;
                            AttributeRule attrRule = child2.next();
                            if (!availableMappedResults.contains(attrRule.getResult()) || !(authnPolicyRuleEvaluator = new AuthnPolicyRuleEvaluator(attrRule)).isRuleConditionMet(req, resp, inMsgCtx, stateParams, authnSourceKey, authnAttrMap, policyTreeState)) continue;
                            ruleMatch = true;
                            if (PolicyTreeLogger.get().isDebugEnabled()) {
                                PolicyTreeLogger.debug((String)policyTree + "Authn Source | " + authnSourceKey.getFriendlyId() + " | Rule | " + attrRule.getResult());
                            }
                            this.addSuccessfulAuthnToAttrsHolder(authnSourceKey, authnBean, authnAttrMap, policyTreeState, stateParams);
                            policyNodeRef = this.getMatchingChildNode(policyNodeRef, attrRule.getResult());
                            break;
                        }
                        if (!ruleMatch) {
                            if (authnStatus != null && authnStatus.equals((Object)AuthnAdapterResponse.AUTHN_STATUS.ACTION)) {
                                String actionName = authnAttrMap.getSingleValue("policy.action");
                                if ("identity.registration".equals(actionName) && authnSourceAction.isFallbackToSuccess()) {
                                    TreeNodeReference successBranchNode = this.getMatchingChildNode(policyNodeRef, "Success");
                                    boolean isNextNodeLocalIdentity = successBranchNode.getNode().getData() instanceof LocalIdentityMappingAction;
                                    if (!isNextNodeLocalIdentity) {
                                        if (PolicyTreeLogger.get().isDebugEnabled()) {
                                            PolicyTreeLogger.error((String)policyTree + "Authn Source | " + authnSourceKey.getFriendlyId() + " | Action | identity.registration | Rule | No eligible Rule. PingFederate requires a Local Identity Profile to be mapped on the Success branch for the identity.registration action.");
                                        }
                                        failedAuthn = true;
                                    }
                                } else {
                                    if (PolicyTreeLogger.get().isDebugEnabled()) {
                                        PolicyTreeLogger.error((String)policyTree + "Authn Source | " + authnSourceKey.getFriendlyId() + " | Action | " + actionName + " | Rule | Not Configured");
                                    }
                                    failedAuthn = true;
                                }
                            }
                            if (!failedAuthn && authnSourceAction.isFallbackToSuccess()) {
                                this.addSuccessfulAuthnToAttrsHolder(authnSourceKey, authnBean, authnAttrMap, policyTreeState, stateParams);
                                policyNodeRef = this.getMatchingChildNode(policyNodeRef, "Success");
                            } else {
                                failedAuthn = true;
                            }
                        }
                        if (PolicyTreeLogger.get().isDebugEnabled()) {
                            if (failedAuthn) {
                                PolicyTreeLogger.debug((String)policyTree + "Authn Source | " + authnSourceKey.getFriendlyId() + " | Rule | No Match");
                            } else {
                                PolicyTreeLogger.debug((String)policyTree + "Authn Source | " + authnSourceKey.getFriendlyId() + PIPE + ((AuthnSelectionAction)policyNodeRef.getNode().getData()).getContext());
                            }
                        }
                    } else {
                        if (resp.isCommitted() && (authnStatus == null || authnStatus == AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS)) break;
                        failedAuthn = true;
                    }
                    this.clearCallbackSelectors(stateParams);
                    if (!resp.isCommitted()) {
                        InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
                        if (authnSourceKey.getType().equals((Object)AuthnSourceKey.AuthnSourceType.ADAPTER) && (this.metadataLocal.getPathUtil().isResumePath(req.getServletPath()) || this.metadataLocal.getPathUtil().isResumePath(PasswordResetStateSupport.getPathWithOverride(req)) || AuthnApiSupport.getDefault().isApiRequest(req)) && req instanceof HttpServletReqProxy) {
                            ((HttpServletReqProxy)req).clearParameters();
                        }
                    }
                    if (!failedAuthn) continue;
                    stateParams.put(LAST_AUTHN_FAILED_STATE_PARAM_NAME, Boolean.TRUE);
                    policyNodeRef = this.getMatchingChildNode(policyNodeRef, "Fail");
                    if (PolicyTreeLogger.get().isDebugEnabled()) {
                        PolicyTreeLogger.debug((String)policyTree + "Authn Source | " + authnSourceKey.getFriendlyId() + " | Fail");
                    }
                    if (AuthnSourceKey.AuthnSourceType.ADAPTER == authnSourceKey.getType() && AdapterUtils.adapterNeedsPathRandomization(instance = this.adapterManager.getIdpAuthnAdapterInstance(authnSourceKey.getFriendlyId()))) {
                        StateSupport stateSupport = new StateSupport(this.metadataLocal);
                        resumePath = stateSupport.insertNonce(resumePath);
                    }
                    if (!resp.isCommitted()) continue;
                    break;
                }
                if (action instanceof AuthnSelectorAction) {
                    String selectorId = ((AuthnSelectorAction)action).getAuthnSelectorId();
                    AuthenticationSelector authnSelector = MgmtFactory.getAuthnSelectorManager().getAuthenticationSelector(selectorId);
                    Map<String, Object> chainedAttrs = policyTreeState.getChainedAttributes();
                    String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
                    HashMap<String, Object> extraParameters = new HashMap<String, Object>();
                    if (inMsgCtx != null) {
                        extraParameters.put("org.sourceid.saml20.adapter.idp.authn.authnCtxDoc", inMsgCtx.getXmlObject());
                    }
                    extraParameters.put("com.pingidentity.adapter.extra.parameter.instanceid", selectorId);
                    extraParameters.put("com.pingidentity.adapter.extra.parameter.authnPolicy", authnPolicy);
                    extraParameters.put("com.pingidentity.sdk.AdapterSelector.signedRequest", stateParams.get("request"));
                    if (chainedAttrs != null) {
                        extraParameters.put("com.pingidentity.sdk.authnselector.chained.attributes", chainedAttrs);
                    }
                    if (StringUtils.isNotBlank((String)spAdapterId)) {
                        extraParameters.put("com.pingidentity.sdk.AdapterSelector.sp.adapterid", spAdapterId);
                    }
                    extraParameters.put("com.pingidentity.sdk.AdapterSelector.clientid", stateParams.get(Parameters.CLIENT_ID));
                    Collection<AuthenticationSession> authnSessions = this.getAuthenticationSessions(req, resp, stateParams, authnPolicy, mappedSources);
                    extraParameters.put(AUTHN_SELECTOR_EXTRA_PARAM_NAME_SESSIONS, authnSessions);
                    extraParameters.put(AUTHN_SELECTOR_EXTRA_PARAM_NAME_CHILD_CONTEXTS, this.getChildNodeContexts(policyNodeRef));
                    Map trackedParams = stateParams.getOrDefault("pf.TrackedHttpParams", new HashMap());
                    extraParameters.put("com.pingidentity.sdk.authnselector.tracked.http.request.params", Collections.unmodifiableMap(trackedParams));
                    this.putExtraParametersToSelectContext(extraParameters, stateParams, inMsgCtx);
                    this.saveTreeState(policyNodeRef, result, policyTreeState);
                    AuthenticationSelectorContext selectorContext = this.invokeSelector(selectorId, authnSelector, req, resp, mappedSources.getSdkKeyToNameMap(), extraParameters, stateParams, resumePath);
                    if (!resp.isCommitted()) {
                        InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
                        this.saveCallbackSelector(selectorId, selectorContext, stateParams);
                        if (selectorContext.getResultType() == AuthenticationSelectorContext.ResultType.CONTEXT) {
                            String context = selectorContext.getResult();
                            if (PolicyTreeLogger.get().isDebugEnabled()) {
                                PolicyTreeLogger.debug((String)policyTree + "Selector | " + selectorId + PIPE + context);
                            }
                            policyNodeRef = this.getMatchingChildNode(policyNodeRef, context);
                            continue;
                        }
                        AuthnSourceKey returnedKey = null;
                        String authnSourceId = selectorContext.getResult();
                        if (selectorContext.getResultType() == AuthenticationSelectorContext.ResultType.ADAPTER_ID) {
                            if (PolicyTreeLogger.get().isDebugEnabled()) {
                                PolicyTreeLogger.debug((String)policyTree + "Selector | " + selectorId + " | adapter id | " + authnSourceId);
                            }
                            returnedKey = new AdapterAuthnSourceKey(authnSourceId);
                        } else if (selectorContext.getResultType() == AuthenticationSelectorContext.ResultType.IDP_CONN_ID) {
                            if (PolicyTreeLogger.get().isDebugEnabled()) {
                                PolicyTreeLogger.debug((String)policyTree + "Selector | " + selectorId + " | idp connection id | " + authnSourceId);
                            }
                            returnedKey = new IdpConnAuthnSourceKey(authnSourceId);
                        } else if (PolicyTreeLogger.get().isDebugEnabled()) {
                            PolicyTreeLogger.debug((String)policyTree + "Selector | invalid returned context | " + selectorContext.getResult());
                        }
                        if (mappedSources.getMappedAuthnSourceKeys().contains(returnedKey)) {
                            AuthnSourceAction newAuthnSourceAction = new AuthnSourceAction(returnedKey);
                            NoOpAction successDone = new NoOpAction(NoOpAction.Type.DONE);
                            successDone.setContext("Success");
                            NoOpAction failedDone = new NoOpAction(NoOpAction.Type.DONE);
                            failedDone.setContext("Fail");
                            Tree.Node newNode = new Tree.Node((Object)newAuthnSourceAction);
                            newNode.addChildData((Object)failedDone);
                            newNode.addChildData((Object)successDone);
                            policyNodeRef = new TreeNodeReference((Tree.Node<AuthnSelectionAction>)newNode, true);
                            continue;
                        }
                        throw new AuthnProcessorException.NoMatchingNode("Authn Policy Tree resulted in an unconfigured path. There is no mapping for the authn source: " + returnedKey);
                    }
                    break;
                }
                if (action instanceof LocalIdentityMappingAction) {
                    LocalIdentityMappingAction lipMappingAction = (LocalIdentityMappingAction)action;
                    LocalIdentityManager localIdentityManager = MgmtFactory.getLocalIdentityProfileManager();
                    LocalIdentityProfile localIdentityProfile = localIdentityManager.getProfile(lipMappingAction.getLipId());
                    if (localIdentityProfile.isRegistrationEnabled() || localIdentityProfile.isProfileEnabled()) {
                        this.mapInboundAttributes(lipMappingAction.getInboundAttributeMapping(), localIdentityProfile.getFieldConfig(), stateParams, policyTreeState, req, resp, inMsgCtx);
                    }
                    if (stateParams.containsKey(REGISTRATION_FRAGMENT_ID)) {
                        Boolean lastAuthnFailed = (Boolean)stateParams.get(LAST_AUTHN_FAILED_STATE_PARAM_NAME);
                        String registrationFragmentId = (String)stateParams.get(REGISTRATION_FRAGMENT_ID);
                        if (lastAuthnFailed != null && lastAuthnFailed.booleanValue()) {
                            this.processFragmentResultForAlreadyExecutedLip(req, resp, resumePath, stateParams, localIdentityProfile, registrationFragmentId, new AuthnSelectionResult(AuthnSelectionResult.ResultType.FAILED));
                            break;
                        }
                    }
                    LocalIdentitySourceKey authnSourceKey = new LocalIdentitySourceKey(localIdentityProfile.getId());
                    if (policyTreeState.isFragmentPolicyState()) {
                        AuditLogger.setFragmentName(policyTreeState.getPolicyName());
                    } else {
                        AuditLogger.removeFragmentName();
                    }
                    this.saveTreeState(policyNodeRef, result, policyTreeState);
                    AuthnSourceAttrsHolder authnSourceAttrHolder = this.lookupAuthN(authnSourceKey, req, resp, authnPolicy, resumePath, stateParams, inMsgCtx, outMsgCtx, adapterLogoutRequired);
                    if (AuthnAdapterResponse.AUTHN_STATUS.SUCCESS.equals((Object)authnSourceAttrHolder.getAuthnStatus())) {
                        IdpHashableAuthnBean authnBean = authnSourceAttrHolder.getAuthnBean();
                        authnAttrMap = authnSourceAttrHolder.getAuthnSourceAttrMap();
                        this.addSuccessfulAuthnToAttrsHolder(authnSourceKey, authnBean, authnAttrMap, policyTreeState, stateParams);
                        String apcId = localIdentityProfile.getContractId();
                        AttributeMapping apcMapping = lipMappingAction.getOutboundAttributeMapping();
                        result = this.mapApc(apcId, apcMapping, stateParams, policyTreeState, req, resp, inMsgCtx);
                    } else if (AuthnAdapterResponse.AUTHN_STATUS.FAILURE.equals((Object)authnSourceAttrHolder.getAuthnStatus())) {
                        result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.FAILED);
                        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                            this.writeRegistrationFragmentFailedAuthnStateResponse(req, resp, localIdentityProfile);
                        } else {
                            this.renderRegistrationFragmentFailedTemplate(req, resp, localIdentityProfile, stateParams);
                        }
                        if (resp.isCommitted()) {
                            break;
                        }
                    } else {
                        String requestedAction = this.getRequestedActionFromResult(authnSourceAttrHolder.getAuthnSourceAttrMap());
                        if (requestedAction != null && requestedAction.equals("Registration Fragment")) {
                            InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
                            String registrationFragmentId = localIdentityProfile.getRegistrationConfig().getRegistrationWorkflowFragmentId();
                            PolicyTreeState fragmentPolicyTreeState = this.getFragmentPolicyState(stateParams, registrationFragmentId, policyTreeState.getFragmentCount(), new AttributeMapping(), policyTreeState, req, resp, inMsgCtx);
                            this.buildContractInputsFromUserToCreate(req, resp, resumePath, fragmentPolicyTreeState, stateParams);
                            this.saveTreeState(policyNodeRef, result, policyTreeState);
                            stateParams.put(REGISTRATION_FRAGMENT_ID, registrationFragmentId);
                            TreeAuthnState currentTreeAuthnState = new TreeAuthnState(policyNodeRef, result, policyTrees, currentTreeIndex);
                            return new TreeAuthnWorkerResult(currentTreeAuthnState, fragmentPolicyTreeState);
                        }
                        if (requestedAction != null && requestedAction.equals("Cancel")) {
                            result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.RESTART);
                        }
                        if (resp.isCommitted()) break;
                    }
                    if (!PolicyTreeLogger.get().isDebugEnabled()) continue;
                    String friendlyAPCName = MgmtFactory.getC2cContractManager().getContract(lipMappingAction.getApcId()).getName();
                    PolicyTreeLogger.debug((String)policyTree + "Local Identity Profile | " + localIdentityProfile.getName() + " | Authentication Policy Contract | " + friendlyAPCName + PIPE + result.getResultType().toString());
                    continue;
                }
                if (action instanceof FragmentAction) {
                    FragmentAction fragmentAction = (FragmentAction)action;
                    AuditLogger.setFragmentName(fragmentAction.getAssociatedFragment().getName());
                    if (PolicyTreeLogger.get().isDebugEnabled()) {
                        PolicyTreeLogger.debug((String)policyTree + "Fragment | " + fragmentAction.getAssociatedFragment().getName());
                    }
                    PolicyTreeState fragmentPolicyTreeState = this.getFragmentPolicyState(stateParams, fragmentAction.getFragmentId(), policyTreeState.getFragmentCount(), fragmentAction.getAttributeMapping(), policyTreeState, req, resp, inMsgCtx);
                    this.saveTreeState(policyNodeRef, result, policyTreeState);
                    TreeAuthnState currentTreeAuthnState = new TreeAuthnState(policyNodeRef, result, policyTrees, currentTreeIndex);
                    return new TreeAuthnWorkerResult(currentTreeAuthnState, fragmentPolicyTreeState);
                }
                if (action instanceof ApcMappingAction) {
                    ApcMappingAction apcMappingAction = (ApcMappingAction)action;
                    String apcId = apcMappingAction.getApcId();
                    AttributeMapping apcMapping = apcMappingAction.getAttributeMapping();
                    result = this.mapApc(apcId, apcMapping, stateParams, policyTreeState, req, resp, inMsgCtx);
                    if (!PolicyTreeLogger.get().isDebugEnabled()) continue;
                    String friendlyAPCName = MgmtFactory.getC2cContractManager().getContract(apcId).getName();
                    PolicyTreeLogger.debug((String)policyTree + "Authentication Policy Contract | " + friendlyAPCName + PIPE + result.getResultType().toString());
                    continue;
                }
                if (action instanceof NoOpAction) {
                    NoOpAction.Type noOpType = ((NoOpAction)action).getType();
                    if (noOpType == NoOpAction.Type.CONTINUE) {
                        if (++currentTreeIndex < policyTrees.size()) {
                            PolicyTreeLogger.debug("Authn Policy Tree is falling through to next tree");
                            policyTreeState.setAuthnTreeIndex(currentTreeIndex);
                            policyNodeRef = new TreeNodeReference((Tree.Node<AuthnSelectionAction>)policyTrees.get(currentTreeIndex).getRootNode());
                            continue;
                        }
                        PolicyTreeLogger.debug("Authn Policy Tree is falling through to default authn sources");
                        result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.FALL_THROUGH);
                        continue;
                    }
                    if (noOpType == NoOpAction.Type.RESTART) {
                        PolicyTreeLogger.debug("Authn Policy Tree is starting over at the beginning.");
                        result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.RESTART);
                        continue;
                    }
                    Boolean lastAuthnFailed = (Boolean)stateParams.get(LAST_AUTHN_FAILED_STATE_PARAM_NAME);
                    if (lastAuthnFailed != null && lastAuthnFailed.booleanValue()) {
                        if (policyTreeState.isFragmentPolicyState()) {
                            result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.FAILED);
                            continue;
                        }
                        this.checkThrowAuthorizationException(stateParams);
                        result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.FINISHED);
                        continue;
                    }
                    AuthnPolicyAttrsHolder attrsHolder = policyTreeState.getAuthnPolicyAttrsHolder();
                    if (attrsHolder == null || policyTreeState.isFragmentPolicyState()) {
                        result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.FINISHED);
                        continue;
                    }
                    LinkedList<IdpHashableAuthnBean> beans = AuthnSourceSupportBase.getCumulativeAuthnBeans(stateParams);
                    IdpHashableAuthnBean mappedBean = beans.getLast();
                    AttributeMap authnSourceAttrMap = attrsHolder.getAuthnSourceAttrMaps().get(mappedBean.getAuthnSourceKey());
                    AttributeMap resultAuthnAttrs = this.getResultAttrsFromAuthnSource(req, mappedBean, authnSourceAttrMap, stateParams);
                    result = new AuthnSelectionResult(AuthnSelectionResult.ResultType.FINISHED, beans, resultAuthnAttrs);
                    stateParams.put(MAPPED_AUTHN_SOURCE_STATE_PARAM_NAME, attrsHolder.getAuthnBeans().getLast().getAuthnSourceKey());
                    continue;
                }
                throw new IllegalStateException("Unsupported action type: " + action.getClass().getName());
            }
            catch (AuthnProcessorException.NoMatchingNode e) {
                TreeAuthnState authnState = this.getTreeStateForNoMatchingNodeException(e, policyTreeState, stateParams, new TreeAuthnState(policyNodeRef, result, policyTrees, currentTreeIndex));
                result = authnState.getResult();
                policyNodeRef = authnState.getCurrentNodeRef();
            }
        }
        if (result.getResultType() == AuthnSelectionResult.ResultType.IN_PROGRESS) {
            this.saveTreeState(policyNodeRef, result, policyTreeState);
        } else if (result.getResultType() == AuthnSelectionResult.ResultType.RESTART) {
            int maxRestarts;
            Object restartCountObj;
            int restartCount;
            InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
            if (req instanceof HttpServletReqProxy) {
                ((HttpServletReqProxy)req).clearParameters();
            }
            if ((restartCount = (restartCountObj = stateParams.get(RESTART_COUNT_KEY)) == null ? 1 : (Integer)restartCountObj) >= (maxRestarts = new RestartConfigManager().getAllowedRestarts())) {
                throw new AuthnProcessorException("Maximum number of restarts (" + maxRestarts + ") has been reached for this transaction.", null);
            }
            if (!policyTreeState.isFragmentPolicyState()) {
                stateParams.put(RESTART_COUNT_KEY, ++restartCount);
            }
            if (!policyTreeState.isFragmentPolicyState()) {
                this.cleanUpStateParams(stateParams);
            }
        } else {
            LinkedList<IdpHashableAuthnBean> beans = AuthnSourceSupportBase.getCumulativeAuthnBeans(stateParams);
            Boolean lastAuthnFailed = (Boolean)stateParams.get(LAST_AUTHN_FAILED_STATE_PARAM_NAME);
            AuthnPluginKey authnPluginKey = (AuthnPluginKey)stateParams.get("APU.CurrentAuthnPlugin");
            if (!policyTreeState.isFragmentPolicyState()) {
                this.cleanUpStateParams(stateParams);
            } else {
                stateParams.remove(LAST_AUTHN_FAILED_STATE_PARAM_NAME);
            }
            if (!(result.getResultType() != AuthnSelectionResult.ResultType.FINISHED || policyTreeState.isFragmentPolicyState() || Boolean.TRUE.equals(lastAuthnFailed) || authnPluginKey != null && authnPluginKey.getType() == AuthnPluginKey.Type.IDP_ADAPTER || !CollectionUtils.isEmpty(beans))) {
                throw new ConfigurationException("Invalid Configuration.", new Exception("No authentication source found in the Authn Policy Tree."));
            }
            if (result.getResultType() == AuthnSelectionResult.ResultType.FALL_THROUGH) {
                stateParams.put(PREV_AUTHN_SEL_RESULT_STATE_PARAM_NAME, result);
            }
        }
        return new TreeAuthnWorkerResult(new TreeAuthnState(policyNodeRef, result, policyTrees, currentTreeIndex), null);
    }

    private void checkThrowAuthorizationException(Map<String, Object> stateParams) throws AuthorizationException {
        AuthorizationExceptionInfo exceptionInfo = (AuthorizationExceptionInfo)stateParams.get(AUTHORIZATION_EXCEPTION_INFO_PARAM_NAME);
        if (exceptionInfo == null) {
            return;
        }
        throw exceptionInfo.toException();
    }

    private UserToCreate buildContractInputsFromUserToCreate(HttpServletRequest req, HttpServletResponse resp, String resumePath, PolicyTreeState policyTreeState, Map<String, Object> stateParams) {
        TransactionalStateSupport txStateSupport = new TransactionalStateSupport(resumePath);
        UserToCreate userToCreate = (UserToCreate)txStateSupport.getAttribute("USER_TO_CREATE", req, resp);
        if (userToCreate != null) {
            HashMap<String, AttributeValue> inboundAttributes = new HashMap<String, AttributeValue>();
            for (Map.Entry<String, FieldData<?>> entry : userToCreate.getAttributesKeyValueMap().entrySet()) {
                List strings = Arrays.stream(entry.getValue().getValues()).map(object -> Objects.toString(object, null)).collect(Collectors.toList());
                AttributeValue value = new AttributeValue(strings);
                inboundAttributes.put(entry.getKey(), value);
            }
            if (CollectionUtils.isNotEmpty(userToCreate.getTransientAttributeMaps())) {
                userToCreate.getTransientAttributeMaps().forEach(inboundAttributes::putAll);
            }
            AttributeMap resultMap = new AttributeMap(inboundAttributes);
            FragmentSourceKey inputSourceKey = new FragmentSourceKey("inputs");
            this.addSuccessfulAuthnToAttrsHolder(inputSourceKey, null, resultMap, policyTreeState, stateParams);
            inputSourceKey = new FragmentSourceKey("Inputs");
            this.addSuccessfulAuthnToAttrsHolder(inputSourceKey, null, resultMap, policyTreeState, stateParams);
        }
        return userToCreate;
    }

    private PolicyTreeState getFragmentPolicyState(Map<String, Object> stateParams, String fragmentId, int fragmentCount, AttributeMapping attributeMapping, PolicyTreeState policyTreeState, HttpServletRequest request, HttpServletResponse resp, InMessageContext inMsgCtx) throws AuthorizationException, AuthnProcessorException {
        PolicyFragmentManager policyFragmentManager = MgmtFactory.getPolicyFragmentManager();
        PolicyFragment fragment = policyFragmentManager.getFragment(fragmentId);
        String apcId = fragment.getInputContractId();
        AuthnSelectionResult inboundResult = this.mapApc(apcId, attributeMapping, stateParams, policyTreeState, request, resp, inMsgCtx);
        PolicyTreeState fragmentPolicyTreeState = new PolicyTreeState(fragmentId, fragmentCount + 1, null, fragment.getName());
        if (stateParams.get(USERID_SUGGESTION) != null && StringUtils.isNotBlank((String)stateParams.get(USERID_SUGGESTION).toString())) {
            ContextSourceKey sourceKey = new ContextSourceKey(SourceContextType.REQUESTED_USER.name());
            AttributeMap ctxSrc = new AttributeMap();
            ctxSrc.put(SourceContextType.REQUESTED_USER.getId(), (String)stateParams.get(USERID_SUGGESTION));
            this.addSuccessfulAuthnToAttrsHolder(sourceKey, null, ctxSrc, fragmentPolicyTreeState, stateParams);
        }
        FragmentSourceKey inputSourceKey = new FragmentSourceKey("inputs");
        this.addSuccessfulAuthnToAttrsHolder(inputSourceKey, null, inboundResult.getPolicyResultMap(), fragmentPolicyTreeState, stateParams);
        inputSourceKey = new FragmentSourceKey("Inputs");
        this.addSuccessfulAuthnToAttrsHolder(inputSourceKey, null, inboundResult.getPolicyResultMap(), fragmentPolicyTreeState, stateParams);
        return fragmentPolicyTreeState;
    }

    protected Map<String, Object> copyStateParamsIntoFragmentStateParams(Map<String, Object> stateParams, Map<String, Object> fragmentParams) {
        for (Map.Entry<String, Object> entry : stateParams.entrySet()) {
            if (fragmentParams.containsKey(entry.getKey())) continue;
            fragmentParams.put(entry.getKey(), entry.getValue());
        }
        return fragmentParams;
    }

    private AuthenticationSelectorContext invokeSelector(String selectorId, AuthenticationSelector authnSelector, HttpServletRequest req, HttpServletResponse resp, Map<AuthenticationSourceKey, String> sdkKeyToNameMap, Map<String, Object> extraParameters, Map<String, Object> stateParams, String resumePath) throws IOException {
        AuthnPluginKey pluginKey = new AuthnPluginKey(AuthnPluginKey.Type.SELECTOR, selectorId);
        AuthnPolicyUtil.getDefault().setCurrentAuthnPlugin(req, stateParams, pluginKey);
        switch (AuthnApiPolicyUtil.getDefault().checkSendAuthnApiRedirect((ConfigurablePlugin)authnSelector, pluginKey, req, resp, stateParams, resumePath)) {
            case RESUME_SENT: {
                return null;
            }
            case REDIRECT_REQUIRED: {
                AuthnApiPolicyUtil.getDefault().redirectToEffectiveAuthnApiApplication(pluginKey, resp, stateParams, resumePath);
                return null;
            }
            case CONTINUE: {
                return authnSelector.selectContext(req, resp, sdkKeyToNameMap, extraParameters, resumePath);
            }
        }
        throw new ProcessRuntimeException("Unexpected result from checkSendAuthnApiRedirect()");
    }

    private Collection<AuthenticationSession> getAuthenticationSessions(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, AuthnPolicy authnPolicy, MappedSourcesWrapper mappedSources) throws AuthnProcessorException {
        ArrayList<AuthenticationSession> authnSessions = new ArrayList<AuthenticationSession>();
        HashSet<AuthenticationSourceKey> seenSourceKeys = new HashSet<AuthenticationSourceKey>();
        Set<IdpHashableAuthnBean> authnBeans = IdpSessionRegistrySupport.getAuthnSessions(req, resp, stateParams, authnPolicy);
        for (IdpHashableAuthnBean bean : authnBeans) {
            AuthenticationSession authnSession;
            AuthnSourceKey mappedSource = mappedSources.getMappedAuthnSourceKey(bean.getAuthnSourceKey());
            if (mappedSource != null && !mappedSource.equalsIncludeAllFields(bean.getAuthnSourceKey()) || seenSourceKeys.contains((authnSession = bean.getAuthenticationSession()).getAuthnSourceKey())) continue;
            seenSourceKeys.add(authnSession.getAuthnSourceKey());
            authnSessions.add(authnSession);
        }
        return authnSessions;
    }

    protected String getNameForAuthnSelectionTree(AuthnSelectionTree tree) {
        if (StringUtils.isNotBlank((String)tree.getName())) {
            return "Policy '" + tree.getName() + "'";
        }
        AuthnSelectionAction action = (AuthnSelectionAction)tree.getRootNode().getData();
        String actionName = "";
        if (action instanceof AuthnSelectorAction) {
            AuthnSelectorManager mgr = MgmtFactory.getAuthnSelectorManager();
            AuthnSelectorInstance instance = (AuthnSelectorInstance)mgr.getInstance(((AuthnSelectorAction)action).getAuthnSelectorId());
            actionName = instance.getName();
        } else if (action instanceof AuthnSourceAction) {
            AuthnSourceKey key = ((AuthnSourceAction)action).getAuthnSourceKey();
            if (key.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                IdpAdapterManager mgr = MgmtFactory.getIdpAdapterManager();
                IdpAuthnAdapterInstance adapter = (IdpAuthnAdapterInstance)mgr.getInstance(key.getId());
                if (adapter != null) {
                    actionName = adapter.getName();
                }
            } else if (key.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                MetadataDirectory mdd = MetaDataFactory.getMetadataDirectory();
                ConnectionBase conn = mdd.getConnection(key.getId());
                actionName = conn.getName();
            }
        }
        if (actionName != null) {
            return "Authentication Policy starting with '" + actionName + "'";
        }
        return actionName;
    }

    private TreeAuthnState getTreeAuthnState(AuthnPolicy authnPolicy, MappedSourcesWrapper mappedSources, Map<String, Object> stateParams, String fragmentId, PolicyTreeState policyTreeState) throws AuthnProcessorException {
        TreeAuthnState treeAuthnState = new TreeAuthnState();
        if (this.authnSelectorConfigManager.getLastModifiedMillis() != policyTreeState.getAuthnPolicyModifiedTime()) {
            PolicyTreeLogger.debug("Policy timestamp has changed since SSO was initiated, restarting policy tree");
            treeAuthnState.setResult(new AuthnSelectionResult(AuthnSelectionResult.ResultType.RESTART));
            return treeAuthnState;
        }
        ProxyScoping proxyScoping = null;
        if (authnPolicy instanceof AdvancedAuthnPolicy) {
            proxyScoping = ((AdvancedAuthnPolicy)authnPolicy).getProxyScoping();
        }
        if (StringUtils.isNotBlank((String)fragmentId)) {
            PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(fragmentId);
            AuthnSelectionTree fragmentTree = new AuthnSelectionTree((Tree.Node<AuthnSelectionAction>)fragment.getRootNode());
            fragmentTree.setName(fragment.getName());
            String authnApiAppId = (String)stateParams.get(CURRENT_AUTHN_API_APP_PARAM_NAME);
            if (StringUtils.isNotBlank((String)authnApiAppId)) {
                fragmentTree.setOverrideAuthnApiApplicationId(authnApiAppId);
            }
            treeAuthnState.setPolicyTrees(Collections.singletonList(fragmentTree));
        } else {
            treeAuthnState.setPolicyTrees(AuthnTreeHelper.copyApplicableAuthnTree(mappedSources.getMappedAuthnSourceKeys(), mappedSources.getMappedApcs(), proxyScoping));
        }
        treeAuthnState.setCurrentTreeIndex(policyTreeState.getAuthnTreeIndex());
        policyTreeState.setAuthnTreeIndex(treeAuthnState.getCurrentTreeIndex());
        AuthnSelectionTree currentTree = null;
        if (treeAuthnState.getCurrentTreeIndex() < treeAuthnState.getPolicyTrees().size()) {
            currentTree = treeAuthnState.getPolicyTrees().get(treeAuthnState.getCurrentTreeIndex());
        }
        if (currentTree == null) {
            treeAuthnState.setResult(new AuthnSelectionResult(AuthnSelectionResult.ResultType.FALL_THROUGH));
        } else {
            treeAuthnState.setResult(new AuthnSelectionResult(AuthnSelectionResult.ResultType.IN_PROGRESS));
            treeAuthnState.setCurrentNodeRef(this.getPolicyNodeRef(currentTree, policyTreeState));
        }
        return treeAuthnState;
    }

    private TreeNodeReference getPolicyNodeRef(AuthnSelectionTree currentTree, PolicyTreeState policyTreeState) {
        TreeNodeReference policyNodeRef = null;
        Tree.Node<AuthnSelectionAction> node = policyTreeState.getCurrentNode();
        Tree.NodePosition<AuthnSelectionAction> nodePosition = policyTreeState.getCurrentNodePosition();
        policyNodeRef = node != null ? new TreeNodeReference(node, true) : (nodePosition != null ? new TreeNodeReference(currentTree, nodePosition) : new TreeNodeReference((Tree.Node<AuthnSelectionAction>)currentTree.getRootNode()));
        return policyNodeRef;
    }

    private void mapInboundAttributes(AttributeMapping inboundAttributeMapping, FieldConfig fieldConfig, Map<String, Object> stateParams, PolicyTreeState policyTreeState, HttpServletRequest request, HttpServletResponse resp, InMessageContext inMsgCtx) throws AuthorizationException, AuthnProcessorException {
        AttributeMap apcResultMap;
        AuthnPolicyAttrsHolder attrsHolder = policyTreeState.getAuthnPolicyAttrsHolder();
        HashMap<String, AttributeMap> sourceAttrs = this.convertAuthnAttrsToAttributeMappingSources(attrsHolder);
        this.addTrackedParams(stateParams, sourceAttrs);
        this.addExtendedPropertiesAttributeMapping(stateParams, sourceAttrs);
        this.addContextAttributeMapping(request, resp, inMsgCtx, sourceAttrs, stateParams);
        AttributeMap inboundSourceAttributeMap = this.buildSourceMapFromInboundDefaults(inboundAttributeMapping, fieldConfig);
        sourceAttrs.put(null, inboundSourceAttributeMap);
        try {
            apcResultMap = inboundAttributeMapping.executeMapping(sourceAttrs, inboundAttributeMapping.getAttributeMapping().keySet());
        }
        catch (AttrLookupException e) {
            throw new AuthnProcessorException(e.getMessage(), e);
        }
        stateParams.put(INBOUND_ATTRIBUTES_PARAM_NAME, apcResultMap);
    }

    private AttributeMap buildSourceMapFromInboundDefaults(AttributeMapping inboundAttributeMapping, FieldConfig fieldConfig) {
        AttributeMap inboundSourceAttributeMap = new AttributeMap();
        List<LocalIdentityField<?>> allFields = fieldConfig.getListOfAllFields();
        for (Map.Entry<String, List<AttrMappingValue>> entry : inboundAttributeMapping.getAttributeMapping().entrySet()) {
            Optional<LocalIdentityField> field = allFields.stream().filter(f -> f.getData().getId().equals(entry.getKey())).findFirst();
            AttributeValue inboundSourceAttribute = new AttributeValue(entry.getValue().toString());
            inboundSourceAttribute.setMasked(field.isPresent() && field.get().isMasked());
            inboundSourceAttributeMap.put(entry.getKey(), inboundSourceAttribute);
        }
        return inboundSourceAttributeMap;
    }

    private String getRequestedActionFromResult(AttributeMap attrMap) {
        AttributeValue action;
        if (attrMap != null && (action = (AttributeValue)attrMap.get((Object)"policy.action")) != null) {
            return action.getValue();
        }
        return null;
    }

    private AuthnSelectionResult mapApc(String apcId, AttributeMapping apcMapping, Map<String, Object> stateParams, PolicyTreeState policyTreeState, HttpServletRequest request, HttpServletResponse resp, InMessageContext inMsgCtx) throws AuthorizationException, AuthnProcessorException {
        AttributeMap apcResultMap;
        AuthnPolicyAttrsHolder attrsHolder = policyTreeState.getAuthnPolicyAttrsHolder();
        HashMap<String, AttributeMap> sourceAttrs = this.convertAuthnAttrsToAttributeMappingSources(attrsHolder);
        LinkedList<IdpHashableAuthnBean> authnBeans = null;
        if (attrsHolder != null) {
            authnBeans = AuthnSourceSupportBase.getCumulativeAuthnBeans(stateParams);
        }
        this.addTrackedParams(stateParams, sourceAttrs);
        this.addExtendedPropertiesAttributeMapping(stateParams, sourceAttrs);
        this.addContextAttributeMapping(request, resp, inMsgCtx, sourceAttrs, stateParams);
        try {
            apcResultMap = apcMapping.executeMapping(sourceAttrs, apcMapping.getAttributeMapping().keySet());
        }
        catch (AttrLookupException e) {
            throw new AuthnProcessorException(e.getMessage(), e);
        }
        return new AuthnSelectionResult(AuthnSelectionResult.ResultType.FINISHED, authnBeans, apcResultMap, true, apcId);
    }

    private void addTrackedParams(Map<String, Object> stateParams, HashMap<String, AttributeMap> sourceAttrs) {
        Map trackedParams = stateParams.getOrDefault("pf.TrackedHttpParams", new HashMap());
        AuthnPolicyUtil.addTrackedParamsToAttributeMappingSource(trackedParams, sourceAttrs);
    }

    private void addExtendedPropertiesAttributeMapping(Map<String, Object> stateParams, HashMap<String, AttributeMap> sourceAttrs) {
        Object extendedPropertiesObject = stateParams.get(EXTENDED_PROPERTIES);
        if (extendedPropertiesObject instanceof Map) {
            AuthnPolicyUtil.addExtendedPropertiesToAttributeMappingSource((Map)extendedPropertiesObject, sourceAttrs);
        }
    }

    private void addContextAttributeMapping(HttpServletRequest request, HttpServletResponse resp, InMessageContext inMsgCtx, HashMap<String, AttributeMap> sourceAttrs, Map<String, Object> stateParams) {
        AttributeMap contractAttributes = AuthnSourceSupportBase.getContextAttributeMap(request, resp, inMsgCtx, stateParams);
        sourceAttrs.putIfAbsent(null, new AttributeMap());
        sourceAttrs.get(null).putAll((Map)contractAttributes);
    }

    private void addSuccessfulAuthnToAttrsHolder(AuthnSourceKey authnSourceKey, IdpHashableAuthnBean authnBean, AttributeMap authnAttrMap, PolicyTreeState policyTreeState, Map<String, Object> stateParams) {
        Map<String, Object> chainedAttrMap;
        AuthnPolicyAttrsHolder attrsHolder = policyTreeState.getAuthnPolicyAttrsHolder();
        if (attrsHolder == null) {
            attrsHolder = new AuthnPolicyAttrsHolder();
            policyTreeState.setAuthnPolicyAttrsHolder(attrsHolder);
        }
        if (authnBean != null) {
            attrsHolder.getAuthnBeans().add(authnBean);
            this.accumulateAuthnBean(stateParams, authnBean);
        }
        attrsHolder.getAuthnSourceAttrMaps().put(authnSourceKey, authnAttrMap);
        Map<String, Object> tmpMap = policyTreeState.getChainedAttributes();
        if (tmpMap == null) {
            chainedAttrMap = new HashMap<String, Object>();
            policyTreeState.setChainedAttributes(chainedAttrMap);
        } else {
            chainedAttrMap = tmpMap;
        }
        authnAttrMap.forEach(chainedAttrMap::put);
    }

    private HashMap<String, AttributeMap> convertAuthnAttrsToAttributeMappingSources(AuthnPolicyAttrsHolder attrsHolder) {
        if (attrsHolder != null) {
            return AuthnSourceSupportBase.convertAuthnAttrsToAttributeMappingSources(attrsHolder.getAuthnSourceAttrMaps());
        }
        return new HashMap<String, AttributeMap>();
    }

    static HashMap<String, AttributeMap> convertAuthnAttrsToAttributeMappingSources(Map<AuthnSourceKey, AttributeMap> authnSourceAttributeMap) {
        HashMap<String, AttributeMap> sourceAttrs = new HashMap<String, AttributeMap>();
        if (authnSourceAttributeMap != null) {
            for (Map.Entry<AuthnSourceKey, AttributeMap> entry : authnSourceAttributeMap.entrySet()) {
                String sourceKey;
                AuthnSourceKey authnSourceKey = entry.getKey();
                switch (authnSourceKey.getType()) {
                    case ADAPTER: {
                        sourceKey = COOKIE_ADAPTER_PREFIX + authnSourceKey.getId();
                        break;
                    }
                    case IDP_CONN: {
                        sourceKey = COOKIE_IDP_PREFIX + authnSourceKey.getId();
                        break;
                    }
                    case LOCAL_IDENTITY: {
                        sourceKey = COOKIE_LOCAL_IDENTITY_PREFIX + authnSourceKey.getId();
                        break;
                    }
                    case FRAGMENT: {
                        sourceKey = "fragment." + authnSourceKey.getId();
                        break;
                    }
                    case CONTEXT: {
                        sourceKey = "context." + authnSourceKey.getId();
                        break;
                    }
                    default: {
                        PolicyTreeLogger.get().warn((Object)("Unrecognized source attribute type: " + authnSourceKey.getType() + " - Dropping source."));
                        sourceKey = null;
                    }
                }
                sourceAttrs.put(sourceKey, entry.getValue());
            }
        }
        return sourceAttrs;
    }

    private void checkAndSetInputUserId(Map<String, Object> stateParams, InMessageContext inMsgCtx, AuthnSourceAction authnSourceAction, PolicyTreeState policyTreeState) {
        AttributeMap result;
        AttrMappingValue inputUserIdMapping = authnSourceAction.getInputUserIdMapping();
        stateParams.remove(CHAINED_USERID_PARAM_NAME);
        if (inputUserIdMapping == null) {
            return;
        }
        AuthnPolicyAttrsHolder attrsHolder = policyTreeState.getAuthnPolicyAttrsHolder();
        HashMap<String, AttributeMap> srcAttrs = this.convertAuthnAttrsToAttributeMappingSources(attrsHolder);
        if (inMsgCtx != null && inMsgCtx.getRequestedUserId() != null) {
            AttributeMap ctxSrc = new AttributeMap();
            ctxSrc.put(SourceContextType.REQUESTED_USER.getId(), inMsgCtx.getRequestedUserId());
            srcAttrs.put("context", ctxSrc);
        }
        AttributeMapping tmp = new AttributeMapping();
        String userId = "userId";
        tmp.putAttributeMapping(userId, List.of(inputUserIdMapping));
        try {
            result = tmp.executeMapping(srcAttrs, null);
        }
        catch (AttrLookupException | AuthorizationException e) {
            log.error((Object)e);
            return;
        }
        AttributeValue userIdVal = (AttributeValue)result.get((Object)userId);
        if (userIdVal != null) {
            PolicyTreeLogger.debug("Authn Policy Tree setting User ID from attribute '" + inputUserIdMapping.getValue() + "' from Source type '" + inputUserIdMapping.getTypeString() + "' and source ID '" + inputUserIdMapping.getAttributeSourceId() + "'");
            stateParams.put(CHAINED_USERID_PARAM_NAME, userIdVal.getValue());
            stateParams.put(ADAPTER_USERNAME_AUTHENTICATED, authnSourceAction.isUserIdAuthenticated());
        }
    }

    private void saveCallbackSelector(String selectorId, AuthenticationSelectorContext selectorContext, Map<String, Object> stateParams) {
        LinkedHashMap<String, AuthenticationSelectorContext> selectorContexts = (LinkedHashMap<String, AuthenticationSelectorContext>)stateParams.get(AUTHN_SELECTOR_CONTEXT_PARAM_NAME);
        if (selectorContexts == null) {
            selectorContexts = new LinkedHashMap<String, AuthenticationSelectorContext>();
            stateParams.put(AUTHN_SELECTOR_CONTEXT_PARAM_NAME, selectorContexts);
        }
        selectorContexts.put(selectorId, selectorContext);
    }

    private void clearCallbackSelectors(Map<String, Object> stateParams) {
        stateParams.remove(AUTHN_SELECTOR_CONTEXT_PARAM_NAME);
    }

    protected void saveTreeState(TreeNodeReference authnPolicyNode, AuthnSelectionResult result, PolicyTreeState policyTreeState) {
        if (authnPolicyNode.isSaveTree()) {
            policyTreeState.setCurrentNode(authnPolicyNode.getNode());
            policyTreeState.setCurrentNodePosition(null);
        } else {
            policyTreeState.setCurrentNodePosition((Tree.NodePosition<AuthnSelectionAction>)authnPolicyNode.getNode().getPosition());
            policyTreeState.setCurrentNode(null);
        }
        policyTreeState.setPreviousAuthnSelResult(result);
    }

    public void cleanUpStateParams(Map<String, Object> stateParams) {
        this.clearCallbackSelectors(stateParams);
        stateParams.remove(STATE_STACK_PARAM_NAME);
        stateParams.remove(LAST_AUTHN_FAILED_STATE_PARAM_NAME);
        stateParams.remove(AUTHORIZATION_EXCEPTION_INFO_PARAM_NAME);
        stateParams.remove("AuthnSelectionTreeReturnedIdpConnAuthnBean");
        stateParams.remove("AuthnSelectionTreeIdpConnComplete");
        stateParams.remove(CHAINED_USERID_PARAM_NAME);
        stateParams.remove(CUMULATIVE_AUTHN_BEANS_PARAM_NAME);
    }

    private AuthnSourceKey doLegacySelection(HttpServletRequest req, HttpServletResponse resp, String resumePath, Map<String, Object> stateParams, MappedSourcesWrapper mappedSources) throws AuthnProcessorException, AuthnAdapterException.NoMappedAdapters, IOException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            if (mappedSources.getMappedAuthnSourceKeys().size() == 1) {
                return mappedSources.getMappedAuthnSourceKeys().iterator().next();
            }
            AuthnApiSupport.getDefault().writeResumeResponse(req, resp, resumePath);
            return null;
        }
        if (req.getParameter("pfidpadapterid") != null) {
            String encodedCookieVal = req.getParameter("pfidpadapterid");
            AuthnSourceKey authnKey = this.fromCookieValue(encodedCookieVal);
            if (authnKey != null && mappedSources.getMappedAuthnSourceKeys().contains(authnKey)) {
                String remember = req.getParameter(PARAM_NAME_REMEMBER_CHOICE);
                stateParams.put(PARAM_NAME_REMEMBER_CHOICE, remember);
                return authnKey;
            }
            log.info((Object)("pfidpadapterid: '" + LogGuard.encode(encodedCookieVal) + "' is not mapped. Using value stored in the cookie if it exists, or will prompt the user for a valid authn source."));
        }
        AuthnSourceKey parameterFromStartEndpoint = this.getAuthnSourceFromStartEndpoint(req);
        if (mappedSources.getMappedAuthnSourceKeys().size() == 1 && parameterFromStartEndpoint == null) {
            return mappedSources.getMappedAuthnSourceKeys().iterator().next();
        }
        if (parameterFromStartEndpoint != null) {
            AuthnSourceKey mappedKeyFromStartEndpoint = mappedSources.getMappedAuthnSourceKey(parameterFromStartEndpoint);
            if (mappedKeyFromStartEndpoint != null) {
                return mappedKeyFromStartEndpoint;
            }
            String escapedParam = EscapeUtils.escape((Object)parameterFromStartEndpoint);
            String msg = this.makeNoMappingErrMsg(stateParams, escapedParam);
            throw new ProcessRuntimeException(msg);
        }
        AuthnSourceKey cookieValue = this.fromCookieValue(CookieMonster.getCookieValue(COOKIE_NAME, req));
        if (cookieValue != null && (cookieValue = mappedSources.getMappedAuthnSourceKey(cookieValue)) != null) {
            return cookieValue;
        }
        if (mappedSources.getMappedAuthnSourceKeys().isEmpty()) {
            throw new AuthnAdapterException.NoMappedAdapters("No authentication methods available.");
        }
        HashMap<String, String> encodedKeyToName = new HashMap<String, String>();
        for (Map.Entry<AuthnSourceKey, String> keyNameEntry : mappedSources.getKeyToNameMap().entrySet()) {
            encodedKeyToName.put(this.toCookieValue(keyNameEntry.getKey()), keyNameEntry.getValue());
        }
        SpConnection spConn = this.getSpConnection(stateParams);
        String connectionName = null;
        if (spConn != null) {
            connectionName = spConn.getName();
        }
        ResponseTemplateRenderer instance = ResponseTemplateRenderer.getInstance();
        String entityId = Objects.toString(stateParams.get("PartnerEntityId"), null);
        String clientId = Objects.toString(stateParams.get(Parameters.CLIENT_ID), null);
        Map<String, Object> params = new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.IDP).entityId(entityId).clientId(clientId).build();
        params.put("action", resumePath);
        params.put("adapterIdParamName", "pfidpadapterid");
        params.put("rememberParamName", PARAM_NAME_REMEMBER_CHOICE);
        params.put("adapterMap", this.sortByValues(encodedKeyToName));
        params.put("changePasswordParamName", PARAM_NAME_CHANGE_PASSWORD);
        Boolean changePassword = Boolean.valueOf(req.getParameter(PARAM_NAME_CHANGE_PASSWORD));
        params.put("changePassword", changePassword);
        params.put("spAdapterId", stateParams.get("SpSessionAuthnAdapterId"));
        params.put("connectionName", connectionName);
        params.put("entityId", entityId);
        params.put("client_id", clientId);
        this.putExtraRenderParameters(params, stateParams);
        instance.render(req, resp, "sourceid-choose-idp-adapter-form-template.html", params);
        return null;
    }

    protected AuthnSourceKey getAuthnSourceFromStartEndpoint(HttpServletRequest req) {
        String adapterId = req.getParameter("IdpAdapterId");
        if (StringUtils.isBlank((String)adapterId)) {
            return null;
        }
        return new AdapterAuthnSourceKey(adapterId);
    }

    private <K, L> Map<K, L> sortByValues(Map<K, L> map) {
        LinkedList<Map.Entry<K, L>> list = new LinkedList<Map.Entry<K, L>>(map.entrySet());
        list.sort(Comparator.comparing(o -> o.getValue().toString().toLowerCase()));
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    private TreeNodeReference getMatchingChildNode(TreeNodeReference parent, String resultContext) throws AuthnProcessorException {
        if (parent.getNode().hasChildren()) {
            for (Tree.Node child : parent.getNode().getChildren()) {
                if (!((AuthnSelectionAction)child.getData()).getContext().equals(resultContext)) continue;
                return new TreeNodeReference((Tree.Node<AuthnSelectionAction>)child, parent.isSaveTree());
            }
        }
        throw new AuthnProcessorException.NoMatchingNode("Authn Policy Tree resulted in an unconfigured path - There is no mapping for the result: " + resultContext);
    }

    private List<String> getChildNodeContexts(TreeNodeReference parent) {
        ArrayList<String> result = new ArrayList<String>();
        if (parent.getNode().hasChildren()) {
            for (Tree.Node child : parent.getNode().getChildren()) {
                if (((AuthnSelectionAction)child.getData()).getContext() == null) continue;
                result.add(((AuthnSelectionAction)child.getData()).getContext());
            }
        }
        return result;
    }

    public void afterInvokeAuthnSource(HttpServletRequest req, HttpServletResponse resp, AuthnSourceKey authnSourceKey, IdpHashableAuthnBean authnBean, Map<String, Object> stateParams) throws IOException {
        if (authnBean != null && !Util.isEmpty(authnBean.getAuthnIdentifiersMap())) {
            this.setCookie(req, resp, stateParams, this.toCookieValue(authnSourceKey));
            this.callbackToAuthnSelector(req, resp, authnSourceKey, authnBean, stateParams);
        } else if (!resp.isCommitted() && BooleanUtils.isNotTrue((Boolean)((Boolean)req.getAttribute(DO_NOT_DELETE_COOKIE)))) {
            this.addCookie(COOKIE_NAME, "", 0, resp);
        }
    }

    public void callbackToAuthnSelector(HttpServletRequest req, HttpServletResponse resp, AuthnSourceKey authnSourceKey, IdpHashableAuthnBean authnBean, Map<String, Object> stateParams) {
        LinkedHashMap selectorContexts = (LinkedHashMap)stateParams.get(AUTHN_SELECTOR_CONTEXT_PARAM_NAME);
        if (selectorContexts != null) {
            selectorContexts.entrySet().forEach(entry -> {
                AuthenticationSelector authnSelector = this.authnSelectorManager.getAuthenticationSelector((String)entry.getKey());
                authnSelector.callback(req, resp, authnBean.getAuthnIdentifiersMap(), authnSourceKey.toPublicAuthnSourceKey(), (AuthenticationSelectorContext)entry.getValue());
            });
        }
    }

    public void setCookie(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, AuthnSourceKey key) {
        this.setCookie(req, resp, stateParams, this.toCookieValue(key));
    }

    protected void setCookie(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String encodedAuthnSourceKey) {
        boolean remember;
        String rememberValue = req.getParameter(PARAM_NAME_REMEMBER_CHOICE);
        if (StringUtils.isBlank((String)rememberValue)) {
            rememberValue = (String)stateParams.get(PARAM_NAME_REMEMBER_CHOICE);
        }
        if ((remember = this.parseOutRememberValue(rememberValue)) || this.alwaysSetCookie) {
            this.addCookie(COOKIE_NAME, encodedAuthnSourceKey, 315360000, resp);
        }
    }

    private boolean parseOutRememberValue(String value) {
        return Boolean.parseBoolean(value);
    }

    private void addCookie(String name, String value, int age, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(age);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        response.addCookie(cookie);
    }

    private String toCookieValue(AuthnSourceKey key) {
        if (key.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
            return COOKIE_IDP_PREFIX + key.getId();
        }
        if (key.getType() == AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY) {
            return "localidentity.." + key.getId();
        }
        AdapterAuthnSourceKey adapterKey = (AdapterAuthnSourceKey)key;
        String connectionId = adapterKey.getConnectionId();
        if (connectionId != null) {
            SpConnection spConn = this.connectionManager.getSpConnection(connectionId);
            return COOKIE_ADAPTER_PREFIX + Base64URL.encodeToString((byte[])spConn.getSourceId()) + "." + key.getId();
        }
        return "ad.." + key.getId();
    }

    protected String toCookieValue(IdpConnection idpConn) {
        return COOKIE_IDP_PREFIX + idpConn.getId();
    }

    public AuthnSourceKey fromCookieValue(String val) {
        if (val == null) {
            return null;
        }
        if (val.startsWith(COOKIE_IDP_PREFIX)) {
            String idpConnSystemId = val.substring(COOKIE_IDP_PREFIX.length());
            return new IdpConnAuthnSourceKey(idpConnSystemId);
        }
        if (val.startsWith(COOKIE_ADAPTER_PREFIX)) {
            String encodedAdapterKey = val.substring(COOKIE_ADAPTER_PREFIX.length());
            int secondDelimIndex = encodedAdapterKey.indexOf(46);
            if (secondDelimIndex == -1 || secondDelimIndex == encodedAdapterKey.length() - 1) {
                return null;
            }
            String encodedSourceId = encodedAdapterKey.substring(0, secondDelimIndex);
            String spConnId = null;
            if (!StringUtils.isBlank((String)encodedSourceId)) {
                byte[] sourceId = Base64URL.decode((String)encodedSourceId);
                spConnId = this.metadataDirectory.getEntityId(sourceId, Protocol.values());
            }
            String adapterId = encodedAdapterKey.substring(secondDelimIndex + 1);
            return new AdapterAuthnSourceKey(adapterId, spConnId);
        }
        return new AdapterAuthnSourceKey(val);
    }

    protected SpConnection getSpConnection(Map<String, Object> stateParams) {
        SpConnection spConnection = null;
        String entityId = (String)stateParams.get("PartnerEntityId");
        if (entityId != null) {
            spConnection = MetadataSupport.getSpConnection(entityId);
        }
        return spConnection;
    }

    protected void putExtraParametersToSelectContext(Map<String, Object> extraParameters, Map<String, Object> stateParams, InMessageContext inMsgCtx) {
    }

    protected void putExtraRenderParameters(Map<String, Object> renderParameters, Map<String, Object> stateParams) {
        String oauthClientId = (String)stateParams.get(Parameters.CLIENT_ID);
        if (StringUtils.isNotBlank((String)oauthClientId)) {
            renderParameters.put(Parameters.CLIENT_ID, oauthClientId);
        }
    }

    private Set<String> getAdapterMaskedFields(AuthnSourceKey authnSourceKey) {
        IdpAdapter instance = this.getAdapterInstance(authnSourceKey);
        return instance.getMaskedFields();
    }

    private boolean getAdapterMaskOgnlValues(AuthnSourceKey authnSourceKey) {
        IdpAdapter instance = this.getAdapterInstance(authnSourceKey);
        return instance.getMaskOgnlValues();
    }

    protected IdpAdapter getAdapterInstance(AuthnSourceKey authnSourceKey) {
        AuthnSourceKey.AuthnSourceType authnSourceType = authnSourceKey.getType();
        if (authnSourceType == AuthnSourceKey.AuthnSourceType.ADAPTER) {
            String adapterId = authnSourceKey.getId();
            String connectionId = ((AdapterAuthnSourceKey)authnSourceKey).getConnectionId();
            return this.adapterManager.getIdpAuthnAdapterInstanceWithConnectionOverride(adapterId, connectionId);
        }
        if (authnSourceType == AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY) {
            LocalIdentityManager profileManager = MgmtFactory.getLocalIdentityProfileManager();
            LocalIdentityProfile profile = profileManager.getProfile(authnSourceKey.getId());
            return new LocalIdentityAdapter(profile);
        }
        return null;
    }

    protected <T extends AuthnSourceKey> AuthnProcessor<T> getAuthnProcessor(T authnSourceKey) {
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
            return new AdapterAuthnProcessor().withAuthenticationPolicyTreePostProcessor(authenticationPolicyTreePostProcessor);
        }
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY) {
            LocalIdentityManager profileManager = MgmtFactory.getLocalIdentityProfileManager();
            LocalIdentityProfile profile = profileManager.getProfile(authnSourceKey.getId());
            LocalIdentityAdapter adapter = new LocalIdentityAdapter(profile);
            return new LocalIdentityAuthnProcessor(adapter);
        }
        return new IdpConnAuthnProcessor();
    }

    protected final String getSpAdapterApplicationName(String spAdapterId) {
        AuthnAdapterInstance instance = this.getAuthnAdapterInstance(spAdapterId);
        return ConfigurationUtil.findEffectiveApplicationName(instance);
    }

    protected final String getSpAdapterApplicationIconUrl(String spAdapterId) {
        AuthnAdapterInstance instance = this.getAuthnAdapterInstance(spAdapterId);
        return ConfigurationUtil.findEffectiveApplicationIconUrlStr(instance);
    }

    private AuthnAdapterInstance getAuthnAdapterInstance(String spAdapterId) {
        SpAdapterManager adapterManager = MgmtFactory.getSpAdapterManager();
        AuthnAdapterInstance instance = (AuthnAdapterInstance)adapterManager.getInstance(spAdapterId);
        if (instance == null) {
            throw new IllegalStateException("Can't find plugin instance with the id: " + spAdapterId);
        }
        return instance;
    }

    private void processFragmentResultForAlreadyExecutedLip(HttpServletRequest req, HttpServletResponse resp, String resumePath, Map<String, Object> stateParams, LocalIdentityProfile localIdentityProfile, String registrationFragmentId, AuthnSelectionResult fragmentResult) throws IOException {
        if (fragmentResult.getResultType().equals((Object)AuthnSelectionResult.ResultType.FINISHED)) {
            stateParams.remove(REGISTRATION_FRAGMENT_ID);
            TransactionalStateSupport txStateSupport = new TransactionalStateSupport(resumePath);
            txStateSupport.setAttribute("local.identity.resume.registration", (Object)Boolean.TRUE, req, resp);
            txStateSupport.setAttribute("executePostLipFragment", (Object)Boolean.TRUE, req, resp);
            UserToCreate userToCreate = (UserToCreate)txStateSupport.getAttribute("USER_TO_CREATE", req, resp);
            this.mergeFragmentResultMapIntoUser(req, localIdentityProfile, fragmentResult, userToCreate);
            txStateSupport.setAttribute("USER_TO_CREATE", (Object)userToCreate, req, resp);
        } else if (fragmentResult.getResultType().equals((Object)AuthnSelectionResult.ResultType.FAILED)) {
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                this.writeRegistrationFragmentFailedAuthnStateResponse(req, resp, localIdentityProfile);
            } else {
                this.renderRegistrationFragmentFailedTemplate(req, resp, localIdentityProfile, stateParams);
            }
            stateParams.put(LAST_AUTHN_FAILED_STATE_PARAM_NAME, Boolean.TRUE);
        } else if (fragmentResult.getResultType().equals((Object)AuthnSelectionResult.ResultType.IN_PROGRESS)) {
            stateParams.put(REGISTRATION_FRAGMENT_ID, registrationFragmentId);
        }
    }

    private void renderRegistrationFragmentFailedTemplate(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile localIdentityProfile, Map<String, Object> stateParams) throws ResponseTemplateRendererException {
        ResponseTemplateRenderer instance = ResponseTemplateRenderer.getInstance();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (stateParams.containsKey(EXTENDED_PROPERTIES)) {
            params.put(EXTENDED_PROPERTIES, stateParams.get(EXTENDED_PROPERTIES));
        }
        if (LocalIdentityAdapter.isVerifiedEmailPosted(req) && localIdentityProfile.getEmailOwnershipVerificationConfig() != null) {
            params.put("title", "title");
            params.put("errorMessageKey", "tooManyAttempts");
            instance.render(req, resp, localIdentityProfile.getEmailOwnershipVerificationConfig().getEmailVerificationErrorTemplateName(), params);
        } else {
            params.put("accountCreated", localIdentityProfile.getRegistrationConfig().isExecuteWorkflowAfterAccountCreation());
            if (localIdentityProfile.getRegistrationConfig().isExecuteWorkflowAfterAccountCreation()) {
                params.put("error", new StandardTemplateMessage(REGISTRATION_FRAGMENT_ERROR_USER_CREATED_MESSAGE_KEY));
            } else {
                params.put("error", new StandardTemplateMessage(REGISTRATION_FRAGMENT_ERROR_USER_NOT_CREATED_MESSAGE_KEY));
            }
            instance.render(req, resp, "local.identity.registration.fragment.error.html", params);
        }
    }

    private void writeRegistrationFragmentFailedAuthnStateResponse(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile localIdentityProfile) throws IOException {
        if (LocalIdentityAdapter.isVerifiedEmailPosted(req) && localIdentityProfile.getEmailOwnershipVerificationConfig() != null) {
            AuthenticationFailed authenticationFailed = new AuthenticationFailed();
            LanguagePackMessages lpm = new LanguagePackMessages("pingfederate-messages", LocaleUtil.getUserLocale(req));
            authenticationFailed.setUserMessage(lpm.getMessage("local.identity.email.verification.error.tooManyAttempts"));
            AuthnState failedAuthnState = CommonStateSpec.FAILED.makeInstance(req, (Object)authenticationFailed);
            AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, failedAuthnState);
        } else {
            AuthnError authnError = CommonErrorSpec.REGISTRATION_FAILED.makeInstance();
            AuthnErrorDetail authnErrorDetail = CommonErrorDetailSpec.REGISTRATION_FAILED.makeInstance();
            if (localIdentityProfile.getRegistrationConfig().isExecuteWorkflowAfterAccountCreation()) {
                authnErrorDetail.setUserMessageKey(REGISTRATION_FRAGMENT_ERROR_USER_CREATED_MESSAGE_KEY);
            } else {
                authnErrorDetail.setUserMessageKey(REGISTRATION_FRAGMENT_ERROR_USER_NOT_CREATED_MESSAGE_KEY);
            }
            authnError.setDetails(Collections.singletonList(authnErrorDetail));
            AuthnApiSupport.getDefault().writeErrorResponse(req, resp, authnError);
        }
    }

    private void mergeFragmentResultMapIntoUser(HttpServletRequest req, LocalIdentityProfile localIdentityProfile, AuthnSelectionResult fragmentResult, UserToCreate userToCreateOrUpdate) {
        if (userToCreateOrUpdate != null) {
            AttributeMap fragmentResultMap = fragmentResult.getPolicyResultMap();
            if (MapUtils.isNotEmpty((Map)fragmentResultMap)) {
                Set<String> attributeNames = localIdentityProfile.getDataStoreConfig().getDataStoreMapping().keySet();
                for (Map.Entry entry : fragmentResultMap.entrySet()) {
                    if (!attributeNames.contains(entry.getKey())) continue;
                    StringFieldData data = new StringFieldData((String)entry.getKey(), false, new String[]{((AttributeValue)entry.getValue()).getValue()});
                    userToCreateOrUpdate.getAttributesKeyValueMap().put((String)entry.getKey(), data);
                }
            }
            req.setAttribute("registrationFragmentDone", (Object)Boolean.TRUE.toString());
        }
    }

    public static void updateAuthnBean(Map<String, Object> stateParams, IdpHashableAuthnBean oldBean, IdpHashableAuthnBean newBean) {
        PolicyTreeState policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams);
        if (policyTreeState != null && policyTreeState.getAuthnPolicyAttrsHolder() != null && policyTreeState.getAuthnPolicyAttrsHolder().getAuthnBeans() != null) {
            policyTreeState.getAuthnPolicyAttrsHolder().getAuthnBeans().replaceAll(existingBean -> existingBean.equals(oldBean) ? newBean : existingBean);
            LinkedList<IdpHashableAuthnBean> authnBeansSoFar = AuthnSourceSupportBase.getCumulativeAuthnBeans(stateParams);
            authnBeansSoFar.replaceAll(existingBean -> existingBean.equals(oldBean) ? newBean : existingBean);
            stateParams.put(CUMULATIVE_AUTHN_BEANS_PARAM_NAME, authnBeansSoFar);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authn Session attributes for '" + oldBean.getAuthnSourceKey().toString() + "' have been updated."));
            }
        }
    }

    private void accumulateAuthnBean(Map<String, Object> stateParams, IdpHashableAuthnBean authnBean) {
        LinkedList<IdpHashableAuthnBean> authnBeansSoFar = AuthnSourceSupportBase.getCumulativeAuthnBeans(stateParams);
        authnBeansSoFar.add(authnBean);
        stateParams.put(CUMULATIVE_AUTHN_BEANS_PARAM_NAME, authnBeansSoFar);
    }

    private static LinkedList<IdpHashableAuthnBean> getCumulativeAuthnBeans(Map<String, Object> stateParams) {
        LinkedList cumulativeAuthnBeans = (LinkedList)stateParams.get(CUMULATIVE_AUTHN_BEANS_PARAM_NAME);
        return cumulativeAuthnBeans == null ? new LinkedList() : cumulativeAuthnBeans;
    }

    public static AttributeMap getContextAttributeMap(HttpServletRequest request, HttpServletResponse resp, InMessageContext inMsgCtx, Map<String, Object> stateParams) {
        AttributeMap contextAttrs = new AttributeMap();
        contextAttrs.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(request.getRemoteAddr()));
        contextAttrs.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)request));
        contextAttrs.put(SourceContextType.SRI.getId(), new AttributeValue(SessionIdUtil.getInstance().getExtendedSriV2(request, resp, stateParams)));
        if (inMsgCtx != null) {
            String requestedUserId;
            String virtualServerId;
            String spEntityId;
            if ("oauth:authz".equals(inMsgCtx.getBinding()) && StringUtils.isNotEmpty((String)inMsgCtx.getEntityId())) {
                contextAttrs.put(SourceContextType.OAUTH_CLIENT.getId(), new AttributeValue(inMsgCtx.getEntityId()));
                Set<String> scopeSet = AuthnSourceSupportBase.getScopeSet(inMsgCtx);
                if (!scopeSet.isEmpty()) {
                    contextAttrs.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue(AuthnSourceSupportBase.getScopeSet(inMsgCtx)));
                }
            }
            if ((spEntityId = MessageCustomization.getFedhubSpConnectionEntityId(inMsgCtx)) != null) {
                contextAttrs.put(SourceContextType.SP_CONN_ENTITY_ID.getId(), spEntityId);
            }
            if ((virtualServerId = inMsgCtx.getVirtualServerId()) != null) {
                contextAttrs.put(SourceContextType.VIRTUAL_SERVER_ID.getId(), virtualServerId);
            }
            if ((requestedUserId = inMsgCtx.getRequestedUserId()) != null) {
                contextAttrs.put(SourceContextType.REQUESTED_USER.getId(), requestedUserId);
            }
        }
        return contextAttrs;
    }

    private static Set<String> getScopeSet(InMessageContext inMsgCtx) {
        String requestedScopeStr = inMsgCtx.getParam(Parameters.SCOPE);
        Scope requestedScope = Scope.getScope((String)requestedScopeStr);
        return requestedScope.getScopeSet();
    }

    private static class TreeAuthnWorkerResult {
        private final PolicyTreeState fragmentPolicyTreeState;
        private final TreeAuthnState treeAuthnState;

        public TreeAuthnWorkerResult(TreeAuthnState treeAuthnState, PolicyTreeState fragmentPolicyTreeState) {
            this.treeAuthnState = treeAuthnState;
            this.fragmentPolicyTreeState = fragmentPolicyTreeState;
        }

        private TreeAuthnState getTreeAuthnState() {
            return this.treeAuthnState;
        }

        private PolicyTreeState getFragmentPolicyTreeState() {
            return this.fragmentPolicyTreeState;
        }
    }

    private static class AuthnSourceAttributeMapping
    extends AttributeMapping {
        private static final long serialVersionUID = 2L;
        private final IdpAdapter instance;

        public AuthnSourceAttributeMapping(IdpAdapter adapterInstance, AttributeMapping attributeMapping) {
            super(attributeMapping);
            this.instance = adapterInstance;
        }

        @Override
        protected void logAttributes(AttributeMap resultantMap, HashMap<String, AttributeMap> srcAttributesMap, AttributeMap attributesFromDS) {
            Set<String> maskedAttributeNames = this.instance.getMaskedFields();
            for (String maskedAttribute : maskedAttributeNames) {
                this.markAttributesForMasking(srcAttributesMap, maskedAttribute);
                if (attributesFromDS != null && attributesFromDS.get((Object)maskedAttribute) != null) {
                    ((AttributeValue)attributesFromDS.get((Object)maskedAttribute)).setMasked(true);
                }
                if (resultantMap == null || resultantMap.get((Object)maskedAttribute) == null) continue;
                ((AttributeValue)resultantMap.get((Object)maskedAttribute)).setMasked(true);
            }
            super.logAttributes(resultantMap, srcAttributesMap, attributesFromDS);
        }

        private void markAttributesForMasking(HashMap<String, AttributeMap> attributesMap, String maskedAttributeName) {
            if (attributesMap != null) {
                for (AttributeMap value : attributesMap.values()) {
                    if (value.get((Object)maskedAttributeName) == null) continue;
                    ((AttributeValue)value.get((Object)maskedAttributeName)).setMasked(true);
                }
            }
        }
    }

    private static class AuthorizationExceptionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String message;
        private final String errorDetail;

        public static AuthorizationExceptionInfo fromException(AuthorizationException e) {
            return new AuthorizationExceptionInfo(e.getMessage(), e.getErrorDetail());
        }

        private AuthorizationExceptionInfo(String message, String errorDetail) {
            this.message = message;
            this.errorDetail = errorDetail;
        }

        public AuthorizationException toException() {
            return new AuthorizationException(this.message, this.errorDetail);
        }
    }

    private static class TreeAuthnState {
        private TreeNodeReference currentNodeRef;
        private AuthnSelectionResult result;
        private List<AuthnSelectionTree> policyTrees;
        private int currentTreeIndex = 0;

        public TreeAuthnState() {
        }

        public TreeAuthnState(TreeNodeReference currentNodeRef, AuthnSelectionResult result, List<AuthnSelectionTree> policyTrees, int currentTreeIndex) {
            this.currentNodeRef = currentNodeRef;
            this.result = result;
            this.policyTrees = policyTrees;
            this.currentTreeIndex = currentTreeIndex;
        }

        public TreeNodeReference getCurrentNodeRef() {
            return this.currentNodeRef;
        }

        public void setCurrentNodeRef(TreeNodeReference currentNodeRef) {
            this.currentNodeRef = currentNodeRef;
        }

        public AuthnSelectionResult getResult() {
            return this.result;
        }

        public void setResult(AuthnSelectionResult result) {
            this.result = result;
        }

        public List<AuthnSelectionTree> getPolicyTrees() {
            return this.policyTrees;
        }

        public void setPolicyTrees(List<AuthnSelectionTree> policyTrees) {
            this.policyTrees = policyTrees;
        }

        public int getCurrentTreeIndex() {
            return this.currentTreeIndex;
        }

        public void setCurrentTreeIndex(int index) {
            this.currentTreeIndex = index;
        }
    }

    protected static class TreeNodeReference {
        private final Tree.Node<AuthnSelectionAction> node;
        private boolean saveTree = false;

        public TreeNodeReference(Tree.Node<AuthnSelectionAction> node) {
            this(node, false);
        }

        public TreeNodeReference(Tree.Node<AuthnSelectionAction> node, boolean saveTree) {
            this.node = node;
            this.saveTree = saveTree;
        }

        public TreeNodeReference(AuthnSelectionTree tree, Tree.NodePosition<AuthnSelectionAction> position) {
            this.node = tree.findNode(position);
            if (this.node == null) {
                throw new ProcessRuntimeException("Could not find node position in authn policy tree");
            }
            this.saveTree = false;
        }

        public Tree.Node<AuthnSelectionAction> getNode() {
            return this.node;
        }

        public boolean isSaveTree() {
            return this.saveTree;
        }
    }

    private static class AuthnSourceAttrsHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IdpHashableAuthnBean authnBean;
        private final AttributeMap authnSourceAttrMap;
        private final AuthnAdapterResponse.AUTHN_STATUS authnStatus;

        public AuthnSourceAttrsHolder(AuthnAdapterResponse.AUTHN_STATUS authnStatus, IdpHashableAuthnBean bean, AttributeMap map) {
            this.authnStatus = authnStatus;
            this.authnBean = bean;
            this.authnSourceAttrMap = map;
        }

        public AuthnSourceAttrsHolder(AuthnAdapterResponse.AUTHN_STATUS authnStatus) {
            this.authnStatus = authnStatus;
            this.authnBean = null;
            this.authnSourceAttrMap = null;
        }

        public IdpHashableAuthnBean getAuthnBean() {
            return this.authnBean;
        }

        public AttributeMap getAuthnSourceAttrMap() {
            return this.authnSourceAttrMap;
        }

        public AuthnAdapterResponse.AUTHN_STATUS getAuthnStatus() {
            return this.authnStatus;
        }
    }

    public static class AuthnPolicyAttrsHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final LinkedList<IdpHashableAuthnBean> authnBeans = new LinkedList();
        private final Map<AuthnSourceKey, AttributeMap> authnSourceAttrMaps = new HashMap<AuthnSourceKey, AttributeMap>();

        public LinkedList<IdpHashableAuthnBean> getAuthnBeans() {
            return this.authnBeans;
        }

        public Map<AuthnSourceKey, AttributeMap> getAuthnSourceAttrMaps() {
            return this.authnSourceAttrMaps;
        }
    }

    protected class MappedSourcesWrapper {
        private final HttpServletRequest req;
        private final Map<String, Object> stateParams;
        private final AuthnPolicy authnPolicy;
        private final BaseMessageContext messageContext;
        private MappedAuthnSourcesAndApcs mappedSources = null;
        private HashMap<AuthnSourceKey, AuthnSourceKey> mappedAuthnSourceKeys = null;
        private Map<AuthnSourceKey, String> keyToNameMap = null;
        private Map<AuthenticationSourceKey, String> sdkKeyToNameMap = null;

        public MappedSourcesWrapper(HttpServletRequest req, Map<String, Object> stateParams, AuthnPolicy authnPolicy, BaseMessageContext messageContext) {
            this.req = req;
            this.stateParams = stateParams;
            this.authnPolicy = authnPolicy;
            this.messageContext = messageContext;
        }

        public Set<AuthnSourceKey> getMappedAuthnSourceKeys() throws AuthnProcessorException {
            return this.getMappedSources().getMappedAuthnSourceKeys();
        }

        public Set<String> getMappedApcs() throws AuthnProcessorException {
            return this.getMappedSources().getMappedApcIds();
        }

        private MappedAuthnSourcesAndApcs getMappedSources() throws AuthnProcessorException {
            if (this.mappedSources == null) {
                ProxyScoping proxyScoping = null;
                if (this.authnPolicy instanceof AdvancedAuthnPolicy) {
                    proxyScoping = ((AdvancedAuthnPolicy)this.authnPolicy).getProxyScoping();
                }
                this.mappedSources = AuthnSourceSupportBase.this.getMappedSources(this.req, this.stateParams, this.messageContext, proxyScoping);
            }
            return this.mappedSources;
        }

        public Map<AuthnSourceKey, String> getKeyToNameMap() throws AuthnProcessorException {
            if (this.keyToNameMap == null) {
                this.keyToNameMap = new HashMap<AuthnSourceKey, String>();
                MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
                IdpAdapterManager adapterManager = MgmtFactory.getIdpAdapterManager();
                Set<AuthnSourceKey> mappedAuthnSourceKeys = this.getMappedAuthnSourceKeys();
                for (AuthnSourceKey key : mappedAuthnSourceKeys) {
                    String name;
                    if (key.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                        IdpConnection conn = metadataDirectory.getIdpConnectionBySystemId(key.getId(), true);
                        name = conn.getName();
                    } else {
                        IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)adapterManager.getInstance(key.getId());
                        name = instance.getName();
                    }
                    this.keyToNameMap.put(key, name);
                }
            }
            return this.keyToNameMap;
        }

        public Map<AuthenticationSourceKey, String> getSdkKeyToNameMap() throws AuthnProcessorException {
            if (this.sdkKeyToNameMap == null) {
                this.sdkKeyToNameMap = new HashMap<AuthenticationSourceKey, String>();
                Map<AuthnSourceKey, String> keyToNameMap = this.getKeyToNameMap();
                for (Map.Entry<AuthnSourceKey, String> keyNameEntry : keyToNameMap.entrySet()) {
                    AuthnSourceKey authnSourceKey = keyNameEntry.getKey();
                    this.sdkKeyToNameMap.put(authnSourceKey.toPublicAuthnSourceKey(), keyNameEntry.getValue());
                }
            }
            return this.sdkKeyToNameMap;
        }

        public <T extends AuthnSourceKey> T getMappedAuthnSourceKey(T key) throws AuthnProcessorException {
            if (this.mappedAuthnSourceKeys == null) {
                this.mappedAuthnSourceKeys = new HashMap();
                for (AuthnSourceKey mappedKey : this.getMappedSources().getMappedAuthnSourceKeys()) {
                    this.mappedAuthnSourceKeys.put(mappedKey, mappedKey);
                }
            }
            return (T)this.mappedAuthnSourceKeys.get(key);
        }
    }
}

