/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.config.SoapAuthStoreFactory;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.RequestHandlerBase;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.protocol.ResponseDocOutMsgCtxUtil;
import org.sourceid.saml20.protocol.nameidparsing.NameIdentifierParser;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.saml20.xmlbinding.protocol.AttributeQueryDocument;
import org.sourceid.saml20.xmlbinding.protocol.AttributeQueryType;
import org.sourceid.saml20.xmlbinding.protocol.ResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ResponseType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandleAttrQueryRequest
extends RequestHandlerBase {
    private final SoapAuthStore soapAuthStore = SoapAuthStoreFactory.getSoapAuthStore();
    private final AssertionAssembler assertionAssembler = new AssertionAssembler();
    private final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);

    @Override
    protected void verifySignature(InMessageContext inMsgCtx) throws StatusResponseException {
        SpConnection sp = MetadataSupport.getSpConnection(inMsgCtx.getEntityId());
        boolean requireSignedAttributeQuery = sp.getAttributeRequester().isRequireSignedAttributeQuery();
        inMsgCtx.setSignatureRequired(requireSignedAttributeQuery);
        super.verifySignature(inMsgCtx);
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        return ResponseDocOutMsgCtxUtil.newCtx(inMsgCtx);
    }

    @Override
    protected void doProcess(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        SpConnection sp = MetadataSupport.getSpConnection(inMsgCtx.getEntityId());
        AttributeRequester attributeRequester = sp.getAttributeRequester();
        boolean signResponse = attributeRequester.isSignResponse();
        outMsgCtx.setSignaturePolicy(signResponse ? SignaturePolicy.SIGN : SignaturePolicy.DO_NOT_SIGN);
        super.doProcess(inMsgCtx, req, resp, outMsgCtx);
    }

    private AttributeQueryType getAttrQueryType(InMessageContext inMsgCtx) {
        XmlObject xmlDoc = inMsgCtx.getXmlObject();
        AttributeQueryDocument attrQueryDoc = (AttributeQueryDocument)xmlDoc;
        return attrQueryDoc.getAttributeQuery();
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        AttributeMap attributes;
        SpConnection sp = MetadataSupport.getSpConnection(inMsgCtx.getEntityId());
        AttributeRequester attributeRequester = sp.getAttributeRequester();
        AttributeQueryType attrQueryType = this.getAttrQueryType(inMsgCtx);
        SubjectType subject = attrQueryType.getSubject();
        if (subject.isSetEncryptedID()) {
            boolean signed;
            String encodedId = sp.getEncodedEntityId();
            SoapAuthInfo in = this.soapAuthStore.getIncoming(encodedId);
            boolean bl = signed = inMsgCtx.getSignatureStatus() == SignatureStatus.VALID;
            if (!(in.isHasBasicEntry() || in.isHasCertEntry() || signed)) {
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "An AttributeQuery with an encrypted NameID must be signed and/or the requester must be authenticated.");
            }
            try {
                EncryptedElementType encryptedID = subject.getEncryptedID();
                String virtualEntityId = VirtualIdentityUtil.resolve(sp, req).getVirtualEntityId(DomainMode.RUNTIME);
                NameIDType nameIDType = this.encryptionEngine.decryptNameID(sp, encryptedID, virtualEntityId);
                subject.unsetEncryptedID();
                subject.setNameID(nameIDType);
            }
            catch (Exception e) {
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "Unable to decrypt NameIdentifier", e);
            }
        } else if (attributeRequester.isRequireEncryptedNameId()) {
            String msg = "The system is configured to require an encrypted NameIdentifier";
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, msg);
        }
        Map<String, Object> nameIdAttrs = NameIdentifierParser.parse(subject.getNameID());
        AttributeMap nameIdAttrMap = AttrValueSupport.convert(nameIdAttrs, (boolean)false);
        AttributeMap contextAttributes = new AttributeMap();
        contextAttributes.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
        contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        AttributeMapping attributeMapping = attributeRequester.getAttributeMapping();
        try {
            Set<String> attributeFilterList = attributeRequester.getAttributeFilterList();
            attributes = attributeMapping.executeMapping(nameIdAttrMap, attributeFilterList, contextAttributes);
            outMsgCtx.setMaskedAttributeNames(attributes.getMaskedAttributeNames());
        }
        catch (AuthorizationException e) {
            attributes = new AttributeMap();
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, new String[]{"urn:oasis:names:tc:SAML:2.0:status:RequestDenied"}, e.getErrorDetail(), e);
        }
        catch (AttrLookupException e) {
            attributes = new AttributeMap();
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, new String[]{"urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal"}, "Error occurred in query fulfillment attribute lookup.", e);
        }
        attributes = this.returnAttributeFiltering(attributes, attrQueryType);
        String spEntityId = inMsgCtx.getEntityId();
        String issuer = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, req).getVirtualEntityId(DomainMode.RUNTIME);
        AssertionType assertionType = this.assertionAssembler.assembleForAttrQueryResponse((Map<String, AttributeValue>)attributes, spEntityId, subject, issuer);
        if (attributeRequester.isSignAssertion()) {
            try {
                assertionType = this.signatureEngine.signAssertion(outMsgCtx, assertionType);
            }
            catch (SigningException e) {
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "Unable to sign assertion", e);
            }
        }
        XmlObject xmlObject = outMsgCtx.getXmlObject();
        ResponseDocument respDoc = (ResponseDocument)xmlObject;
        ResponseType response = respDoc.getResponse();
        if (attributeRequester.isEncryptAssertion()) {
            try {
                EncryptedElementType encryptedElementType = this.encryptionEngine.encryptAssertion(sp, assertionType, outMsgCtx.getMaskedAttributeNames());
                response.setEncryptedAssertionArray(new EncryptedElementType[]{encryptedElementType});
            }
            catch (Exception e) {
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "Unable to encrypt assertion", e);
            }
        } else {
            response.setAssertionArray(new AssertionType[]{assertionType});
        }
    }

    private AttributeMap returnAttributeFiltering(AttributeMap attributes, AttributeQueryType attrQueryType) {
        AttributeMap returnAttributes;
        AttributeType[] requestedAttributes = attrQueryType.getAttributeArray();
        if (requestedAttributes == null || requestedAttributes.length == 0 || attributes == null || attributes.isEmpty()) {
            returnAttributes = attributes;
        } else {
            returnAttributes = new AttributeMap();
            for (AttributeType requestedAttribute : requestedAttributes) {
                String name = requestedAttribute.getName();
                AttributeValue returnValue = (AttributeValue)attributes.get((Object)name);
                if (returnValue == null) continue;
                XmlObject[] requestedValues = requestedAttribute.getAttributeValueArray();
                if (requestedValues != null && requestedValues.length > 0) {
                    Iterable values = returnValue.getValues();
                    ArrayList<String> filteredValueList = new ArrayList<String>();
                    block1: for (String value : values) {
                        for (XmlObject obj : requestedValues) {
                            if (!(obj instanceof XmlString)) continue;
                            String requestedStringValue = ((XmlString)obj).getStringValue();
                            if (value == null || !value.equals(requestedStringValue)) continue;
                            filteredValueList.add(value);
                            continue block1;
                        }
                    }
                    returnValue = new AttributeValue(filteredValueList);
                }
                returnAttributes.put(name, returnValue);
            }
        }
        return returnAttributes;
    }
}

